/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.exportimport.internal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.exportimport.internal.lar.CurrentUserIdStrategy;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.DefaultConfigurationPortletDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReference;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.exportimport.portlet.data.handler.util.ExportImportGroupedModelUtil;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorRegistryUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactory;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.staging.configuration.StagingConfiguration;
import jakarta.portlet.PortletRequest;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Component(configurationPid={"com.liferay.staging.configuration.StagingConfiguration"}, service={ExportImportHelper.class})
public class ExportImportHelperImpl
implements ExportImportHelper {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportHelperImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    @Reference
    private PortletLocalService _portletLocalService;
    private volatile StagingConfiguration _stagingConfiguration;
    @Reference
    private SystemEventLocalService _systemEventLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ZipReaderFactory _zipReaderFactory;
    @Reference
    private ZipWriterFactory _zipWriterFactory;

    public long[] getAllLayoutIds(long groupId, boolean privateLayout) {
        return this.getLayoutIds(this._layoutLocalService.getLayouts(groupId, privateLayout));
    }

    public Map<Long, Boolean> getAllLayoutIdsMap(long groupId, boolean privateLayout) {
        HashMap<Long, Boolean> layoutIdMap = new HashMap<Long, Boolean>();
        for (Layout layout : this._layoutLocalService.getLayouts(groupId, privateLayout, 0L)) {
            layoutIdMap.put(layout.getPlid(), true);
        }
        return layoutIdMap;
    }

    public List<Portlet> getDataSiteAndInstanceLevelPortlets(long companyId) throws Exception {
        return this.getDataSiteAndInstanceLevelPortlets(companyId, false);
    }

    public List<Portlet> getDataSiteAndInstanceLevelPortlets(long companyId, boolean excludeDataAlwaysStaged) throws Exception {
        return this._getPortlets(companyId, new DataLevel[]{DataLevel.PORTLET_INSTANCE, DataLevel.SITE}, excludeDataAlwaysStaged);
    }

    public Portlet getDataSiteLevelPortlet(String className, long companyId, boolean excludeDataAlwaysStaged) {
        for (Portlet portlet : this._portletLocalService.getPortlets(companyId)) {
            PortletDataHandler portletDataHandler;
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || !ArrayUtil.contains((Object[])portletDataHandler.getClassNames(), (Object)className) || !portletDataHandler.isDataSiteLevel() || excludeDataAlwaysStaged && portletDataHandler.isDataAlwaysStaged()) continue;
            return portlet;
        }
        return null;
    }

    public List<Portlet> getDataSiteLevelPortlets(long companyId) throws Exception {
        return this.getDataSiteLevelPortlets(companyId, false);
    }

    public List<Portlet> getDataSiteLevelPortlets(long companyId, boolean excludeDataAlwaysStaged) throws Exception {
        return this._getPortlets(companyId, new DataLevel[]{DataLevel.SITE}, excludeDataAlwaysStaged);
    }

    public List<Portlet> getExportablePortlets(long companyId, boolean excludeDataAlwaysStaged, long groupId) {
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (stagingGroupHelper.isCompanyGroup(companyId, groupId)) {
            return this._getPortlets(companyId, new DataLevel[]{DataLevel.PORTAL}, excludeDataAlwaysStaged);
        }
        if (stagingGroupHelper.isDepotGroup(groupId)) {
            return ListUtil.filter(this._getPortlets(companyId, new DataLevel[]{DataLevel.DEPOT, DataLevel.SITE}, excludeDataAlwaysStaged), portlet -> {
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                return portletDataHandler.isDataDepotLevel() || portletDataHandler.isDataSiteLevel() && !portletDataHandler.isBatch();
            });
        }
        return this._getPortlets(companyId, new DataLevel[]{DataLevel.SITE}, excludeDataAlwaysStaged);
    }

    public String getExportableRootPortletId(long companyId, String portletId) throws Exception {
        Portlet portlet = this._portletLocalService.getPortletById(companyId, portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return null;
        }
        return PortletIdCodec.decodePortletName((String)portletId);
    }

    public Map<String, Boolean> getExportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap) throws Exception {
        return this.getExportPortletControlsMap(companyId, portletId, parameterMap, "layout-set");
    }

    public Map<String, Boolean> getExportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, String type) throws Exception {
        return HashMapBuilder.put((Object)"PORTLET_DATA", (Object)this._getExportPortletData(companyId, portletId, parameterMap)).putAll(this._getExportPortletSetupControlsMap(companyId, portletId, parameterMap, type)).build();
    }

    public Map<String, Boolean> getImportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, Element portletDataElement, ManifestSummary manifestSummary) throws Exception {
        return HashMapBuilder.put((Object)"PORTLET_DATA", (Object)this._isImportPortletData(companyId, portletId, parameterMap, portletDataElement)).putAll(this._getImportPortletSetupControlsMap(companyId, portletId, parameterMap, manifestSummary)).build();
    }

    public Map<Long, Boolean> getLayoutIdMap(PortletRequest portletRequest) throws PortalException {
        String layoutIdsJSON = GetterUtil.getString((Object)portletRequest.getAttribute("layoutIdMap"));
        if (Validator.isNull((String)layoutIdsJSON)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Long, Boolean> layoutIdMap = new LinkedHashMap<Long, Boolean>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(layoutIdsJSON);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            layoutIdMap.put(jsonObject.getLong("plid"), jsonObject.getBoolean("includeChildren"));
        }
        return layoutIdMap;
    }

    public long[] getLayoutIds(List<Layout> layouts) {
        return TransformUtil.transformToLongArray(layouts, LayoutModel::getLayoutId);
    }

    public long[] getLayoutIds(Map<Long, Boolean> layoutIdMap) throws PortalException {
        return this.getLayoutIds(layoutIdMap, 0L);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public long[] getLayoutIds(Map<Long, Boolean> layoutIdMap, long targetGroupId) throws PortalException {
        if (MapUtil.isEmpty(layoutIdMap)) {
            return new long[0];
        }
        layouts = new ArrayList<Layout>();
        entries = layoutIdMap.entrySet();
        for (Map.Entry<Long, Boolean> entry : entries) {
            plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            layout = null;
            try {
                layout = this.getLayoutOrCreateDummyRootLayout(plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                if (ExportImportHelperImpl._log.isWarnEnabled()) {
                    ExportImportHelperImpl._log.warn((Object)("Unable to publish deleted layout " + plid));
                }
                if (ExportImportHelperImpl._log.isDebugEnabled()) {
                    ExportImportHelperImpl._log.debug((Throwable)noSuchLayoutException);
                }
                entries.remove(plid);
                continue;
            }
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            if (layout.getPlid() == 0L) continue;
            parentLayouts = Collections.emptyList();
            if (targetGroupId != 0L) {
                parentLayouts = this.getMissingParentLayouts(layout, targetGroupId);
            }
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-199086")) {
                try {
                    stagingConfiguration = (StagingConfiguration)this._configurationProvider.getCompanyConfiguration(StagingConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
                    if (!stagingConfiguration.publishParentLayoutsByDefault()) ** GOTO lbl44
                    for (Layout parentLayout : parentLayouts) {
                        if (layouts.contains(parentLayout)) continue;
                        layouts.add(parentLayout);
                    }
                }
                catch (Exception exception) {
                    ExportImportHelperImpl._log.error((Throwable)exception);
                }
            } else {
                for (Layout parentLayout : parentLayouts) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
            }
lbl44:
            // 4 sources

            includeChildren = entry.getValue();
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        return this.getLayoutIds(layouts);
    }

    public long[] getLayoutIds(PortletRequest portletRequest) throws PortalException {
        return this.getLayoutIds(this.getLayoutIdMap(portletRequest), 0L);
    }

    public long[] getLayoutIds(PortletRequest portletRequest, long targetGroupId) throws PortalException {
        return this.getLayoutIds(this.getLayoutIdMap(portletRequest), targetGroupId);
    }

    public long getLayoutModelDeletionCount(PortletDataContext portletDataContext, boolean privateLayout) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._systemEventLocalService.getActionableDynamicQuery();
        StagedModelType stagedModelType = new StagedModelType(Layout.class);
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            this.doAddCriteria(portletDataContext, stagedModelType, dynamicQuery);
            Property extraDataProperty = PropertyFactoryUtil.forName((String)"extraData");
            dynamicQuery.add(extraDataProperty.like((Object)("%\"privateLayout\":\"" + privateLayout + "\"%")));
        });
        actionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        return actionableDynamicQuery.performCount();
    }

    public Layout getLayoutOrCreateDummyRootLayout(long plid) throws PortalException {
        LayoutImpl layout = new LayoutImpl();
        if (plid == 0L) {
            layout.setPlid(0L);
            layout.setLayoutId(0L);
            layout.setParentLayoutId(0L);
        } else {
            layout = this._layoutLocalService.getLayout(plid);
        }
        return layout;
    }

    public ZipWriter getLayoutSetZipWriter(long groupId) {
        String fileName = this._getZipWriterFileName(String.valueOf(groupId));
        return this.getZipWriter(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManifestSummary getManifestSummary(long userId, long groupId, Map<String, String[]> parameterMap, FileEntry fileEntry) throws Exception {
        ManifestSummary manifestSummary = null;
        File file = FileUtil.createTempFile((String)"lar");
        ZipReader zipReader = null;
        try (InputStream inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);){
            FileUtil.write((File)file, (InputStream)inputStream);
            Group group = this._groupLocalService.getGroup(groupId);
            String userIdStrategy = MapUtil.getString(parameterMap, (Object)"USER_ID_STRATEGY");
            zipReader = this._zipReaderFactory.getZipReader(file);
            PortletDataContext portletDataContext = this._portletDataContextFactory.createImportPortletDataContext(group.getCompanyId(), groupId, parameterMap, this.getUserIdStrategy(userId, userIdStrategy), zipReader);
            manifestSummary = this.getManifestSummary(portletDataContext);
        }
        finally {
            if (zipReader != null) {
                zipReader.close();
            }
            FileUtil.delete((File)file);
        }
        return manifestSummary;
    }

    public ManifestSummary getManifestSummary(PortletDataContext portletDataContext) throws Exception {
        ManifestSummary manifestSummary = new ManifestSummary();
        XMLReader xmlReader = SecureXMLFactoryProviderUtil.newXMLReader();
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        ElementHandler elementHandler = new ElementHandler((ElementProcessor)new ManifestSummaryElementProcessor(group, manifestSummary), new String[]{"header", "portlet", "staged-model"});
        xmlReader.setContentHandler((ContentHandler)elementHandler);
        xmlReader.parse(new InputSource(portletDataContext.getZipEntryAsInputStream("/manifest.xml")));
        return manifestSummary;
    }

    public List<Layout> getMissingParentLayouts(Layout layout, long liveGroupId) throws PortalException {
        ArrayList<Layout> missingParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        Layout parentLayout = null;
        while (parentLayoutId > 0L && !this._layoutLocalService.hasLayout((parentLayout = this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId)).getUuid(), liveGroupId, parentLayout.isPrivateLayout())) {
            missingParentLayouts.add(parentLayout);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return missingParentLayouts;
    }

    public long getModelDeletionCount(PortletDataContext portletDataContext, StagedModelType stagedModelType) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._systemEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> this.doAddCriteria(portletDataContext, stagedModelType, dynamicQuery));
        actionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        return actionableDynamicQuery.performCount();
    }

    public String getPortletExportFileName(Portlet portlet) {
        return StringBundler.concat((String[])new String[]{StringUtil.replace((String)portlet.getDisplayName(), (char)' ', (char)'_'), "-", Time.getShortTimestamp(), ".portlet.lar"});
    }

    public ZipWriter getPortletZipWriter(String portletId) {
        String fileName = this._getZipWriterFileName(portletId);
        return this.getZipWriter(fileName);
    }

    public String getSelectedLayoutsJSON(long groupId, boolean privateLayout, String selectedNodes) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        long[] selectedLayoutIds = StringUtil.split((String)selectedNodes, (long)0L);
        for (Layout layout : this._layoutLocalService.getLayouts(groupId, privateLayout, 0L)) {
            this._populateLayoutsJSON(jsonArray, layout, selectedLayoutIds);
        }
        if (ArrayUtil.contains((long[])selectedLayoutIds, (long)0L)) {
            jsonArray.put(JSONUtil.put((String)"includeChildren", (Object)true).put("plid", 0));
        }
        return jsonArray.toString();
    }

    public FileEntry getTempFileEntry(long groupId, long userId, String folderName) throws PortalException {
        String[] tempFileNames = this._layoutService.getTempFileNames(groupId, folderName);
        if (tempFileNames.length == 0) {
            return null;
        }
        return TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)tempFileNames[0]);
    }

    public UserIdStrategy getUserIdStrategy(long userId, String userIdStrategy) throws PortalException {
        User user = this._userLocalService.getUserById(userId);
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    public boolean isAlwaysIncludeReference(PortletDataContext portletDataContext, StagedModel referenceStagedModel) {
        String rootPortletId = portletDataContext.getRootPortletId();
        if (Validator.isBlank((String)rootPortletId)) {
            return true;
        }
        return this.isAlwaysIncludeReference(portletDataContext, referenceStagedModel, rootPortletId);
    }

    public boolean isAlwaysIncludeReference(PortletDataContext portletDataContext, StagedModel referenceStagedModel, String rootPortletId) {
        Portlet portlet = this._portletLocalService.getPortletById(rootPortletId);
        if (portlet == null) {
            return true;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        Map parameterMap = portletDataContext.getParameterMap();
        Object[] referencedContentBehaviorArray = (String[])parameterMap.get(PortletDataHandlerControl.getNamespacedName((String)portletDataHandler.getNamespace(), (String)"referenced-content-behavior"));
        Object referencedContentBehavior = "include-always";
        if (ArrayUtil.isNotEmpty((Object[])referencedContentBehaviorArray)) {
            referencedContentBehavior = referencedContentBehaviorArray[0];
        }
        return ((String)referencedContentBehavior).equals("include-always") || ((String)referencedContentBehavior).equals("include-if-modified") && portletDataContext.isWithinDateRange(referenceStagedModel.getModifiedDate());
    }

    public boolean isExportPortletData(PortletDataContext portletDataContext) {
        if ((portletDataContext.getScopeGroupId() == portletDataContext.getGroupId() || portletDataContext.getScopeGroupId() == portletDataContext.getCompanyGroupId()) && (ExportImportThreadLocal.isLayoutExportInProcess() || ExportImportThreadLocal.isLayoutStagingInProcess())) {
            return false;
        }
        return !ExportImportThreadLocal.isLayoutStagingInProcess() || this._isStagedPortlet(portletDataContext);
    }

    public boolean isLayoutRevisionInReview(Layout layout) {
        return ListUtil.exists((List)this._layoutRevisionLocalService.getLayoutRevisions(layout.getPlid()), layoutRevision -> 1 == layoutRevision.getStatus());
    }

    public boolean isPublishDisplayedContent(PortletDataContext portletDataContext, Portlet portlet) {
        try {
            if (!ExportImportThreadLocal.isStagingInProcess()) {
                return true;
            }
            this._stagingConfiguration = (StagingConfiguration)this._configurationProvider.getCompanyConfiguration(StagingConfiguration.class, portletDataContext.getCompanyId());
            if (this._stagingConfiguration.publishDisplayedContent()) {
                return true;
            }
            ExportImportPortletPreferencesProcessor exportImportPortletPreferencesProcessor = ExportImportPortletPreferencesProcessorRegistryUtil.getExportImportPortletPreferencesProcessor((String)portlet.getRootPortletId());
            if (exportImportPortletPreferencesProcessor != null) {
                return exportImportPortletPreferencesProcessor.isPublishDisplayedContent();
            }
            return true;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    public boolean isReferenceWithinExportScope(PortletDataContext portletDataContext, StagedModel stagedModel) {
        if (!(stagedModel instanceof GroupedModel)) {
            return true;
        }
        GroupedModel groupedModel = (GroupedModel)stagedModel;
        if (portletDataContext.getGroupId() == groupedModel.getGroupId()) {
            return true;
        }
        return ExportImportGroupedModelUtil.isReferenceInLayoutGroupWithinExportScope((PortletDataContext)portletDataContext, (GroupedModel)groupedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBackgroundTaskManifestSummary(long userId, long sourceGroupId, BackgroundTask backgroundTask, File file) throws PortalException {
        FileEntry fileEntry = null;
        try {
            fileEntry = TempFileEntryUtil.addTempFileEntry((long)sourceGroupId, (long)userId, (String)ExportImportHelper.TEMP_FOLDER_NAME, (String)file.getName(), (File)file, (String)MimeTypesUtil.getContentType((File)file));
            ManifestSummary manifestSummary = this.getManifestSummary(userId, sourceGroupId, new HashMap<String, String[]>(), fileEntry);
            Map taskContextMap = backgroundTask.getTaskContextMap();
            taskContextMap.put("assetTitles", new HashMap(manifestSummary.getStagedModelAssetTitles()));
            taskContextMap.put("modelAdditionCounters", new HashMap(manifestSummary.getModelAdditionCounters()));
            taskContextMap.put("modelDeletionCounters", new HashMap(manifestSummary.getModelDeletionCounters()));
            taskContextMap.put("manifestSummaryKeys", new HashSet(manifestSummary.getManifestSummaryKeys()));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to process manifest for the process summary screen", (Throwable)exception);
            }
        }
        finally {
            if (fileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)fileEntry.getFileEntryId());
            }
        }
    }

    public void setPortletScope(PortletDataContext portletDataContext, Element portletElement) {
        String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
        String scopeLayoutType = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-type"));
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        portletDataContext.setScopeType(scopeLayoutType);
        try {
            Group scopeGroup = null;
            if (scopeLayoutType.equals("company")) {
                scopeGroup = this._groupLocalService.getCompanyGroup(portletDataContext.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                Group group;
                block17: {
                    Layout scopeLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
                    scopeGroup = this._groupLocalService.checkScopeGroup(scopeLayout, portletDataContext.getUserId(null));
                    group = scopeLayout.getGroup();
                    if (group.isStaged() && !group.isStagedRemotely()) {
                        try {
                            boolean privateLayout = GetterUtil.getBoolean((String)portletElement.attributeValue("private-layout"));
                            Layout oldLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getSourceGroupId(), privateLayout);
                            Group oldScopeGroup = oldLayout.getScopeGroup();
                            if (group.isStagingGroup()) {
                                scopeGroup.setLiveGroupId(oldScopeGroup.getGroupId());
                                scopeGroup = this._groupLocalService.updateGroup(scopeGroup);
                            } else {
                                oldScopeGroup.setLiveGroupId(scopeGroup.getGroupId());
                                this._groupLocalService.updateGroup(oldScopeGroup);
                            }
                        }
                        catch (NoSuchLayoutException noSuchLayoutException) {
                            if (!_log.isWarnEnabled()) break block17;
                            _log.warn((Throwable)noSuchLayoutException);
                        }
                    }
                }
                if (!ExportImportThreadLocal.isStagingInProcess() && group.isStagingGroup() && !group.isStagedPortlet(portletDataContext.getPortletId())) {
                    scopeGroup = group.getLiveGroup();
                    Layout scopeLiveLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(scopeLayoutUuid, group.getLiveGroupId(), portletDataContext.isPrivateLayout());
                    if (scopeLiveLayout != null) {
                        scopeGroup = this._groupLocalService.checkScopeGroup(scopeLiveLayout, portletDataContext.getUserId(null));
                    }
                }
            } else {
                Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
                if (!ExportImportThreadLocal.isStagingInProcess() && group.isStagingGroup()) {
                    scopeGroup = group.isStagedPortlet(portletDataContext.getPortletId()) ? group : group.getLiveGroup();
                }
            }
            if (scopeGroup != null) {
                portletDataContext.setScopeGroupId(scopeGroup.getGroupId());
                Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
                long oldScopeGroupId = GetterUtil.getLong((String)portletElement.attributeValue("scope-group-id"));
                groupIds.put(oldScopeGroupId, scopeGroup.getGroupId());
            }
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    public MissingReferences validateMissingReferences(final PortletDataContext portletDataContext) throws Exception {
        final MissingReferences missingReferences = new MissingReferences();
        XMLReader xmlReader = SecureXMLFactoryProviderUtil.newXMLReader();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                MissingReference missingReference = ExportImportHelperImpl.this._validateMissingReference(portletDataContext, element);
                if (missingReference != null) {
                    missingReferences.add(missingReference);
                }
            }
        }, new String[]{"missing-reference"});
        xmlReader.setContentHandler((ContentHandler)elementHandler);
        xmlReader.parse(new InputSource(portletDataContext.getZipEntryAsInputStream("/manifest.xml")));
        return missingReferences;
    }

    public void writeManifestSummary(Document document, ManifestSummary manifestSummary) {
        Element rootElement = document.getRootElement();
        Element manifestSummaryElement = rootElement.addElement("manifest-summary");
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            long modelDeletionCount;
            String stagedModelAssetTitle;
            Element element = manifestSummaryElement.addElement("staged-model");
            element.addAttribute("manifest-summary-key", manifestSummaryKey);
            long modelAdditionCount = manifestSummary.getModelAdditionCount(manifestSummaryKey);
            if (modelAdditionCount > 0L) {
                element.addAttribute("addition-count", String.valueOf(modelAdditionCount));
            }
            if (Validator.isNotNull((String)(stagedModelAssetTitle = manifestSummary.getStagedModelAssetTitle(manifestSummaryKey)))) {
                element.addAttribute("asset-title", stagedModelAssetTitle);
            }
            if ((modelDeletionCount = manifestSummary.getModelDeletionCount(manifestSummaryKey)) <= 0L) continue;
            element.addAttribute("deletion-count", String.valueOf(modelDeletionCount));
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._stagingConfiguration = (StagingConfiguration)ConfigurableUtil.createConfigurable(StagingConfiguration.class, properties);
    }

    protected void addCreateDateProperty(PortletDataContext portletDataContext, DynamicQuery dynamicQuery) {
        if (!portletDataContext.hasDateRange()) {
            return;
        }
        Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
        dynamicQuery.add(createDateProperty.ge((Object)portletDataContext.getStartDate()));
        dynamicQuery.add(createDateProperty.le((Object)portletDataContext.getEndDate()));
    }

    protected void doAddCriteria(PortletDataContext portletDataContext, StagedModelType stagedModelType, DynamicQuery dynamicQuery) {
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        if (portletDataContext.getScopeGroupId() != portletDataContext.getCompanyGroupId()) {
            dynamicQuery.add(groupIdProperty.eq((Object)portletDataContext.getScopeGroupId()));
        } else {
            dynamicQuery.add(groupIdProperty.eq((Object)0L));
        }
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getClassNameId()));
        long referrerClassNameId = stagedModelType.getReferrerClassNameId();
        Property referrerClassNameIdProperty = PropertyFactoryUtil.forName((String)"referrerClassNameId");
        if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
            dynamicQuery.add(referrerClassNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
        } else if (referrerClassNameId == -2L) {
            dynamicQuery.add(referrerClassNameIdProperty.isNotNull());
        }
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.eq((Object)1));
        this.addCreateDateProperty(portletDataContext, dynamicQuery);
    }

    protected ZipWriter getZipWriter(String fileName) {
        block3: {
            long companyId = CompanyThreadLocal.getCompanyId();
            try {
                this._stagingConfiguration = (StagingConfiguration)this._configurationProvider.getCompanyConfiguration(StagingConfiguration.class, companyId);
            }
            catch (ConfigurationException configurationException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)configurationException);
            }
        }
        if (!ExportImportThreadLocal.isStagingInProcess() || this._stagingConfiguration.stagingDeleteTempLAROnFailure() && this._stagingConfiguration.stagingDeleteTempLAROnSuccess()) {
            return this._zipWriterFactory.getZipWriter();
        }
        return this._zipWriterFactory.getZipWriter(new File(SystemProperties.get((String)"java.io.tmpdir") + "/" + fileName));
    }

    private Map<String, Boolean> _createAllPortletSetupControlsMap(Map<String, String[]> parameterMap, boolean portletConfiguration) {
        return this._createPortletConfigurablePortletSetupControlsMap(parameterMap, portletConfiguration, "PORTLET_ARCHIVED_SETUPS_ALL", "PORTLET_SETUP_ALL", "PORTLET_USER_PREFERENCES_ALL");
    }

    private Map<String, Boolean> _createPortletConfigurablePortletSetupControlsMap(Map<String, String[]> parameterMap, boolean portletConfiguration, String portletArchivedSetupKey, String portletSetupKey, String portletUserPreferencesKey) {
        boolean portletArchivedSetups = false;
        boolean portletSetup = false;
        boolean portletUserPreferences = false;
        if (portletConfiguration) {
            if (MapUtil.getBoolean(parameterMap, (String)portletArchivedSetupKey)) {
                portletArchivedSetups = true;
            }
            if (MapUtil.getBoolean(parameterMap, (String)portletSetupKey)) {
                portletSetup = true;
            }
            if (MapUtil.getBoolean(parameterMap, (String)portletUserPreferencesKey)) {
                portletUserPreferences = true;
            }
        }
        return this._createPortletSetupControlsMap(portletArchivedSetups, portletConfiguration, portletSetup, portletUserPreferences);
    }

    private Map<String, Boolean> _createPortletSetupControlsMap(boolean portletArchivedSetups, boolean portletConfiguration, boolean portletSetup, boolean portletUserPreferences) {
        return HashMapBuilder.put((Object)"PORTLET_ARCHIVED_SETUPS", (Object)portletArchivedSetups).put((Object)"PORTLET_CONFIGURATION", (Object)portletConfiguration).put((Object)"PORTLET_SETUP", (Object)portletSetup).put((Object)"PORTLET_USER_PREFERENCES", (Object)portletUserPreferences).build();
    }

    private Map<String, Boolean> _createRootPortletSetupControlsMap(Map<String, String[]> parameterMap, boolean portletConfiguration, String rootPortletId) {
        portletConfiguration = portletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_CONFIGURATION_" + rootPortletId));
        String portletArchivedSetupKey = "PORTLET_ARCHIVED_SETUPS_" + rootPortletId;
        String portletSetupKey = "PORTLET_SETUP_" + rootPortletId;
        String portletUserPreferencesKey = "PORTLET_USER_PREFERENCES_" + rootPortletId;
        return this._createPortletConfigurablePortletSetupControlsMap(parameterMap, portletConfiguration, portletArchivedSetupKey, portletSetupKey, portletUserPreferencesKey);
    }

    private boolean _getExportPortletData(long companyId, String portletId, Map<String, String[]> parameterMap) throws Exception {
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
        }
        if (!exportPortletData) {
            return false;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId);
        if (portletDataHandler == null) {
            return false;
        }
        if (exportPortletDataAll) {
            return true;
        }
        return MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + PortletIdCodec.decodePortletName((String)portletId)));
    }

    private Map<String, Boolean> _getExportPortletSetupControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, String type) throws Exception {
        boolean exportPortletConfiguration = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION");
        boolean exportPortletConfigurationAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet configuration " + exportPortletConfiguration));
        }
        String rootPortletId = this.getExportableRootPortletId(companyId, portletId);
        Map<String, Boolean> exportPortletSetupControlsMap = this._createPortletSetupControlsMap(exportPortletConfiguration, exportPortletConfiguration, exportPortletConfiguration, exportPortletConfiguration);
        if (exportPortletConfigurationAll || exportPortletConfiguration && type.equals("layout-prototype")) {
            exportPortletSetupControlsMap = this._createAllPortletSetupControlsMap(parameterMap, true);
        } else if (rootPortletId != null) {
            exportPortletSetupControlsMap = this._createRootPortletSetupControlsMap(parameterMap, exportPortletConfiguration, rootPortletId);
        }
        return exportPortletSetupControlsMap;
    }

    private Map<String, Boolean> _getImportPortletSetupControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, ManifestSummary manifestSummary) throws Exception {
        boolean importPortletConfiguration = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION");
        boolean importPortletConfigurationAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import portlet configuration " + importPortletConfiguration));
        }
        String rootPortletId = this.getExportableRootPortletId(companyId, portletId);
        Map<String, Boolean> importPortletSetupControlsMap = this._createPortletSetupControlsMap(importPortletConfiguration, importPortletConfiguration, importPortletConfiguration, importPortletConfiguration);
        if (importPortletConfigurationAll) {
            String[] configurationPortletOptions;
            boolean importCurPortletConfiguration = true;
            if (manifestSummary != null && (configurationPortletOptions = manifestSummary.getConfigurationPortletOptions(rootPortletId)) == null) {
                importCurPortletConfiguration = false;
            }
            importPortletSetupControlsMap = this._createAllPortletSetupControlsMap(parameterMap, importCurPortletConfiguration);
        } else if (rootPortletId != null) {
            importPortletSetupControlsMap = this._createRootPortletSetupControlsMap(parameterMap, importPortletConfiguration, rootPortletId);
        }
        return importPortletSetupControlsMap;
    }

    private List<Portlet> _getPortlets(long companyId, DataLevel[] dataLevels, boolean excludeDataAlwaysStaged) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        TreeMap<Integer, ArrayList<Portlet>> rankedPortletsMap = new TreeMap<Integer, ArrayList<Portlet>>();
        for (Portlet portlet : this._portletLocalService.getPortlets(companyId)) {
            PortletDataHandler portletDataHandler;
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || !ArrayUtil.contains((Object[])dataLevels, (Object)portletDataHandler.getDataLevel()) || !portletDataHandler.isBatch() && portletDataHandler.isDataPortalLevel() || excludeDataAlwaysStaged && portletDataHandler.isDataAlwaysStaged()) continue;
            ArrayList<Portlet> rankedPortlets = (ArrayList<Portlet>)rankedPortletsMap.get(portletDataHandler.getRank());
            if (rankedPortlets == null) {
                rankedPortlets = new ArrayList<Portlet>();
            }
            rankedPortlets.add(portlet);
            rankedPortletsMap.put(portletDataHandler.getRank(), rankedPortlets);
        }
        for (List rankedPortlets : rankedPortletsMap.values()) {
            portlets.addAll(rankedPortlets);
        }
        return portlets;
    }

    private String _getZipWriterFileName(String id) {
        return StringBundler.concat((String[])new String[]{id, "-", Time.getTimestamp(), ".lar"});
    }

    private boolean _isImportPortletData(long companyId, String portletId, Map<String, String[]> parameterMap, Element portletDataElement) throws Exception {
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import all portlet data " + importPortletDataAll));
        }
        if (!importPortletData) {
            return false;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId);
        if (portletDataHandler == null || portletDataElement == null && !portletDataHandler.isDisplayPortlet()) {
            return false;
        }
        if (importPortletDataAll) {
            return true;
        }
        return MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + PortletIdCodec.decodePortletName((String)portletId)));
    }

    private boolean _isStagedPortlet(PortletDataContext portletDataContext) {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        if (group == null) {
            return false;
        }
        return group.isStagedPortlet(portletDataContext.getPortletId());
    }

    private boolean _populateLayoutsJSON(JSONArray layoutsJSONArray, Layout layout, long[] selectedLayoutIds) {
        boolean checked;
        List childLayouts = layout.getChildren();
        JSONArray childLayoutsJSONArray = null;
        boolean includeChildren = true;
        if (ListUtil.isNotEmpty((List)childLayouts)) {
            childLayoutsJSONArray = this._jsonFactory.createJSONArray();
            for (Layout childLayout : childLayouts) {
                if (this._populateLayoutsJSON(childLayoutsJSONArray, childLayout, selectedLayoutIds)) continue;
                includeChildren = false;
            }
        }
        if (checked = ArrayUtil.contains((long[])selectedLayoutIds, (long)layout.getLayoutId())) {
            layoutsJSONArray.put(JSONUtil.put((String)"includeChildren", (Object)includeChildren).put("plid", layout.getPlid()));
        }
        if (checked && includeChildren) {
            return true;
        }
        if (childLayoutsJSONArray != null) {
            for (int i = 0; i < childLayoutsJSONArray.length(); ++i) {
                layoutsJSONArray.put(childLayoutsJSONArray.getJSONObject(i));
            }
        }
        return false;
    }

    private MissingReference _validateMissingReference(PortletDataContext portletDataContext, Element element) {
        if (Validator.isNotNull((String)element.attributeValue("element-path"))) {
            return null;
        }
        String className = element.attributeValue("class-name");
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)className);
        if (stagedModelDataHandler != null && stagedModelDataHandler.validateReference(portletDataContext, element)) {
            return null;
        }
        MissingReference missingReference = new MissingReference(element);
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        missingReference.setGroupId(MapUtil.getLong((Map)groupIds, (long)GetterUtil.getLong((String)element.attributeValue("group-id"))));
        return missingReference;
    }

    private class ManifestSummaryElementProcessor
    implements ElementProcessor {
        private final Group _group;
        private final ManifestSummary _manifestSummary;

        public ManifestSummaryElementProcessor(Group group, ManifestSummary manifestSummary) {
            this._group = group;
            this._manifestSummary = manifestSummary;
        }

        public void processElement(Element element) {
            String elementName = element.getName();
            if (elementName.equals("header")) {
                String exportDateString = element.attributeValue("export-date");
                this._manifestSummary.setExportDate(GetterUtil.getDate((String)exportDateString, (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z")));
            } else if (elementName.equals("portlet")) {
                String portletId = element.attributeValue("portlet-id");
                Portlet portlet = null;
                try {
                    portlet = ExportImportHelperImpl.this._portletLocalService.getPortletById(this._group.getCompanyId(), portletId);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    return;
                }
                PortletDataHandler portletDataHandler = ExportImportHelperImpl.this._portletDataHandlerProvider.provide(portlet);
                if (portletDataHandler == null) {
                    return;
                }
                String[] configurationPortletOptions = StringUtil.split((String)element.attributeValue("portlet-configuration"));
                if (!(portletDataHandler instanceof DefaultConfigurationPortletDataHandler) && (portletDataHandler.isBatch() && portletDataHandler.isDataPortalLevel() || portletDataHandler.isDataSiteLevel()) && GetterUtil.getBoolean((String)element.attributeValue("portlet-data"))) {
                    this._manifestSummary.addDataPortlet(portlet, configurationPortletOptions);
                } else {
                    this._manifestSummary.addLayoutPortlet(portlet, configurationPortletOptions);
                }
            } else if (elementName.equals("staged-model")) {
                String manifestSummaryKey = element.attributeValue("manifest-summary-key");
                if (Validator.isNull((String)manifestSummaryKey)) {
                    return;
                }
                long modelAdditionCount = GetterUtil.getLong((String)element.attributeValue("addition-count"));
                this._manifestSummary.addModelAdditionCount(manifestSummaryKey, modelAdditionCount);
                String assetTitle = GetterUtil.getString((String)element.attributeValue("asset-title"));
                this._manifestSummary.addAssetTitle(manifestSummaryKey, assetTitle);
                long modelDeletionCount = GetterUtil.getLong((String)element.attributeValue("deletion-count"));
                this._manifestSummary.addModelDeletionCount(manifestSummaryKey, modelDeletionCount);
            }
        }
    }
}

