/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DLReferencesReverseIterator
implements Iterator<DLReference> {
    private static final String[] _DL_REFERENCE_LEGACY_STOP_STRINGS = new String[]{"'", "&apos;", "\\'", "\\\"", "]", "}", ")", ">", "<", "|", "#", "\"", "&quot;", " "};
    private static final String[] _DL_REFERENCE_STOP_STRINGS = new String[]{"'", "&apos;", "\\'", "\\\"", "]", "}", ")", ">", "<", "\n", "|", "#", "?", "\"", "&quot;", " "};
    private static final int _OFFSET_COLON_PORT = 6;
    private static final Log _log = LogFactoryUtil.getLog(DLReferencesReverseIterator.class);
    private static final Pattern _jsonAttributePattern = Pattern.compile("\\\"[^\"\\\\\\\\]*\\\"\\s*:\\s*\\\"");
    private static final Pattern _jsonLocalizedPattern = Pattern.compile("\\\"[^\"\\\\]*\\\"\\s*:\\s*\\{\\\"[a-zA-Z_]+\\\"\\s*:\\s*\\\"[^\"\\\\]*");
    private static final Pattern _uuidPattern = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}(?=[&,?]|$)");
    private final String _content;
    private int _endPos;
    private FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    private final long _groupId;
    private Boolean _hasNext;
    private DLReference _nextDLReference;
    private final String _pathContext;
    private final String[] _patterns;

    public DLReferencesReverseIterator(String content, FileEntryFriendlyURLResolver fileEntryFriendlyURLResolver, long groupId) {
        this._content = content;
        this._fileEntryFriendlyURLResolver = fileEntryFriendlyURLResolver;
        this._groupId = groupId;
        this._endPos = content.length();
        this._pathContext = PortalUtil.getPathContext();
        this._patterns = this._getPatterns(this._pathContext);
    }

    @Override
    public boolean hasNext() {
        if (this._hasNext != null) {
            return this._hasNext;
        }
        this._nextDLReference = this.next();
        this._hasNext = this._nextDLReference != null;
        return this._hasNext;
    }

    @Override
    public DLReference next() {
        FileEntry fileEntry;
        Map<String, String[]> dlReferenceParameters;
        String dlReference;
        if (this._nextDLReference != null) {
            DLReference dlReference2 = this._nextDLReference;
            this._hasNext = null;
            this._nextDLReference = null;
            return dlReference2;
        }
        int beginPos = -1;
        while (true) {
            if ((beginPos = StringUtil.lastIndexOfAny((String)this._content, (String[])this._patterns, (int)this._endPos)) == -1) {
                return null;
            }
            ObjectValuePair<String, Integer> dlReferenceEndPosObjectValuePair = this._getDLReferenceEndPosObjectValuePair(this._content, beginPos + this._pathContext.length(), this._endPos);
            if (dlReferenceEndPosObjectValuePair == null) {
                this._endPos = beginPos - 1;
                continue;
            }
            dlReference = (String)dlReferenceEndPosObjectValuePair.getKey();
            dlReferenceParameters = this._getDLReferenceParameters(this._groupId, this._content, beginPos + this._pathContext.length(), (Integer)dlReferenceEndPosObjectValuePair.getValue(), dlReference);
            if (MapUtil.isEmpty(dlReferenceParameters)) {
                this._endPos = beginPos - 1;
                continue;
            }
            fileEntry = this._getFileEntry(dlReferenceParameters);
            if (fileEntry == null) {
                fileEntry = this._getFileEntry(this._content, beginPos + this._pathContext.length());
            }
            try {
                if (!this._isExternalURL(this._groupId, this._content, beginPos, this._endPos)) break;
                this._endPos = beginPos - 1;
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                this._endPos = beginPos - 1;
            }
        }
        this._endPos = beginPos - 1;
        return new DLReference(beginPos, MapUtil.getInteger(dlReferenceParameters, (String)"endPos"), fileEntry, dlReferenceParameters, dlReference);
    }

    private ObjectValuePair<String, Integer> _getDLReferenceEndPosObjectValuePair(String content, int beginPos, int endPos) {
        int urlPatternPos;
        String[] stopStrings = _DL_REFERENCE_LEGACY_STOP_STRINGS;
        if (!this._isLegacyURL(content, beginPos)) {
            stopStrings = _DL_REFERENCE_STOP_STRINGS;
        }
        if ((urlPatternPos = StringUtil.indexOfAny((String)content, (String[])stopStrings, (int)beginPos, (int)endPos)) == -1) {
            if (endPos != content.length()) {
                return null;
            }
            urlPatternPos = endPos;
        }
        return new ObjectValuePair((Object)content.substring(beginPos, urlPatternPos), (Object)urlPatternPos);
    }

    private Map<String, String[]> _getDLReferenceParameters(long groupId, String content, int beginPos, int endPos, String dlReference) {
        boolean legacyURL = this._isLegacyURL(content, beginPos);
        Map<String, Object> map = new HashMap<String, String[]>();
        while (dlReference.contains("&amp;")) {
            dlReference = StringUtil.replace((String)dlReference, (String)"&amp;", (String)"&");
        }
        if (!legacyURL) {
            String uuid;
            String[] pathArray = dlReference.split("/");
            if (pathArray.length < 3) {
                return map;
            }
            if (Objects.equals(pathArray[2], "d")) {
                if (pathArray.length >= 5) {
                    map.put("friendlyURL", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
                if (pathArray.length >= 4) {
                    map.put("groupName", new String[]{pathArray[3]});
                }
            } else if (Objects.equals(pathArray[2], "portlet_file_entry")) {
                if (pathArray.length >= 4) {
                    map.put("groupId", new String[]{pathArray[3]});
                }
                if (pathArray.length >= 5) {
                    map.put("title", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
            } else {
                map.put("groupId", new String[]{pathArray[2]});
                if (pathArray.length == 5) {
                    map.put("folderId", new String[]{pathArray[3]});
                    map.put("title", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
            }
            if (Validator.isNotNull((String)(uuid = this._getUuid(dlReference)))) {
                map.put("uuid", new String[]{uuid});
            }
        } else {
            dlReference = dlReference.substring(dlReference.indexOf(63) + 1);
            map = HttpComponentsUtil.parameterMapFromString((String)dlReference);
            Object[] imageIds = null;
            if (map.containsKey("img_id")) {
                imageIds = (String[])map.get("img_id");
            } else if (map.containsKey("i_id")) {
                imageIds = (String[])map.get("i_id");
            }
            imageIds = (String[])ArrayUtil.filter((Object[])imageIds, Validator::isNotNull);
            if (ArrayUtil.isNotEmpty((Object[])imageIds)) {
                map.put("image_id", imageIds);
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (Object)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(groupId);
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    private FileEntry _getFileEntry(Map<String, String[]> map) {
        FileEntry fileEntry;
        block19: {
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (Object)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    try {
                        fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                        break block19;
                    }
                    catch (PortalException portalException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Unable to get file entry", (Throwable)portalException);
                        }
                        return DLAppLocalServiceUtil.getFileEntryByExternalReferenceCode((String)uuid, (long)groupId);
                    }
                }
                if (map.containsKey("friendlyURL")) {
                    String friendlyURL = MapUtil.getString(map, (Object)"friendlyURL");
                    fileEntry = this._resolveFileEntry(MapUtil.getString(map, (Object)"groupName"), friendlyURL);
                    if (fileEntry == null) {
                        throw new NoSuchFileEntryException("No file entry found for friendly URL " + friendlyURL);
                    }
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (Object)"name");
                    String title = MapUtil.getString(map, (Object)"title");
                    if (Validator.isNotNull((String)title)) {
                        try {
                            fileEntry = DLAppLocalServiceUtil.getFileEntryByFileName((long)groupId, (long)folderId, (String)title);
                        }
                        catch (NoSuchFileEntryException noSuchFileEntryException) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Throwable)noSuchFileEntryException);
                            }
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
                        }
                    } else {
                        DLFileEntry dlFileEntry2 = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                        if (dlFileEntry2 != null) {
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block19;
                _log.warn((Throwable)exception);
            }
        }
        return fileEntry;
    }

    private FileEntry _getFileEntry(String content, int beginPos) {
        int cdataBeginPos = StringUtil.lastIndexOfAny((String)content, (String[])new String[]{"<![CDATA["}, (int)beginPos);
        if (cdataBeginPos == -1) {
            return null;
        }
        int cdataEndPos = StringUtil.indexOfAny((String)content, (String[])new String[]{"]]>"}, (int)cdataBeginPos);
        if (cdataEndPos == -1) {
            return null;
        }
        int jsonBeginPos = StringUtil.indexOfAny((String)content, (char[])new char[]{'{'}, (int)cdataBeginPos, (int)cdataEndPos);
        int jsonEndPos = StringUtil.lastIndexOfAny((String)content, (char[])new char[]{'}'}, (int)cdataBeginPos, (int)cdataEndPos);
        if (jsonBeginPos == -1 || jsonEndPos == -1) {
            return null;
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content.substring(jsonBeginPos, jsonEndPos + 1));
            return DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)jsonObject.getString("uuid"), (long)jsonObject.getLong("groupId"));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private Group _getGroup(FileEntry fileEntry, Map<String, String[]> parameteres) {
        block5: {
            try {
                if (fileEntry != null) {
                    return GroupLocalServiceUtil.getGroup((long)fileEntry.getGroupId());
                }
                if (parameteres.containsKey("groupId")) {
                    return GroupLocalServiceUtil.getGroup((long)MapUtil.getLong(parameteres, (String)"groupId"));
                }
                if (parameteres.containsKey("groupName")) {
                    return this._getGroup(MapUtil.getString(parameteres, (Object)"groupName"));
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return null;
    }

    private Group _getGroup(String name) throws Exception {
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)CompanyThreadLocal.getCompanyId(), (String)("/" + name));
        if (group != null) {
            return group;
        }
        User user = UserLocalServiceUtil.getUserByScreenName((long)CompanyThreadLocal.getCompanyId(), (String)name);
        return user.getGroup();
    }

    private String[] _getPatterns(String contextPath) {
        return new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
    }

    private String _getUuid(String s) {
        Matcher matcher = _uuidPattern.matcher(s);
        String uuid = "";
        while (matcher.find()) {
            uuid = matcher.group(0);
        }
        return uuid;
    }

    private boolean _isCreoleReference(String content, int beginPos) {
        return content.regionMatches(true, beginPos - 2, "[[", 0, 2) || content.regionMatches(true, beginPos - 2, "{{", 0, 2);
    }

    private boolean _isExternalURL(long groupId, String content, int beginPos, int endPos) throws PortalException {
        ServiceContext serviceContext;
        if (beginPos == 0 && endPos == content.length() || this._isCreoleReference(content, beginPos) || this._isHTMLReference(content, beginPos) || this._isJSONReference(content, beginPos) || this._isStyleReference(content, beginPos)) {
            return false;
        }
        String portalURL = this._pathContext;
        if (Validator.isNull((String)portalURL) && (serviceContext = ServiceContextThreadLocal.getServiceContext()) != null && serviceContext.getThemeDisplay() != null) {
            portalURL = PortalUtil.getPortalURL((ThemeDisplay)serviceContext.getThemeDisplay());
        }
        HashSet<Object> hostnames = new HashSet<Object>();
        hostnames.add(portalURL);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        for (VirtualHost virtualHost : VirtualHostLocalServiceUtil.getVirtualHosts((long)group.getCompanyId())) {
            String hostname = virtualHost.getHostname();
            hostnames.add(hostname);
            hostnames.add("http://" + hostname);
            hostnames.add("https://" + hostname);
        }
        int colonPos = 0;
        for (int i = 1; i <= 6 && i <= beginPos; ++i) {
            if (content.charAt(beginPos - i) != ':') continue;
            colonPos = i;
            break;
        }
        long urlPort = 0L;
        if (colonPos > 0) {
            urlPort = GetterUtil.getLong((String)content.substring(beginPos - colonPos + 1, beginPos));
        }
        for (String string : hostnames) {
            String substring;
            int curBeginPos;
            int serverPort;
            if (urlPort > 0L && urlPort != (long)(serverPort = PortalUtil.getPortalServerPort((boolean)string.startsWith("https://"))) || (curBeginPos = beginPos - string.length() - colonPos) < 0 || !(substring = content.substring(curBeginPos, endPos)).startsWith(string) || (curBeginPos != 0 || endPos != content.length()) && !this._isCreoleReference(content, curBeginPos) && !this._isHTMLReference(content, curBeginPos) && !this._isJSONReference(content, curBeginPos) && !this._isStyleReference(content, curBeginPos)) continue;
            return false;
        }
        return true;
    }

    private boolean _isHTMLReference(String content, int beginPos) {
        String[] attributes;
        if (content.regionMatches(beginPos - 1, "'", 0, 1) || content.regionMatches(beginPos - 1, "\"", 0, 1)) {
            --beginPos;
        }
        if (content.regionMatches(true, beginPos - 1, "\\", 0, 1)) {
            --beginPos;
        }
        for (String attribute : attributes = new String[]{"href=", "src="}) {
            if (!content.regionMatches(true, beginPos - attribute.length(), attribute, 0, attribute.length())) continue;
            return true;
        }
        return false;
    }

    private boolean _isJSONReference(String content, int beginPos) {
        String[] jsonAttributes = new String[]{"\"href\"", "\"url\""};
        int position = StringUtil.lastIndexOfAny((String)content, (String[])jsonAttributes, (int)beginPos);
        if (position == -1) {
            return false;
        }
        return _jsonAttributePattern.matcher(content.substring(position, beginPos)).matches() || _jsonLocalizedPattern.matcher(content.substring(position, beginPos)).matches();
    }

    private boolean _isLegacyURL(String content, int beginPos) {
        return !content.startsWith("/documents/", beginPos);
    }

    private boolean _isStyleReference(String content, int beginPos) {
        if (content.regionMatches((beginPos = this._skipWhiteSpacePos(content, beginPos)) - 1, "'", 0, 1) || content.regionMatches(beginPos - 1, "\"", 0, 1)) {
            --beginPos;
        }
        beginPos = this._skipWhiteSpacePos(content, beginPos);
        String url = "url(";
        return content.regionMatches(true, beginPos - url.length(), url, 0, 2);
    }

    private FileEntry _resolveFileEntry(String groupName, String friendlyURL) throws Exception {
        if (this._fileEntryFriendlyURLResolver == null) {
            return null;
        }
        Group group = this._getGroup(groupName);
        return this._fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), friendlyURL);
    }

    private int _skipWhiteSpacePos(String content, int beginPos) {
        while (content.regionMatches(beginPos - 1, "\n", 0, 1) || content.regionMatches(beginPos - 1, "\r", 0, 1) || content.regionMatches(beginPos - 1, " ", 0, 1) || content.regionMatches(beginPos - 1, "\t", 0, 1)) {
            --beginPos;
        }
        return beginPos;
    }

    public class DLReference {
        private final int _beginPos;
        private final int _endPos;
        private final FileEntry _fileEntry;
        private final Group _group;
        private final Map<String, String[]> _parameters;
        private final String _reference;

        public DLReference(int beginPos, int endPos, FileEntry fileEntry, Map<String, String[]> parameters, String reference) {
            this._beginPos = beginPos;
            this._endPos = endPos;
            this._fileEntry = fileEntry;
            this._parameters = parameters;
            this._reference = reference;
            this._group = DLReferencesReverseIterator.this._getGroup(fileEntry, parameters);
        }

        public boolean containsParameter(String name) {
            return this._parameters.containsKey(name);
        }

        public int getBeginPos() {
            return this._beginPos;
        }

        public int getEndPos() {
            return this._endPos;
        }

        public FileEntry getFileEntry() {
            return this._fileEntry;
        }

        public Group getGroup() {
            return this._group;
        }

        public String getParameter(String name) {
            return MapUtil.getString(this._parameters, (Object)name);
        }

        public Map<String, String[]> getParameters() {
            return this._parameters;
        }

        public String getReference() {
            return this._reference;
        }
    }
}

