/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.internal.exportimport.content.processor.DLReferencesReverseIterator;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.report.model.ExportImportReportEntry;
import com.liferay.exportimport.report.service.ExportImportReportEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.staging.StagingGroupHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=DLReferences"}, service={ExportImportContentProcessor.class})
public class DLReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final Log _log = LogFactoryUtil.getLog(DLReferencesExportImportContentProcessor.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private ExportImportReportEntryLocalService _exportImportReportEntryLocalService;
    @Reference
    private FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet") && ExportImportThreadLocal.isStagingInProcess()) {
            return content;
        }
        return this._replaceExportDLReferences(content, exportReferencedContent, portletDataContext, stagedModel);
    }

    public String replaceExportContentReferences(String content, PortletDataContext portletDataContext) {
        StringBuilder sb = new StringBuilder(content);
        DLReferencesReverseIterator dlReferencesReverseIterator = new DLReferencesReverseIterator(content, this._fileEntryFriendlyURLResolver, portletDataContext.getScopeGroupId());
        while (dlReferencesReverseIterator.hasNext()) {
            DLReferencesReverseIterator.DLReference dlReference = dlReferencesReverseIterator.next();
            FileEntry fileEntry = dlReference.getFileEntry();
            String externalReferenceCode = null;
            String uuid = null;
            if (fileEntry != null) {
                externalReferenceCode = fileEntry.getExternalReferenceCode();
                uuid = fileEntry.getUuid();
            } else {
                if (Validator.isBlank((String)dlReference.getParameter("friendlyURL"))) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)"The file entry does not exist and the friendly URL parameter was not parsed");
                    continue;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("The file entry with friendly URL " + dlReference.getParameter("friendlyURL") + " does not exist"));
                }
            }
            Group group = dlReference.getGroup();
            if (group == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to get group for document library reference " + dlReference.getReference()));
                continue;
            }
            DocumentLibraryReference documentLibraryReference = new DocumentLibraryReference(externalReferenceCode, dlReference.getParameter("friendlyURL"), group.getFriendlyURL(), group.getGroupId(), uuid);
            sb.replace(dlReference.getBeginPos(), dlReference.getEndPos(), documentLibraryReference.toString());
        }
        return sb.toString();
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this._replaceImportDLReferences(content, portletDataContext, stagedModel);
    }

    public String replaceImportContentReferences(String content, PortletDataContext portletDataContext) throws Exception {
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        for (DocumentLibraryReference documentLibraryReference : DocumentLibraryReference.parse(content)) {
            Group group;
            long groupId;
            FileEntry fileEntry;
            if (!this._isSameFileEntry(documentLibraryReference, fileEntry = this._fileEntryFriendlyURLResolver.resolveFriendlyURL(groupId = (group = this._getGroup(portletDataContext.getCompanyId(), documentLibraryReference, groupIds)) != null ? group.getGroupId() : 0L, documentLibraryReference.getFileEntryFriendlyURL()))) {
                if (_log.isDebugEnabled()) {
                    if (fileEntry == null) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"The file entry with friendly URL ", documentLibraryReference.getFileEntryFriendlyURL(), " and group friendly URL ", documentLibraryReference.getGroupFriendlyURL(), " does not exist"}));
                    } else {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"The file entry with friendly URL ", documentLibraryReference.getFileEntryFriendlyURL(), " and group with friendly URL ", documentLibraryReference.getGroupFriendlyURL(), " exists but it may contain incorrect data"}));
                    }
                }
                boolean companyGroup = false;
                if (group != null) {
                    companyGroup = this._stagingGroupHelper.isCompanyGroup(group);
                }
                ExportImportReportEntry exportImportReportEntry = this._exportImportReportEntryLocalService.addEmptyExportImportReportEntry(companyGroup ? 0L : groupId, portletDataContext.getCompanyId(), documentLibraryReference.getExternalReferenceCode(), this._classNameLocalService.getClassNameId(FileEntry.class), GetterUtil.getLong((Object)ExportImportThreadLocal.getExportImportConfigurationId()), FileEntry.class.getName());
                this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), () -> {
                    FileEntry afterImportFileEntry = this._fileEntryFriendlyURLResolver.resolveFriendlyURL(groupId, documentLibraryReference.getFileEntryFriendlyURL());
                    if (this._isSameFileEntry(documentLibraryReference, afterImportFileEntry)) {
                        this._exportImportReportEntryLocalService.deleteExportImportReportEntry(exportImportReportEntry.getExportImportReportEntryId());
                    }
                    return null;
                });
            }
            content = StringUtil.replaceLast((String)content, (String)documentLibraryReference.getReferenceString(), (String)this._getUrl(documentLibraryReference, fileEntry, group));
        }
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        if (this._isValidateDLReferences()) {
            this._validateDLReferences(content, groupId);
        }
    }

    private Group _getGroup(long companyId, DocumentLibraryReference documentLibraryReference, Map<Long, Long> groupIds) {
        try {
            if (groupIds.containsKey(documentLibraryReference.getGroupId())) {
                return this._groupLocalService.getGroup(groupIds.get(documentLibraryReference.getGroupId()).longValue());
            }
            return this._groupLocalService.fetchFriendlyURLGroup(companyId, documentLibraryReference.getGroupFriendlyURL());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private String _getUrl(DocumentLibraryReference documentLibraryReference, FileEntry fileEntry, Group group) throws Exception {
        if (fileEntry == null) {
            return this._dlURLHelper.getPreviewURL(documentLibraryReference.getFileEntryFriendlyURL(), group != null ? group.getFriendlyURL() : documentLibraryReference.getGroupFriendlyURL());
        }
        return this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
    }

    private boolean _isSameFileEntry(DocumentLibraryReference documentLibraryReference, FileEntry fileEntry) {
        return fileEntry != null && StringUtil.equals((String)documentLibraryReference.getExternalReferenceCode(), (String)fileEntry.getExternalReferenceCode()) && StringUtil.equals((String)documentLibraryReference.getUuid(), (String)fileEntry.getUuid());
    }

    private boolean _isValidateDLReferences() {
        try {
            ExportImportServiceConfiguration exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return exportImportServiceConfiguration.validateFileEntryReferences();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    private String _replaceExportDLReferences(String content, boolean exportReferencedContent, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        StringBuilder sb = new StringBuilder(content);
        DLReferencesReverseIterator dlReferencesReverseIterator = new DLReferencesReverseIterator(content, this._fileEntryFriendlyURLResolver, portletDataContext.getScopeGroupId());
        while (dlReferencesReverseIterator.hasNext()) {
            DLReferencesReverseIterator.DLReference dlReference = dlReferencesReverseIterator.next();
            FileEntry fileEntry = dlReference.getFileEntry();
            if (fileEntry == null) continue;
            if (exportReferencedContent && !fileEntry.isInTrash()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)fileEntry, (String)"dependency");
            } else {
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                String referenceType = "dependency";
                if (fileEntry.isInTrash()) {
                    referenceType = "disposable_dependency";
                }
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)fileEntry, referenceType, true);
            }
            String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
            StringBundler exportedReferenceSB = new StringBundler(10);
            exportedReferenceSB.append("[$dl-reference=");
            exportedReferenceSB.append(path);
            if (dlReference.containsParameter("friendlyURL")) {
                exportedReferenceSB.append("$,$include-friendly-url=true");
            } else {
                exportedReferenceSB.append("$,$include-uuid=");
                exportedReferenceSB.append(dlReference.containsParameter("uuid"));
            }
            exportedReferenceSB.append("$]");
            if (fileEntry.isInTrash()) {
                String originalReference = sb.substring(dlReference.getBeginPos(), dlReference.getEndPos());
                exportedReferenceSB.append("[#dl-reference=");
                exportedReferenceSB.append(originalReference);
                if (dlReference.containsParameter("friendlyURL")) {
                    exportedReferenceSB.append("#,#include-friendly-url=true");
                } else {
                    exportedReferenceSB.append("#,#include-uuid=");
                    exportedReferenceSB.append(dlReference.containsParameter("uuid"));
                }
                exportedReferenceSB.append("#]");
            }
            sb.replace(dlReference.getBeginPos(), dlReference.getEndPos(), exportedReferenceSB.toString());
        }
        return sb.toString();
    }

    private String _replaceImportDLReferences(String content, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            Long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, DLFileEntry.class, classPK.longValue());
            String path = null;
            if (referenceDataElement != null) {
                path = referenceDataElement.attributeValue("path");
            }
            if (Validator.isNull(path)) {
                long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                String className = referenceElement.attributeValue("class-name");
                path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (Serializable)classPK);
            }
            while (content.contains("[$dl-reference=" + path + "$,$include-friendly-url=true$]") || content.contains("[$dl-reference=" + path + "$,$include-uuid=false$]") || content.contains("[$dl-reference=" + path + "$,$include-uuid=true$]")) {
                String url;
                block14: {
                    try {
                        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, DLFileEntry.class, (Serializable)classPK);
                    }
                    catch (Exception exception) {
                        StringBundler exceptionSB = new StringBundler(6);
                        exceptionSB.append("Unable to process file entry ");
                        exceptionSB.append((Object)classPK);
                        exceptionSB.append(" for ");
                        exceptionSB.append(stagedModel.getModelClassName());
                        exceptionSB.append(" with primary key ");
                        exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                        ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                        }
                        if (!_log.isWarnEnabled()) break block14;
                        _log.warn((Object)exceptionSB.toString());
                    }
                }
                Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
                long fileEntryId = MapUtil.getLong((Map)dlFileEntryIds, (long)classPK, (long)classPK);
                int beginPos = content.indexOf("[$dl-reference=" + path);
                int endPos = content.indexOf("$]", beginPos) + 2;
                FileEntry importedFileEntry = null;
                try {
                    importedFileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)portalException);
                    }
                    if (content.startsWith("[#dl-reference=", endPos)) {
                        int prefixPos = endPos + "[#dl-reference=".length();
                        int postfixPos = content.indexOf("#]", prefixPos);
                        String originalReference = content.substring(prefixPos, postfixPos);
                        String exportedReference = content.substring(beginPos, postfixPos + 2);
                        content = StringUtil.replace((String)content, (String)exportedReference, (String)originalReference);
                        continue;
                    }
                    throw portalException;
                }
                boolean appendVersion = false;
                if (!content.contains("$include-friendly-url=true$")) {
                    appendVersion = true;
                }
                if ((url = this._dlURLHelper.getPreviewURL(importedFileEntry, importedFileEntry.getFileVersion(), null, "", appendVersion, false)).contains("?")) {
                    url = url.substring(0, url.lastIndexOf("?"));
                }
                String urlWithoutUUID = url.substring(0, url.lastIndexOf("/"));
                String exportedReferenceFriendlyURL = "[$dl-reference=" + path + "$,$include-friendly-url=true$]";
                String exportedReferenceWithoutUUID = "[$dl-reference=" + path + "$,$include-uuid=false$]";
                String exportedReferenceWithUUID = "[$dl-reference=" + path + "$,$include-uuid=true$]";
                if (content.startsWith("[#dl-reference=", endPos)) {
                    int friendlyURLPosition = content.indexOf("#,#include-friendly-url=true", beginPos);
                    endPos = friendlyURLPosition != -1 ? friendlyURLPosition + 2 : content.indexOf("#,#include-uuid=", beginPos) + 2;
                    exportedReferenceFriendlyURL = content.substring(beginPos, endPos) + "#include-friendly-url=true#]";
                    exportedReferenceWithoutUUID = content.substring(beginPos, endPos) + "#include-uuid=false#]";
                    exportedReferenceWithUUID = content.substring(beginPos, endPos) + "#include-uuid=true#]";
                }
                content = StringUtil.replace((String)content, (String)exportedReferenceFriendlyURL, (String)url);
                content = StringUtil.replace((String)content, (String)exportedReferenceWithUUID, (String)url);
                content = StringUtil.replace((String)content, (String)exportedReferenceWithoutUUID, (String)urlWithoutUUID);
            }
        }
        return content;
    }

    private void _validateDLReferences(String content, long groupId) throws PortalException {
        DLReferencesReverseIterator dlReferencesReverseIterator = new DLReferencesReverseIterator(content, this._fileEntryFriendlyURLResolver, groupId);
        while (dlReferencesReverseIterator.hasNext()) {
            DLReferencesReverseIterator.DLReference dlReference = dlReferencesReverseIterator.next();
            if (dlReference.getFileEntry() != null) continue;
            ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(DLReferencesExportImportContentProcessor.class.getName(), (Throwable)new NoSuchFileEntryException());
            exportImportContentValidationException.setDLReferenceParameters(dlReference.getParameters());
            exportImportContentValidationException.setDLReference(dlReference.getReference());
            exportImportContentValidationException.setType(5);
            throw exportImportContentValidationException;
        }
    }

    private static class DocumentLibraryReference {
        private static final String _BEGIN = "[$dl-reference$";
        private static final String _END = "$]";
        private static final String _EXTERNAL_REFERENCE_CODE = "external-reference-code";
        private static final String _FILE_ENTRY_FRIENDLY_URL = "file-entry-friendly-url";
        private static final String _GROUP_FRIENDLY_URL = "group-friendly-url";
        private static final String _GROUP_ID = "group-id";
        private static final String _UUID = "uuid";
        private final String _externalReferenceCode;
        private final String _fileEntryFriendlyURL;
        private final String _groupFriendlyURL;
        private final long _groupId;
        private String _referenceString;
        private final String _uuid;

        public static List<DocumentLibraryReference> parse(String value) {
            ArrayList<DocumentLibraryReference> documentLibraryReferences = new ArrayList<DocumentLibraryReference>();
            int startIndex = -1;
            while ((startIndex = value.indexOf(_BEGIN)) != -1) {
                int endIndex = value.indexOf(_END, startIndex);
                String reference = value.substring(startIndex, endIndex + _END.length());
                String externalReferenceCode = DocumentLibraryReference._decode(DocumentLibraryReference._getArgumentValue(_EXTERNAL_REFERENCE_CODE, reference));
                String fileEntryFriendlyURL = DocumentLibraryReference._getArgumentValue(_FILE_ENTRY_FRIENDLY_URL, reference);
                String groupFriendlyURL = DocumentLibraryReference._getArgumentValue(_GROUP_FRIENDLY_URL, reference);
                long groupId = GetterUtil.getLong((String)DocumentLibraryReference._getArgumentValue(_GROUP_ID, reference));
                String uuid = DocumentLibraryReference._getArgumentValue(_UUID, reference);
                documentLibraryReferences.add(new DocumentLibraryReference(externalReferenceCode, fileEntryFriendlyURL, groupFriendlyURL, groupId, reference, uuid));
                value = value.substring(endIndex + _END.length());
            }
            return documentLibraryReferences;
        }

        public String getExternalReferenceCode() {
            return this._externalReferenceCode;
        }

        public String getFileEntryFriendlyURL() {
            return this._fileEntryFriendlyURL;
        }

        public String getGroupFriendlyURL() {
            return this._groupFriendlyURL;
        }

        public long getGroupId() {
            return this._groupId;
        }

        public String getReferenceString() {
            return this._referenceString;
        }

        public String getUuid() {
            return this._uuid;
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{_BEGIN, " $", _EXTERNAL_REFERENCE_CODE, "=", this._encode(this._externalReferenceCode), "$,$", _FILE_ENTRY_FRIENDLY_URL, "=", this._fileEntryFriendlyURL, "$,$", _GROUP_FRIENDLY_URL, "=", this._groupFriendlyURL, "$,$", _GROUP_ID, "=", this._groupId, "$,$", _UUID, "=", this._uuid, _END});
        }

        private static String _decode(String text) {
            return StringUtil.replace((String)text, (String[])new String[]{"\\$\\", "\\[\\", "\\]\\"}, (String[])new String[]{"$", "[", "]"});
        }

        private static String _getArgumentValue(String name, String reference) {
            String key = "$" + name + "=";
            int beginIndex = reference.indexOf(key);
            int endIndex = StringUtil.indexOfAny((String)reference, (String[])new String[]{"$,$", _END}, (int)beginIndex, (int)reference.length());
            return reference.substring(beginIndex + key.length(), endIndex);
        }

        private DocumentLibraryReference(String externalReferenceCode, String fileEntryFriendlyURL, String groupFriendlyURL, long groupId, String uuid) {
            this(externalReferenceCode, fileEntryFriendlyURL, groupFriendlyURL, groupId, null, uuid);
        }

        private DocumentLibraryReference(String externalReferenceCode, String fileEntryFriendlyURL, String groupFriendlyURL, long groupId, String referenceString, String uuid) {
            this._externalReferenceCode = GetterUtil.getString((String)externalReferenceCode);
            this._fileEntryFriendlyURL = fileEntryFriendlyURL;
            this._groupFriendlyURL = groupFriendlyURL;
            this._groupId = groupId;
            this._referenceString = referenceString;
            this._uuid = GetterUtil.getString((String)uuid);
        }

        private String _encode(String text) {
            return StringUtil.replace((String)text, (String[])new String[]{"$", "[", "]"}, (String[])new String[]{"\\$\\", "\\[\\", "\\]\\"});
        }
    }
}

