/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.batch.engine.action;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.action.ExportTaskPostAction;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.ExportImportContentProcessorRegistryUtil;
import com.liferay.exportimport.internal.lar.ExportImportDescriptorThreadLocal;
import com.liferay.exportimport.internal.lar.PortletDataContextThreadLocal;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(service={ExportTaskPostAction.class})
public class DependencyManagementExportTaskPostAction
implements ExportTaskPostAction {
    private static final Log _log = LogFactoryUtil.getLog(DependencyManagementExportTaskPostAction.class);

    public void run(BatchEngineExportTask batchEngineExportTask, BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, Object item) throws Exception {
        if (!ExportImportThreadLocal.isExportInProcess()) {
            return;
        }
        ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor exportImportDescriptor = ExportImportDescriptorThreadLocal.getExportImportDescriptor();
        if (exportImportDescriptor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get the export import descriptor");
            }
            return;
        }
        Map references = exportImportDescriptor.getReferences();
        if (MapUtil.isEmpty((Map)references)) {
            return;
        }
        PortletDataContext portletDataContext = PortletDataContextThreadLocal.getPortletDataContext();
        if (portletDataContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get the portlet data context");
            }
            return;
        }
        Method getPropertyValueMethod = null;
        Method setPropertyValueMethod = null;
        for (Map.Entry entry : references.entrySet()) {
            String fieldName = (String)entry.getKey();
            Class<?> itemClass = item.getClass();
            Method getMethod = this._fetchDeclaredMethod(itemClass, "get" + StringUtil.upperCaseFirstLetter((String)fieldName), new Class[0]);
            if (getMethod == null && getPropertyValueMethod == null) {
                getPropertyValueMethod = this._fetchDeclaredMethod(itemClass, "getPropertyValue", String.class);
            }
            if (getMethod == null && getPropertyValueMethod == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to find the get method for the field \"" + fieldName + "\""));
                continue;
            }
            Method setMethod = this._fetchDeclaredMethod(itemClass, "set" + StringUtil.upperCaseFirstLetter((String)fieldName), UnsafeSupplier.class);
            if (setMethod == null && setPropertyValueMethod == null) {
                setPropertyValueMethod = this._fetchDeclaredMethod(itemClass, "setPropertyValue", String.class, Object.class);
            }
            if (setMethod == null && setPropertyValueMethod == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to find the set method for the field \"" + fieldName + "\""));
                continue;
            }
            for (String contentProcessorType : (String[])entry.getValue()) {
                ExportImportContentProcessor exportImportContentProcessor = ExportImportContentProcessorRegistryUtil.getExportImportContentProcessorByContentProcessorType((String)contentProcessorType);
                if (exportImportContentProcessor == null) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to get the export import content ", "processor for the content processor type \"", contentProcessorType, "\""}));
                    continue;
                }
                String value = getMethod != null ? GetterUtil.getString((Object)getMethod.invoke(item, new Object[0])) : GetterUtil.getString((Object)getPropertyValueMethod.invoke(item, fieldName));
                if (setMethod != null) {
                    setMethod.invoke(item, () -> exportImportContentProcessor.replaceExportContentReferences(value, portletDataContext));
                    continue;
                }
                setPropertyValueMethod.invoke(item, fieldName, exportImportContentProcessor.replaceExportContentReferences(value, portletDataContext));
            }
        }
    }

    private Method _fetchDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (clazz == Object.class) {
            return null;
        }
        Method method = ReflectionUtil.fetchDeclaredMethod(clazz, (String)name, (Class[])parameterTypes);
        if (method == null) {
            return this._fetchDeclaredMethod(clazz.getSuperclass(), name, parameterTypes);
        }
        return method;
    }
}

