/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.notifications;

import com.liferay.exportimport.kernel.configuration.constants.ExportImportConfigurationConstants;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplayFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import jakarta.portlet.PortletURL;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet"}, service={UserNotificationHandler.class})
public class ExportImportUserNotificationHandler
extends BaseUserNotificationHandler {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportUserNotificationHandler.class);
    @Reference
    private BackgroundTaskDisplayFactory _backgroundTaskDisplayFactory;
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public ExportImportUserNotificationHandler() {
        this.setOpenDialog(true);
        this.setPortletId("com_liferay_exportimport_web_portlet_ExportImportPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return this._getMessage(userNotificationEvent, serviceContext);
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
        long backgroundTaskId = jsonObject.getLong("backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId);
        if (backgroundTask == null || serviceContext.getThemeDisplay() == null) {
            return "";
        }
        return PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)serviceContext.getRequest(), (String)"com_liferay_exportimport_web_portlet_ExportImportPortlet", (String)"RENDER_PHASE")).setMVCPath("/view_export_import.jsp").setBackURL(serviceContext.getCurrentURL()).setParameter("backgroundTaskId", (Object)backgroundTaskId).buildString();
    }

    protected String getTitle(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return this._getMessage(userNotificationEvent, serviceContext);
    }

    private String _getMessage(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getLocale(serviceContext.getRequest());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
        ExportImportConfiguration exportImportConfiguration = null;
        try {
            exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(jsonObject.getLong("exportImportConfigurationId"));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return this._language.get(locale, "the-process-referenced-by-this-notification-does-not-exist");
        }
        String typeLabel = ExportImportConfigurationConstants.getTypeLabel((int)exportImportConfiguration.getType());
        String message = "x-" + typeLabel;
        int status = jsonObject.getInt("status");
        if (status == 3) {
            message = message + "-process-finished-successfully";
        } else if (status == 2) {
            message = message + "-process-failed";
        } else {
            return "Unable to process notification: " + HtmlUtil.escape((String)jsonObject.toString());
        }
        long backgroundTaskId = jsonObject.getLong("backgroundTaskId");
        BackgroundTaskDisplay backgroundTaskDisplay = this._backgroundTaskDisplayFactory.getBackgroundTaskDisplay(backgroundTaskId);
        String processName = backgroundTaskDisplay.getDisplayName(serviceContext.getRequest());
        return this._language.format(locale, message, (Object)processName);
    }
}

