/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.data.handler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegateRegistry;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.batch.engine.jaxrs.uri.BatchEngineUriInfo;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.batch.engine.service.BatchEngineExportTaskService;
import com.liferay.batch.engine.service.BatchEngineImportTaskService;
import com.liferay.exportimport.internal.data.handler.BatchEnginePortletDataHandlerUtil;
import com.liferay.exportimport.internal.lar.PortletDataContextThreadLocal;
import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import jakarta.portlet.PortletPreferences;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BatchEnginePortletDataHandler
extends BasePortletDataHandler {
    public static final String BATCH_DELETE_CLASS_NAME_POSTFIX = "_batchDeleteExternalReferenceCodes";
    public static final String SCHEMA_VERSION = "4.0.0";
    protected static final TransactionConfig transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    private final BatchEngineExportTaskService _batchEngineExportTaskService;
    private final BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    private final BatchEngineImportTaskService _batchEngineImportTaskService;
    private final BatchEngineTaskItemDelegateRegistry _batchEngineTaskItemDelegateRegistry;
    private final String _className;
    private final CompanyLocalService _companyLocalService;
    private final String _deletionsFileName;
    private final ExportImportVulcanBatchEngineTaskItemDelegate<?> _exportImportVulcanBatchEngineTaskItemDelegate;
    private final String _fileName;
    private final String _itemClassName;
    private final String _taskItemDelegateName;
    private final UserLocalService _userLocalService;

    public BatchEnginePortletDataHandler(BatchEngineExportTaskExecutor batchEngineExportTaskExecutor, BatchEngineExportTaskService batchEngineExportTaskService, BatchEngineImportTaskExecutor batchEngineImportTaskExecutor, BatchEngineImportTaskService batchEngineImportTaskService, BatchEngineTaskItemDelegateRegistry batchEngineTaskItemDelegateRegistry, String className, CompanyLocalService companyLocalService, ExportImportVulcanBatchEngineTaskItemDelegate exportImportVulcanBatchEngineTaskItemDelegate, String itemClassName, String taskItemDelegateName, UserLocalService userLocalService) {
        this._batchEngineExportTaskExecutor = batchEngineExportTaskExecutor;
        this._batchEngineExportTaskService = batchEngineExportTaskService;
        this._batchEngineImportTaskExecutor = batchEngineImportTaskExecutor;
        this._batchEngineImportTaskService = batchEngineImportTaskService;
        this._batchEngineTaskItemDelegateRegistry = batchEngineTaskItemDelegateRegistry;
        this._className = className;
        this._companyLocalService = companyLocalService;
        this._exportImportVulcanBatchEngineTaskItemDelegate = exportImportVulcanBatchEngineTaskItemDelegate;
        this._itemClassName = itemClassName;
        this._taskItemDelegateName = taskItemDelegateName;
        this._userLocalService = userLocalService;
        String fileNamePrefix = GetterUtil.getString((String)taskItemDelegateName, (String)className);
        this._deletionsFileName = fileNamePrefix + "_deletions.json";
        this._fileName = fileNamePrefix + ".json";
        if (ExportImportVulcanBatchEngineTaskItemDelegate.Scope.COMPANY.equals((Object)exportImportVulcanBatchEngineTaskItemDelegate.getScope())) {
            this.setDataLevel(DataLevel.PORTAL);
        } else {
            this.setDataLevel(DataLevel.SITE);
        }
        this.setEmptyControlsAllowed(true);
    }

    public void exportDeletionSystemEvents(PortletDataContext portletDataContext) {
        Map map = portletDataContext.getNewPrimaryKeysMap(this._itemClassName + BATCH_DELETE_CLASS_NAME_POSTFIX);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String key : map.keySet()) {
            jsonArray.put(JSONUtil.put((String)"externalReferenceCode", (Object)String.valueOf(key)));
        }
        portletDataContext.addZipEntry(this._normalize(this._deletionsFileName, portletDataContext.getScopeGroupId()), jsonArray.toString());
    }

    public String[] getClassNames() {
        return new String[]{this._className};
    }

    public StagedModelType[] getDeletionSystemEventStagedModelTypes() {
        return new StagedModelType[]{new StagedModelType(this._itemClassName)};
    }

    public String getName() {
        return this._className + "#" + this._taskItemDelegateName;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isBatch() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.getZipReader() == null) {
            return portletPreferences;
        }
        InputStream inputStream = portletDataContext.getZipEntryAsInputStream(this._normalize(this._deletionsFileName, portletDataContext.getSourceGroupId()));
        if (inputStream == null) {
            return portletPreferences;
        }
        BatchEngineImportTask batchEngineDeleteTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, this._className, this._getBytes(this._normalize(this._fileName, portletDataContext.getSourceGroupId()), inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 1, BatchEngineTaskOperation.DELETE.name(), (Map)HashMapBuilder.put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).build(), this._taskItemDelegateName);
        this._batchEngineImportTaskExecutor.execute(batchEngineDeleteTask);
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        try (SafeCloseable safeCloseable = PortletDataContextThreadLocal.setPortletDataContextWithSafeCloseable(portletDataContext);){
            BatchEngineExportTaskExecutor.Result result = this._batchEngineExportTaskExecutor.execute(this._batchEngineExportTaskService.addBatchEngineExportTask(null, portletDataContext.getCompanyId(), this._getUserId(), null, this._className, "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyList(), BatchEnginePortletDataHandlerUtil.buildExportParameters(this._exportImportVulcanBatchEngineTaskItemDelegate.getNestedFields(), this._exportImportVulcanBatchEngineTaskItemDelegate.getParameters(), portletDataContext), this._taskItemDelegateName), new BatchEngineExportTaskExecutor.Settings(){

                public boolean isCompressContent() {
                    return false;
                }

                public boolean isPersistContent() {
                    return false;
                }
            });
            portletDataContext.addZipEntry(this._normalize(this._fileName, portletDataContext.getScopeGroupId()), result.getInputStream());
            portletDataContext.setValidateExistingDataHandler(true);
            String string = this.getExportDataRootElementString(this.addExportDataRootElement(portletDataContext));
            return string;
        }
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        String normalizedFileName = this._normalize(this._fileName, portletDataContext.getSourceGroupId());
        InputStream inputStream = portletDataContext.getZipEntryAsInputStream(normalizedFileName);
        if (inputStream == null) {
            return portletPreferences;
        }
        BatchEngineImportTask batchEngineImportTask = this._batchEngineImportTaskService.addBatchEngineImportTask(null, portletDataContext.getCompanyId(), this._getUserId(), 100L, null, this._className, this._getBytes(normalizedFileName, inputStream), "JSON", BatchEngineTaskExecuteStatus.INITIAL.name(), Collections.emptyMap(), 1, BatchEngineTaskOperation.CREATE.name(), BatchEnginePortletDataHandlerUtil.buildImportParameters(portletDataContext), this._taskItemDelegateName);
        try {
            BatchEngineImportTask finalBatchEngineImportTask = batchEngineImportTask;
            TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, () -> {
                try (SafeCloseable safeCloseable = PortletDataContextThreadLocal.setPortletDataContextWithSafeCloseable(portletDataContext);){
                    this._batchEngineImportTaskExecutor.execute(finalBatchEngineImportTask);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            throw new PortletDataException(throwable);
        }
        batchEngineImportTask = this._batchEngineImportTaskService.getBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
        BatchEngineTaskExecuteStatus batchEngineTaskExecuteStatus = BatchEngineTaskExecuteStatus.valueOf((String)batchEngineImportTask.getExecuteStatus());
        if (batchEngineTaskExecuteStatus == BatchEngineTaskExecuteStatus.FAILED) {
            throw new PortletDataException("Unable to import batch data: " + batchEngineImportTask.getErrorMessage());
        }
        return portletPreferences;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        BatchEngineTaskItemDelegate batchEngineTaskItemDelegate = this._batchEngineTaskItemDelegateRegistry.getBatchEngineTaskItemDelegate(portletDataContext.getCompanyId(), this._className, this._taskItemDelegateName);
        batchEngineTaskItemDelegate.setContextCompany(this._companyLocalService.getCompany(portletDataContext.getCompanyId()));
        BatchEngineUriInfo.Builder builder = new BatchEngineUriInfo.Builder();
        Map<String, Serializable> parameters = BatchEnginePortletDataHandlerUtil.buildExportParameters(Collections.emptyList(), null, portletDataContext);
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            builder.queryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        batchEngineTaskItemDelegate.setContextUriInfo((UriInfo)builder.build());
        User user = this._userLocalService.getUser(this._getUserId());
        batchEngineTaskItemDelegate.setContextUser(user);
        batchEngineTaskItemDelegate.setLanguageId(user.getLanguageId());
        Page page = batchEngineTaskItemDelegate.read(null, Pagination.of((int)0, (int)0), null, parameters, null);
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        manifestSummary.addModelAdditionCount(new StagedModelType(this._itemClassName), page.getTotalCount());
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        return manifestSummary.getModelAdditionCount(new StagedModelType(this._itemClassName));
    }

    private byte[] _getBytes(String fileName, InputStream inputStream) throws Exception {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)unsyncByteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)zipOutputStream, (boolean)false);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }

    private String _normalize(String fileName, long groupId) {
        return StringBundler.concat((Object[])new Object[]{"/", "group", "/", groupId, "/", fileName});
    }
}

