/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.messaging;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class ExportImportLifecycleMessagingConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    private final List<ServiceRegistration<Destination>> _serviceRegistrations = new ArrayList<ServiceRegistration<Destination>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._registerDestination(bundleContext, "liferay/export_import_lifecycle_event_async", "serial");
        this._registerDestination(bundleContext, "liferay/export_import_lifecycle_event_sync", "synchronous");
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private ServiceRegistration<Destination> _registerDestination(BundleContext bundleContext, String destinationName, String destinationType) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration(destinationType, destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        ServiceRegistration serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
        this._serviceRegistrations.add((ServiceRegistration<Destination>)serviceRegistration);
        return serviceRegistration;
    }
}

