/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.exportimport.content.processor;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.configuration.ExportImportServiceConfigurationWhitelistedURLPatternsHelper;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.staging.StagingGroupHelper;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.exportimport.configuration.ExportImportServiceConfiguration"}, property={"content.processor.type=LayoutReferences"}, service={ExportImportContentProcessor.class})
public class LayoutReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DATA_HANDLER_COMPANY_DEFAULT_GROUP_URL = "@data_handler_company_default_group_url@";
    private static final String _DATA_HANDLER_COMPANY_SECURE_DEFAULT_GROUP_URL = "@data_handler_company_secure_default_group_url@";
    private static final String _DATA_HANDLER_COMPANY_SECURE_URL = "@data_handler_company_secure_url@";
    private static final String _DATA_HANDLER_COMPANY_URL = "@data_handler_company_url@";
    private static final String _DATA_HANDLER_GROUP_FRIENDLY_URL = "@data_handler_group_friendly_url@";
    private static final String _DATA_HANDLER_PATH_CONTEXT = "@data_handler_path_context@";
    private static final String _DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING = "@data_handler_private_group_servlet_mapping@";
    private static final String _DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL = "@data_handler_private_layout_set_secure_url@";
    private static final String _DATA_HANDLER_PRIVATE_LAYOUT_SET_URL = "@data_handler_private_layout_set_url@";
    private static final String _DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING = "@data_handler_private_user_servlet_mapping@";
    private static final String _DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL = "@data_handler_public_layout_set_secure_url@";
    private static final String _DATA_HANDLER_PUBLIC_LAYOUT_SET_URL = "@data_handler_public_layout_set_url@";
    private static final String _DATA_HANDLER_PUBLIC_SERVLET_MAPPING = "@data_handler_public_servlet_mapping@";
    private static final String _DATA_HANDLER_SITE_ADMIN_URL = "@data_handler_site_admin_url@";
    private static final String _DATA_HANDLER_VIRTUAL_HOST_PRIVATE_LAYOUT_FRIENDLY_URL = "@data_handler_virtual_host_private_layout_friendly_url@";
    private static final String _DATA_HANDLER_VIRTUAL_HOST_PUBLIC_LAYOUT_FRIENDLY_URL = "@data_handler_virtual_host_public_layout_friendly_url@";
    private static final char[] _LAYOUT_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '#', '?', '\"', ' '};
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.group.servlet.mapping") + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.user.servlet.mapping") + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.public.servlet.mapping") + "/";
    private static final String _TEMPLATE_NAME_PREFIX = "template";
    private static final char[] _URL_REFERENCE_STOP_CHARS = new char[]{'\'', '\\', ']', '>', '|', '#', '?', '\"', ' '};
    private static final Log _log = LogFactoryUtil.getLog(LayoutReferencesExportImportContentProcessor.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile ExportImportServiceConfiguration _exportImportServiceConfiguration;
    @Reference
    private ExportImportServiceConfigurationWhitelistedURLPatternsHelper _exportImportServiceConfigurationWhitelistedURLPatternsHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this.replaceExportLayoutReferences(portletDataContext, stagedModel, content);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this.replaceImportLayoutReferences(portletDataContext, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this.validateLayoutReferences(groupId, content);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._exportImportServiceConfiguration = (ExportImportServiceConfiguration)ConfigurableUtil.createConfigurable(ExportImportServiceConfiguration.class, properties);
    }

    protected String replaceExportHostname(Group group, String url, StringBundler urlSB) throws PortalException {
        if (!HttpComponentsUtil.hasProtocol((String)url)) {
            return url;
        }
        boolean secure = HttpComponentsUtil.isSecure((String)url);
        int serverPort = this._portal.getPortalServerPort(secure);
        if (serverPort == -1) {
            return url;
        }
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        NavigableMap publicLayoutSetVirtualHostnames = publicLayoutSet.getVirtualHostnames();
        String portalURL = "";
        if (!publicLayoutSetVirtualHostnames.isEmpty() && url.startsWith(portalURL = this._portal.getPortalURL((String)publicLayoutSetVirtualHostnames.firstKey(), serverPort, secure))) {
            if (secure) {
                urlSB.append(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL);
            }
            return url.substring(portalURL.length());
        }
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        NavigableMap privateLayoutSetVirtualHostnames = privateLayoutSet.getVirtualHostnames();
        if (!privateLayoutSetVirtualHostnames.isEmpty() && url.startsWith(portalURL = this._portal.getPortalURL((String)privateLayoutSetVirtualHostnames.firstKey(), serverPort, secure))) {
            if (secure) {
                urlSB.append(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL);
            }
            return url.substring(portalURL.length());
        }
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        String companyVirtualHostname = company.getVirtualHostname();
        if (Validator.isNotNull((String)companyVirtualHostname) && url.startsWith(portalURL = this._getPortalURL(url, this._portal.getPortalURL(companyVirtualHostname, serverPort, secure)))) {
            if (this._isDefaultGroup(group)) {
                if (secure) {
                    urlSB.append(_DATA_HANDLER_COMPANY_SECURE_DEFAULT_GROUP_URL);
                } else {
                    urlSB.append(_DATA_HANDLER_COMPANY_DEFAULT_GROUP_URL);
                }
            } else if (secure) {
                urlSB.append(_DATA_HANDLER_COMPANY_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_COMPANY_URL);
            }
            return url.substring(portalURL.length());
        }
        portalURL = this._portal.getPortalURL("localhost", serverPort, secure);
        if (url.startsWith(portalURL)) {
            return url.substring(portalURL.length());
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String replaceExportLayoutReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        StringBundler hostnameSB = new StringBundler(2);
        content = this.replaceExportHostname(group, content, hostnameSB);
        if (hostnameSB.index() > 0) {
            hostnameSB.append(content);
            content = hostnameSB.toString();
        }
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{"href=", "[[", "{{"};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) return sb.toString();
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c = content.charAt(beginPos + offset);
                if (c == '\\') {
                    offset = 7;
                } else if (c == '\'' || c == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[' || content.charAt(beginPos) == '{') {
                offset = 2;
            }
            if ((endPos = content.startsWith("href=", beginPos) ? StringUtil.indexOfAny((String)content, (char[])_URL_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos) : StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1) continue;
            String url = content.substring(beginPos + offset, endPos);
            int pos = url.indexOf("/-/");
            if (pos != -1) {
                url = url.substring(0, pos);
                endPos = beginPos + offset + pos;
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
                --endPos;
            }
            StringBundler urlSB = new StringBundler(6);
            try {
                Group urlGroup;
                Layout layout;
                if (!(url = this.replaceExportHostname(group, url, urlSB)).startsWith("/")) continue;
                String pathContext = this._portal.getPathContext();
                if (pathContext.length() > 1) {
                    if (!url.startsWith(pathContext)) continue;
                    urlSB.append(_DATA_HANDLER_PATH_CONTEXT);
                    url = url.substring(pathContext.length());
                }
                if ((pos = url.indexOf("/", 1)) == -1) {
                    pos = url.length();
                }
                Locale locale = null;
                String localePath = url.substring(0, pos);
                if (localePath.length() > 1) {
                    locale = LocaleUtil.fromLanguageId((String)localePath.substring(1), (boolean)true, (boolean)false);
                }
                if (locale != null) {
                    String urlWithoutLocale = url.substring(localePath.length());
                    if (urlWithoutLocale.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PRIVATE_USER_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING)) {
                        urlSB.append(localePath);
                        url = urlWithoutLocale;
                    } else if (!(urlWithoutLocale.indexOf("/", 1) != -1 || localePath.equals(_PRIVATE_GROUP_SERVLET_MAPPING) || localePath.equals(_PRIVATE_USER_SERVLET_MAPPING) || localePath.equals(_PUBLIC_GROUP_SERVLET_MAPPING))) {
                        urlSB.append(localePath);
                        url = urlWithoutLocale;
                    } else {
                        layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, urlWithoutLocale);
                        if (layout == null) {
                            layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), true, urlWithoutLocale);
                        }
                        if (layout != null) {
                            urlSB.append(localePath);
                            url = urlWithoutLocale;
                        }
                    }
                }
                if (!url.startsWith("/")) continue;
                boolean privateLayout = false;
                if (url.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING)) {
                    urlSB.append(_DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING);
                    url = url.substring(_PRIVATE_GROUP_SERVLET_MAPPING.length() - 1);
                    privateLayout = true;
                } else if (url.startsWith(_PRIVATE_USER_SERVLET_MAPPING)) {
                    urlSB.append(_DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING);
                    url = url.substring(_PRIVATE_USER_SERVLET_MAPPING.length() - 1);
                    privateLayout = true;
                } else if (url.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING)) {
                    urlSB.append(_DATA_HANDLER_PUBLIC_SERVLET_MAPPING);
                    url = url.substring(_PUBLIC_GROUP_SERVLET_MAPPING.length() - 1);
                } else {
                    String urlSBString = urlSB.toString();
                    LayoutSet layoutSet = null;
                    if (urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL)) {
                        layoutSet = group.getPublicLayoutSet();
                    } else if (urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL)) {
                        layoutSet = group.getPrivateLayoutSet();
                    } else if (urlSBString.contains(_DATA_HANDLER_COMPANY_SECURE_DEFAULT_GROUP_URL) || urlSBString.contains(_DATA_HANDLER_COMPANY_DEFAULT_GROUP_URL)) {
                        layoutSet = group.getPublicLayoutSet();
                    } else {
                        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
                        NavigableMap publicVirtualHostnames = publicLayoutSet.getVirtualHostnames();
                        if (!publicVirtualHostnames.isEmpty() || this._isDefaultGroup(group)) {
                            layoutSet = group.getPublicLayoutSet();
                        }
                    }
                    if (layoutSet == null) continue;
                    privateLayout = layoutSet.isPrivateLayout();
                    LayoutFriendlyURL layoutFriendlyURL = this._layoutFriendlyURLLocalService.fetchFirstLayoutFriendlyURL(group.getGroupId(), privateLayout, url);
                    if (layoutFriendlyURL == null) continue;
                    if (privateLayout) {
                        urlSB.append(_DATA_HANDLER_VIRTUAL_HOST_PRIVATE_LAYOUT_FRIENDLY_URL);
                        continue;
                    }
                    urlSB.append(_DATA_HANDLER_VIRTUAL_HOST_PUBLIC_LAYOUT_FRIENDLY_URL);
                    continue;
                }
                layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), privateLayout, url);
                if (layout != null) {
                    Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                    portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
                    continue;
                }
                pos = url.indexOf("/", 1);
                String groupFriendlyURL = url;
                if (pos != -1) {
                    groupFriendlyURL = url.substring(0, pos);
                }
                if ((urlGroup = this._groupLocalService.fetchFriendlyURLGroup(group.getCompanyId(), groupFriendlyURL)) == null) {
                    throw new NoSuchLayoutException();
                }
                urlSB.append(_DATA_HANDLER_GROUP_FRIENDLY_URL);
                urlSB.append("@");
                if (urlGroup.isStagedRemotely()) {
                    String remoteGroupUuid = urlGroup.getTypeSettingsProperty("remoteGroupUUID");
                    if (Validator.isNotNull((String)remoteGroupUuid)) {
                        urlSB.append(remoteGroupUuid);
                    }
                } else if (this._stagingGroupHelper.isStagingGroup(urlGroup)) {
                    Group liveGroup = urlGroup.getLiveGroup();
                    urlSB.append(liveGroup.getUuid());
                } else if (urlGroup.isControlPanel() || this._stagingGroupHelper.isLiveGroup(urlGroup) && group.getLiveGroupId() == urlGroup.getGroupId()) {
                    urlSB.append(urlGroup.getUuid());
                } else {
                    urlSB.append(urlGroup.getFriendlyURL());
                }
                urlSB.append("@");
                String siteAdminURL = "/control_panel" + PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL;
                if (url.endsWith(siteAdminURL)) {
                    urlSB.append(_DATA_HANDLER_SITE_ADMIN_URL);
                    url = "";
                    continue;
                }
                if (pos == -1) {
                    url = "";
                    continue;
                }
                url = url.substring(pos);
                layout = this._layoutLocalService.getFriendlyURLLayout(urlGroup.getGroupId(), privateLayout, url);
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
                continue;
            }
            catch (Exception exception) {
                if (exception instanceof NoSuchLayoutException && !this._exportImportServiceConfiguration.validateLayoutReferences() || this._exportImportServiceConfigurationWhitelistedURLPatternsHelper.isWhitelistedURL(CompanyThreadLocal.getCompanyId().longValue(), url)) continue;
                StringBundler exceptionSB = new StringBundler(6);
                exceptionSB.append("Unable to process layout URL ");
                exceptionSB.append(url);
                exceptionSB.append(" for staged model ");
                exceptionSB.append(stagedModel.getModelClassName());
                exceptionSB.append(" with primary key ");
                exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exceptionSB.toString());
                continue;
            }
            finally {
                if (urlSB.length() > 0) {
                    urlSB.append(url);
                    url = urlSB.toString();
                }
                sb.replace(beginPos + offset, endPos, url);
                continue;
            }
            break;
        }
    }

    protected String replaceImportLayoutReferences(PortletDataContext portletDataContext, String content) throws Exception {
        int groupFriendlyUrlPos;
        NavigableMap publicVirtualHostnames;
        String companyDefaultGroupPortalURL = "";
        String companyPortalURL = "";
        String privateLayoutSetPortalURL = "";
        String publicLayoutSetPortalURL = "";
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        int serverPort = this._portal.getPortalServerPort(false);
        if (serverPort != -1) {
            NavigableMap privateVirtualHostnames;
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companyPortalURL = this._portal.getPortalURL(company.getVirtualHostname(), serverPort, false);
            }
            privateLayoutSetPortalURL = !(privateVirtualHostnames = privateLayoutSet.getVirtualHostnames()).isEmpty() ? this._portal.getPortalURL((String)privateVirtualHostnames.firstKey(), serverPort, false) : companyPortalURL;
            NavigableMap publicVirtualHostnames2 = publicLayoutSet.getVirtualHostnames();
            publicLayoutSetPortalURL = !publicVirtualHostnames2.isEmpty() ? this._portal.getPortalURL((String)publicVirtualHostnames2.firstKey(), serverPort, false) : companyPortalURL;
            companyDefaultGroupPortalURL = this._isDefaultGroup(group) ? companyPortalURL : publicLayoutSetPortalURL;
        }
        int secureSecurePort = this._portal.getPortalServerPort(true);
        String companySecureDefaultGroupPortalURL = "";
        String companySecurePortalURL = "";
        String privateLayoutSetSecurePortalURL = "";
        String publicLayoutSetSecurePortalURL = "";
        if (secureSecurePort != -1) {
            NavigableMap publicVirtualHostnames3;
            NavigableMap privateVirtualHostnames;
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companySecurePortalURL = this._portal.getPortalURL(company.getVirtualHostname(), secureSecurePort, true);
            }
            if (!(privateVirtualHostnames = privateLayoutSet.getVirtualHostnames()).isEmpty()) {
                privateLayoutSetSecurePortalURL = this._portal.getPortalURL((String)privateVirtualHostnames.firstKey(), secureSecurePort, true);
            }
            if (!(publicVirtualHostnames3 = publicLayoutSet.getVirtualHostnames()).isEmpty()) {
                publicLayoutSetSecurePortalURL = this._portal.getPortalURL((String)publicVirtualHostnames3.firstKey(), secureSecurePort, true);
            }
            companySecureDefaultGroupPortalURL = this._isDefaultGroup(group) ? companySecurePortalURL : publicLayoutSetSecurePortalURL;
        }
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_DEFAULT_GROUP_URL, (String)companyDefaultGroupPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_SECURE_DEFAULT_GROUP_URL, (String)companySecureDefaultGroupPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_SECURE_URL, (String)companySecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_URL, (String)companyPortalURL);
        Object virtualHostPrivateLayoutFriendlyURLReplacement = "";
        Object virtualHostPublicLayoutFriendlyURLReplacement = "";
        NavigableMap privateVirtualHostnames = privateLayoutSet.getVirtualHostnames();
        if (privateVirtualHostnames.isEmpty()) {
            virtualHostPrivateLayoutFriendlyURLReplacement = group.isUser() ? PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING : PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
            virtualHostPrivateLayoutFriendlyURLReplacement = (String)virtualHostPrivateLayoutFriendlyURLReplacement + group.getFriendlyURL();
        }
        if ((publicVirtualHostnames = publicLayoutSet.getVirtualHostnames()).isEmpty() && !this._isDefaultGroup(group)) {
            virtualHostPublicLayoutFriendlyURLReplacement = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING + group.getFriendlyURL();
        }
        while ((groupFriendlyUrlPos = content.indexOf(_DATA_HANDLER_GROUP_FRIENDLY_URL)) != -1) {
            int groupUuidPos = groupFriendlyUrlPos + _DATA_HANDLER_GROUP_FRIENDLY_URL.length();
            int endIndex = -1;
            if (content.charAt(groupUuidPos) != '@') {
                content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)group.getFriendlyURL(), (int)groupFriendlyUrlPos);
                continue;
            }
            endIndex = content.indexOf("@", groupUuidPos + 1);
            if (endIndex < groupUuidPos + 1) {
                content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)"", (int)groupFriendlyUrlPos);
                continue;
            }
            String groupUuid = content.substring(groupUuidPos + 1, endIndex);
            Group groupFriendlyUrlGroup = this._groupLocalService.fetchGroupByUuidAndCompanyId(groupUuid, portletDataContext.getCompanyId());
            if (groupFriendlyUrlGroup == null) {
                groupFriendlyUrlGroup = this._groupLocalService.fetchFriendlyURLGroup(portletDataContext.getCompanyId(), groupUuid);
            }
            if (groupFriendlyUrlGroup == null || groupUuid.contains(_TEMPLATE_NAME_PREFIX)) {
                content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)group.getFriendlyURL(), (int)groupFriendlyUrlPos);
                content = StringUtil.replaceFirst((String)content, (String)("@" + groupUuid + "@"), (String)"", (int)groupFriendlyUrlPos);
                if (!groupUuid.contains(_TEMPLATE_NAME_PREFIX)) continue;
                content = this._replaceTemplateLinkToLayout(content, portletDataContext.isPrivateLayout());
                continue;
            }
            content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)"", (int)groupFriendlyUrlPos);
            content = StringUtil.replaceFirst((String)content, (String)("@" + groupUuid + "@"), (String)groupFriendlyUrlGroup.getFriendlyURL(), (int)groupFriendlyUrlPos);
        }
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PATH_CONTEXT, (String)this._portal.getPathContext());
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL, (String)privateLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL, (String)privateLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL, (String)publicLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL, (String)publicLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_SITE_ADMIN_URL, (String)StringBundler.concat((String[])new String[]{"/~", "/control_panel", PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL}));
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_VIRTUAL_HOST_PRIVATE_LAYOUT_FRIENDLY_URL, (String)virtualHostPrivateLayoutFriendlyURLReplacement);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_VIRTUAL_HOST_PUBLIC_LAYOUT_FRIENDLY_URL, (String)virtualHostPublicLayoutFriendlyURLReplacement);
        return content;
    }

    protected void validateLayoutReferences(long groupId, String content) throws PortalException {
        long companyId;
        block41: {
            companyId = CompanyThreadLocal.getCompanyId();
            try {
                this._exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, companyId);
            }
            catch (ConfigurationException configurationException) {
                if (!_log.isWarnEnabled()) break block41;
                _log.warn((Throwable)configurationException);
            }
        }
        if (!this._exportImportServiceConfiguration.validateLayoutReferences()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        String[] patterns = new String[]{"href=", "[[", "{{"};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            Group urlGroup;
            Layout layout;
            int pos;
            StringBundler urlSB;
            String url;
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) break;
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c = content.charAt(beginPos + offset);
                if (c == '\\') {
                    offset = 7;
                } else if (c == '\'' || c == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[' || content.charAt(beginPos) == '{') {
                offset = 2;
            }
            if ((endPos = content.startsWith("href=", beginPos) ? StringUtil.indexOfAny((String)content, (char[])_URL_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos) : StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1 || (url = content.substring(beginPos + offset, endPos + 1)).contains("/c/document_library/get_file?") || url.contains("/documents/") || url.contains("/image/image_gallery?")) continue;
            url = content.substring(beginPos + offset, endPos);
            if ((endPos = StringUtil.indexOfAny((String)url, (String[])ArrayUtil.remove((String[])FriendlyURLResolverRegistryUtil.getURLSeparators(), (String)"/~"))) != -1) {
                url = url.substring(0, endPos);
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if (!(url = this.replaceExportHostname(group, url, urlSB = new StringBundler(1))).startsWith("/") || PortalInstances.isVirtualHostsIgnorePath((String)url)) continue;
            String pathContext = this._portal.getPathContext();
            if (pathContext.length() > 1) {
                if (!url.startsWith(pathContext)) continue;
                url = url.substring(pathContext.length());
            }
            if ((pos = url.indexOf("/", 1)) == -1) {
                pos = url.length();
            }
            Locale locale = null;
            String localePath = url.substring(0, pos);
            if (localePath.length() > 1) {
                locale = LocaleUtil.fromLanguageId((String)localePath.substring(1), (boolean)true, (boolean)false);
            }
            if (locale != null) {
                String urlWithoutLocale = url.substring(localePath.length());
                if (urlWithoutLocale.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PRIVATE_USER_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING) || this._isVirtualHostDefined(urlSB)) {
                    url = urlWithoutLocale;
                } else if (!(urlWithoutLocale.indexOf("/", 1) != -1 || localePath.equals(_PRIVATE_GROUP_SERVLET_MAPPING) || localePath.equals(_PRIVATE_USER_SERVLET_MAPPING) || localePath.equals(_PUBLIC_GROUP_SERVLET_MAPPING))) {
                    urlSB.append(localePath);
                    url = urlWithoutLocale;
                } else {
                    layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, urlWithoutLocale);
                    if (layout == null) {
                        layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), true, urlWithoutLocale);
                    }
                    if (layout != null) {
                        urlSB.append(localePath);
                        url = urlWithoutLocale;
                    }
                }
            }
            if (!url.startsWith("/") || this._exportImportServiceConfigurationWhitelistedURLPatternsHelper.isWhitelistedURL(companyId, url)) continue;
            boolean privateLayout = false;
            if (url.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING)) {
                url = url.substring(_PRIVATE_GROUP_SERVLET_MAPPING.length() - 1);
                privateLayout = true;
            } else if (url.startsWith(_PRIVATE_USER_SERVLET_MAPPING)) {
                url = url.substring(_PRIVATE_USER_SERVLET_MAPPING.length() - 1);
                privateLayout = true;
            } else if (url.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING)) {
                url = url.substring(_PUBLIC_GROUP_SERVLET_MAPPING.length() - 1);
            } else {
                String urlSBString = urlSB.toString();
                LayoutSet layoutSet = null;
                if (urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL)) {
                    layoutSet = group.getPublicLayoutSet();
                } else if (urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL)) {
                    layoutSet = group.getPrivateLayoutSet();
                } else if (urlSBString.contains(_DATA_HANDLER_COMPANY_SECURE_DEFAULT_GROUP_URL) || urlSBString.contains(_DATA_HANDLER_COMPANY_DEFAULT_GROUP_URL)) {
                    layoutSet = group.getPublicLayoutSet();
                } else {
                    LayoutSet publicLayoutSet = group.getPublicLayoutSet();
                    NavigableMap publicVirtualHostnames = publicLayoutSet.getVirtualHostnames();
                    if (!publicVirtualHostnames.isEmpty() || this._isDefaultGroup(group)) {
                        layoutSet = group.getPublicLayoutSet();
                    }
                }
                if (layoutSet == null) continue;
                privateLayout = layoutSet.isPrivateLayout();
            }
            if ((layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, url)) != null) continue;
            String siteAdminURL = "/control_panel" + PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL;
            if (url.endsWith("/~" + siteAdminURL)) {
                url = url.substring(url.indexOf(siteAdminURL));
            }
            pos = url.indexOf("/", 1);
            String groupFriendlyURL = url;
            if (pos != -1) {
                groupFriendlyURL = url.substring(0, pos);
            }
            if ((urlGroup = this._groupLocalService.fetchFriendlyURLGroup(group.getCompanyId(), groupFriendlyURL)) == null) {
                ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(LayoutReferencesExportImportContentProcessor.class.getName());
                exportImportContentValidationException.setGroupFriendlyURL(groupFriendlyURL);
                exportImportContentValidationException.setLayoutURL(url);
                exportImportContentValidationException.setType(2);
                throw exportImportContentValidationException;
            }
            if (pos == -1) continue;
            url = url.substring(pos);
            try {
                this._layoutLocalService.getFriendlyURLLayout(urlGroup.getGroupId(), privateLayout, url);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(LayoutReferencesExportImportContentProcessor.class.getName(), (Throwable)noSuchLayoutException);
                exportImportContentValidationException.setLayoutURL(url);
                exportImportContentValidationException.setType(4);
                throw exportImportContentValidationException;
            }
        }
    }

    private String _getPortalURL(String url, String portalURL) throws PortalException {
        try {
            InetAddress inetAddress;
            URI uri;
            block7: {
                uri = null;
                try {
                    uri = HttpComponentsUtil.getURI((String)url);
                }
                catch (URISyntaxException uriSyntaxException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Throwable)uriSyntaxException);
                }
            }
            if (uri != null && Validator.isIPAddress((String)uri.getHost()) && (inetAddress = InetAddressUtil.getInetAddressByName((String)uri.getHost())) != null && InetAddressUtil.isLocalInetAddress((InetAddress)inetAddress)) {
                return StringBundler.concat((Object[])new Object[]{uri.getScheme(), "://", uri.getHost(), ":", uri.getPort()});
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)unknownHostException);
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        return portalURL;
    }

    private boolean _isDefaultGroup(Group group) {
        return StringUtil.equals((String)group.getGroupKey(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
    }

    private boolean _isVirtualHostDefined(StringBundler urlSB) {
        String urlSBString = urlSB.toString();
        return urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL) || urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL);
    }

    private String _replaceTemplateLinkToLayout(String content, boolean privateLayout) {
        content = privateLayout ? StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING) : StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING);
        return content;
    }
}

