/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.controller;

import com.liferay.asset.link.model.adapter.StagedAssetLink;
import com.liferay.expando.kernel.exception.NoSuchTableException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.util.ExpandoConverterUtil;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.controller.PortletImportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.exception.ExportImportDocumentException;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.lar.DeletionSystemEventImporter;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portlet.PortletPreferencesImpl;
import jakarta.portlet.PortletPreferences;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.Portlet"}, service={ExportImportController.class, PortletImportController.class})
public class PortletImportControllerImpl
implements PortletImportController {
    private static final Log _log = LogFactoryUtil.getLog(PortletImportControllerImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DeletionSystemEventImporter _deletionSystemEventImporter;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PermissionImporter _permissionImporter;
    @Reference
    private Portal _portal;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    @Reference
    private PortletDataHandlerStatusMessageSender _portletDataHandlerStatusMessageSender;
    @Reference
    private PortletItemLocalService _portletItemLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ZipReaderFactory _zipReaderFactory;

    public void deletePortletData(PortletDataContext portletDataContext) throws Exception {
        String xml;
        PortletPreferencesIds portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), 0L, portletDataContext.getPlid(), portletDataContext.getPortletId());
        PortletPreferences portletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(portletDataContext, portletPreferences)) != null) {
            this._portletPreferencesLocalService.updatePreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId(), xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importAssetLinks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/links.xml");
        if (xml == null) {
            return;
        }
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        try {
            Document document = SAXReaderUtil.read((String)xml);
            portletDataContext.setImportDataRootElement(document.getRootElement());
            Element linksElement = portletDataContext.getImportDataGroupElement(StagedAssetLink.class);
            List linkElements = linksElement.elements();
            for (Element linkElement : linkElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)linkElement);
            }
        }
        finally {
            portletDataContext.setImportDataRootElement(importDataRootElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setPortletDataDeletionImportInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            String portletId = MapUtil.getString((Map)settingsMap, (Object)"portletId");
            long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            Layout layout = this._layoutLocalService.getLayout(targetPlid);
            zipReader = this._zipReaderFactory.getZipReader(file);
            this.validateFile(layout.getCompanyId(), targetGroupId, portletId, zipReader);
            PortletDataContext portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            boolean deletePortletData = MapUtil.getBoolean((Map)parameterMap, (String)"DELETE_PORTLET_DATA");
            if (deletePortletData) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting portlet data");
                }
                this.deletePortletData(portletDataContext);
            }
            this.populateDeletionStagedModelTypes(portletDataContext);
            this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        }
        finally {
            ExportImportThreadLocal.setPortletDataDeletionImportInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    public void importFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration, file);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            long userId = MapUtil.getLong((Map)exportImportConfiguration.getSettingsMap(), (String)"userId");
            this._importPortletInfo(portletDataContext, userId);
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), Long.valueOf(userId)});
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
            throw throwable;
        }
    }

    public void importPortletData(PortletDataContext portletDataContext, Element portletDataElement) throws Exception {
        String xml;
        PortletPreferencesIds portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), 0L, portletDataContext.getPlid(), portletDataContext.getPortletId());
        PortletPreferences portletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if (Validator.isNotNull((String)(xml = this.importPortletData(portletDataContext, portletPreferences, portletDataElement)))) {
            this._portletPreferencesLocalService.updatePreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId(), xml);
        }
    }

    public String importPortletData(PortletDataContext portletDataContext, PortletPreferences portletPreferences, Element portletDataElement) throws Exception {
        String portletData;
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Do not import portlet data for portlet ", portletDataContext.getPortletId(), " because the portlet does not have a portlet data ", "handler"}));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for portlet " + portletDataContext.getPortletId()));
        }
        if (Validator.isNull((String)(portletData = portletDataContext.getZipEntryAsString(portletDataElement.attributeValue("path"))))) {
            return null;
        }
        if (ExportImportThreadLocal.isPortletStagingInProcess() && ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            String changesetPortletId = "com_liferay_exportimport_web_portlet_ChangesetPortlet";
            Portlet changesetPortlet = this._portletLocalService.getPortletById(changesetPortletId);
            PortletDataHandler changesetPortletPortletDataHandlerInstance = changesetPortlet.getPortletDataHandlerInstance();
            portletPreferences = changesetPortletPortletDataHandlerInstance.importData(portletDataContext, changesetPortletId, portletPreferences, portletData);
        } else {
            portletPreferences = portletDataHandler.importData(portletDataContext, portletDataContext.getPortletId(), portletPreferences, portletData);
        }
        if (portletPreferences == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPortletPreferences(PortletDataContext portletDataContext, long companyId, long groupId, Layout layout, Element parentElement, boolean preserveScopeLayoutId, boolean importPortletArchivedSetups, boolean importPortletData, boolean importPortletSetup, boolean importPortletUserPreferences) throws Exception {
        long plid = 0L;
        String scopeType = "";
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId) {
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
                scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
                scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List portletPreferencesElements = parentElement.elements("portlet-preferences");
        for (Element portletPreferencesElement : portletPreferencesElements) {
            boolean defaultUser;
            String userUuid;
            String path = portletPreferencesElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            String xml = null;
            Element element = null;
            try {
                xml = portletDataContext.getZipEntryAsString(path);
                Document preferencesDocument = SAXReaderUtil.read((String)xml);
                element = preferencesDocument.getRootElement();
            }
            catch (DocumentException documentException) {
                ExportImportDocumentException exportImportDocumentException = new ExportImportDocumentException((Throwable)documentException);
                exportImportDocumentException.setPortletId(portletDataContext.getPortletId());
                exportImportDocumentException.setType(3);
                throw exportImportDocumentException;
            }
            long ownerId = GetterUtil.getLong((String)element.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)element.attributeValue("owner-type"));
            if (ownerType == 1 || !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importPortletUserPreferences) continue;
            long curPlid = plid;
            String curPortletId = portletDataContext.getPortletId();
            if (ownerType == 2) {
                curPlid = 0L;
                curPortletId = portletDataContext.getRootPortletId();
                ownerId = portletDataContext.getScopeGroupId();
            }
            long elementPlid = GetterUtil.getLong((String)element.attributeValue("plid"));
            Map parameterMap = portletDataContext.getParameterMap();
            parameterMap.put("portletPreferencePlid", new String[]{String.valueOf(elementPlid)});
            portletDataContext.setParameterMap(parameterMap);
            if (ownerType == 3 && ownerId != 0L && elementPlid == 0L) {
                curPlid = 0L;
                ownerId = portletDataContext.getScopeGroupId();
            }
            if (ownerType == 5) {
                userUuid = element.attributeValue("archive-user-uuid");
                long userId = portletDataContext.getUserId(userUuid);
                String name = element.attributeValue("archive-name");
                curPortletId = portletDataContext.getRootPortletId();
                PortletItem portletItem = this._portletItemLocalService.updatePortletItem(userId, groupId, name, curPortletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
                curPlid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (ownerType == 4) {
                userUuid = element.attributeValue("user-uuid");
                ownerId = portletDataContext.getUserId(userUuid);
            }
            if (defaultUser = GetterUtil.getBoolean((String)element.attributeValue("default-user"))) {
                ownerId = this._userLocalService.getGuestUserId(companyId);
            }
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)curPlid, (String)curPortletId, (String)xml);
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                ExportImportPortletPreferencesProcessor exportImportPortletPreferencesProcessor;
                Element preferenceDataElement = portletPreferencesElement.element("preference-data");
                if (preferenceDataElement != null) {
                    portletDataContext.setImportDataRootElement(preferenceDataElement);
                }
                if ((exportImportPortletPreferencesProcessor = ExportImportPortletPreferencesProcessorRegistryUtil.getExportImportPortletPreferencesProcessor((String)PortletIdCodec.decodePortletName((String)curPortletId))) != null) {
                    List importCapabilities = exportImportPortletPreferencesProcessor.getImportCapabilities();
                    if (ListUtil.isNotEmpty((List)importCapabilities)) {
                        for (Capability importCapability : importCapabilities) {
                            importCapability.process(portletDataContext, jxPortletPreferences);
                        }
                    }
                    exportImportPortletPreferencesProcessor.processImportPortletPreferences(portletDataContext, jxPortletPreferences);
                }
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
            this._updatePortletPreferences(portletDataContext, ownerId, ownerType, curPlid, curPortletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences), importPortletData);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
            try {
                jxPortletPreferences.setValue("lfrScopeType", scopeType);
                jxPortletPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
                jxPortletPreferences.store();
            }
            finally {
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    public void importServicePortletPreferences(PortletDataContext portletDataContext, Element serviceElement) throws PortalException {
        long ownerId = GetterUtil.getLong((String)serviceElement.attributeValue("owner-id"));
        int ownerType = GetterUtil.getInteger((String)serviceElement.attributeValue("owner-type"));
        String serviceName = serviceElement.attributeValue("service-name");
        if (ownerType == 2) {
            ownerId = portletDataContext.getGroupId();
        } else if (ownerType == 1) {
            ownerId = portletDataContext.getCompanyId();
        }
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.getPortletPreferences(portletDataContext.getCompanyId(), ownerId, ownerType, 0L, serviceName);
        for (Attribute attribute : serviceElement.attributes()) {
            serviceElement.remove(attribute);
        }
        this._portletPreferencesLocalService.updatePreferences(portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), portletPreferences.getPlid(), portletPreferences.getPortletId(), serviceElement.asXML());
    }

    public void readExpandoTables(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/expando-tables.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List expandoTableElements = rootElement.elements("expando-table");
        for (Element expandoTableElement : expandoTableElements) {
            String className = expandoTableElement.attributeValue("class-name");
            ExpandoTable expandoTable = null;
            try {
                expandoTable = this._expandoTableLocalService.getDefaultTable(portletDataContext.getCompanyId(), className);
            }
            catch (NoSuchTableException noSuchTableException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchTableException);
                }
                expandoTable = this._expandoTableLocalService.addDefaultTable(portletDataContext.getCompanyId(), className);
            }
            List expandoColumnElements = expandoTableElement.elements("expando-column");
            for (Element expandoColumnElement : expandoColumnElements) {
                long columnId = GetterUtil.getLong((String)expandoColumnElement.attributeValue("column-id"));
                String name = expandoColumnElement.attributeValue("name");
                int type = GetterUtil.getInteger((String)expandoColumnElement.attributeValue("type"));
                String defaultData = expandoColumnElement.elementText("default-data");
                String typeSettings = expandoColumnElement.elementText("type-settings");
                Serializable defaultDataObject = ExpandoConverterUtil.getAttributeFromString((int)type, (String)defaultData);
                ExpandoColumn expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), name);
                if (expandoColumn != null) {
                    this._expandoColumnLocalService.updateColumn(expandoColumn.getColumnId(), name, type, (Object)defaultDataObject);
                } else {
                    expandoColumn = this._expandoColumnLocalService.addColumn(expandoTable.getTableId(), name, type, (Object)defaultDataObject);
                }
                this._expandoColumnLocalService.updateTypeSettings(expandoColumn.getColumnId(), typeSettings);
                portletDataContext.importPermissions(ExpandoColumn.class, (Serializable)Long.valueOf(columnId), (Serializable)Long.valueOf(expandoColumn.getColumnId()));
            }
        }
    }

    public void readLocks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/locks.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            Lock lock = (Lock)portletDataContext.getZipEntryAsObject(path);
            if (lock == null) continue;
            String className = assetElement.attributeValue("class-name");
            String key = assetElement.attributeValue("key");
            portletDataContext.addLocks(className, key, lock);
        }
    }

    public void resetPortletScope(PortletDataContext portletDataContext, long groupId) {
        portletDataContext.setScopeGroupId(groupId);
        portletDataContext.setScopeLayoutUuid("");
        portletDataContext.setScopeType("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(ExportImportConfiguration exportImportConfiguration, File file) throws Exception {
        ZipReader zipReader = null;
        try {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)true);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            String portletId = MapUtil.getString((Map)settingsMap, (Object)"portletId");
            long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
            Layout layout = this._layoutLocalService.getLayout(targetPlid);
            zipReader = this._zipReaderFactory.getZipReader(file);
            this.validateFile(layout.getCompanyId(), targetGroupId, portletId, zipReader);
            MissingReferences missingReferences = this._exportImportHelper.validateMissingReferences(this.getPortletDataContext(exportImportConfiguration, file));
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                if (this.isValidateMissingReferences()) {
                    throw new MissingReferenceException(missingReferences);
                }
                if (_log.isWarnEnabled()) {
                    try {
                        JSONArray errorMessagesJSONArray = this._staging.getErrorMessagesJSONArray(LocaleUtil.getDefault(), dependencyMissingReferences);
                        _log.warn((Object)("Missing reference validation errors ignored: " + String.valueOf(errorMessagesJSONArray)));
                    }
                    catch (Exception exception) {
                        _log.warn((Throwable)exception);
                    }
                }
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)false);
            if (zipReader != null) {
                zipReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deletePortletData(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (!group.isStagedPortlet(portletDataContext.getPortletId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for portlet " + portletDataContext.getPortletId() + " because the portlet is not staged"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Do not delete portlet data for portlet ", portletDataContext.getPortletId(), " because the portlet does not have a ", "PortletDataHandler"}));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for portlet " + portletDataContext.getPortletId()));
        }
        try {
            portletPreferences = portletDataHandler.deleteData(portletDataContext, portletDataContext.getPortletId(), portletPreferences);
        }
        finally {
            portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        }
        if (portletPreferences == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String portletId = MapUtil.getString((Map)settingsMap, (Object)"portletId");
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        Layout layout = this._layoutLocalService.getLayout(targetPlid);
        String userIdStrategyString = MapUtil.getString((Map)parameterMap, (Object)"USER_ID_STRATEGY");
        PortletDataContext portletDataContext = this._portletDataContextFactory.createImportPortletDataContext(layout.getCompanyId(), targetGroupId, parameterMap, this._exportImportHelper.getUserIdStrategy(userId, userIdStrategyString), this._zipReaderFactory.getZipReader(file));
        portletDataContext.setExportImportProcessId(String.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        portletDataContext.setPlid(targetPlid);
        portletDataContext.setPortletId(portletId);
        portletDataContext.setPrivateLayout(layout.isPrivateLayout());
        portletDataContext.setType("portlet");
        return portletDataContext;
    }

    protected com.liferay.portal.kernel.model.PortletPreferences getPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String serviceName) throws PortalException {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, 0L, serviceName) : this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, serviceName);
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchPortletPreferencesException);
            }
            portletPreferences = this._portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, serviceName, null, null);
        }
        return portletPreferences;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isPortletStagingInProcess()) {
            return 36;
        }
        return 35;
    }

    protected boolean isValidateMissingReferences() {
        try {
            ExportImportServiceConfiguration exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return exportImportServiceConfiguration.validateMissingReferences();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    protected void populateDeletionStagedModelTypes(PortletDataContext portletDataContext) throws Exception {
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            return;
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(portletDataHandler.getDeletionSystemEventStagedModelTypes());
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(StagedAssetLink.class)});
    }

    protected void validateFile(long companyId, long groupId, String portletId, ZipReader zipReader) throws Exception {
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException(1);
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception exception) {
            throw new LARFileException(2, (Throwable)exception);
        }
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (importBuildNumber < 7000) {
            throw new LayoutImportException(1, new Object[]{importBuildNumber, ReleaseInfo.getBuildNumber()});
        }
        BiPredicate<Version, Version> majorVersionBiPredicate = (currentVersion, importVersion) -> Objects.equals(currentVersion.getMajor(), importVersion.getMajor());
        BiPredicate<Version, Version> minorVersionBiPredicate = (currentVersion, importVersion) -> {
            int currentMinorVersion = GetterUtil.getInteger((String)currentVersion.getMinor(), (int)-1);
            int importedMinorVersion = GetterUtil.getInteger((String)importVersion.getMinor(), (int)-1);
            return (currentMinorVersion != -1 || importedMinorVersion != -1) && currentMinorVersion >= importedMinorVersion;
        };
        BiPredicate<Version, Version> manifestVersionBiPredicate = (currentVersion, importVersion) -> {
            BiPredicate<Version, Version> versionBiPredicate = majorVersionBiPredicate.and(minorVersionBiPredicate);
            return versionBiPredicate.test((Version)currentVersion, (Version)importVersion);
        };
        String importSchemaVersion = GetterUtil.getString((String)headerElement.attributeValue("schema-version"), (String)"1.0.0");
        if (!manifestVersionBiPredicate.test(Version.getInstance((String)"4.0.0"), Version.getInstance((String)importSchemaVersion))) {
            throw new LayoutImportException(2, new Object[]{importSchemaVersion, "4.0.0"});
        }
        String larType = headerElement.attributeValue("type");
        if (!larType.equals("portlet")) {
            throw new LARTypeException(larType, new String[]{"portlet"});
        }
        String rootPortletId = headerElement.attributeValue("root-portlet-id");
        String expectedRootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        if (!expectedRootPortletId.equals(rootPortletId)) {
            throw new PortletIdException(expectedRootPortletId);
        }
        Element portletElement = rootElement.element("portlet");
        String schemaVersion = GetterUtil.getString((String)portletElement.attributeValue("schema-version"), (String)"1.0.0");
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(companyId, portletId);
        if (!portletDataHandler.validateSchemaVersion(schemaVersion)) {
            throw new LayoutImportException(3, new Object[]{schemaVersion, portletId, portletDataHandler.getSchemaVersion()});
        }
        if (portletDataHandler.isDataLocalized()) {
            String[] sourceAvailableLanguageIds;
            for (String sourceAvailableLanguageId : sourceAvailableLanguageIds = StringUtil.split((String)headerElement.attributeValue("available-locales"))) {
                if (this._language.isAvailableLocale(this._portal.getSiteGroupId(groupId), sourceAvailableLanguageId)) continue;
                LocaleException localeException = new LocaleException(2);
                localeException.setSourceAvailableLanguageIds(Arrays.asList(sourceAvailableLanguageIds));
                localeException.setTargetAvailableLocales((Collection)this._language.getAvailableLocales(this._portal.getSiteGroupId(groupId)));
                throw localeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _importPortletInfo(PortletDataContext portletDataContext, long userId) throws Exception {
        boolean importPortletSetup;
        String layoutsImportMode;
        Map parameterMap = portletDataContext.getParameterMap();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(portletDataContext.getCompanyId());
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        this.validateFile(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), portletDataContext.getPortletId(), portletDataContext.getZipReader());
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), portletDataContext.getGroupId());
        ManifestSummary manifestSummary = this._exportImportHelper.getManifestSummary(portletDataContext);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            this._portletDataHandlerStatusMessageSender.sendStatusMessage("portlet", portletDataContext.getPortletId(), manifestSummary);
        }
        portletDataContext.setManifestSummary(manifestSummary);
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element portletElement = null;
        try {
            portletElement = rootElement.element("portlet");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletElement.attributeValue("path")));
            portletElement = portletDocument.getRootElement();
        }
        catch (DocumentException documentException) {
            ExportImportDocumentException exportImportDocumentException = new ExportImportDocumentException((Throwable)documentException);
            exportImportDocumentException.setPortletId(portletDataContext.getPortletId());
            exportImportDocumentException.setType(2);
            throw exportImportDocumentException;
        }
        boolean importPermissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        this._permissionImporter.clearCache();
        if (importPermissions) {
            this._permissionImporter.checkRoles(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), userId, portletElement);
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        if (!(layoutsImportMode = MapUtil.getString((Map)parameterMap, (Object)"LAYOUTS_IMPORT_MODE")).equals("CREATED_FROM_PROTOTYPE")) {
            this.readExpandoTables(portletDataContext);
        }
        this.readLocks(portletDataContext);
        Element portletDataElement = portletElement.element("portlet-data");
        Map importPortletControlsMap = this._exportImportHelper.getImportPortletControlsMap(portletDataContext.getCompanyId(), portletDataContext.getPortletId(), parameterMap, portletDataElement, manifestSummary);
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        try {
            this.importPortletPreferences(portletDataContext, layout.getCompanyId(), portletDataContext.getGroupId(), layout, portletElement, true, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
            if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Importing portlet data");
                }
                this.importPortletData(portletDataContext, portletDataElement);
            }
        }
        finally {
            this.resetPortletScope(portletDataContext, portletDataContext.getGroupId());
        }
        if (importPermissions) {
            PortletDataHandler portletDataHandler;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Importing portlet permissions");
            }
            if ((portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletDataContext.getPortletId())) != null && Validator.isNotNull((String)portletDataHandler.getResourceName())) {
                portletDataContext.importPortletPermissions(portletDataHandler.getResourceName());
            }
            this._permissionImporter.importPortletPermissions(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), userId, layout, portletElement, portletDataContext.getPortletId());
            if (userId > 0L) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)this._userLocalService.fetchUser(userId));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing asset links");
        }
        this.importAssetLinks(portletDataContext);
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet takes " + stopWatch.getTime() + " ms"));
        }
        if (importPortletSetup = ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue()) {
            try {
                List serviceElements = rootElement.elements("service");
                for (Element serviceElement : serviceElements) {
                    Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(serviceElement.attributeValue("path")));
                    this.importServicePortletPreferences(portletDataContext, serviceDocument.getRootElement());
                }
            }
            catch (DocumentException documentException) {
                ExportImportDocumentException exportImportDocumentException = new ExportImportDocumentException((Throwable)documentException);
                exportImportDocumentException.setPortletId(portletDataContext.getPortletId());
                exportImportDocumentException.setType(4);
                throw exportImportDocumentException;
            }
            catch (PortalException portalException) {
                throw new PortletDataException("Unable to import service preferences for portlet " + portletDataContext.getPortletId(), (Throwable)portalException);
            }
        }
        ZipReader zipReader = portletDataContext.getZipReader();
        zipReader.close();
    }

    private void _updatePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, long plid, String portletId, String xml, boolean importData) throws Exception {
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getCompanyId(), portletId);
        PortletPreferences portletPreferences = this._portletPreferencesLocalService.getPreferences(portletDataContext.getCompanyId(), ownerId, ownerType, plid, portletId);
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        if (importData || !MergeLayoutPrototypesThreadLocal.isInProgress()) {
            String currentLastPublishDate = portletPreferences.getValue("last-publish-date", null);
            String newLastPublishDate = jxPortletPreferences.getValue("last-publish-date", null);
            if (Validator.isNotNull((String)currentLastPublishDate)) {
                jxPortletPreferences.setValue("last-publish-date", currentLastPublishDate);
            } else if (Validator.isNotNull((String)newLastPublishDate)) {
                jxPortletPreferences.reset("last-publish-date");
            }
            this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, plid, portletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
            return;
        }
        Object[] dataPortletPreferences = portletDataHandler.getDataPortletPreferences();
        Enumeration enumeration = jxPortletPreferences.getNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String scopeType = portletDataContext.getScopeType();
            if (ArrayUtil.contains((Object[])dataPortletPreferences, (Object)name) && (!Validator.isNull((String)portletDataContext.getScopeLayoutUuid()) || !scopeType.equals("company"))) continue;
            portletPreferences.setValues(name, jxPortletPreferences.getValues(name, null));
        }
        this._portletPreferencesLocalService.updatePreferences(ownerId, ownerType, plid, portletId, portletPreferences);
    }
}

