/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class ExportImportProcessCallbackUtil {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportProcessCallbackUtil.class);
    private static final Map<String, List<List<Callable<?>>>> _callbackListListMap = new ConcurrentHashMap();

    public static List<Callable<?>> popCallbackList(String processId) {
        List<List<Callable<?>>> callbackListList = _callbackListListMap.get(processId);
        if (callbackListList == null) {
            return Collections.emptyList();
        }
        return callbackListList.remove(callbackListList.size() - 1);
    }

    public static void pushCallbackList(String processId) {
        List<List<Callable<?>>> callbackListList = _callbackListListMap.get(processId);
        if (callbackListList == null) {
            callbackListList = new ArrayList();
            _callbackListListMap.put(processId, callbackListList);
        }
        callbackListList.add(Collections.emptyList());
    }

    public static void registerCallback(String processId, Callable<?> callable) {
        List<List<Callable<?>>> callbackListList = _callbackListListMap.get(processId);
        if (ListUtil.isEmpty(callbackListList)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Calling export import process callback immediately, because there is no active process with ID " + processId));
            }
            try {
                callable.call();
            }
            catch (Exception exception) {
                ExportImportRuntimeException exportImportRuntimeException = new ExportImportRuntimeException(exception.getLocalizedMessage(), (Throwable)exception);
                Class<?> clazz = callable.getClass();
                exportImportRuntimeException.setClassName(clazz.getName());
                throw exportImportRuntimeException;
            }
            return;
        }
        int index = callbackListList.size() - 1;
        List<Callable<?>> callableList = callbackListList.get(index);
        if (callableList == Collections.emptyList()) {
            callableList = new ArrayList();
            callbackListList.set(index, callableList);
        }
        callableList.add(callable);
    }
}

