/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.controller;

import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.model.adapter.StagedAssetLink;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.controller.PortletExportController;
import com.liferay.exportimport.internal.lar.PermissionExporter;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.lar.DeletionSystemEventExporter;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import jakarta.portlet.PortletPreferences;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.Portlet"}, service={ExportImportController.class, PortletExportController.class})
public class PortletExportControllerImpl
implements PortletExportController {
    private static final Log _log = LogFactoryUtil.getLog(PortletExportControllerImpl.class);
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DeletionSystemEventExporter _deletionSystemEventExporter;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    private final PermissionExporter _permissionExporter = PermissionExporter.getInstance();
    @Reference
    private Portal _portal;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;
    @Reference
    private PortletDataHandlerStatusMessageSender _portletDataHandlerStatusMessageSender;
    @Reference
    private PortletItemLocalService _portletItemLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public File export(ExportImportConfiguration exportImportConfiguration) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(9, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            File file = this.doExport(portletDataContext);
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(8, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            return file;
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(7, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAssetLinks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("links");
        Element exportDataRootElement = portletDataContext.getExportDataRootElement();
        try {
            portletDataContext.setExportDataRootElement(rootElement);
            ArrayList<AssetLink> assetLinks = new ArrayList<AssetLink>();
            if (this._isIncludeAllAssetLinks()) {
                assetLinks.addAll(this._assetLinkLocalService.getLinks(portletDataContext.getGroupId(), portletDataContext.getStartDate(), portletDataContext.getEndDate(), -1, -1));
            }
            Set assetLinkIds = portletDataContext.getAssetLinkIds();
            for (Long assetLinkId : assetLinkIds) {
                AssetLink assetLink = this._assetLinkLocalService.fetchAssetLink(assetLinkId.longValue());
                if (assetLink == null || assetLinks.contains(assetLink)) continue;
                assetLinks.add(assetLink);
            }
            for (AssetLink assetLink : assetLinks) {
                StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
                portletDataContext.addClassedModel(portletDataContext.getExportDataElement((ClassedModel)stagedAssetLink), ExportImportPathUtil.getModelPath((StagedModel)stagedAssetLink), (ClassedModel)stagedAssetLink);
            }
        }
        finally {
            portletDataContext.setExportDataRootElement(exportDataRootElement);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/links.xml", document.formattedString());
    }

    public void exportLocks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("locks");
        Map locksMap = portletDataContext.getLocks();
        for (Map.Entry entry : locksMap.entrySet()) {
            Lock lock = (Lock)entry.getValue();
            String entryKey = (String)entry.getKey();
            int pos = entryKey.indexOf(35);
            String className = entryKey.substring(0, pos);
            String key = entryKey.substring(pos + 1);
            String path = this._getLockPath(portletDataContext, className, key, lock);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", path);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("key", key);
            portletDataContext.addZipEntry(path, (Object)lock);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/locks.xml", document.formattedString());
    }

    public void exportPortlet(PortletDataContext portletDataContext, long plid, Element parentElement, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences) throws Exception {
        block32: {
            String path;
            Element portletElement;
            Document document;
            PortletDataHandler portletDataHandler;
            Portlet portlet;
            Layout layout;
            long layoutId;
            block31: {
                layoutId = 0L;
                layout = this._layoutLocalService.fetchLayout(plid);
                if (layout != null) {
                    layoutId = layout.getLayoutId();
                }
                if ((portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletDataContext.getPortletId())) == null || portlet.isUndeployedPortlet()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Do not export portlet " + portlet.getPortletId() + " because the portlet is not deployed"));
                    }
                    return;
                }
                if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && portletDataContext.hasNotUniquePerLayout(portlet.getPortletId())) {
                    return;
                }
                portletDataHandler = portlet.getPortletDataHandlerInstance();
                if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                    PortletDataContext clonedPortletDataContext = this._portletDataContextFactory.clonePortletDataContext(portletDataContext);
                    ManifestSummary manifestSummary = clonedPortletDataContext.getManifestSummary();
                    manifestSummary.resetCounters();
                    portletDataHandler.prepareManifestSummary(clonedPortletDataContext);
                    this._portletDataHandlerStatusMessageSender.sendStatusMessage("portlet", portlet.getPortletId(), manifestSummary);
                }
                document = SAXReaderUtil.createDocument();
                portletElement = document.addElement("portlet");
                portletElement.addAttribute("portlet-id", portlet.getPortletId());
                portletElement.addAttribute("root-portlet-id", portlet.getRootPortletId());
                portletElement.addAttribute("scope-group-id", String.valueOf(portletDataContext.getScopeGroupId()));
                portletElement.addAttribute("scope-layout-type", portletDataContext.getScopeType());
                portletElement.addAttribute("scope-layout-uuid", portletDataContext.getScopeLayoutUuid());
                portletElement.addAttribute("private-layout", String.valueOf(portletDataContext.isPrivateLayout()));
                path = StringBundler.concat((Object[])new Object[]{ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext), "/", plid, "/portlet.xml"});
                portletElement.addAttribute("self-path", path);
                if (exportPortletData) {
                    PortletPreferences jxPortletPreferences = null;
                    if (ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
                        if (layout != null) {
                            liveGroup = layout.getGroup();
                            if (liveGroup.isStaged()) {
                                stagingGroup = liveGroup.getStagingGroup();
                                layout.setGroupId(stagingGroup.getGroupId());
                                jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portlet.getPortletId());
                            }
                            layout.setGroupId(liveGroup.getGroupId());
                        } else {
                            liveGroup = this._groupLocalService.getGroup(portletDataContext.getGroupId());
                            stagingGroup = liveGroup.getStagingGroup();
                            jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((long)portletDataContext.getCompanyId(), (long)stagingGroup.getGroupId(), (String)portlet.getPortletId());
                        }
                    } else {
                        jxPortletPreferences = layout != null ? PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portlet.getPortletId()) : PortletPreferencesFactoryUtil.getStrictPortletSetup((long)portletDataContext.getCompanyId(), (long)portletDataContext.getGroupId(), (String)portlet.getPortletId());
                    }
                    if (!portlet.isPreferencesUniquePerLayout()) {
                        String dataKey = StringBundler.concat((String[])new String[]{portlet.getPortletId(), "@", portletDataContext.getScopeType(), "@", portletDataContext.getScopeLayoutUuid()});
                        if (!portletDataContext.hasNotUniquePerLayout(dataKey)) {
                            portletDataContext.putNotUniquePerLayout(dataKey);
                            this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
                        }
                    } else {
                        this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
                    }
                }
                if (exportPortletSetup) {
                    this._exportPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, false, layout, plid, portlet.getRootPortletId(), portletElement);
                    this._exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, layout, 0L, portlet.getRootPortletId(), portletElement);
                    this._exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 3, false, layout, 0L, portlet.getPortletId(), portletElement);
                    this._exportPortletPreferences(portletDataContext, 0L, 3, false, layout, plid, portlet.getPortletId(), portletElement);
                }
                if (exportPortletUserPreferences) {
                    List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(4, plid, portlet.getPortletId());
                    for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
                        boolean defaultUser = false;
                        if (portletPreferences.getOwnerId() == 0L) {
                            defaultUser = true;
                        }
                        this._exportPortletPreferences(portletDataContext, portletPreferences.getOwnerId(), 4, defaultUser, layout, plid, portlet.getPortletId(), portletElement);
                    }
                    try {
                        com.liferay.portal.kernel.model.PortletPreferences groupPortletPreferences = this._portletPreferencesLocalService.getPortletPreferences(portletDataContext.getScopeGroupId(), 2, 0L, portlet.getRootPortletId());
                        this._exportPortletPreference(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, groupPortletPreferences, portlet.getRootPortletId(), 0L, portletElement);
                    }
                    catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
                        if (!_log.isDebugEnabled()) break block31;
                        _log.debug((Throwable)noSuchPortletPreferencesException);
                    }
                }
            }
            if (exportPortletArchivedSetups) {
                List portletItems = this._portletItemLocalService.getPortletItems(portletDataContext.getGroupId(), portlet.getRootPortletId(), com.liferay.portal.kernel.model.PortletPreferences.class.getName());
                for (PortletItem portletItem : portletItems) {
                    this._exportPortletPreferences(portletDataContext, portletItem.getPortletItemId(), 5, false, null, plid, portletItem.getPortletId(), portletElement);
                }
            }
            if (exportPermissions) {
                if (Validator.isNotNull((String)portletDataHandler.getResourceName())) {
                    portletDataContext.addPortletPermissions(portletDataHandler.getResourceName());
                }
                this._permissionExporter.exportPortletPermissions(portletDataContext, portlet.getPortletId(), layout, portletElement);
            }
            Element element = parentElement.addElement("portlet");
            element.addAttribute("display-name", portlet.getDisplayName());
            element.addAttribute("portlet-id", portlet.getPortletId());
            element.addAttribute("layout-id", String.valueOf(layoutId));
            element.addAttribute("path", path);
            StringBundler configurationOptionsSB = new StringBundler(6);
            if (exportPortletSetup) {
                configurationOptionsSB.append("setup");
                configurationOptionsSB.append(",");
            }
            if (exportPortletArchivedSetups) {
                configurationOptionsSB.append("archived-setups");
                configurationOptionsSB.append(",");
            }
            if (exportPortletUserPreferences) {
                configurationOptionsSB.append("user-preferences");
                configurationOptionsSB.append(",");
            }
            if (configurationOptionsSB.index() > 0) {
                configurationOptionsSB.setIndex(configurationOptionsSB.index() - 1);
            }
            element.addAttribute("portlet-configuration", configurationOptionsSB.toString());
            element.addAttribute("portlet-data", String.valueOf(exportPortletData));
            element.addAttribute("schema-version", portletDataHandler.getSchemaVersion());
            if (portletDataContext.isValidateExistingDataHandler()) {
                element.addAttribute("validate-existing-data-handler", "true");
            }
            try {
                portletDataContext.addZipEntry(path, document.formattedString());
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block32;
                _log.warn((Throwable)ioException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPortletData(PortletDataContext portletDataContext, Portlet portlet, Layout layout, PortletPreferences jxPortletPreferences, Element parentElement) throws Exception {
        String path;
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = this._getPortletDataHandler(portletDataContext, portlet);
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        long plid = 0L;
        if (layout != null) {
            group = layout.getGroup();
            plid = layout.getPlid();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        String portletId = portlet.getPortletId();
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet(portletId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        if (portletDataContext.hasPrimaryKey(String.class, path = ExportImportPathUtil.getPortletDataPath((PortletDataContext)portletDataContext))) {
            return;
        }
        Date originalStartDate = portletDataContext.getStartDate();
        Date portletLastPublishDate = ExportImportDateUtil.getLastPublishDate((PortletDataContext)portletDataContext, (PortletPreferences)jxPortletPreferences);
        portletDataContext.setStartDate(portletLastPublishDate);
        long groupId = portletDataContext.getGroupId();
        portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        portletDataContext.clearScopedPrimaryKeys();
        String data = null;
        try {
            data = portletDataHandler.exportData(portletDataContext, portletId, jxPortletPreferences);
        }
        finally {
            portletDataContext.clearScopedPrimaryKeys();
            portletDataContext.setGroupId(groupId);
            portletDataContext.setStartDate(originalStartDate);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        Element portletDataElement = parentElement.addElement("portlet-data");
        portletDataElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, data);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            DateRange adjustedDateRange = new DateRange(portletLastPublishDate, portletDataContext.getEndDate());
            this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new UpdatePortletLastPublishDateCallable(adjustedDateRange, portletDataContext.getEndDate(), portletDataContext.getGroupId(), plid, portletId));
        }
    }

    public void exportService(PortletDataContext portletDataContext, Element rootElement, boolean exportServiceSetup) throws Exception {
        if (!exportServiceSetup) {
            return;
        }
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletDataContext.getPortletId());
        if (portletDataHandler == null) {
            return;
        }
        String serviceName = portletDataHandler.getServiceName();
        if (Validator.isNotNull((String)serviceName)) {
            this._exportServicePortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, serviceName, rootElement);
            this._exportServicePortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, serviceName, rootElement);
        }
    }

    protected File doExport(PortletDataContext portletDataContext) throws Exception {
        boolean exportPermissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException(StringBundler.concat((Object[])new Object[]{"Unable to export layout ", layout.getPlid(), " because it has an invalid type: ", layout.getType()}));
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(layout.getCompanyId());
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(this._userLocalService.getGuestUserId(layout.getCompanyId()));
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        long scopeGroupId = portletDataContext.getGroupId();
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
        String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
        String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
        if (Validator.isNotNull((String)scopeType)) {
            Group scopeGroup = null;
            if (scopeType.equals("company")) {
                scopeGroup = this._groupLocalService.getCompanyGroup(layout.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                scopeGroup = layout.getScopeGroup();
            }
            if (scopeGroup != null) {
                scopeGroupId = scopeGroup.getGroupId();
            }
        }
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Collection)this._language.getAvailableLocales(this._portal.getSiteGroupId(portletDataContext.getScopeGroupId()))));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("type", portletDataContext.getType());
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(scopeGroupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        headerElement.addAttribute("root-portlet-id", portletDataContext.getRootPortletId());
        headerElement.addAttribute("schema-version", "4.0.0");
        portletDataContext.setMissingReferencesElement(rootElement.addElement("missing-references"));
        Map exportPortletControlsMap = this._exportImportHelper.getExportPortletControlsMap(layout.getCompanyId(), portletDataContext.getPortletId(), portletDataContext.getParameterMap());
        this.exportPortlet(portletDataContext, layout.getPlid(), rootElement, exportPermissions, (Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)exportPortletControlsMap.get("PORTLET_DATA"), (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"), (Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        this.exportService(portletDataContext, rootElement, (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"));
        this.exportAssetLinks(portletDataContext);
        this.exportLocks(portletDataContext);
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(StagedAssetLink.class)});
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._exportImportHelper.writeManifestSummary(document, portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(PortletExportControllerImpl.class.getName(), (Throwable)ioException);
            exportImportIOException.setPortletId(portletDataContext.getPortletId());
            exportImportIOException.setType(9);
            throw exportImportIOException;
        }
        ZipWriter zipWriter = portletDataContext.getZipWriter();
        return zipWriter.getFile();
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourcePlid = MapUtil.getLong((Map)settingsMap, (String)"sourcePlid");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        String portletId = MapUtil.getString((Map)settingsMap, (Object)"portletId");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration);
        Layout layout = this._layoutLocalService.getLayout(sourcePlid);
        ZipWriter zipWriter = this._exportImportHelper.getPortletZipWriter(portletId);
        PortletDataContext portletDataContext = this._portletDataContextFactory.createExportPortletDataContext(layout.getCompanyId(), sourceGroupId, parameterMap, dateRange.getStartDate(), dateRange.getEndDate(), zipWriter);
        portletDataContext.setExportImportProcessId(String.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        portletDataContext.setPlid(sourcePlid);
        portletDataContext.setPortletId(portletId);
        portletDataContext.setType("portlet");
        return portletDataContext;
    }

    protected com.liferay.portal.kernel.model.PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = null;
        portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, 0L, portletId) : this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, portletId);
        return portletPreferences;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isPortletStagingInProcess()) {
            return 36;
        }
        return 34;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exportPortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.kernel.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentElement) throws Exception {
        PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
        Element portletPreferencesElement = parentElement.addElement("portlet-preferences");
        if (portlet != null && portlet.getPortletDataHandlerInstance() != null) {
            boolean portletDataAll;
            Map parameterMap;
            HashSet oldScopedPrimaryKeys;
            Element exportDataRootElement;
            block10: {
                exportDataRootElement = portletDataContext.getExportDataRootElement();
                oldScopedPrimaryKeys = new HashSet(portletDataContext.getScopedPrimaryKeys());
                parameterMap = portletDataContext.getParameterMap();
                portletDataAll = MapUtil.getBoolean((Map)parameterMap, (String)"PORTLET_DATA_ALL");
                try {
                    portletDataContext.clearScopedPrimaryKeys();
                    Element preferenceDataElement = portletPreferencesElement.addElement("preference-data");
                    portletDataContext.setExportDataRootElement(preferenceDataElement);
                    ExportImportPortletPreferencesProcessor exportImportPortletPreferencesProcessor = ExportImportPortletPreferencesProcessorRegistryUtil.getExportImportPortletPreferencesProcessor((String)portlet.getRootPortletId());
                    if (exportImportPortletPreferencesProcessor == null) break block10;
                    List exportCapabilities = exportImportPortletPreferencesProcessor.getExportCapabilities();
                    if (ListUtil.isNotEmpty((List)exportCapabilities)) {
                        for (Capability exportCapability : exportCapabilities) {
                            exportCapability.process(portletDataContext, jxPortletPreferences);
                        }
                    }
                    exportImportPortletPreferencesProcessor.processExportPortletPreferences(portletDataContext, jxPortletPreferences);
                }
                catch (Throwable throwable) {
                    parameterMap.put("PORTLET_DATA_ALL", new String[]{String.valueOf(portletDataAll)});
                    portletDataContext.addScopedPrimaryKeys(oldScopedPrimaryKeys);
                    portletDataContext.setExportDataRootElement(exportDataRootElement);
                    throw throwable;
                }
            }
            parameterMap.put("PORTLET_DATA_ALL", new String[]{String.valueOf(portletDataAll)});
            portletDataContext.addScopedPrimaryKeys(oldScopedPrimaryKeys);
            portletDataContext.setExportDataRootElement(exportDataRootElement);
        }
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(defaultUser));
        rootElement.addAttribute("plid", String.valueOf(plid));
        rootElement.addAttribute("portlet-id", portletId);
        if (ownerType == 5) {
            PortletItem portletItem = this._portletItemLocalService.getPortletItem(ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = this._userLocalService.fetchUserById(ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            node.detach();
        }
        String path = ExportImportPathUtil.getPortletPreferencesPath((PortletDataContext)portletDataContext, (String)portletId, (long)ownerId, (int)ownerType, (long)plid);
        portletPreferencesElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, document.formattedString("\t", false, false));
    }

    private void _exportPortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, Layout layout, long plid, String portletId, Element parentElement) throws Exception {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, plid, portletId);
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchPortletPreferencesException);
            }
            return;
        }
        if (this._hasPortletId(layout, portletId, ownerType)) {
            this._exportPortletPreference(portletDataContext, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentElement);
        }
    }

    private void _exportServicePortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, com.liferay.portal.kernel.model.PortletPreferences portletPreferences, String serviceName, Element parentElement) throws Exception {
        PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", Boolean.FALSE.toString());
        rootElement.addAttribute("service-name", serviceName);
        if (ownerType == 5) {
            PortletItem portletItem = this._portletItemLocalService.getPortletItem(ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = this._userLocalService.fetchUserById(ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            node.detach();
        }
        Element serviceElement = parentElement.addElement("service");
        String path = ExportImportPathUtil.getServicePortletPreferencesPath((PortletDataContext)portletDataContext, (String)serviceName, (long)ownerId, (int)ownerType);
        serviceElement.addAttribute("path", path);
        serviceElement.addAttribute("service-name", serviceName);
        portletDataContext.addZipEntry(path, document.formattedString());
    }

    private void _exportServicePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, String serviceName, Element parentElement) throws Exception {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, 0L, serviceName);
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchPortletPreferencesException);
            }
            return;
        }
        this._exportServicePortletPreference(portletDataContext, ownerId, ownerType, portletPreferences, serviceName, parentElement);
    }

    private String _getLockPath(PortletDataContext portletDataContext, String className, String key, Lock lock) {
        return StringBundler.concat((Object[])new Object[]{ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext), "/locks/", this._portal.getClassNameId(className), Character.valueOf('/'), key, Character.valueOf('/'), lock.getLockId(), ".xml"});
    }

    private PortletDataHandler _getPortletDataHandler(PortletDataContext portletDataContext, Portlet portlet) {
        if ((portlet = this._replacePortlet(portletDataContext, portlet)) != null) {
            return portlet.getPortletDataHandlerInstance();
        }
        return null;
    }

    private boolean _hasPortletId(Layout layout, String portletId, int ownerType) {
        if (layout == null) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (layoutTypePortlet == null) {
            return true;
        }
        boolean rootPortletId = false;
        if (ownerType == 1 || ownerType == 2) {
            rootPortletId = true;
        }
        if (!rootPortletId) {
            return layoutTypePortlet.hasPortletId(portletId);
        }
        List allPortlets = layoutTypePortlet.getAllPortlets(false);
        for (Portlet portlet : allPortlets) {
            if (!portletId.equals(portlet.getRootPortletId())) continue;
            return true;
        }
        return false;
    }

    private boolean _isIncludeAllAssetLinks() {
        try {
            ExportImportServiceConfiguration exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return exportImportServiceConfiguration.includeAllAssetLinks();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private Portlet _replacePortlet(PortletDataContext portletDataContext, Portlet portlet) {
        if (ExportImportDateUtil.isRangeFromLastPublishDate((PortletDataContext)portletDataContext)) {
            String changesetPortletId = "com_liferay_exportimport_web_portlet_ChangesetPortlet";
            if (ExportImportThreadLocal.isPortletStagingInProcess()) {
                return this._portletLocalService.getPortletById(changesetPortletId);
            }
            if (ExportImportThreadLocal.isLayoutStagingInProcess() && !changesetPortletId.equals(portlet.getPortletId())) {
                return null;
            }
        }
        return portlet;
    }

    private class UpdatePortletLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final Date _endDate;
        private final long _groupId;
        private final long _plid;
        private final String _portletId;

        public UpdatePortletLastPublishDateCallable(DateRange dateRange, Date endDate, long groupId, long plid, String portletId) {
            this._dateRange = dateRange;
            this._endDate = endDate;
            this._groupId = groupId;
            this._plid = plid;
            this._portletId = portletId;
        }

        @Override
        public Void call() throws PortalException {
            Group group = PortletExportControllerImpl.this._groupLocalService.getGroup(this._groupId);
            Layout layout = PortletExportControllerImpl.this._layoutLocalService.fetchLayout(this._plid);
            if (group.hasStagingGroup()) {
                group = group.getStagingGroup();
                if (layout != null) {
                    layout = PortletExportControllerImpl.this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), group.getGroupId(), layout.isPrivateLayout());
                }
            }
            PortletPreferences jxPortletPreferences = null;
            jxPortletPreferences = layout == null ? PortletPreferencesFactoryUtil.getStrictPortletSetup((long)group.getCompanyId(), (long)group.getGroupId(), (String)this._portletId) : PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)this._portletId);
            ExportImportDateUtil.updateLastPublishDate((String)this._portletId, (PortletPreferences)jxPortletPreferences, (DateRange)this._dateRange, (Date)this._endDate);
            return null;
        }
    }
}

