/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.configuration;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.configuration.ExportImportServiceConfigurationWhitelistedURLPatternsHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.url.pattern.mapper.URLPatternMapper;
import com.liferay.petra.url.pattern.mapper.URLPatternMapperFactory;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.exportimport.configuration.ExportImportServiceConfiguration"}, service={ExportImportServiceConfigurationWhitelistedURLPatternsHelper.class})
public class ExportImportServiceConfigurationWhitelistedURLPatternsHelperImpl
implements ExportImportServiceConfigurationWhitelistedURLPatternsHelper {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportServiceConfigurationWhitelistedURLPatternsHelperImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Map<Long, URLPatternMapper<Boolean>> _urlPatternMappers = Collections.synchronizedMap(new HashMap());

    public boolean isWhitelistedURL(long companyId, String url) {
        URLPatternMapper<Boolean> urlPatternMapper;
        if (!this._urlPatternMappers.containsKey(companyId)) {
            try {
                this.rebuildURLPatternMapper(companyId);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to instantiate URL pattern mapper for ", "company ", companyId}), (Throwable)exception);
                } else {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to instantiate URL pattern mapper for ", "company ", companyId, ": ", exception.getMessage()}));
                }
                return false;
            }
        }
        if ((urlPatternMapper = this._urlPatternMappers.get(companyId)) == null) {
            return false;
        }
        Boolean result = (Boolean)urlPatternMapper.getValue(url);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void rebuildURLPatternMapper(long companyId) throws Exception {
        this.rebuildURLPatternMapper(companyId, null);
    }

    public void rebuildURLPatternMapper(long companyId, ExportImportServiceConfiguration exportImportServiceConfiguration) throws Exception {
        Object[] whitelistedURLPatterns;
        if (exportImportServiceConfiguration == null) {
            exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, companyId);
        }
        if (ArrayUtil.isEmpty((Object[])(whitelistedURLPatterns = exportImportServiceConfiguration.validateLayoutReferencesWhitelistedURLPatterns()))) {
            this._urlPatternMappers.put(companyId, null);
            return;
        }
        HashMap<Object, Boolean> whitelistedURLPatternsMap = new HashMap<Object, Boolean>();
        for (Object whitelistedURLPattern : whitelistedURLPatterns) {
            whitelistedURLPatternsMap.put(whitelistedURLPattern, true);
        }
        this._urlPatternMappers.put(companyId, (URLPatternMapper<Boolean>)URLPatternMapperFactory.create(whitelistedURLPatternsMap));
    }

    public void rebuildURLPatternMappers() {
        this._companyLocalService.forEachCompanyId(companyId -> {
            try {
                this.rebuildURLPatternMapper((long)companyId);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to instantiate URL pattern mapper for ", "company ", companyId}), (Throwable)exception);
                }
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to instantiate URL pattern mapper for ", "company ", companyId, ": ", exception.getMessage()}));
            }
        });
    }

    public void removeURLPatternMapper(long companyId) {
        this._urlPatternMappers.remove(companyId);
    }

    public void removeURLPatternMappers() {
        this._urlPatternMappers.clear();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.removeURLPatternMappers();
    }
}

