/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.exportimport.internal.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.internal.background.task.display.LayoutStagingBackgroundTaskDisplay;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.exportimport.kernel.service.StagingLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.trash.service.TrashEntryLocalService;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.exportimport.internal.background.task.LayoutStagingBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class LayoutStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private DLAppHelperLocalService _dLAppHelperLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLocalService _exportImportLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private StagingLocalService _stagingLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;

    public LayoutStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        this.clearBackgroundTaskStatus(backgroundTask);
        File file = null;
        MissingReferences missingReferences = null;
        try {
            Group stagingGroup;
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
            Group targetGroup = this._groupLocalService.fetchGroup(targetGroupId);
            if (targetGroup == null) {
                throw new NoSuchGroupException("Target group does not exist with the primary key " + targetGroupId);
            }
            Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
            if (sourceGroup.hasStagingGroup() && (stagingGroup = sourceGroup.getStagingGroup()).getGroupId() == targetGroupId) {
                this._dLAppHelperLocalService.cancelCheckOuts(sourceGroupId);
                ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)true);
                this._trashEntryLocalService.deleteEntries(sourceGroupId, true);
            }
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)15, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            this.initThreadLocals(sourceGroupId, privateLayout);
            file = this._exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
            this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
            missingReferences = (MissingReferences)TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutStagingImportCallable(backgroundTask.getBackgroundTaskId(), exportImportConfiguration, file, sourceGroupId, targetGroupId, userId));
            this.deleteExportedChangesetEntries();
            ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)14, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            this._exportImportHelper.processBackgroundTaskManifestSummary(userId, sourceGroupId, backgroundTask, file);
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)13, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration, throwable});
            Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
            if (sourceGroup.hasStagingGroup()) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUserId(userId);
                this._stagingLocalService.disableStaging(sourceGroup, serviceContext);
                List queuedBackgroundTasks = this._backgroundTaskManager.getBackgroundTasks(sourceGroupId, LayoutStagingBackgroundTaskExecutor.class.getName(), 4);
                for (BackgroundTask queuedBackgroundTask : queuedBackgroundTasks) {
                    this._backgroundTaskManager.amendBackgroundTask(queuedBackgroundTask.getBackgroundTaskId(), null, 5, new ServiceContext());
                }
            }
            this.deleteTempLarOnFailure(file);
            throw new SystemException(throwable);
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    @Override
    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new LayoutStagingBackgroundTaskDisplay(backgroundTask);
    }

    private void _initLayoutSetBranches(long userId, long sourceGroupId, long targetGroupId) throws PortalException {
        Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
        if (!sourceGroup.hasStagingGroup()) {
            return;
        }
        this._layoutSetBranchLocalService.deleteLayoutSetBranches(targetGroupId, false, true);
        this._layoutSetBranchLocalService.deleteLayoutSetBranches(targetGroupId, true, true);
        UnicodeProperties typeSettingsUnicodeProperties = sourceGroup.getTypeSettingsProperties();
        boolean branchingPrivate = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("branchingPrivate"));
        boolean branchingPublic = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("branchingPublic"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        this._stagingLocalService.checkDefaultLayoutSetBranches(userId, sourceGroup, branchingPublic, branchingPrivate, false, serviceContext);
    }

    private class LayoutStagingImportCallable
    implements Callable<MissingReferences> {
        private final long _backgroundTaskId;
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;
        private final long _sourceGroupId;
        private final long _targetGroupId;
        private final long _userId;

        public LayoutStagingImportCallable(long backgroundTaskId, ExportImportConfiguration exportImportConfiguration, File file, long sourceGroupId, long targetGroupId, long userId) {
            this._backgroundTaskId = backgroundTaskId;
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
            this._sourceGroupId = sourceGroupId;
            this._targetGroupId = targetGroupId;
            this._userId = userId;
        }

        @Override
        public MissingReferences call() throws PortalException {
            LayoutStagingBackgroundTaskExecutor.this._exportImportLocalService.importLayoutsDataDeletions(this._exportImportConfiguration, this._file);
            MissingReferences missingReferences = LayoutStagingBackgroundTaskExecutor.this._exportImportLocalService.validateImportLayoutsFile(this._exportImportConfiguration, this._file);
            LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "validated");
            LayoutStagingBackgroundTaskExecutor.this._exportImportLocalService.importLayouts(this._exportImportConfiguration, this._file);
            LayoutStagingBackgroundTaskExecutor.this._initLayoutSetBranches(this._userId, this._sourceGroupId, this._targetGroupId);
            return missingReferences;
        }
    }
}

