/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.service.AssetLinkLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.adapter.StagedExpandoColumn;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.exportimport.internal.util.ExportImportPermissionUtil;
import com.liferay.exportimport.internal.xstream.ConverterAdapter;
import com.liferay.exportimport.internal.xstream.XStreamStagedModelTypeHierarchyPermission;
import com.liferay.exportimport.internal.xstream.converter.TimestampConverter;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.exportimport.kernel.xstream.XStreamAlias;
import com.liferay.exportimport.kernel.xstream.XStreamConverter;
import com.liferay.exportimport.kernel.xstream.XStreamType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.NoSuchTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.adapter.StagedGroupedWorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import com.liferay.portal.workflow.util.WorkflowDefinitionManagerUtil;
import com.liferay.xstream.configurator.XStreamConfigurator;
import com.liferay.xstream.configurator.XStreamConfiguratorRegistryUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PortletDataContextImpl
implements PortletDataContext {
    private static final Class<?>[] _XSTREAM_DEFAULT_ALLOWED_TYPES = new Class[]{boolean[].class, byte[].class, Date.class, Date[].class, double[].class, float[].class, int[].class, Locale.class, long[].class, Number.class, Number[].class, short[].class, String.class, String[].class};
    private static final Log _log = LogFactoryUtil.getLog(PortletDataContextImpl.class);
    private static ClassLoader _classLoader;
    private static long _modifiedCount;
    private static transient XStream _xStream;
    private final Map<String, long[]> _assetCategoryIdsMap = new HashMap<String, long[]>();
    private final Set<Long> _assetLinkIds = new HashSet<Long>();
    private final Map<String, String[]> _assetTagNamesMap = new HashMap<String, String[]>();
    private long _companyGroupId;
    private long _companyId;
    private String _dataStrategy;
    private final Set<StagedModelType> _deletionSystemEventModelTypes = new HashSet<StagedModelType>();
    private Date _endDate;
    private final Map<String, List<ExpandoColumn>> _expandoColumnsMap = new HashMap<String, List<ExpandoColumn>>();
    private transient Element _exportDataRootElement;
    private String _exportImportProcessId;
    private long _groupId;
    private Map<String, Element> _importDataElements;
    private transient Element _importDataRootElement;
    private transient long[] _layoutIds;
    private String _layoutSetPrototypeUuid;
    private final transient LockManager _lockManager;
    private final transient Map<String, Lock> _locksMap = new HashMap<String, Lock>();
    private transient ManifestSummary _manifestSummary = new ManifestSummary();
    private final transient Set<String> _missingReferences = new HashSet<String>();
    private transient Element _missingReferencesElement;
    private transient List<Layout> _newLayouts;
    private final Map<String, Map<?, ?>> _newPrimaryKeysMaps = new HashMap();
    private final Set<String> _notUniquePerLayout = new HashSet<String>();
    private final Map<String, Object> _objectsMap = new HashMap<String, Object>();
    private boolean _originalPrivateLayout;
    private Map<String, String[]> _parameterMap;
    private final Map<String, List<KeyValuePair>> _permissionsMap = new HashMap<String, List<KeyValuePair>>();
    private long _plid;
    private String _portletId;
    private final Set<String> _primaryKeys = new HashSet<String>();
    private boolean _privateLayout;
    private final Set<String> _references = new HashSet<String>();
    private String _rootPortletId;
    private final Set<String> _scopedPrimaryKeys = new HashSet<String>();
    private long _scopeGroupId;
    private String _scopeLayoutUuid;
    private String _scopeType;
    private long _sourceCompanyGroupId;
    private long _sourceCompanyId;
    private long _sourceGroupId;
    private long _sourceUserPersonalSiteGroupId;
    private Date _startDate;
    private String _type;
    private transient UserIdStrategy _userIdStrategy;
    private long _userPersonalSiteGroupId;
    private transient ZipReader _zipReader;
    private transient ZipWriter _zipWriter;

    public PortletDataContextImpl(LockManager lockManager) {
        this(lockManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PortletDataContextImpl(LockManager lockManager, boolean createXstream) {
        if (createXstream) {
            Class<PortletDataContextImpl> clazz = PortletDataContextImpl.class;
            // MONITORENTER : com.liferay.exportimport.internal.lar.PortletDataContextImpl.class
            this._initXStream();
            // MONITOREXIT : clazz
        }
        this._lockManager = lockManager;
    }

    public void addAssetCategories(String className, long classPK, long[] assetCategoryIds) {
        this._assetCategoryIdsMap.put(this._getPrimaryKeyString(className, (Serializable)Long.valueOf(classPK)), assetCategoryIds);
    }

    public void addAssetTags(String className, long classPK, String[] assetTagNames) {
        this._assetTagNamesMap.put(this._getPrimaryKeyString(className, (Serializable)Long.valueOf(classPK)), assetTagNames);
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel) throws PortalException {
        this.addClassedModel(element, path, classedModel, classedModel.getModelClass());
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel, Class<?> clazz) throws PortalException {
        AuditedModel auditedModel;
        element.addAttribute("path", path);
        this._populateClassNameAttribute(classedModel, element);
        Serializable classPK = ExportImportClassedModelUtil.getPrimaryKeyObj((ClassedModel)classedModel);
        long classNameId = ExportImportClassedModelUtil.getClassNameId((ClassedModel)classedModel);
        if (!this.hasPrimaryKey(String.class, path)) {
            if (classedModel instanceof AuditedModel) {
                auditedModel = (AuditedModel)classedModel;
                auditedModel.setUserUuid(auditedModel.getUserUuid());
            }
            if (this._isResourceMain(classedModel)) {
                this._addAssetLinks(classNameId, GetterUtil.getLong((Object)classPK));
                this.addExpando(element, path, classedModel, clazz);
                if (this.getBooleanParameter(clazz.getName(), "LOCKS", false)) {
                    this.addLocks(clazz, String.valueOf(classPK));
                }
                this.addPermissions(clazz, classPK);
            }
            this._references.add(this._getReferenceKey(classedModel));
        }
        if (classedModel instanceof AuditedModel) {
            auditedModel = (AuditedModel)classedModel;
            element.addAttribute("user-uuid", auditedModel.getUserUuid());
        }
        if (this._isResourceMain(classedModel)) {
            double assetEntryPriority = AssetEntryLocalServiceUtil.getEntryPriority((long)classNameId, (long)GetterUtil.getLong((Object)classPK));
            element.addAttribute("asset-entry-priority", String.valueOf(assetEntryPriority));
        }
        this._addWorkflowDefinitionLink(classedModel);
        this.addZipEntry(path, classedModel);
    }

    public void addDateRangeCriteria(DynamicQuery dynamicQuery, String propertyName) {
        Criterion criterion = this.getDateRangeCriteria(propertyName);
        if (criterion == null) {
            return;
        }
        dynamicQuery.add(criterion);
    }

    public void addDeletionSystemEventStagedModelTypes(StagedModelType ... stagedModelTypes) {
        for (StagedModelType stagedModelType : stagedModelTypes) {
            this._deletionSystemEventModelTypes.add(stagedModelType);
        }
    }

    public void addLocks(Class<?> clazz, String key) throws PortalException {
        if (!this._locksMap.containsKey(this._getPrimaryKeyString(clazz, (Serializable)((Object)key))) && this._lockManager.isLocked(clazz.getName(), key)) {
            this.addLocks(clazz.getName(), key, this._lockManager.getLock(clazz.getName(), key));
        }
    }

    public void addLocks(String className, String key, Lock lock) {
        this._locksMap.put(this._getPrimaryKeyString(className, (Serializable)((Object)key)), lock);
    }

    public void addPermissions(Class<?> clazz, Serializable classPK) {
        this.addPermissions(clazz.getName(), GetterUtil.getLong((Object)classPK));
    }

    public void addPermissions(String resourceName, long resourcePK) {
        if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        Map<Long, Set<String>> roleIdsToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(this._companyId, resourceName, resourcePK);
        ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
        for (Map.Entry<Long, Set<String>> entry : roleIdsToActionIds.entrySet()) {
            long roleId = entry.getKey();
            Role role = RoleLocalServiceUtil.fetchRole((long)roleId);
            if (role == null) continue;
            String roleName = role.getName();
            if (role.isTeam()) {
                try {
                    roleName = ExportImportPermissionUtil.getTeamRoleName(role.getDescriptiveName());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                }
            }
            KeyValuePair permission = new KeyValuePair(roleName, StringUtil.merge((Collection)entry.getValue()));
            permissions.add(permission);
        }
        if (permissions.isEmpty()) {
            return;
        }
        this._permissionsMap.put(this._getPrimaryKeyString(resourceName, (Serializable)Long.valueOf(resourcePK)), permissions);
    }

    public void addPermissions(String resourceName, long resourcePK, List<KeyValuePair> permissions) {
        this._permissionsMap.put(this._getPrimaryKeyString(resourceName, (Serializable)Long.valueOf(resourcePK)), permissions);
    }

    public void addPortalPermissions() {
        this.addPermissions("90", this.getCompanyId());
    }

    public void addPortletPermissions(String resourceName) {
        this.addPermissions(resourceName, this.getGroupId());
    }

    public boolean addPrimaryKey(Class<?> clazz, String primaryKey) {
        return !this._primaryKeys.add(this._getPrimaryKeyString(clazz, (Serializable)((Object)primaryKey)));
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String referenceType, boolean missing) {
        return this.addReferenceElement(referrerClassedModel, element, classedModel, ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), "", referenceType, missing);
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String binPath, String referenceType, boolean missing) {
        return this.addReferenceElement(referrerClassedModel, element, classedModel, ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), binPath, referenceType, missing);
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String className, String binPath, String referenceType, boolean missing) {
        Element referenceElement = this._addReferenceElement(referrerClassedModel, element, classedModel, className, binPath, referenceType, false);
        String referenceKey = this._getReferenceKey(classedModel);
        if (missing) {
            referenceElement.addAttribute("missing", Boolean.TRUE.toString());
            if (this._references.contains(referenceKey)) {
                return referenceElement;
            }
            if (!this._missingReferences.contains(referenceKey)) {
                this._missingReferences.add(referenceKey);
                this._addReferenceElement(referrerClassedModel, null, classedModel, className, binPath, referenceType, true);
            }
        } else {
            this._references.add(referenceKey);
            referenceElement.addAttribute("missing", Boolean.FALSE.toString());
            this.cleanUpMissingReferences(classedModel);
        }
        return referenceElement;
    }

    public boolean addScopedPrimaryKey(Class<?> clazz, String primaryKey) {
        boolean value = this.hasScopedPrimaryKey(clazz, primaryKey);
        if (!value) {
            this._scopedPrimaryKeys.add(this._getPrimaryKeyString(clazz, (Serializable)((Object)primaryKey)));
        }
        return value;
    }

    public void addScopedPrimaryKeys(Collection<String> scopedPrimaryKeys) {
        this._scopedPrimaryKeys.addAll(scopedPrimaryKeys);
    }

    public void addZipEntry(String path, byte[] bytes) {
        if (this.isPathProcessed(path)) {
            return;
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, bytes);
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(PortletDataContextImpl.class.getName(), (Throwable)ioException);
            exportImportIOException.setFileName(path);
            exportImportIOException.setType(2);
            throw new SystemException((Throwable)exportImportIOException);
        }
    }

    public void addZipEntry(String path, InputStream inputStream) {
        if (this.isPathProcessed(path)) {
            return;
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, inputStream);
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(PortletDataContextImpl.class.getName(), (Throwable)ioException);
            exportImportIOException.setFileName(path);
            exportImportIOException.setType(3);
            throw new SystemException((Throwable)exportImportIOException);
        }
    }

    public void addZipEntry(String path, Object object) {
        if (this.isPathProcessed(path)) {
            return;
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, this.toXML(object));
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(PortletDataContextImpl.class.getName(), (Throwable)ioException);
            exportImportIOException.setFileName(path);
            exportImportIOException.setType(4);
            throw new SystemException((Throwable)exportImportIOException);
        }
    }

    public void addZipEntry(String path, String s) {
        if (this.isPathProcessed(path)) {
            return;
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, s);
        }
        catch (IOException ioException) {
            ExportImportIOException exportImportIOException = new ExportImportIOException(PortletDataContextImpl.class.getName(), (Throwable)ioException);
            exportImportIOException.setFileName(path);
            exportImportIOException.setType(4);
            throw new SystemException((Throwable)exportImportIOException);
        }
    }

    public void addZipEntry(String path, StringBuilder sb) {
        this.addZipEntry(path, sb.toString());
    }

    public void cleanUpMissingReferences(ClassedModel classedModel) {
        String referenceKey = this._getReferenceKey(classedModel);
        if (this._missingReferences.contains(referenceKey)) {
            this._missingReferences.remove(referenceKey);
            Element missingReferenceElement = this.getMissingReferenceElement(classedModel);
            if (classedModel instanceof Layout) {
                missingReferenceElement.addAttribute("element-path", "/manifest.xml");
            } else {
                missingReferenceElement.addAttribute("element-path", this._getPortletXmlPath());
            }
        }
    }

    public void clearScopedPrimaryKeys() {
        this._scopedPrimaryKeys.clear();
    }

    public ServiceContext createServiceContext(Element element, ClassedModel classedModel) {
        return this.createServiceContext(element, classedModel, classedModel.getModelClass());
    }

    public ServiceContext createServiceContext(StagedModel stagedModel) {
        return this.createServiceContext(stagedModel, stagedModel.getModelClass());
    }

    public ServiceContext createServiceContext(StagedModel stagedModel, Class<?> clazz) {
        return this.createServiceContext(this.getImportDataStagedModelElement(stagedModel), (ClassedModel)stagedModel, clazz);
    }

    public ServiceContext createServiceContext(String path, ClassedModel classedModel) {
        return this.createServiceContext(null, classedModel, classedModel.getModelClass());
    }

    public Object fromXML(byte[] bytes) {
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return null;
        }
        return _xStream.fromXML(new String(bytes));
    }

    public Object fromXML(String xml) {
        if (Validator.isNull((String)xml)) {
            return null;
        }
        return _xStream.fromXML(xml);
    }

    public long[] getAssetCategoryIds(Class<?> clazz, Serializable classPK) {
        long[] assetCategoryIds = this._assetCategoryIdsMap.get(this._getPrimaryKeyString(clazz, classPK));
        if (assetCategoryIds == null) {
            return new long[0];
        }
        return assetCategoryIds;
    }

    public Set<Long> getAssetLinkIds() {
        return this._assetLinkIds;
    }

    public String[] getAssetTagNames(Class<?> clazz, Serializable classPK) {
        return this.getAssetTagNames(this._getPrimaryKeyString(clazz, classPK));
    }

    public String[] getAssetTagNames(String className, Serializable classPK) {
        return this.getAssetTagNames(this._getPrimaryKeyString(className, classPK));
    }

    public Map<String, String[]> getAssetTagNamesMap() {
        return this._assetTagNamesMap;
    }

    public boolean getBooleanParameter(String namespace, String name) {
        return this.getBooleanParameter(namespace, name, true);
    }

    public boolean getBooleanParameter(String namespace, String name, boolean useDefaultValue) {
        if (!useDefaultValue) {
            return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name));
        }
        boolean defaultValue = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_CONTROL_DEFAULT", (boolean)true);
        return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name), (boolean)defaultValue);
    }

    public ClassLoader getClassLoader() {
        return _xStream.getClassLoader();
    }

    public long getCompanyGroupId() {
        return this._companyGroupId;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDataStrategy() {
        return this._dataStrategy;
    }

    public DateRange getDateRange() {
        DateRange dateRange = null;
        if (this.hasDateRange()) {
            dateRange = new DateRange(this._startDate, this._endDate);
        }
        return dateRange;
    }

    public Criterion getDateRangeCriteria(String propertyName) {
        if (!this.hasDateRange()) {
            return null;
        }
        Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
        Property property = PropertyFactoryUtil.forName((String)propertyName);
        conjunction.add(property.le((Object)this._endDate));
        conjunction.add(property.ge((Object)this._startDate));
        return conjunction;
    }

    public Set<StagedModelType> getDeletionSystemEventStagedModelTypes() {
        return this._deletionSystemEventModelTypes;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Element getExportDataElement(ClassedModel classedModel) {
        return this.getExportDataElement(classedModel, ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)classedModel));
    }

    public Element getExportDataElement(ClassedModel classedModel, String modelClassSimpleName) {
        Element groupElement = this.getExportDataGroupElement(modelClassSimpleName);
        Element element = null;
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
            element = this._getDataElement(groupElement, "path", path);
            if (element != null) {
                return element;
            }
            element = this._getDataElement(groupElement, "uuid", stagedModel.getUuid());
            if (element != null) {
                return element;
            }
        }
        element = groupElement.addElement("staged-model");
        long groupId = this._getGroupId(classedModel);
        if (groupId > 0L) {
            element.addAttribute("group-id", String.valueOf(groupId));
        }
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            element.addAttribute("uuid", stagedModel.getUuid());
        }
        return element;
    }

    public Element getExportDataGroupElement(Class<? extends StagedModel> clazz) {
        return this.getExportDataGroupElement(clazz.getSimpleName());
    }

    public Element getExportDataRootElement() {
        return this._exportDataRootElement;
    }

    public String getExportImportProcessId() {
        return this._exportImportProcessId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public Element getImportDataElement(StagedModel stagedModel) {
        return this.getImportDataElement(ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)stagedModel), "uuid", stagedModel.getUuid());
    }

    public Element getImportDataElement(String name, String attribute, String value) {
        String selfPath;
        Element importDataElement = null;
        String key = "";
        if (this._importDataElements != null && Validator.isNotNull((String)(selfPath = this._importDataRootElement.attributeValue("self-path"))) && (importDataElement = this._importDataElements.get(key = StringBundler.concat((Object[])new Object[]{selfPath, Character.valueOf('#'), name, Character.valueOf('#'), attribute, Character.valueOf('#'), value}))) != null) {
            return importDataElement;
        }
        Element groupElement = this.getImportDataGroupElement(name);
        importDataElement = this._getDataElement(groupElement, attribute, value);
        if (Validator.isNotNull((String)key)) {
            this._importDataElements.put(key, importDataElement);
        }
        return importDataElement;
    }

    public Element getImportDataGroupElement(Class<? extends StagedModel> clazz) {
        return this.getImportDataGroupElement(clazz.getSimpleName());
    }

    public Element getImportDataRootElement() {
        return this._importDataRootElement;
    }

    public Element getImportDataStagedModelElement(StagedModel stagedModel) {
        String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
        return this.getImportDataElement(ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)stagedModel), "path", path);
    }

    public long[] getLayoutIds() {
        return this._layoutIds;
    }

    public String getLayoutSetPrototypeUuid() {
        return this._layoutSetPrototypeUuid;
    }

    public Map<String, Lock> getLocks() {
        return this._locksMap;
    }

    public ManifestSummary getManifestSummary() {
        return this._manifestSummary;
    }

    public Element getMissingReferenceElement(ClassedModel classedModel) {
        return this._searchFirstChildElementWithPredicate(this._missingReferencesElement, "missing-reference", childElement -> Objects.equals(childElement.attributeValue("class-name"), ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel)) && Objects.equals(childElement.attributeValue("class-pk"), String.valueOf(classedModel.getPrimaryKeyObj())));
    }

    public Element getMissingReferencesElement() {
        return this._missingReferencesElement;
    }

    public Object getNewPrimaryKey(String className, Object newPrimaryKey) {
        Map<?, ?> primaryKeys = this.getNewPrimaryKeysMap(className);
        return primaryKeys.get(newPrimaryKey);
    }

    public Map<?, ?> getNewPrimaryKeysMap(Class<?> clazz) {
        return this.getNewPrimaryKeysMap(clazz.getName());
    }

    public Map<?, ?> getNewPrimaryKeysMap(String className) {
        Map<?, ?> map = this._newPrimaryKeysMaps.get(className);
        if (map == null) {
            map = new HashMap();
            this._newPrimaryKeysMaps.put(className, map);
        }
        return map;
    }

    public Map<String, Map<?, ?>> getNewPrimaryKeysMaps() {
        return this._newPrimaryKeysMaps;
    }

    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    public Map<String, List<KeyValuePair>> getPermissions() {
        return this._permissionsMap;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public Set<String> getPrimaryKeys() {
        return this._primaryKeys;
    }

    public Element getReferenceDataElement(Element parentElement, Class<?> clazz, long classPK) {
        List<Element> referenceDataElements = this.getReferenceDataElements(this.getReferenceElements(parentElement, clazz.getName(), 0L, null, Long.valueOf(classPK), null), clazz);
        if (referenceDataElements.isEmpty()) {
            return null;
        }
        return referenceDataElements.get(0);
    }

    public Element getReferenceDataElement(Element parentElement, Class<?> clazz, long groupId, String uuid) {
        List<Element> referenceDataElements = this.getReferenceDataElements(this.getReferenceElements(parentElement, clazz.getName(), groupId, uuid, null, null), clazz);
        if (referenceDataElements.isEmpty()) {
            return null;
        }
        return referenceDataElements.get(0);
    }

    public Element getReferenceDataElement(StagedModel parentStagedModel, Class<?> clazz, long classPK) {
        Element parentElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceDataElement(parentElement, clazz, classPK);
    }

    public Element getReferenceDataElement(StagedModel parentStagedModel, Class<?> clazz, long groupId, String uuid) {
        Element parentElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceDataElement(parentElement, clazz, groupId, uuid);
    }

    public List<Element> getReferenceDataElements(Element parentElement, Class<?> clazz, String referenceType) {
        return this.getReferenceDataElements(this.getReferenceElements(parentElement, clazz.getName(), 0L, null, null, referenceType), clazz);
    }

    public List<Element> getReferenceDataElements(StagedModel parentStagedModel, Class<?> clazz) {
        return this.getReferenceDataElements(parentStagedModel, clazz, null);
    }

    public List<Element> getReferenceDataElements(StagedModel parentStagedModel, Class<?> clazz, String referenceType) {
        return this.getReferenceDataElements(this.getReferenceElements(parentStagedModel, clazz.getName(), null, referenceType), clazz);
    }

    public Element getReferenceElement(Element parentElement, Class<?> clazz, long groupId, String uuid, String referenceType) {
        List<Element> referenceElements = this.getReferenceElements(parentElement, clazz.getName(), groupId, uuid, null, referenceType);
        if (!referenceElements.isEmpty()) {
            return referenceElements.get(0);
        }
        return null;
    }

    public Element getReferenceElement(StagedModel parentStagedModel, String className, Serializable classPK) {
        List<Element> referenceElements = this.getReferenceElements(parentStagedModel, className, classPK, null);
        if (!referenceElements.isEmpty()) {
            return referenceElements.get(0);
        }
        return null;
    }

    public Element getReferenceElement(String className, Serializable classPK) {
        Element parentElement = this.getImportDataRootElement();
        List<Element> referenceElements = this.getReferenceElements(parentElement, className, 0L, null, classPK, null);
        if (ListUtil.isNotEmpty(referenceElements)) {
            return referenceElements.get(0);
        }
        return null;
    }

    public List<Element> getReferenceElements(StagedModel parentStagedModel, Class<?> clazz) {
        return this.getReferenceElements(parentStagedModel, clazz.getName(), null, null);
    }

    public String getRootPortletId() {
        return this._rootPortletId;
    }

    public Set<String> getScopedPrimaryKeys() {
        return this._scopedPrimaryKeys;
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getScopeLayoutUuid() {
        return this._scopeLayoutUuid;
    }

    public String getScopeType() {
        return this._scopeType;
    }

    public long getSourceCompanyGroupId() {
        return this._sourceCompanyGroupId;
    }

    public long getSourceCompanyId() {
        return this._sourceCompanyId;
    }

    public long getSourceGroupId() {
        return this._sourceGroupId;
    }

    public long getSourceUserPersonalSiteGroupId() {
        return this._sourceUserPersonalSiteGroupId;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public String getType() {
        return this._type;
    }

    public long getUserId(String userUuid) {
        return this._userIdStrategy.getUserId(userUuid);
    }

    public UserIdStrategy getUserIdStrategy() {
        return this._userIdStrategy;
    }

    public long getUserPersonalSiteGroupId() {
        return this._userPersonalSiteGroupId;
    }

    public byte[] getZipEntryAsByteArray(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        return this.getZipReader().getEntryAsByteArray(path);
    }

    public InputStream getZipEntryAsInputStream(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        return this.getZipReader().getEntryAsInputStream(path);
    }

    public Object getZipEntryAsObject(Element element, String path) {
        Attribute classNameAttribute;
        Object object = this.getZipEntryAsObject(path);
        if (object instanceof TypedModel && (classNameAttribute = element.attribute("attached-class-name")) != null) {
            TypedModel typedModel = (TypedModel)object;
            typedModel.setClassNameId(PortalUtil.getClassNameId((String)classNameAttribute.getText()));
        }
        return object;
    }

    public Object getZipEntryAsObject(String path) {
        return this._objectsMap.computeIfAbsent(path, key -> this.fromXML(this.getZipEntryAsString((String)key)));
    }

    public String getZipEntryAsString(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        return this.getZipReader().getEntryAsString(path);
    }

    public List<String> getZipFolderEntries(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        return this.getZipReader().getFolderEntries(path);
    }

    public ZipReader getZipReader() {
        return this._zipReader;
    }

    public ZipWriter getZipWriter() {
        return this._zipWriter;
    }

    public boolean hasDateRange() {
        return this._startDate != null;
    }

    public boolean hasNotUniquePerLayout(String dataKey) {
        return this._notUniquePerLayout.contains(dataKey);
    }

    public boolean hasPrimaryKey(Class<?> clazz, String primaryKey) {
        return this._primaryKeys.contains(this._getPrimaryKeyString(clazz, (Serializable)((Object)primaryKey)));
    }

    public boolean hasScopedPrimaryKey(Class<?> clazz, String primaryKey) {
        return this._scopedPrimaryKeys.contains(this._getPrimaryKeyString(clazz, (Serializable)((Object)primaryKey)));
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel) throws PortalException {
        this.importClassedModel(classedModel, newClassedModel, classedModel.getModelClass());
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel, Class<?> clazz) throws PortalException {
        StagedGroupedModel stagedGroupedModel;
        Map<?, ?> groupIds;
        if (!this._isResourceMain(classedModel)) {
            return;
        }
        Serializable primaryKeyObj = ExportImportClassedModelUtil.getPrimaryKeyObj((ClassedModel)classedModel);
        Serializable newPrimaryKeyObj = ExportImportClassedModelUtil.getPrimaryKeyObj((ClassedModel)newClassedModel);
        Map<?, ?> newPrimaryKeysMap = this.getNewPrimaryKeysMap(clazz);
        newPrimaryKeysMap.put(primaryKeyObj, newPrimaryKeyObj);
        if (classedModel instanceof StagedGroupedModel && newClassedModel instanceof StagedGroupedModel && !(groupIds = this.getNewPrimaryKeysMap(Group.class)).containsKey((stagedGroupedModel = (StagedGroupedModel)classedModel).getGroupId())) {
            StagedGroupedModel newStagedGroupedModel = (StagedGroupedModel)newClassedModel;
            groupIds.put(stagedGroupedModel.getGroupId(), newStagedGroupedModel.getGroupId());
        }
        this._importWorkflowDefinitionLink(clazz, newClassedModel);
        this.importLocks(clazz, String.valueOf(primaryKeyObj), String.valueOf(newPrimaryKeyObj));
        this.importPermissions(clazz, primaryKeyObj, newPrimaryKeyObj);
    }

    public void importLocks(Class<?> clazz, String key, String newKey) throws PortalException {
        Lock lock = this._locksMap.get(this._getPrimaryKeyString(clazz, (Serializable)((Object)key)));
        if (lock == null) {
            return;
        }
        long userId = this.getUserId(lock.getUserUuid());
        long expirationTime = 0L;
        if (lock.getExpirationDate() != null) {
            Date expirationDate = lock.getExpirationDate();
            expirationTime = expirationDate.getTime();
        }
        this._lockManager.lock(userId, clazz.getName(), newKey, lock.getOwner(), lock.isInheritable(), expirationTime);
    }

    public void importPermissions(Class<?> clazz, Serializable classPK, Serializable newClassPK) throws PortalException {
        this.importPermissions(clazz.getName(), GetterUtil.getLong((Object)classPK), GetterUtil.getLong((Object)newClassPK));
    }

    public void importPermissions(String resourceName, long resourcePK, long newResourcePK) throws PortalException {
        if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        List<KeyValuePair> permissions = this._permissionsMap.get(this._getPrimaryKeyString(resourceName, (Serializable)Long.valueOf(resourcePK)));
        if (permissions == null) {
            return;
        }
        Map<Long, Set<String>> existingRoleIdsToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(this._companyId, resourceName, newResourcePK);
        HashMap<Long, String[]> importedRoleIdsToActionIds = new HashMap<Long, String[]>();
        for (KeyValuePair permission : permissions) {
            String roleName = permission.getKey();
            Team team = null;
            if (ExportImportPermissionUtil.isTeamRoleName(roleName)) {
                roleName = roleName.substring("ROLE_TEAM_,*".length());
                try {
                    team = TeamLocalServiceUtil.getTeam((long)this._groupId, (String)roleName);
                }
                catch (NoSuchTeamException noSuchTeamException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Team " + roleName + " does not exist"), (Throwable)noSuchTeamException);
                    continue;
                }
            }
            Role role = null;
            try {
                role = team != null ? RoleLocalServiceUtil.getTeamRole((long)this._companyId, (long)team.getTeamId()) : RoleLocalServiceUtil.getRole((long)this._companyId, (String)roleName);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Role " + roleName + " does not exist"), (Throwable)noSuchRoleException);
                continue;
            }
            if (this.isPrivateLayout() && resourceName.equals(Layout.class.getName()) && roleName.equals("Guest") && !this._isGroupLayoutSetPrototype()) continue;
            String[] actionIds = StringUtil.split((String)permission.getValue());
            importedRoleIdsToActionIds.put(role.getRoleId(), actionIds);
        }
        Map<Long, String[]> roleIdsToActionIds = ExportImportPermissionUtil.mergeImportedPermissionsWithExistingPermissions(existingRoleIdsToActionIds, importedRoleIdsToActionIds);
        ExportImportPermissionUtil.updateResourcePermissions(this._companyId, this._groupId, resourceName, newResourcePK, roleIdsToActionIds);
    }

    public void importPortalPermissions() throws PortalException {
        this.importPermissions("90", this.getSourceCompanyId(), this.getCompanyId());
    }

    public void importPortletPermissions(String resourceName) throws PortalException {
        if (this.getGroupId() != this.getScopeGroupId()) {
            return;
        }
        this.importPermissions(resourceName, this.getSourceGroupId(), this.getScopeGroupId());
    }

    public boolean isDataStrategyMirror() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR") || this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isDataStrategyMirrorWithOverwriting() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isInitialPublication() {
        Group group;
        block2: {
            group = null;
            try {
                group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        return ExportImportThreadLocal.isStagingInProcess() && group != null && group.hasStagingGroup();
    }

    public boolean isMissingReference(Element referenceElement) {
        Attribute missingAttribute = referenceElement.attribute("missing");
        if (missingAttribute != null && !GetterUtil.getBoolean((String)referenceElement.attributeValue("missing"))) {
            return false;
        }
        if (this._missingReferences.isEmpty()) {
            List missingReferenceElements = this._missingReferencesElement.elements();
            for (Element missingReferenceElement : missingReferenceElements) {
                if (Validator.isNotNull((String)missingReferenceElement.attributeValue("element-path"))) continue;
                String missingReferenceClassName = missingReferenceElement.attributeValue("class-name");
                String missingReferenceClassPK = missingReferenceElement.attributeValue("class-pk");
                String missingReferenceKey = this._getReferenceKey(missingReferenceClassName, missingReferenceClassPK);
                this._missingReferences.add(missingReferenceKey);
            }
        }
        String className = referenceElement.attributeValue("class-name");
        String classPK = referenceElement.attributeValue("class-pk");
        return this._missingReferences.contains(this._getReferenceKey(className, classPK));
    }

    public boolean isModelCounted(String className, Serializable classPK) {
        String modelCountedPrimaryKey = StringBundler.concat((Object[])new Object[]{className, "#", classPK});
        return this.addPrimaryKey(String.class, modelCountedPrimaryKey);
    }

    public boolean isOriginalPrivateLayout() {
        return this._originalPrivateLayout;
    }

    public boolean isPathExportedInScope(String path) {
        return this.addScopedPrimaryKey(String.class, path);
    }

    public boolean isPathNotProcessed(String path) {
        return !this.isPathProcessed(path);
    }

    public boolean isPathProcessed(String path) {
        this.addScopedPrimaryKey(String.class, path);
        return this.addPrimaryKey(String.class, path);
    }

    public boolean isPerformDirectBinaryImport() {
        return MapUtil.getBoolean(this._parameterMap, (String)"PERFORM_DIRECT_BINARY_IMPORT");
    }

    public boolean isPrivateLayout() {
        return this._privateLayout;
    }

    public boolean isStagedModelCounted(StagedModel stagedModel) {
        return this.isModelCounted(ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel), ExportImportClassedModelUtil.getPrimaryKeyObj((ClassedModel)stagedModel));
    }

    public boolean isWithinDateRange(Date modifiedDate) {
        if (!this.hasDateRange()) {
            return true;
        }
        return this._startDate.compareTo(modifiedDate) <= 0 && this._endDate.after(modifiedDate);
    }

    public void putNotUniquePerLayout(String dataKey) {
        this._notUniquePerLayout.add(dataKey);
    }

    public void removePrimaryKey(String path) {
        String primaryKeyString = this._getPrimaryKeyString(String.class, (Serializable)((Object)path));
        this._primaryKeys.remove(primaryKeyString);
        this._scopedPrimaryKeys.remove(primaryKeyString);
    }

    public void setClassLoader(ClassLoader classLoader) {
        _xStream.setClassLoader(classLoader);
    }

    public void setCompanyGroupId(long companyGroupId) {
        this._companyGroupId = companyGroupId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setDataStrategy(String dataStrategy) {
        this._dataStrategy = dataStrategy;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public void setExportDataRootElement(Element exportDataRootElement) {
        this._exportDataRootElement = exportDataRootElement;
    }

    public void setExportImportProcessId(String exportImportProcessId) {
        this._exportImportProcessId = exportImportProcessId;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setImportDataElementCacheEnabled(boolean importDataElementCacheEnabled) {
        this._importDataElements = importDataElementCacheEnabled ? new HashMap<String, Element>() : null;
    }

    public void setImportDataRootElement(Element importDataRootElement) {
        this._importDataRootElement = importDataRootElement;
    }

    public void setLayoutIds(long[] layoutIds) {
        this._layoutIds = layoutIds;
    }

    public void setLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        this._layoutSetPrototypeUuid = layoutSetPrototypeUuid;
    }

    public void setManifestSummary(ManifestSummary manifestSummary) {
        this._manifestSummary = manifestSummary;
    }

    public void setMissingReferencesElement(Element missingReferencesElement) {
        this._missingReferencesElement = missingReferencesElement;
    }

    public void setNewLayouts(List<Layout> newLayouts) {
        this._newLayouts = newLayouts;
    }

    public void setOriginalPrivateLayout(boolean originalPrivateLayout) {
        this._originalPrivateLayout = originalPrivateLayout;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this._parameterMap = parameterMap;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
        this._rootPortletId = Validator.isNotNull((String)portletId) ? PortletIdCodec.decodePortletName((String)portletId) : null;
    }

    public void setPrivateLayout(boolean privateLayout) {
        this._privateLayout = privateLayout;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setScopeLayoutUuid(String scopeLayoutUuid) {
        this._scopeLayoutUuid = scopeLayoutUuid;
    }

    public void setScopeType(String scopeType) {
        this._scopeType = scopeType;
    }

    public void setSourceCompanyGroupId(long sourceCompanyGroupId) {
        this._sourceCompanyGroupId = sourceCompanyGroupId;
    }

    public void setSourceCompanyId(long sourceCompanyId) {
        this._sourceCompanyId = sourceCompanyId;
    }

    public void setSourceGroupId(long sourceGroupId) {
        this._sourceGroupId = sourceGroupId;
    }

    public void setSourceUserPersonalSiteGroupId(long sourceUserPersonalSiteGroupId) {
        this._sourceUserPersonalSiteGroupId = sourceUserPersonalSiteGroupId;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setUserIdStrategy(UserIdStrategy userIdStrategy) {
        this._userIdStrategy = userIdStrategy;
    }

    public void setUserPersonalSiteGroupId(long userPersonalSiteGroupId) {
        this._userPersonalSiteGroupId = userPersonalSiteGroupId;
    }

    public void setZipReader(ZipReader zipReader) {
        this._zipReader = zipReader;
    }

    public void setZipWriter(ZipWriter zipWriter) {
        this._zipWriter = zipWriter;
    }

    public String toXML(Object object) {
        return _xStream.toXML(object);
    }

    protected void addExpando(Element element, String path, ClassedModel classedModel, Class<?> clazz) {
        ExpandoBridge expandoBridge;
        String className = clazz.getName();
        if (!this._expandoColumnsMap.containsKey(className)) {
            List expandoColumns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)className);
            for (ExpandoColumn expandoColumn : expandoColumns) {
                this.addPermissions(ExpandoColumn.class, Long.valueOf(expandoColumn.getColumnId()));
            }
            this._expandoColumnsMap.put(className, expandoColumns);
            for (ExpandoColumn expandoColumn : expandoColumns) {
                StagedExpandoColumn stagedExpandoColumn = (StagedExpandoColumn)ModelAdapterUtil.adapt((Object)expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
                this.addReferenceElement(classedModel, element, (ClassedModel)stagedExpandoColumn, "dependency", true);
            }
        }
        if ((expandoBridge = classedModel.getExpandoBridge()) == null) {
            return;
        }
        Map expandoBridgeAttributes = expandoBridge.getAttributes();
        if (!expandoBridgeAttributes.isEmpty()) {
            String expandoPath = ExportImportPathUtil.getExpandoPath((String)path);
            element.addAttribute("expando-path", expandoPath);
            this.addZipEntry(expandoPath, expandoBridgeAttributes);
        }
    }

    protected ServiceContext createServiceContext(Element element, ClassedModel classedModel, Class<?> clazz) {
        ServiceContext serviceContext;
        block14: {
            Attribute assetPriorityAttribute;
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.getCompanyId());
            serviceContext.setScopeGroupId(this.getScopeGroupId());
            if (classedModel instanceof AuditedModel) {
                AuditedModel auditedModel = (AuditedModel)classedModel;
                serviceContext.setCreateDate(auditedModel.getCreateDate());
                serviceContext.setModifiedDate(auditedModel.getModifiedDate());
                serviceContext.setUserId(this.getUserId(auditedModel));
            } else if (classedModel instanceof StagedModel) {
                StagedModel stagedModel = (StagedModel)classedModel;
                serviceContext.setCreateDate(stagedModel.getCreateDate());
                serviceContext.setModifiedDate(stagedModel.getModifiedDate());
            }
            String xml = this.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)this) + "/portlet-data-permissions.xml");
            if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS") || Validator.isNull((String)xml)) {
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
            }
            if (this._isResourceMain(classedModel)) {
                Serializable classPKObj = ExportImportClassedModelUtil.getPrimaryKeyObj((ClassedModel)classedModel);
                serviceContext.setAssetCategoryIds(this.getAssetCategoryIds(clazz, classPKObj));
                serviceContext.setAssetTagNames(this.getAssetTagNames(clazz, classPKObj));
            }
            if (element != null && (assetPriorityAttribute = element.attribute("asset-entry-priority")) != null) {
                serviceContext.setAssetPriority(GetterUtil.getDouble((String)assetPriorityAttribute.getValue()));
            }
            String expandoPath = null;
            expandoPath = element != null ? element.attributeValue("expando-path") : ExportImportPathUtil.getExpandoPath((String)ExportImportPathUtil.getModelPath((PortletDataContext)this, (String)classedModel.getModelClassName(), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)classedModel)));
            if (Validator.isNotNull((String)expandoPath)) {
                try {
                    Map expandoBridgeAttributes = (Map)this.getZipEntryAsObject(expandoPath);
                    if (expandoBridgeAttributes != null) {
                        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block14;
                    _log.debug((Throwable)exception);
                }
            }
        }
        if (classedModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)classedModel;
            if (workflowedModel.getStatus() == 0) {
                serviceContext.setWorkflowAction(1);
            } else if (workflowedModel.getStatus() == 2) {
                serviceContext.setWorkflowAction(2);
            }
        }
        return serviceContext;
    }

    protected String[] getAssetTagNames(String key) {
        String[] assetTagNames = this._assetTagNamesMap.get(key);
        if (assetTagNames == null) {
            return new String[0];
        }
        return assetTagNames;
    }

    protected Element getExportDataGroupElement(String name) {
        if (this._exportDataRootElement == null) {
            PortletDataException portletDataException = new PortletDataException(15);
            portletDataException.setStagedModelClassName(name);
            throw new SystemException((Throwable)portletDataException);
        }
        Element groupElement = this._exportDataRootElement.element(name);
        if (groupElement == null) {
            groupElement = this._exportDataRootElement.addElement(name);
        }
        return groupElement;
    }

    protected Element getImportDataGroupElement(String name) {
        String selfPath;
        if (this._importDataRootElement == null) {
            PortletDataException portletDataException = new PortletDataException(16);
            portletDataException.setStagedModelClassName(name);
            throw new SystemException((Throwable)portletDataException);
        }
        if (Validator.isNull((String)name)) {
            return SAXReaderUtil.createElement((String)"EMPTY-ELEMENT");
        }
        Element groupElement = null;
        String key = "";
        if (this._importDataElements != null && Validator.isNotNull((String)(selfPath = this._importDataRootElement.attributeValue("self-path"))) && (groupElement = this._importDataElements.get(key = StringBundler.concat((Object[])new Object[]{selfPath, Character.valueOf('#'), name}))) != null) {
            return groupElement;
        }
        groupElement = this._deepSearchForFirstChildElement(this._importDataRootElement, name);
        if (groupElement == null) {
            groupElement = SAXReaderUtil.createElement((String)"EMPTY-ELEMENT");
        }
        if (Validator.isNotNull((String)key)) {
            this._importDataElements.put(key, groupElement);
        }
        return groupElement;
    }

    protected List<Element> getReferenceDataElements(List<Element> referenceElements, Class<?> clazz) {
        ArrayList<Element> referenceDataElements = new ArrayList<Element>();
        for (Element referenceElement : referenceElements) {
            Element referenceDataElement = null;
            String path = referenceElement.attributeValue("path");
            if (Validator.isNotNull((String)path)) {
                referenceDataElement = this.getImportDataElement(clazz.getSimpleName(), "path", path);
            } else {
                String groupId = referenceElement.attributeValue("group-id");
                String uuid = referenceElement.attributeValue("uuid");
                Element groupElement = this.getImportDataGroupElement(clazz.getSimpleName());
                Predicate<Element> childElementPredicate = childElement -> Objects.equals(childElement.attributeValue("uuid"), uuid);
                if (groupId != null) {
                    childElementPredicate = childElementPredicate.and(childElement -> Objects.equals(childElement.attributeValue("group-id"), groupId));
                }
                referenceDataElement = this._searchFirstChildElementWithPredicate(groupElement, "staged-model", childElementPredicate);
            }
            if (referenceDataElement == null) continue;
            referenceDataElements.add(referenceDataElement);
        }
        return referenceDataElements;
    }

    protected List<Element> getReferenceElements(Element parentElement, String className, long groupId, String uuid, Serializable classPK, String referenceType) {
        if (parentElement == null) {
            return Collections.emptyList();
        }
        Element referencesElement = parentElement.element("references");
        if (referencesElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> referenceElements = new ArrayList<Element>();
        for (Element referenceElement : referencesElement.elements("reference")) {
            if (!Objects.equals(referenceElement.attributeValue("class-name"), className) || groupId > 0L && !Objects.equals(referenceElement.attributeValue("group-id"), String.valueOf(groupId)) || Validator.isNotNull((String)uuid) && !Objects.equals(referenceElement.attributeValue("uuid"), uuid) || Validator.isNotNull((Object)classPK) && !Objects.equals(referenceElement.attributeValue("class-pk"), String.valueOf(classPK)) || referenceType != null && !Objects.equals(referenceElement.attributeValue("type"), String.valueOf(referenceType))) continue;
            referenceElements.add(referenceElement);
        }
        return referenceElements;
    }

    protected List<Element> getReferenceElements(StagedModel parentStagedModel, String className, Serializable classPK, String referenceType) {
        Element stagedModelElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceElements(stagedModelElement, className, 0L, null, classPK, referenceType);
    }

    protected long getUserId(AuditedModel auditedModel) {
        try {
            return this.getUserId(auditedModel.getUserUuid());
        }
        catch (SystemException systemException) {
            _log.error((Throwable)systemException);
            return 0L;
        }
    }

    private void _addAssetLinks(long classNameId, long classPK) {
        List assetLinks = AssetLinkLocalServiceUtil.getLinks((long)classNameId, (long)classPK);
        for (AssetLink assetLink : assetLinks) {
            this._assetLinkIds.add(assetLink.getLinkId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element _addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String className, String binPath, String referenceType, boolean missing) {
        Element referenceElement;
        block28: {
            long groupId;
            Element referencesElement;
            if (!missing) {
                Element originalImportDataRootElement = this.getImportDataRootElement();
                try {
                    this.setImportDataRootElement(element);
                    Element referenceElement2 = this.getReferenceElement(ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), classedModel.getPrimaryKeyObj());
                    if (referenceElement2 != null) {
                        Element element2 = referenceElement2;
                        return element2;
                    }
                }
                finally {
                    this.setImportDataRootElement(originalImportDataRootElement);
                }
            }
            referenceElement = null;
            if (missing) {
                referencesElement = this._missingReferencesElement;
                referenceElement = referencesElement.addElement("missing-reference");
            } else {
                referencesElement = element.element("references");
                if (referencesElement == null) {
                    referencesElement = element.addElement("references");
                }
                referenceElement = referencesElement.addElement("reference");
            }
            referenceElement.addAttribute("class-name", className);
            referenceElement.addAttribute("class-pk", String.valueOf(classedModel.getPrimaryKeyObj()));
            this._populateClassNameAttribute(classedModel, referenceElement);
            if (missing) {
                if (classedModel instanceof StagedModel) {
                    referenceElement.addAttribute("display-name", StagedModelDataHandlerUtil.getDisplayName((StagedModel)((StagedModel)classedModel)));
                } else {
                    referenceElement.addAttribute("display-name", String.valueOf(classedModel.getPrimaryKeyObj()));
                }
            }
            if ((groupId = this._getGroupId(classedModel)) > 0L) {
                referenceElement.addAttribute("group-id", String.valueOf(groupId));
                try {
                    Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                    long liveGroupId = group.getLiveGroupId();
                    if (group.isStagedRemotely()) {
                        liveGroupId = group.getRemoteLiveGroupId();
                    }
                    if (liveGroupId == 0L) {
                        liveGroupId = group.getGroupId();
                    }
                    referenceElement.addAttribute("group-key", group.getGroupKey());
                    referenceElement.addAttribute("live-group-id", String.valueOf(liveGroupId));
                    if (group.isLayout()) {
                        try {
                            Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                            referenceElement.addAttribute("scope-layout-uuid", scopeLayout.getUuid());
                        }
                        catch (NoSuchLayoutException noSuchLayoutException) {
                            if (_log.isWarnEnabled()) {
                                _log.warn((Object)("Unable to find layout " + group.getClassPK()), (Throwable)noSuchLayoutException);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block28;
                    _log.warn((Object)("Unable to find group " + groupId), (Throwable)exception);
                }
            }
        }
        if (Validator.isNotNull((String)binPath)) {
            referenceElement.addAttribute("path", binPath);
        }
        referenceElement.addAttribute("type", referenceType);
        if (missing) {
            referenceElement.addAttribute("referrer-class-name", ExportImportClassedModelUtil.getClassName((ClassedModel)referrerClassedModel));
            if (referrerClassedModel instanceof PortletModel) {
                Portlet portlet = (Portlet)referrerClassedModel;
                referenceElement.addAttribute("referrer-display-name", portlet.getRootPortletId());
            } else if (referrerClassedModel instanceof StagedModel) {
                StagedModel referrerStagedModel = (StagedModel)referrerClassedModel;
                referenceElement.addAttribute("referrer-display-name", StagedModelDataHandlerUtil.getDisplayName((StagedModel)referrerStagedModel));
            }
        }
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            referenceElement.addAttribute("uuid", stagedModel.getUuid());
            referenceElement.addAttribute("company-id", String.valueOf(stagedModel.getCompanyId()));
            Map referenceAttributes = StagedModelDataHandlerUtil.getReferenceAttributes((PortletDataContext)this, (StagedModel)stagedModel);
            for (Map.Entry referenceAttribute : referenceAttributes.entrySet()) {
                referenceElement.addAttribute((String)referenceAttribute.getKey(), (String)referenceAttribute.getValue());
            }
        }
        return referenceElement;
    }

    private void _addWorkflowDefinitionLink(ClassedModel classedModel) throws PortletDataException {
        if (classedModel instanceof StagedGroupedModel || classedModel instanceof WorkflowedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)classedModel;
            List workflowDefinitionLinks = WorkflowDefinitionLinkLocalServiceUtil.fetchWorkflowDefinitionLinks((long)stagedGroupedModel.getCompanyId(), (long)stagedGroupedModel.getGroupId(), (String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedGroupedModel), (long)ExportImportClassedModelUtil.getClassPK((ClassedModel)stagedGroupedModel));
            for (WorkflowDefinitionLink workflowDefinitionLink : workflowDefinitionLinks) {
                StagedGroupedWorkflowDefinitionLink stagedGroupedWorkflowDefinitionLink = (StagedGroupedWorkflowDefinitionLink)ModelAdapterUtil.adapt((Object)workflowDefinitionLink, WorkflowDefinitionLink.class, StagedGroupedWorkflowDefinitionLink.class);
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)this, (StagedModel)stagedGroupedWorkflowDefinitionLink);
            }
        }
    }

    private Element _deepSearchForFirstChildElement(Element parentElement, String childElementName) {
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(parentElement);
        Element currentElement = null;
        while ((currentElement = (Element)queue.poll()) != null) {
            for (Element childElement : currentElement.elements()) {
                if (childElementName.equals(childElement.getName())) {
                    return childElement;
                }
                queue.add(childElement);
            }
        }
        return null;
    }

    private Element _getDataElement(Element parentElement, String attribute, String value) {
        if (parentElement == null) {
            return null;
        }
        return this._searchFirstChildElementWithPredicate(parentElement, "staged-model", childElement -> Objects.equals(childElement.attributeValue(attribute), value));
    }

    private long _getGroupId(ClassedModel classedModel) {
        if (classedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)classedModel;
            return groupedModel.getGroupId();
        }
        return 0L;
    }

    private long _getOldPrimaryKey(Map<Long, Long> map, long value) {
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return 0L;
    }

    private String _getPortletXmlPath() {
        if (this._exportDataRootElement == null) {
            return "";
        }
        Element parentElement = null;
        for (Element element = this._exportDataRootElement.getParent(); element != null; element = element.getParent()) {
            parentElement = element;
        }
        if (parentElement == null) {
            return "";
        }
        return parentElement.attributeValue("self-path");
    }

    private String _getPrimaryKeyString(Class<?> clazz, Serializable primaryKey) {
        return this._getPrimaryKeyString(clazz.getName(), primaryKey);
    }

    private String _getPrimaryKeyString(String className, Serializable primaryKey) {
        return StringBundler.concat((Object[])new Object[]{className, "#", primaryKey});
    }

    private String _getReferenceKey(ClassedModel classedModel) {
        return this._getReferenceKey(ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), String.valueOf(classedModel.getPrimaryKeyObj()));
    }

    private String _getReferenceKey(String className, String classPK) {
        return StringBundler.concat((String[])new String[]{className, "#", classPK});
    }

    private void _importWorkflowDefinitionLink(Class<?> clazz, ClassedModel classedModel) throws PortletDataException {
        Element stagedGroupedWorkflowDefinitionLinkElements = this.getImportDataGroupElement(StagedGroupedWorkflowDefinitionLink.class);
        String className = clazz.getName();
        Map<Long, Long> primaryKeys = this.getNewPrimaryKeysMap(className);
        for (Element stagedGroupedWorkflowDefinitionLinkElement : stagedGroupedWorkflowDefinitionLinkElements.elements()) {
            String displayName;
            String referrerClassName = GetterUtil.getString((String)stagedGroupedWorkflowDefinitionLinkElement.attributeValue("referrer-class-name"));
            long referrerClassPK = GetterUtil.getLong((String)stagedGroupedWorkflowDefinitionLinkElement.attributeValue("referrer-class-pk"));
            long newPrimaryKey = GetterUtil.getLong((Object)classedModel.getPrimaryKeyObj());
            long oldPrimaryKey = this._getOldPrimaryKey(primaryKeys, newPrimaryKey);
            if (!referrerClassName.equals(className) || referrerClassPK != oldPrimaryKey || Validator.isNull((String)(displayName = stagedGroupedWorkflowDefinitionLinkElement.attributeValue("display-name")))) continue;
            WorkflowDefinition workflowDefinition = null;
            try {
                workflowDefinition = WorkflowDefinitionManagerUtil.liberalGetLatestWorkflowDefinition((long)this.getCompanyId(), (String)displayName);
            }
            catch (WorkflowException workflowException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to get workflow definition with name " + displayName), (Throwable)workflowException);
                continue;
            }
            long typePK = GetterUtil.getLong((String)stagedGroupedWorkflowDefinitionLinkElement.attributeValue("type-pk"), (long)-1L);
            if (typePK != -1L) {
                Map<?, ?> ddmPrimaryKeys = this.getNewPrimaryKeysMap(DDMStructure.class.getName());
                typePK = ddmPrimaryKeys.getOrDefault(typePK, typePK);
            }
            if (workflowDefinition == null || WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this.getCompanyId(), (long)this.getScopeGroupId(), (String)className, (long)newPrimaryKey, (long)typePK)) continue;
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            try {
                WorkflowDefinitionLinkLocalServiceUtil.addWorkflowDefinitionLink((long)permissionChecker.getUserId(), (long)this.getCompanyId(), (long)this.getScopeGroupId(), (String)className, (long)newPrimaryKey, (long)typePK, (String)workflowDefinition.getName(), (int)workflowDefinition.getVersion());
            }
            catch (PortalException portalException) {
                throw new PortletDataException(portalException.getMessage(), (Throwable)portalException);
            }
        }
    }

    private void _initXStream() {
        ClassLoader classLoader = XStreamConfiguratorRegistryUtil.getConfiguratorsClassLoader((ClassLoader)AggregateClassLoader.getAggregateClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (ClassLoader[])new ClassLoader[]{XStream.class.getClassLoader()}));
        long modifiedCount = XStreamConfiguratorRegistryUtil.getModifiedCount();
        if (_xStream != null && _modifiedCount == modifiedCount && classLoader.equals(_classLoader)) {
            return;
        }
        _modifiedCount = modifiedCount;
        _classLoader = classLoader;
        _xStream = new XStream(null, (HierarchicalStreamDriver)new XppDriver(), new ClassLoaderReference(classLoader));
        _xStream.omitField(HashMap.class, "cache_bitmask");
        _xStream.registerConverter((Converter)new ConverterAdapter((XStreamConverter)new TimestampConverter()), 10000);
        List xStreamConfigurators = XStreamConfiguratorRegistryUtil.getXStreamConfigurators();
        if (xStreamConfigurators.isEmpty()) {
            return;
        }
        ArrayList<String> allowedTypeNames = new ArrayList<String>();
        for (XStreamConfigurator xStreamConfigurator : xStreamConfigurators) {
            List xStreamTypes;
            List xStreamConverters;
            List xStreamAliases = xStreamConfigurator.getXStreamAliases();
            if (ListUtil.isNotEmpty((List)xStreamAliases)) {
                for (XStreamAlias xStreamAlias : xStreamAliases) {
                    _xStream.alias(xStreamAlias.getName(), xStreamAlias.getClazz());
                }
            }
            if (ListUtil.isNotEmpty((List)(xStreamConverters = xStreamConfigurator.getXStreamConverters()))) {
                XStreamAlias xStreamAlias;
                xStreamAlias = xStreamConverters.iterator();
                while (xStreamAlias.hasNext()) {
                    XStreamConverter xStreamConverter = (XStreamConverter)xStreamAlias.next();
                    _xStream.registerConverter((Converter)new ConverterAdapter(xStreamConverter), 10000);
                }
            }
            if (!ListUtil.isNotEmpty((List)(xStreamTypes = xStreamConfigurator.getAllowedXStreamTypes()))) continue;
            for (XStreamType xStreamType : xStreamTypes) {
                allowedTypeNames.add(xStreamType.getTypeExpression());
            }
        }
        _xStream.addPermission(NoTypePermission.NONE);
        _xStream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        _xStream.addPermission(XStreamStagedModelTypeHierarchyPermission.STAGED_MODELS);
        _xStream.allowTypes((Class[])_XSTREAM_DEFAULT_ALLOWED_TYPES);
        _xStream.allowTypeHierarchy(List.class);
        _xStream.allowTypeHierarchy(Map.class);
        _xStream.allowTypeHierarchy(Timestamp.class);
        _xStream.allowTypeHierarchy(Set.class);
        _xStream.allowTypes(allowedTypeNames.toArray(new String[0]));
        _xStream.allowTypesByWildcard(new String[]{"com.thoughtworks.xstream.mapper.DynamicProxyMapper*"});
    }

    private boolean _isGroupLayoutSetPrototype() throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
        return group.isLayoutSetPrototype();
    }

    private boolean _isResourceMain(ClassedModel classedModel) {
        if (classedModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)classedModel;
            return resourcedModel.isResourceMain();
        }
        return true;
    }

    private void _populateClassNameAttribute(ClassedModel classedModel, Element element) {
        if (classedModel instanceof TypedModel) {
            TypedModel typedModel = (TypedModel)classedModel;
            element.addAttribute("attached-class-name", typedModel.getClassName());
        }
    }

    private Element _searchFirstChildElementWithPredicate(Element parentElement, String childElementName, Predicate<Element> childElementPredicate) {
        for (Element childElement : parentElement.elements(childElementName)) {
            if (!childElementPredicate.test(childElement)) continue;
            return childElement;
        }
        return null;
    }
}

