/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.messaging;

import com.liferay.exportimport.internal.messaging.BasePublisherMessageListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/layouts_local_publisher"}, service={MessageListener.class})
public class LayoutsLocalPublisherMessageListener
extends BasePublisherMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsLocalPublisherMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.exportimport.service)(release.schema.version=1.0.2))")
    private Release _release;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private Staging _staging;

    public void receive(Message message) throws MessageListenerException {
        long exportImportConfigurationId = GetterUtil.getLong((Object)message.getPayload());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId);
        if (exportImportConfiguration == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find export import configuration with ID " + exportImportConfigurationId));
            }
            return;
        }
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        try {
            this.initThreadLocals(userId, parameterMap);
            this._staging.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, exportImportConfiguration.getName(), parameterMap);
        }
        catch (PortalException portalException) {
            throw new MessageListenerException((Throwable)portalException);
        }
        finally {
            this.resetThreadLocals();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("parallel", "liferay/layouts_local_publisher"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

