/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BasePublisherMessageListener
implements MessageListener {
    protected void initThreadLocals(long userId, Map<String, String[]> parameterMap) throws PortalException {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        PrincipalThreadLocal.setName((long)userId);
        PermissionChecker permissionChecker = null;
        try {
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        }
        catch (Exception exception) {
            throw new SystemException("Unable to initialize thread locals because an error occured when creating a permission checker for user " + userId, (Throwable)exception);
        }
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setSignedIn(!user.isGuestUser());
        serviceContext.setUserId(user.getUserId());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            Object[] values = entry.getValue();
            if (ArrayUtil.isEmpty((Object[])values)) continue;
            String param = entry.getKey();
            if (values.length == 1) {
                attributes.put(param, values[0]);
                continue;
            }
            attributes.put(param, values);
        }
        serviceContext.setAttributes(attributes);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
    }

    protected void resetThreadLocals() {
        CompanyThreadLocal.setCompanyId((Long)0L);
        PermissionThreadLocal.setPermissionChecker(null);
        PrincipalThreadLocal.setName(null);
        ServiceContextThreadLocal.popServiceContext();
    }
}

