/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.controller;

import com.liferay.asset.link.model.adapter.StagedAssetLink;
import com.liferay.exportimport.controller.PortletExportController;
import com.liferay.exportimport.internal.lar.DeletionSystemEventExporter;
import com.liferay.exportimport.internal.lar.PermissionExporter;
import com.liferay.exportimport.kernel.controller.ExportController;
import com.liferay.exportimport.kernel.controller.ExportImportController;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.site.model.adapter.StagedGroup;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={ExportImportController.class})
public class LayoutExportController
implements ExportController {
    private static final Log _log = LogFactoryUtil.getLog(LayoutExportController.class);
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    private final DeletionSystemEventExporter _deletionSystemEventExporter = DeletionSystemEventExporter.getInstance();
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    private final PermissionExporter _permissionExporter = PermissionExporter.getInstance();
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletExportController _portletExportController;
    @Reference
    private UserLocalService _userLocalService;

    public File export(ExportImportConfiguration exportImportConfiguration) throws Exception {
        PortletDataContext portletDataContext = null;
        try {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)true);
            portletDataContext = this.getPortletDataContext(exportImportConfiguration);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(3, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            File file = this.doExport(portletDataContext);
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(2, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            return file;
        }
        catch (Throwable throwable) {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
            this._exportImportLifecycleManager.fireExportImportLifecycleEvent(1, this.getProcessFlag(), String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), throwable});
            throw throwable;
        }
    }

    protected File doExport(PortletDataContext portletDataContext) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        boolean ignoreLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + permissions));
        }
        long companyId = portletDataContext.getCompanyId();
        long guestUserId = this._userLocalService.getGuestUserId(companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.popServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setCompanyId(companyId);
        serviceContext.setSignedIn(true);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(BackgroundTaskThreadLocal.getBackgroundTaskId());
            serviceContext.setUserId(backgroundTask.getUserId());
        } else {
            serviceContext.setUserId(guestUserId);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        if (ignoreLastPublishDate) {
            portletDataContext.setEndDate(null);
            portletDataContext.setStartDate(null);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Collection)this._language.getAvailableLocales(portletDataContext.getScopeGroupId())));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("schema-version", "4.0.0");
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(portletDataContext.getGroupId()));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(portletDataContext.isPrivateLayout()));
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        portletDataContext.setType(type);
        portletDataContext.setMissingReferencesElement(rootElement.addElement("missing-references"));
        rootElement.addElement("site-portlets");
        rootElement.addElement("site-services");
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeSettings) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
            headerElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            headerElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        StagedGroup stagedGroup = (StagedGroup)ModelAdapterUtil.adapt((Object)group, Group.class, StagedGroup.class);
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedGroup);
        this._portletExportController.exportAssetLinks(portletDataContext);
        this._portletExportController.exportLocks(portletDataContext);
        if (Objects.equals(portletDataContext.getType(), "layout-set")) {
            portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(SegmentsExperience.class, Layout.class)});
            portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(StagedAssetLink.class)});
        }
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (permissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._exportImportHelper.writeManifestSummary(document, portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        ZipWriter zipWriter = portletDataContext.getZipWriter();
        return zipWriter.getFile();
    }

    protected PortletDataContext getPortletDataContext(ExportImportConfiguration exportImportConfiguration) throws Exception {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        Group group = this._groupLocalService.getGroup(sourceGroupId);
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration);
        ZipWriter zipWriter = this._exportImportHelper.getLayoutSetZipWriter(sourceGroupId);
        PortletDataContext portletDataContext = this._portletDataContextFactory.createExportPortletDataContext(group.getCompanyId(), sourceGroupId, parameterMap, dateRange.getStartDate(), dateRange.getEndDate(), zipWriter);
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
        String cmd = MapUtil.getString((Map)parameterMap, (String)"cmd");
        if (ArrayUtil.contains((long[])layoutIds, (long)0L) && !Objects.equals(cmd, "export") && !Objects.equals(cmd, "publish_to_live") && !Objects.equals(cmd, "publish_to_remote")) {
            layoutIds = this._exportImportHelper.getAllLayoutIds(sourceGroupId, privateLayout);
        }
        portletDataContext.setExportImportProcessId(String.valueOf(exportImportConfiguration.getExportImportConfigurationId()));
        portletDataContext.setPrivateLayout(privateLayout);
        portletDataContext.setLayoutIds(layoutIds);
        return portletDataContext;
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
            return 32;
        }
        return 30;
    }
}

