/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task.display;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.display.BaseBackgroundTaskDisplay;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HtmlUtil_IW;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ExportImportBackgroundTaskDisplay
extends BaseBackgroundTaskDisplay {
    private static final String _DETIALS_TEMPLATE = "com/liferay/exportimport/internal/background/task/display/dependencies/export_import_background_task_details.ftl";
    private static final int _EXPORT_PHASE_MAX_PERCENTAGE = 50;
    private final long _allProgressBarCountersTotal;
    private final String _cmd;
    private final long _currentProgressBarCountersTotal;
    private String _messageKey;
    private int _percentage;
    private final String _phase;
    private final String _stagedModelName;
    private final String _stagedModelType;

    public ExportImportBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        super(backgroundTask);
        this._cmd = MapUtil.getString((Map)backgroundTask.getTaskContextMap(), (String)"cmd");
        this._percentage = -1;
        if (this.backgroundTaskStatus == null) {
            this._allProgressBarCountersTotal = 0L;
            this._currentProgressBarCountersTotal = 0L;
            this._phase = null;
            this._stagedModelName = null;
            this._stagedModelType = null;
            return;
        }
        long allModelAdditionCountersTotal = this.getBackgroundTaskStatusAttributeLong("allModelAdditionCountersTotal");
        long allPortletAdditionCounter = this.getBackgroundTaskStatusAttributeLong("allPortletAdditionCounter");
        this._allProgressBarCountersTotal = allModelAdditionCountersTotal + allPortletAdditionCounter;
        long currentModelAdditionCountersTotal = this.getBackgroundTaskStatusAttributeLong("currentModelAdditionCountersTotal");
        long currentPortletAdditionCounter = this.getBackgroundTaskStatusAttributeLong("currentPortletAdditionCounter");
        this._currentProgressBarCountersTotal = currentModelAdditionCountersTotal + currentPortletAdditionCounter;
        this._phase = this.getBackgroundTaskStatusAttributeString("phase");
        this._stagedModelName = this.getBackgroundTaskStatusAttributeString("stagedModelName");
        this._stagedModelType = this.getBackgroundTaskStatusAttributeString("stagedModelType");
    }

    public int getPercentage() {
        if (this._percentage > -1) {
            return this._percentage;
        }
        this._percentage = 100;
        if (this._allProgressBarCountersTotal > 0L) {
            int base = 100;
            if (this._phase.equals("export") && !Objects.equals(this._cmd, "publish_to_remote")) {
                base = 50;
            }
            this._percentage = Math.round((float)this._currentProgressBarCountersTotal / (float)this._allProgressBarCountersTotal * (float)base);
        }
        return this._percentage;
    }

    public boolean hasPercentage() {
        if (!this.hasBackgroundTaskStatus()) {
            return false;
        }
        return this._allProgressBarCountersTotal > 0L && (!Objects.equals(this._cmd, "publish_to_remote") || this.getPercentage() < 100);
    }

    public String renderDisplayTemplate(Locale locale) {
        if (!this.backgroundTask.isInProgress()) {
            return super.renderDisplayTemplate(locale);
        }
        if (this._hasStagedModelMessage()) {
            return this._getStagedModelMessage(locale);
        }
        return LanguageUtil.get((Locale)locale, (String)this._getStatusMessageKey());
    }

    protected TemplateResource getTemplateResource() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return new URLTemplateResource(_DETIALS_TEMPLATE, classLoader.getResource(_DETIALS_TEMPLATE));
    }

    protected Map<String, Object> getTemplateVars() {
        return HashMapBuilder.put((Object)"exported", (Object)MapUtil.getBoolean((Map)this.backgroundTask.getTaskContextMap(), (String)"exported")).put((Object)"htmlUtil", (Object)HtmlUtil_IW.getInstance()).put((Object)"validated", (Object)MapUtil.getBoolean((Map)this.backgroundTask.getTaskContextMap(), (String)"validated")).build();
    }

    private String _getStagedModelMessage(Locale locale) {
        return StringBundler.concat((String[])new String[]{"<strong>", LanguageUtil.get((Locale)locale, (String)this._getStatusMessageKey()), "...</strong>", ResourceActionsUtil.getModelResource((Locale)locale, (String)this._stagedModelType), "<em>", HtmlUtil.escape((String)this._stagedModelName), "</em>"});
    }

    private String _getStatusMessageKey() {
        if (Validator.isNotNull((String)this._messageKey)) {
            return this._messageKey;
        }
        this._messageKey = "";
        if (this._hasRemoteMessage()) {
            this._messageKey = "please-wait-as-the-publish-processes-complete-on-the-remote-site";
        } else if (this._hasStagedModelMessage()) {
            this._messageKey = "exporting";
            if (Objects.equals(this._cmd, "import")) {
                this._messageKey = "importing";
            } else if (Objects.equals(this._cmd, "publish_to_live") || Objects.equals(this._cmd, "publish_to_remote")) {
                this._messageKey = "publishing";
            }
        }
        return this._messageKey;
    }

    private boolean _hasRemoteMessage() {
        return Objects.equals(this._cmd, "publish_to_remote") && this.getPercentage() == 100;
    }

    private boolean _hasStagedModelMessage() {
        return Validator.isNotNull((String)this._stagedModelName) && Validator.isNotNull((String)this._stagedModelType);
    }
}

