/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.PortletExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.internal.background.task.display.PortletExportImportBackgroundTaskDisplay;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.File;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.exportimport.internal.background.task.PortletExportBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class PortletExportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ExportImportLocalService _exportImportLocalService;

    public PortletExportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletExportImportBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        String fileName = MapUtil.getString((Map)settingsMap, (String)"fileName");
        File larFile = this._exportImportLocalService.exportPortletInfoAsFile(exportImportConfiguration);
        this._backgroundTaskManager.addBackgroundTaskAttachment(userId, backgroundTask.getBackgroundTaskId(), fileName, larFile);
        return BackgroundTaskResult.SUCCESS;
    }

    @Override
    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new PortletExportImportBackgroundTaskDisplay(backgroundTask);
    }
}

