/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staging;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.exportimport.internal.util.StagingGroupServiceTunnelUtil;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.exception.ExportImportDocumentException;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReference;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutBranchException;
import com.liferay.portal.kernel.exception.NoSuchLayoutRevisionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.exception.RemoteOptionsException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.RecentLayoutBranch;
import com.liferay.portal.kernel.model.RecentLayoutRevision;
import com.liferay.portal.kernel.model.RecentLayoutSetBranch;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.adapter.StagedTheme;
import com.liferay.portal.kernel.scheduler.CronTextUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutBranchLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.RecentLayoutBranchLocalService;
import com.liferay.portal.kernel.service.RecentLayoutRevisionLocalService;
import com.liferay.portal.kernel.service.RecentLayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.upload.configuration.UploadServletRequestConfigurationProviderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.configuration.StagingConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Staging.class})
public class StagingImpl
implements Staging {
    private static final Log _log = LogFactoryUtil.getLog(StagingImpl.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationParameterMapFactory _exportImportConfigurationParameterMapFactory;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutBranchLocalService _layoutBranchLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private RecentLayoutBranchLocalService _recentLayoutBranchLocalService;
    @Reference
    private RecentLayoutRevisionLocalService _recentLayoutRevisionLocalService;
    @Reference
    private RecentLayoutSetBranchLocalService _recentLayoutSetBranchLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private StagingURLHelper _stagingURLHelper;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public <T extends BaseModel> void addModelToChangesetCollection(T model) throws PortalException {
        if (!(model instanceof StagedGroupedModel) || ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
            return;
        }
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)model;
        long groupId = stagedGroupedModel.getGroupId();
        if (groupId <= 0L) {
            return;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null || !this._stagingGroupHelper.isStagingGroup(group)) {
            return;
        }
        if (this._stagedModelRepositoryHelper.isStagedModelInTrash((StagedModel)stagedGroupedModel)) {
            this.removeModelFromChangesetCollection(model);
            return;
        }
        if (stagedGroupedModel instanceof WorkflowedModel) {
            int[] exportableStatuses = new int[]{0};
            String className = ExportImportClassedModelUtil.getClassName((ClassedModel)stagedGroupedModel);
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)className);
            if (stagedModelDataHandler != null) {
                exportableStatuses = stagedModelDataHandler.getExportableStatuses();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get staged model data handler for class name " + className));
            }
            WorkflowedModel workflowedModel = (WorkflowedModel)stagedGroupedModel;
            if (!ArrayUtil.contains((int[])exportableStatuses, (int)workflowedModel.getStatus())) {
                this.removeModelFromChangesetCollection(model);
                return;
            }
        }
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchOrAddChangesetCollection(groupId, "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        long classPK = (Long)stagedGroupedModel.getPrimaryKeyObj();
        this._changesetEntryLocalService.fetchOrAddChangesetEntry(changesetCollection.getChangesetCollectionId(), this._classNameLocalService.getClassNameId(stagedGroupedModel.getModelClassName()), classPK);
    }

    public long copyFromLive(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        long targetGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = this._groupLocalService.getGroup(targetGroupId);
        long sourceGroupId = stagingGroup.getLiveGroupId();
        boolean privateLayout = this._isPrivateLayout(portletRequest);
        long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        Map publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(user, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(user.getUserId(), exportImportConfiguration);
    }

    public long copyFromLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = this._portal.getScopeGroupId(this._portal.getHttpServletRequest(portletRequest), portlet.getPortletId());
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        return this.publishPortlet(themeDisplay.getUserId(), scopeGroupId, plid, portlet.getPortletId(), parameterMap, true);
    }

    public long copyRemoteLayouts(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
        int remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
        String remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
        boolean secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
        boolean remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
        return this._copyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public long copyRemoteLayouts(long exportImportConfigurationId) throws PortalException {
        return this.copyRemoteLayouts(this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout) throws PortalException {
        return this.copyRemoteLayouts(sourceGroupId, privateLayout, layoutIdMap, null, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout);
    }

    public long copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, String name, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        Map publishLayoutRemoteSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutRemoteSettingsMap(user.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 2, publishLayoutRemoteSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 2, publishLayoutRemoteSettingsMap);
        return this._copyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public void deleteLastImportSettings(Group liveGroup, boolean privateLayout) throws PortalException {
        List layouts = this._layoutLocalService.getLayouts(liveGroup.getGroupId(), privateLayout);
        for (Layout layout : layouts) {
            UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            HashSet<String> keys = new HashSet<String>();
            for (String key : typeSettingsUnicodeProperties.keySet()) {
                if (!key.startsWith("last-import-")) continue;
                keys.add(key);
            }
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                typeSettingsUnicodeProperties.remove((Object)key);
            }
            this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), typeSettingsUnicodeProperties.toString());
        }
    }

    public void deleteRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid) {
        this.deleteRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid);
    }

    public void deleteRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid) {
        RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
        if (recentLayoutRevision != null) {
            this._recentLayoutRevisionLocalService.deleteRecentLayoutRevision(recentLayoutRevision);
        }
    }

    public JSONArray getErrorMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences) {
        JSONArray errorMessagesJSONArray = this._jsonFactory.createJSONArray();
        for (Map.Entry<String, MissingReference> missingReferenceEntry : missingReferences.entrySet()) {
            MissingReference missingReference = missingReferenceEntry.getValue();
            JSONObject errorMessageJSONObject = this._jsonFactory.createJSONObject();
            String className = missingReference.getClassName();
            Map referrers = missingReference.getReferrers();
            if (className.equals(StagedTheme.class.getName())) {
                errorMessageJSONObject.put("info", this._language.format(locale, "the-referenced-theme-x-is-not-deployed-in-the-current-environment", (Object)missingReference.getClassPK(), false));
            } else if (referrers.size() == 1) {
                Set referrerDisplayNames = referrers.entrySet();
                Iterator iterator = referrerDisplayNames.iterator();
                Map.Entry entry = iterator.next();
                String referrerDisplayName = (String)entry.getKey();
                String referrerClassName = (String)entry.getValue();
                if (referrerClassName.equals(Portlet.class.getName())) {
                    referrerDisplayName = this._portal.getPortletTitle(referrerDisplayName, locale);
                }
                errorMessageJSONObject.put("info", this._language.format(locale, "referenced-by-a-x-x", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, false));
            } else {
                errorMessageJSONObject.put("info", this._language.format(locale, "referenced-by-x-elements", (Object)referrers.size(), true));
            }
            errorMessageJSONObject.put("name", missingReferenceEntry.getKey());
            Group group = this._groupLocalService.fetchGroup(missingReference.getReferenceGroupId());
            if (group != null) {
                errorMessageJSONObject.put("site", this._language.format(locale, "in-environment-x", (Object)group.getName(locale), false));
            }
            errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()));
            errorMessagesJSONArray.put(errorMessageJSONObject);
        }
        return errorMessagesJSONArray;
    }

    public JSONObject getExceptionMessagesJSONObject(Locale locale, Exception exception, ExportImportConfiguration exportImportConfiguration) {
        String errorMessage = "";
        JSONArray errorMessagesJSONArray = null;
        int errorType = 0;
        JSONArray warningMessagesJSONArray = null;
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        Throwable throwable = exception.getCause();
        if (exception.getCause() instanceof ConnectException) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
            String remotePort = MapUtil.getString((Map)settingsMap, (String)"remotePort");
            String argument = remoteAddress + ":" + remotePort;
            errorMessage = this._language.format(resourceBundle, "could-not-connect-to-address-x.-please-verify-that-the-specified-port-is-correct-and-that-the-remote-server-is-configured-to-accept-requests-from-this-server", (Object)argument);
            errorType = 499;
        } else if (exception instanceof DuplicateFileEntryException) {
            errorMessage = this._language.get(locale, "please-enter-a-unique-document-name");
            errorType = 490;
        } else if (exception instanceof ExportImportContentProcessorException) {
            ExportImportContentProcessorException exportImportContentProcessorException = (ExportImportContentProcessorException)exception;
            if (exportImportContentProcessorException.getType() == 2) {
                errorMessage = Validator.isNotNull((String)exportImportContentProcessorException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-process-referenced-article-because-it-cannot-be-found-with-key-x", (Object)String.valueOf(exportImportContentProcessorException.getStagedModelClassPK())) : this._language.get(resourceBundle, "unable-to-process-referenced-article-because-it-cannot-be-found");
            }
            errorType = 499;
        } else if (exception instanceof ExportImportContentValidationException) {
            ExportImportContentValidationException exportImportContentValidationException = (ExportImportContentValidationException)exception;
            errorMessage = exportImportContentValidationException.getType() == 6 ? (throwable != null && throwable.getLocalizedMessage() != null ? this._language.format(resourceBundle, "unable-to-validate-referenced-journal-article-x", (Object)throwable.getLocalizedMessage()) : this._language.get(resourceBundle, "unable-to-validate-referenced-journal-article")) : (exportImportContentValidationException.getType() == 5 ? (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-validate-referenced-file-entry-because-it-cannot-be-found-with-the-following-parameters-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{MapUtil.toString((Map)exportImportContentValidationException.getDlReferenceParameters()), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-referenced-file-entry-because-it-cannot-be-found-with-the-following-parameters-x", (Object)exportImportContentValidationException.getDlReferenceParameters())) : (exportImportContentValidationException.getType() == 7 ? (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-validate-referenced-article-feed-because-it-cannot-be-found-with-url-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{exportImportContentValidationException.getJournalArticleFeedURL(), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-referenced-journal-feed-because-it-cannot-be-found-with-url-x", (Object)exportImportContentValidationException.getJournalArticleFeedURL())) : (exportImportContentValidationException.getType() == 2 ? (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, StringBundler.concat((String[])new String[]{"unable-to-validate-referenced-page-with-url-x-", "because-the-page-group-with-url-x-cannot-be-", "found-within-the-content-of-x-with-primary-key-x"}), (Object[])new String[]{exportImportContentValidationException.getLayoutURL(), exportImportContentValidationException.getGroupFriendlyURL(), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-referenced-page-with-url-x-because-the-page-group-with-url-x-cannot-be-found", (Object[])new String[]{exportImportContentValidationException.getLayoutURL(), exportImportContentValidationException.getGroupFriendlyURL()})) : (exportImportContentValidationException.getType() == 3 ? (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-validate-referenced-page-because-it-cannot-be-found-with-the-following-parameters-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{MapUtil.toString((Map)exportImportContentValidationException.getLayoutReferenceParameters()), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-referenced-page-because-it-cannot-be-found-with-the-following-parameters-x", (Object)exportImportContentValidationException.getLayoutReferenceParameters())) : (exportImportContentValidationException.getType() == 4 ? (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-validate-referenced-page-because-it-cannot-be-found-with-url-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{exportImportContentValidationException.getLayoutURL(), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-referenced-page-because-it-cannot-be-found-with-url-x", (Object)exportImportContentValidationException.getLayoutURL())) : (Validator.isNotNull((String)exportImportContentValidationException.getStagedModelClassName()) ? this._language.format(resourceBundle, "unable-to-validate-content-of-x-with-primary-key-x-in-x", (Object[])new String[]{exportImportContentValidationException.getClassName(), exportImportContentValidationException.getStagedModelClassName(), String.valueOf(exportImportContentValidationException.getStagedModelPrimaryKeyObj())}) : this._language.format(resourceBundle, "unable-to-validate-content-in-x", (Object)exportImportContentValidationException.getClassName())))))));
            errorType = 499;
        } else if (exception instanceof ExportImportDocumentException) {
            ExportImportDocumentException exportImportDocumentException = (ExportImportDocumentException)exception;
            errorMessage = exportImportDocumentException.getType() == 2 ? this._language.format(resourceBundle, "unable-to-parse-xml-document-for-portlet-x-during-import", (Object)exportImportDocumentException.getPortletId()) : (exportImportDocumentException.getType() == 3 ? this._language.format(resourceBundle, "unable-to-parse-xml-portlet-preferences-for-portlet-x-while-importing-portlet-preferences", (Object)exportImportDocumentException.getPortletId()) : this._language.get(resourceBundle, "unable-to-parse-xml-document"));
            errorType = 499;
        } else if (exception instanceof ExportImportIOException || throwable instanceof SystemException && throwable.getCause() instanceof ExportImportIOException) {
            ExportImportIOException exportImportIOException = null;
            exportImportIOException = exception instanceof ExportImportIOException ? (ExportImportIOException)exception : (ExportImportIOException)throwable.getCause();
            errorMessage = exportImportIOException.getType() == 2 ? this._language.format(resourceBundle, "unable-to-add-data-bytes-to-the-lar-file-with-path-x", (Object)exportImportIOException.getFileName()) : (exportImportIOException.getType() == 3 ? this._language.format(resourceBundle, "unable-to-add-data-stream-to-the-lar-file-with-path-x", (Object)exportImportIOException.getFileName()) : (exportImportIOException.getType() == 4 ? this._language.format(resourceBundle, "unable-to-add-data-string-to-the-lar-file-with-path-x", (Object)exportImportIOException.getFileName()) : (exportImportIOException.getType() == 5 ? this._language.format(resourceBundle, "unable-to-process-lar-file-for-layout-import-while-executing-x-due-to-a-file-system-error", (Object)exportImportIOException.getClassName()) : (exportImportIOException.getType() == 6 ? this._language.format(resourceBundle, "unable-to-process-lar-file-x-for-layout-import-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{exportImportIOException.getFileName(), exportImportIOException.getClassName()}) : (exportImportIOException.getType() == 7 ? this._language.format(resourceBundle, "unable-to-process-lar-file-for-layout-import-validation-while-executing-x-due-to-a-file-system-error", (Object)exportImportIOException.getClassName()) : (exportImportIOException.getType() == 8 ? this._language.format(resourceBundle, "unable-to-process-lar-file-x-for-layout-import-validation-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{exportImportIOException.getFileName(), exportImportIOException.getClassName()}) : (exportImportIOException.getType() == 9 ? this._language.format(resourceBundle, "unable-to-create-the-export-lar-manifest-file-for-portlet-x", (Object)exportImportIOException.getPortletId()) : (exportImportIOException.getType() == 10 ? this._language.format(resourceBundle, "unable-to-process-lar-file-for-portlet-import-while-executing-x-due-to-a-file-system-error", (Object)exportImportIOException.getClassName()) : (exportImportIOException.getType() == 11 ? this._language.format(resourceBundle, "unable-to-process-lar-file-x-for-portlet-import-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{exportImportIOException.getFileName(), exportImportIOException.getClassName()}) : (exportImportIOException.getType() == 12 ? this._language.format(resourceBundle, "unable-to-process-lar-file-for-portlet-import-validation-while-executing-x-due-to-a-file-system-error", (Object)exportImportIOException.getClassName()) : (exportImportIOException.getType() == 13 ? this._language.format(resourceBundle, "unable-to-process-lar-file-x-for-portlet-import-validation-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{exportImportIOException.getFileName(), exportImportIOException.getClassName()}) : (exportImportIOException.getType() == 14 ? this._language.format(resourceBundle, "unable-to-complete-remote-staging-publication-request-x-due-to-a-file-system-error", (Object)exportImportIOException.getStagingRequestId()) : (exportImportIOException.getType() == 15 ? this._language.format(resourceBundle, "unable-to-process-lar-file-pieces-for-remote-staging-publication-because-lar-file-checksum-is-not-x", (Object)exportImportIOException.getChecksum()) : (exportImportIOException.getType() == 16 ? this._language.format(resourceBundle, "unable-to-reassemble-lar-file-for-remote-staging-publication-request-x", (Object)exportImportIOException.getStagingRequestId()) : this._language.format(resourceBundle, "x-failed-due-to-a-file-system-error", (Object)exportImportIOException.getClassName())))))))))))))));
            errorType = 499;
        } else if (exception instanceof ExportImportRuntimeException) {
            _log.error((Throwable)exception);
            ExportImportRuntimeException exportImportRuntimeException = (ExportImportRuntimeException)exception;
            errorMessage = Validator.isNull((String)exportImportRuntimeException.getMessage()) ? this._language.format(resourceBundle, "an-unexpected-error-occurred-within-x", (Object)exportImportRuntimeException.getClassName()) : this._language.format(resourceBundle, "the-following-error-occurred-within-x-x", (Object[])new String[]{exportImportRuntimeException.getClassName(), exportImportRuntimeException.getMessage()});
            errorType = 499;
        } else if (exception instanceof FileExtensionException) {
            errorMessage = this._language.format(locale, "document-names-must-end-with-one-of-the-following-extensions", (Object)".lar", false);
            errorType = 491;
        } else if (exception instanceof FileNameException) {
            errorMessage = this._language.get(locale, "please-enter-a-file-with-a-valid-file-name");
            errorType = 492;
        } else if (exception instanceof FileSizeException || exception instanceof LARFileSizeException) {
            if (exportImportConfiguration != null && (exportImportConfiguration.getType() == 1 || exportImportConfiguration.getType() == 2 || exportImportConfiguration.getType() == 8 || exportImportConfiguration.getType() != 9)) {
                errorMessage = this._language.get(locale, "file-size-limit-exceeded.-please-ensure-that-the-file-does-not-exceed-the-file-size-limit-in-both-the-live-environment-and-the-staging-environment");
            } else {
                long maxSize = this._dlValidator.getMaxAllowableSize(exportImportConfiguration.getGroupId(), null);
                if (exception instanceof FileSizeException) {
                    FileSizeException fileSizeException = (FileSizeException)exception;
                    maxSize = fileSizeException.getMaxSize();
                }
                errorMessage = this._language.format(locale, "please-enter-a-file-with-a-valid-file-size-no-larger-than-x", (Object)this._language.formatStorageSize((double)maxSize, locale), false);
            }
            errorType = 493;
        } else if (exception instanceof LARTypeException) {
            LARTypeException larTypeException = (LARTypeException)exception;
            errorMessage = larTypeException.getType() == 5 ? this._language.format(resourceBundle, "a-x-can-only-be-imported-to-a-x", (Object)"global-site") : (larTypeException.getType() == 1 ? this._language.format(resourceBundle, "a-x-can-only-be-imported-to-a-x", (Object)this._language.get(locale, "page-template")) : (larTypeException.getType() == 2 ? this._language.format(resourceBundle, "a-x-can-only-be-imported-to-a-x", (Object)"site") : (larTypeException.getType() == 3 ? this._language.format(resourceBundle, "a-x-can-only-be-imported-to-a-x", (Object)this._language.get(locale, "site-template")) : this._language.format(resourceBundle, "uploaded-lar-file-type-x-does-not-match-x", new Object[]{larTypeException.getActualLARType(), StringUtil.merge((Object[])larTypeException.getExpectedLARTypes(), (String)", ")}))));
            errorType = 499;
        } else if (exception instanceof LARFileException) {
            LARFileException larFileException = (LARFileException)exception;
            errorMessage = larFileException.getType() == 2 ? this._language.format(resourceBundle, "invalid-manifest.xml-x", (Object)larFileException.getMessage()) : (larFileException.getType() == 1 ? this._language.get(resourceBundle, "missing-manifest.xml") : this._language.get(locale, "please-specify-a-lar-file-to-import"));
            errorType = 499;
        } else if (exception instanceof LayoutImportException || throwable instanceof LayoutImportException) {
            LayoutImportException layoutImportException = null;
            layoutImportException = exception instanceof LayoutImportException ? (LayoutImportException)exception : (LayoutImportException)throwable;
            if (layoutImportException.getType() == 1) {
                errorMessage = this._language.format(resourceBundle, "lar-build-number-x-does-not-match-portal-build-number-x", layoutImportException.getArguments());
            } else if (layoutImportException.getType() == 2) {
                errorMessage = this._language.format(resourceBundle, "lar-schema-version-x-does-not-match-deployed-export-import-schema-version-x", layoutImportException.getArguments());
            } else if (layoutImportException.getType() == 3) {
                Object[] arguments = layoutImportException.getArguments();
                Portlet portlet = this._portletLocalService.getPortletById((String)arguments[1]);
                arguments[1] = portlet.getDisplayName();
                errorMessage = this._language.format(resourceBundle, "applications's-schema-version-x-in-the-lar-is-not-valid-for-the-deployed-application-x-with-schema-version-x", layoutImportException.getArguments());
            } else {
                errorMessage = exception.getLocalizedMessage();
            }
            errorType = 499;
        } else if (exception instanceof LayoutPrototypeException) {
            LayoutPrototypeException layoutPrototypeException = (LayoutPrototypeException)exception;
            errorMessage = this._language.get(resourceBundle, StringBundler.concat((String[])new String[]{"the-lar-file-could-not-be-imported-because-it-requires-", "page-templates-or-site-templates-that-could-not-be-", "found.-please-import-the-following-templates-manually"}));
            errorMessagesJSONArray = this._jsonFactory.createJSONArray();
            List missingLayoutPrototypes = layoutPrototypeException.getMissingLayoutPrototypes();
            for (Tuple missingLayoutPrototype : missingLayoutPrototypes) {
                errorMessagesJSONArray.put(JSONUtil.put((String)"info", (Object)((String)missingLayoutPrototype.getObject(1))).put("name", (String)missingLayoutPrototype.getObject(2)).put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)((String)missingLayoutPrototype.getObject(0)))));
            }
            errorType = 499;
        } else if (exception instanceof LocaleException) {
            LocaleException localeException = (LocaleException)exception;
            errorMessage = this._language.format(locale, "the-available-languages-in-the-lar-file-x-do-not-match-the-site's-available-languages-x", (Object[])new String[]{StringUtil.merge((Collection)localeException.getSourceAvailableLanguageIds(), (String)", "), StringUtil.merge((Collection)localeException.getTargetAvailableLanguageIds(), (String)", ")}, false);
            errorType = 499;
        } else if (exception instanceof MissingReferenceException) {
            MissingReferenceException missingReferenceException = (MissingReferenceException)exception;
            errorMessage = exportImportConfiguration != null && (exportImportConfiguration.getType() == 1 || exportImportConfiguration.getType() == 2 || exportImportConfiguration.getType() == 8 || exportImportConfiguration.getType() != 9) ? this._language.get(locale, "there-are-missing-references-that-could-not-be-found-in-the-live-environment-the-following-elements-are-published-from-their-own-environment") : this._language.get(locale, "there-are-missing-references-that-could-not-be-found-in-the-current-environment");
            MissingReferences missingReferences = missingReferenceException.getMissingReferences();
            errorMessagesJSONArray = this.getErrorMessagesJSONArray(locale, missingReferences.getDependencyMissingReferences());
            errorType = 499;
            warningMessagesJSONArray = this.getWarningMessagesJSONArray(locale, missingReferences.getWeakMissingReferences());
        } else if (exception instanceof PortletDataException) {
            PortletDataException portletDataException = (PortletDataException)exception;
            String referrerClassName = portletDataException.getStagedModelClassName();
            String referrerDisplayName = portletDataException.getStagedModelDisplayName();
            String modelResource = ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName);
            if (portletDataException.getType() == 25) {
                errorMessage = this._language.format(resourceBundle, "unable-to-create-a-portlet-data-context-for-company-x-because-it-is-being-deleted", (Object)String.valueOf(portletDataException.getCompanyId()));
            } else if (portletDataException.getType() == 10) {
                errorMessage = Validator.isNotNull((String)portletDataException.getLocalizedMessage()) ? this._language.format(locale, "the-following-error-in-x-while-deleting-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale), portletDataException.getLocalizedMessage()}, false) : this._language.format(locale, "an-unexpected-error-in-x-while-deleting-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale)}, false);
            } else if (portletDataException.getType() == 15) {
                errorMessage = this._language.format(resourceBundle, "unable-to-return-the-export-data-group-element-for-group-x-because-the-root-data-element-is-not-initialized", (Object)portletDataException.getStagedModelClassName());
            } else if (portletDataException.getType() == 11) {
                errorMessage = Validator.isNotNull((String)portletDataException.getLocalizedMessage()) ? this._language.format(locale, "the-following-error-in-x-while-exporting-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale), portletDataException.getLocalizedMessage()}, false) : this._language.format(locale, "an-unexpected-error-in-x-while-exporting-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale)}, false);
            } else if (portletDataException.getType() == 18) {
                errorMessage = this._language.format(resourceBundle, "unable-to-export-portlet-permissions-for-x-while-processing-portlet-preferences-during-export", (Object)portletDataException.getPortletId());
            } else if (portletDataException.getType() == 19) {
                errorMessage = this._language.format(resourceBundle, "unable-to-export-referenced-article-template-for-x-while-processing-portlet-preferences-during-export", (Object)portletDataException.getPortletId());
            } else if (portletDataException.getType() == 23) {
                String localizedMessage = portletDataException.getLocalizedMessage();
                if (portletDataException.getCause() instanceof ExportImportRuntimeException && Validator.isNull((String)portletDataException.getMessage())) {
                    ExportImportRuntimeException exportImportRuntimeException = (ExportImportRuntimeException)portletDataException.getCause();
                    localizedMessage = this._language.format(resourceBundle, exportImportRuntimeException.getMessageKey(), (Object[])exportImportRuntimeException.getData());
                }
                errorMessage = this._language.format(resourceBundle, "the-x-x-could-not-be-exported-because-of-the-following-error-x", (Object[])new String[]{modelResource, referrerDisplayName, localizedMessage}, false);
            } else {
                errorMessage = portletDataException.getType() == 16 ? this._language.format(resourceBundle, "unable-to-return-the-import-data-group-element-for-group-x-because-the-root-data-element-is-not-initialized", (Object)portletDataException.getStagedModelClassName()) : (portletDataException.getType() == 12 ? (Validator.isNotNull((String)portletDataException.getLocalizedMessage()) ? this._language.format(locale, "the-following-error-in-x-while-importing-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale), portletDataException.getLocalizedMessage()}, false) : this._language.format(locale, "an-unexpected-error-in-x-while-importing-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale)}, false)) : (portletDataException.getType() == 20 ? this._language.format(resourceBundle, "unable-to-import-portlet-permissions-for-x-while-processing-portlet-preferences-during-import", (Object)portletDataException.getPortletId()) : (portletDataException.getType() == 24 ? this._language.format(resourceBundle, "the-x-x-could-not-be-imported-because-of-the-following-error-x", (Object[])new String[]{modelResource, referrerDisplayName, portletDataException.getLocalizedMessage()}, false) : (portletDataException.getType() == 4 ? this._language.format(locale, "the-x-x-could-not-be-exported-because-it-is-not-in-the-currently-exported-group", (Object[])new String[]{modelResource, referrerDisplayName}, false) : (portletDataException.getType() == 5 ? this._language.format(locale, "the-x-x-has-missing-references-that-could-not-be-found-during-the-process", (Object[])new String[]{modelResource, referrerDisplayName}, false) : (portletDataException.getType() == 14 ? this._language.format(locale, "the-x-x-missing-reference-could-not-be-found-during-the-process", (Object[])new String[]{modelResource, referrerDisplayName}, false) : (portletDataException.getType() == 13 ? (Validator.isNotNull((String)portletDataException.getLocalizedMessage()) ? this._language.format(locale, "the-following-error-in-x-while-preparing-its-manifest-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale), portletDataException.getLocalizedMessage()}, false) : this._language.format(locale, "an-unexpected-error-in-x-while-preparing-its-manifest-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(portletDataException.getPortletId(), locale)}, false)) : (portletDataException.getType() == 8 ? this._language.format(locale, "the-x-x-could-not-be-exported-because-it-is-in-the-recycle-bin", (Object[])new String[]{modelResource, referrerDisplayName}, false) : (portletDataException.getType() == 9 ? this._language.format(locale, "the-x-x-could-not-be-exported-because-its-workflow-status-is-not-exportable", (Object[])new String[]{modelResource, referrerDisplayName}, false) : (portletDataException.getType() == 21 ? this._language.format(resourceBundle, "unable-to-update-journal-content-search-data-for-x-while-processing-portlet-preferences-during-import", (Object)portletDataException.getPortletId()) : (portletDataException.getType() == 22 ? this._language.format(resourceBundle, "unable-to-update-portlet-preferences-for-x-during-import", (Object)portletDataException.getPortletId()) : (Validator.isNotNull((String)referrerDisplayName) ? this._language.format(resourceBundle, "the-following-error-occurred-while-processing-the-x-x-x", (Object[])new String[]{modelResource, referrerDisplayName, exception.getLocalizedMessage()}) : exception.getLocalizedMessage()))))))))))));
            }
            errorType = 499;
        } else if (exception instanceof PortletIdException) {
            PortletIdException portletIdException = (PortletIdException)exception;
            Portlet portlet = this._portletLocalService.getPortletById(portletIdException.getMessage());
            errorMessage = this._language.format(resourceBundle, "a-x-can-only-be-imported-to-a-x", (Object)(portlet.getDisplayName() + " Portlet"));
            errorType = 499;
        } else if (exception instanceof UploadRequestSizeException) {
            errorMessage = this._language.format(resourceBundle, "upload-request-reached-the-maximum-permitted-size-of-x-bytes", (Object)String.valueOf(UploadServletRequestConfigurationProviderUtil.getMaxSize()));
            errorType = 493;
        } else {
            errorMessage = exception.getLocalizedMessage();
            errorType = 499;
        }
        JSONObject exceptionMessagesJSONObject = JSONUtil.put((String)"message", (Object)errorMessage);
        if (errorMessagesJSONArray != null && errorMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("messageListItems", errorMessagesJSONArray);
        }
        exceptionMessagesJSONObject.put("status", errorType);
        if (warningMessagesJSONArray != null && warningMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("warningMessages", warningMessagesJSONArray);
        }
        return exceptionMessagesJSONObject;
    }

    public Group getLiveGroup(Group group) {
        if (group == null) {
            return null;
        }
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public Group getLiveGroup(long groupId) {
        if (groupId <= 0L) {
            return null;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public long getLiveGroupId(long groupId) {
        Group group = this.getLiveGroup(groupId);
        if (group == null) {
            return groupId;
        }
        return group.getGroupId();
    }

    public Group getPermissionStagingGroup(Group group) {
        Group stagingGroup;
        block5: {
            if (group == null) {
                return null;
            }
            stagingGroup = group;
            if (!group.isStagedRemotely() && group.hasStagingGroup()) {
                try {
                    PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                    long scopeGroupId = stagingGroup.getGroupId();
                    boolean hasManageStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"MANAGE_STAGING");
                    boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"PUBLISH_STAGING");
                    boolean hasViewStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"VIEW_STAGING");
                    if (hasManageStagingPermission || hasPublishStagingPermission || hasViewStagingPermission) {
                        stagingGroup = group.getStagingGroup();
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)exception);
                }
            }
        }
        return stagingGroup;
    }

    public long getRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid) throws PortalException {
        return this.getRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid);
    }

    public long getRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) throws PortalException {
        return this.getRecentLayoutRevisionId(user.getUserId(), layoutSetBranchId, plid);
    }

    public long getRecentLayoutSetBranchId(HttpServletRequest httpServletRequest, long layoutSetId) {
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(this._portal.getUserId(httpServletRequest), layoutSetId);
        if (recentLayoutSetBranch != null) {
            return recentLayoutSetBranch.getLayoutSetBranchId();
        }
        return 0L;
    }

    public long getRecentLayoutSetBranchId(User user, long layoutSetId) {
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(user.getUserId(), layoutSetId);
        if (recentLayoutSetBranch != null) {
            return recentLayoutSetBranch.getLayoutSetBranchId();
        }
        return 0L;
    }

    public Layout getRemoteLayout(long userId, long stagingGroupId, long plid) throws PortalException {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            Layout layout2 = LayoutServiceHttp.getLayoutByUuidAndGroupId((HttpPrincipal)httpPrincipal, (String)layout.getUuid(), (long)stagingGroup.getRemoteLiveGroupId(), (boolean)layout.isPrivateLayout());
            return layout2;
        }
    }

    public long getRemoteLayoutPlid(long userId, long stagingGroupId, long plid) throws PortalException {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        return LayoutServiceHttp.fetchLayoutPlid((HttpPrincipal)httpPrincipal, (String)layout.getUuid(), (long)stagingGroup.getRemoteLiveGroupId(), (boolean)layout.isPrivateLayout());
    }

    public String getRemoteSiteURL(Group stagingGroup, boolean privateLayout) throws PortalException {
        UnicodeProperties typeSettingsUnicodeProperties;
        boolean overrideRemoteSiteURL;
        if (!stagingGroup.isStagedRemotely()) {
            return "";
        }
        if (stagingGroup.isLayout()) {
            stagingGroup = stagingGroup.getParentGroup();
        }
        if (overrideRemoteSiteURL = GetterUtil.getBoolean((String)(typeSettingsUnicodeProperties = stagingGroup.getTypeSettingsProperties()).getProperty("overrideRemoteSiteURL"))) {
            return GetterUtil.getString((String)typeSettingsUnicodeProperties.getProperty("remoteSiteURL"));
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(typeSettingsUnicodeProperties), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        long remoteGroupId = GetterUtil.getLong((String)typeSettingsUnicodeProperties.getProperty("remoteGroupId"));
        boolean secureConnection = GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("secureConnection"));
        String groupDisplayURL = StagingGroupServiceTunnelUtil.getGroupDisplayURL(httpPrincipal, remoteGroupId, privateLayout, secureConnection);
        try {
            URL remoteSiteURL = new URL(groupDisplayURL);
            if (!this._isStagingUseVirtualHostForRemoteSite()) {
                String remoteAddress = typeSettingsUnicodeProperties.getProperty("remoteAddress");
                remoteSiteURL = new URL(remoteSiteURL.getProtocol(), remoteAddress, remoteSiteURL.getPort(), remoteSiteURL.getFile());
            }
            return remoteSiteURL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new PortalException((Throwable)malformedURLException);
        }
    }

    public String getSchedulerGroupName(String destinationName, long groupId) {
        return StringBundler.concat((Object[])new Object[]{destinationName, "/", groupId});
    }

    public String getStagedPortletId(String portletId) {
        String key = portletId;
        if (key.startsWith("staged-portlet_")) {
            return key;
        }
        return "staged-portlet_".concat(portletId);
    }

    public long[] getStagingAndLiveGroupIds(long groupId) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new long[]{groupId, 0L};
        }
        Group stagingGroup = group.getStagingGroup();
        if (stagingGroup != null) {
            return new long[]{stagingGroup.getGroupId(), groupId};
        }
        Group liveGroup = group.getLiveGroup();
        if (liveGroup != null) {
            return new long[]{groupId, liveGroup.getGroupId()};
        }
        return new long[]{groupId, 0L};
    }

    public Group getStagingGroup(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        Group stagingGroup = group;
        if (!group.isStagedRemotely() && group.hasStagingGroup()) {
            stagingGroup = group.getStagingGroup();
        }
        return stagingGroup;
    }

    public JSONArray getWarningMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences) {
        JSONArray warningMessagesJSONArray = this._jsonFactory.createJSONArray();
        for (Map.Entry<String, MissingReference> entry : missingReferences.entrySet()) {
            MissingReference missingReference = entry.getValue();
            warningMessagesJSONArray.put(JSONUtil.put((String)"info", () -> {
                if (Validator.isNotNull((String)missingReference.getClassName())) {
                    return this._language.format(locale, "the-original-x-does-not-exist-in-the-current-environment", (Object)ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()), false);
                }
                return null;
            }).put("size", () -> {
                Map referrers = missingReference.getReferrers();
                return referrers.size();
            }).put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)entry.getKey())));
        }
        return warningMessagesJSONArray;
    }

    public WorkflowTask getWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this._workflowInstanceLinkLocalService.fetchWorkflowInstanceLink(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), LayoutRevision.class.getName(), layoutRevision.getLayoutRevisionId());
        if (workflowInstanceLink == null) {
            return null;
        }
        List workflowTasks = WorkflowTaskManagerUtil.getWorkflowTasksByWorkflowInstance((long)layoutRevision.getCompanyId(), (Long)userId, (long)workflowInstanceLink.getWorkflowInstanceId(), (Boolean)false, (int)0, (int)1, null);
        if (!workflowTasks.isEmpty()) {
            return (WorkflowTask)workflowTasks.get(0);
        }
        return null;
    }

    public boolean hasRemoteLayout(long userId, long stagingGroupId, long plid) throws PortalException {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        return LayoutServiceHttp.hasLayout((HttpPrincipal)httpPrincipal, (String)layout.getUuid(), (long)stagingGroup.getRemoteLiveGroupId(), (boolean)layout.isPrivateLayout());
    }

    public boolean hasWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowTask workflowTask = this.getWorkflowTask(userId, layoutRevision);
        return workflowTask != null;
    }

    public boolean isGroupAccessible(Group group, Group fromGroup) {
        if (fromGroup == null) {
            block6: {
                long companyId = group.getCompanyId();
                try {
                    Company company = this._companyLocalService.getCompany(companyId);
                    Group companyGroup = company.getGroup();
                    if (group.equals(companyGroup)) {
                        return true;
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Company group does not exist", (Throwable)portalException);
                }
            }
            return false;
        }
        if (group.equals(fromGroup)) {
            return true;
        }
        if (group.isStaged() && !group.isStagedRemotely() && group.isStagingGroup()) {
            return false;
        }
        return !group.hasStagingGroup() || !fromGroup.equals(group.getStagingGroup());
    }

    public boolean isGroupAccessible(long groupId, long fromGroupId) throws PortalException {
        return this.isGroupAccessible(this._groupLocalService.getGroup(groupId), this._groupLocalService.getGroup(fromGroupId));
    }

    public boolean isIncomplete(Layout layout) {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        return layoutRevision != null && this._isLayoutRevisionIncomplete(layout.getPlid(), layoutRevision, layoutRevision.getLayoutSetBranchId());
    }

    public boolean isIncomplete(Layout layout, long layoutSetBranchId) {
        return this._isLayoutRevisionIncomplete(layout.getPlid(), LayoutStagingUtil.getLayoutRevision((Layout)layout), layoutSetBranchId);
    }

    public boolean isRemoteLayoutHasPortletId(long userId, long stagingGroupId, long plid, String portletId) {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        try {
            HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            return LayoutServiceHttp.hasPortletId((HttpPrincipal)httpPrincipal, (long)plid, (String)portletId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to determine if remote layout ", plid, " contains portlet ", portletId}), (Throwable)portalException);
            }
            return false;
        }
    }

    public void populateLastPublishDateCounts(PortletDataContext portletDataContext, StagedModelType[] stagedModelTypes) throws PortalException {
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(portletDataContext.getScopeGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        for (StagedModelType stagedModelType : stagedModelTypes) {
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (modelAdditionCount > -1L) continue;
            if (changesetCollection != null) {
                if (stagedModelType.getReferrerClassName() == null) {
                    modelAdditionCount = this._changesetEntryLocalService.getChangesetEntriesCount(changesetCollection.getChangesetCollectionId(), stagedModelType.getClassNameId());
                } else {
                    StagedModelRepository stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)stagedModelType.getClassName());
                    if (stagedModelRepository != null) {
                        List changesetEntries = this._changesetEntryLocalService.getChangesetEntries(changesetCollection.getChangesetCollectionId(), stagedModelType.getClassNameId());
                        modelAdditionCount = 0L;
                        for (ChangesetEntry changesetEntry : changesetEntries) {
                            TypedModel typedModel;
                            StagedModel stagedModel = stagedModelRepository.getStagedModel(changesetEntry.getClassPK());
                            if (!(stagedModel instanceof TypedModel) || !Objects.equals((typedModel = (TypedModel)stagedModel).getClassName(), stagedModelType.getReferrerClassName())) continue;
                            ++modelAdditionCount;
                        }
                    }
                }
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
            }
            long modelDeletionCount = this._exportImportHelper.getModelDeletionCount(portletDataContext, stagedModelType);
            manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
        }
    }

    public void populateLastPublishDateCounts(PortletDataContext portletDataContext, String[] classNames) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return;
        }
        StagedModelType[] stagedModelTypes = new StagedModelType[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            stagedModelTypes[i] = new StagedModelType(classNames[i]);
        }
        this.populateLastPublishDateCounts(portletDataContext, stagedModelTypes);
    }

    public long publishLayout(long userId, long plid, long liveGroupId, boolean includeChildren) throws PortalException {
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = this._layoutLocalService.getLayout(plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        List parentLayouts = this._exportImportHelper.getMissingParentLayouts(layout, liveGroupId);
        layouts.addAll(parentLayouts);
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        return this.publishLayouts(userId, layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), this._exportImportHelper.getLayoutIds(layouts), parameterMap);
    }

    public long publishLayouts(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        this._checkPermission(exportImportConfiguration);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String backgroundTaskName = MapUtil.getString((Map)parameterMap, (String)"name", (String)exportImportConfiguration.getName());
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), backgroundTaskName, "com.liferay.exportimport.internal.background.task.LayoutStagingBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).put((Object)"privateLayout", (Object)MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout")).build(), new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long publishLayouts(long userId, long exportImportConfigurationId) throws PortalException {
        return this.publishLayouts(userId, this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap) throws PortalException {
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, null, parameterMap);
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, String name, Map<String, String[]> parameterMap) throws PortalException {
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        Map publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(this._userLocalService.getUser(userId), sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(userId, exportImportConfiguration);
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        List sourceGroupLayouts = this._layoutLocalService.getLayouts(sourceGroupId, privateLayout);
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, this._exportImportHelper.getLayoutIds(sourceGroupLayouts), parameterMap);
    }

    public long publishPortlet(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        HashMap taskContextMap = HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build();
        String backgroundTaskExecutor = "com.liferay.exportimport.internal.background.task.PortletStagingBackgroundTaskExecutor";
        if (exportImportConfiguration.getType() == 9) {
            backgroundTaskExecutor = "com.liferay.exportimport.internal.background.task.PortletRemoteStagingBackgroundTaskExecutor";
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            HashMap parameterMap = (HashMap)settingsMap.get("parameterMap");
            long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
            Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
            UnicodeProperties typeSettingsUnicodeProperties = sourceGroup.getTypeSettingsProperties();
            String remoteAddress = MapUtil.getString((Map)parameterMap, (String)"remoteAddress", (String)typeSettingsUnicodeProperties.getProperty("remoteAddress"));
            int remotePort = MapUtil.getInteger((Map)parameterMap, (String)"remotePort", (int)GetterUtil.getInteger((String)typeSettingsUnicodeProperties.getProperty("remotePort")));
            String remotePathContext = MapUtil.getString((Map)parameterMap, (String)"remotePathContext", (String)typeSettingsUnicodeProperties.getProperty("remotePathContext"));
            boolean secureConnection = MapUtil.getBoolean((Map)parameterMap, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("secureConnection")));
            this._groupLocalService.validateRemote(sourceGroupId, remoteAddress, remotePort, remotePathContext, secureConnection, sourceGroup.getRemoteLiveGroupId());
            String remoteURL = this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            taskContextMap.put("httpPrincipal", httpPrincipal);
        }
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), backgroundTaskExecutor, (Map)taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long publishPortlet(long userId, long exportImportConfigurationId) throws PortalException {
        return this.publishPortlet(userId, this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long publishPortlet(long userId, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Map publishPortletSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishPortletSettingsMap(userId, sourceGroupId, sourcePlid, targetGroupId, targetPlid, portletId, parameterMap, user.getLocale(), user.getTimeZone());
        Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
        int type = 8;
        if (sourceGroup.isStagedRemotely()) {
            type = 9;
        }
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, type, publishPortletSettingsMap);
        return this.publishPortlet(userId, exportImportConfiguration);
    }

    public long publishToLive(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group targetGroup = this.getLiveGroup(groupId);
        if (!targetGroup.isStaged()) {
            return 0L;
        }
        if (targetGroup.isStagedRemotely()) {
            return this.publishToRemote(portletRequest);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        Map publishLayoutLocalSettingsMap = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            publishLayoutLocalSettingsMap = exportImportConfiguration.getSettingsMap();
            Map parameterMap = (Map)publishLayoutLocalSettingsMap.get("parameterMap");
            parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
            if (!Validator.isBlank((String)name)) {
                parameterMap.put("name", new String[]{name});
            }
        }
        if (publishLayoutLocalSettingsMap == null) {
            Group sourceGroup = targetGroup.getStagingGroup();
            long sourceGroupId = sourceGroup.getGroupId();
            long targetGroupId = targetGroup.getGroupId();
            boolean privateLayout = this._isPrivateLayout(portletRequest);
            long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
            Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
            publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(user, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        }
        exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(user.getUserId(), exportImportConfiguration);
    }

    public long publishToLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = this._portal.getScopeGroupId(this._portal.getHttpServletRequest(portletRequest), portlet.getPortletId());
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        return this.publishPortlet(themeDisplay.getUserId(), scopeGroupId, plid, portlet.getPortletId(), parameterMap, false);
    }

    public long publishToRemote(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties groupTypeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsUnicodeProperties.getProperty("remoteGroupId")));
        Map publishLayoutRemoteSettingsMap = null;
        String remoteAddress = null;
        int remotePort = 0;
        String remotePathContext = null;
        boolean secureConnection = false;
        boolean remotePrivateLayout = false;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            publishLayoutRemoteSettingsMap = exportImportConfiguration.getSettingsMap();
            remoteAddress = MapUtil.getString((Map)publishLayoutRemoteSettingsMap, (String)"remoteAddress");
            remotePort = MapUtil.getInteger((Map)publishLayoutRemoteSettingsMap, (String)"remotePort");
            remotePathContext = MapUtil.getString((Map)publishLayoutRemoteSettingsMap, (String)"remotePathContext");
            secureConnection = MapUtil.getBoolean((Map)publishLayoutRemoteSettingsMap, (String)"secureConnection");
            remoteGroupId = MapUtil.getLong((Map)publishLayoutRemoteSettingsMap, (String)"targetGroupId");
            remotePrivateLayout = MapUtil.getBoolean((Map)publishLayoutRemoteSettingsMap, (String)"remotePrivateLayout");
            if (!Validator.isBlank((String)name)) {
                Map parameterMap = (Map)publishLayoutRemoteSettingsMap.get("parameterMap");
                parameterMap.put("name", new String[]{name});
            }
        }
        if (publishLayoutRemoteSettingsMap == null) {
            Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsUnicodeProperties.getProperty("remoteAddress"));
            remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsUnicodeProperties.getProperty("remotePort")));
            remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsUnicodeProperties.getProperty("remotePathContext"));
            secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsUnicodeProperties.getProperty("secureConnection")));
            remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
            publishLayoutRemoteSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutRemoteSettingsMap(user.getUserId(), groupId, this._isPrivateLayout(portletRequest), this._exportImportHelper.getLayoutIdMap(portletRequest), parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
        }
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 2, publishLayoutRemoteSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 2, publishLayoutRemoteSettingsMap);
        return this._copyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public <T extends BaseModel> void removeModelFromChangesetCollection(T model) throws PortalException {
        if (!(model instanceof StagedGroupedModel)) {
            return;
        }
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)model;
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(stagedGroupedModel.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        if (changesetCollection == null) {
            return;
        }
        long classPK = (Long)stagedGroupedModel.getPrimaryKeyObj();
        ChangesetEntry changesetEntry = this._changesetEntryLocalService.fetchChangesetEntry(changesetCollection.getChangesetCollectionId(), this._classNameLocalService.getClassNameId(stagedGroupedModel.getModelClassName()), classPK);
        if (changesetEntry == null) {
            return;
        }
        this._changesetEntryLocalService.deleteChangesetEntry(changesetEntry.getChangesetEntryId());
    }

    public void scheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long targetGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group targetGroup = this._groupLocalService.getGroup(targetGroupId);
        long sourceGroupId = targetGroup.getLiveGroupId();
        long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        ScheduleInformation scheduleInformation = this._getScheduleInformation(portletRequest, targetGroupId, false);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        this._layoutService.schedulePublishToLive(sourceGroupId, targetGroupId, this._isPrivateLayout(portletRequest), layoutIds, parameterMap, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void schedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long sourceGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
        long targetGroupId = sourceGroup.getLiveGroupId();
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        Map parameterMap = null;
        boolean privateLayout = false;
        long[] layoutIds = null;
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            parameterMap = (Map)settingsMap.get("parameterMap");
            privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
            parameterMap.put("timeZoneId", ParamUtil.getParameterValues((PortletRequest)portletRequest, (String)"timeZoneId"));
        }
        if (parameterMap == null) {
            privateLayout = this._isPrivateLayout(portletRequest);
            layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
            parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        }
        ScheduleInformation scheduleInformation = this._getScheduleInformation(portletRequest, targetGroupId, false);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (!Validator.isBlank((String)name)) {
            parameterMap.put("name", new String[]{name});
        }
        this._layoutService.schedulePublishToLive(sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void schedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties groupTypeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        boolean privateLayout = false;
        Map layoutIdMap = null;
        Map parameterMap = null;
        String remoteAddress = null;
        int remotePort = 0;
        String remotePathContext = null;
        boolean secureConnection = false;
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsUnicodeProperties.getProperty("remoteGroupId")));
        boolean remotePrivateLayout = false;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            layoutIdMap = (Map)settingsMap.get("layoutIdMap");
            parameterMap = (Map)settingsMap.get("parameterMap");
            remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
            remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
            remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
            secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
            remoteGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
            parameterMap.put("timeZoneId", ParamUtil.getParameterValues((PortletRequest)portletRequest, (String)"timeZoneId"));
        }
        if (parameterMap == null) {
            privateLayout = this._isPrivateLayout(portletRequest);
            layoutIdMap = this._exportImportHelper.getLayoutIdMap(portletRequest);
            parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsUnicodeProperties.getProperty("remoteAddress"));
            remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsUnicodeProperties.getProperty("remotePort")));
            remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsUnicodeProperties.getProperty("remotePathContext"));
            secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsUnicodeProperties.getProperty("secureConnection")));
            remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        }
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        ScheduleInformation scheduleInformation = this._getScheduleInformation(portletRequest, groupId, true);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (!Validator.isBlank((String)name)) {
            parameterMap.put("name", new String[]{name});
        }
        this._layoutService.schedulePublishToRemote(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, null, null, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void setRecentLayoutBranchId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        this.setRecentLayoutBranchId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutBranchId(User user, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        this.setRecentLayoutBranchId(user.getUserId(), layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        this.setRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        this.setRecentLayoutRevisionId(user.getUserId(), layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutSetBranchId(HttpServletRequest httpServletRequest, long layoutSetId, long layoutSetBranchId) throws PortalException {
        this.setRecentLayoutSetBranchId(this._portal.getUserId(httpServletRequest), layoutSetId, layoutSetBranchId);
    }

    public void setRecentLayoutSetBranchId(User user, long layoutSetId, long layoutSetBranchId) throws PortalException {
        this.setRecentLayoutSetBranchId(user.getUserId(), layoutSetId, layoutSetBranchId);
    }

    public void setRemoteSiteURL(Group stagingGroup, boolean overrideRemoteSiteURL, String remoteSiteURL) throws PortalException {
        UnicodeProperties typeSettingsUnicodeProperties = stagingGroup.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("overrideRemoteSiteURL", String.valueOf(overrideRemoteSiteURL));
        if (overrideRemoteSiteURL) {
            typeSettingsUnicodeProperties.setProperty("remoteSiteURL", String.valueOf(remoteSiteURL));
        } else {
            typeSettingsUnicodeProperties.setProperty("remoteSiteURL", "");
        }
        this._groupLocalService.updateGroup(stagingGroup.getGroupId(), typeSettingsUnicodeProperties.toString());
    }

    public String stripProtocolFromRemoteAddress(String remoteAddress) {
        if (remoteAddress.startsWith("http://")) {
            remoteAddress = remoteAddress.substring("http://".length());
        } else if (remoteAddress.startsWith("https://")) {
            remoteAddress = remoteAddress.substring("https://".length());
        }
        return remoteAddress;
    }

    public void transferFileToRemoteLive(File file, long stagingRequestId, HttpPrincipal httpPrincipal) throws Exception {
        byte[] bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
        int i = 0;
        int j = 0;
        String numberString = String.valueOf((int)(file.length() / (long)bytes.length));
        String numberFormat = String.format("%%0%dd", numberString.length() + 1);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            while ((i = fileInputStream.read(bytes)) >= 0) {
                String fileName = file.getName() + String.format(numberFormat, j++);
                if (i < PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE) {
                    byte[] tempBytes = new byte[i];
                    System.arraycopy(bytes, 0, tempBytes, 0, i);
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])tempBytes);
                } else {
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])bytes);
                }
                bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
            }
        }
    }

    public void unscheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        this._layoutService.unschedulePublishToLive(stagingGroupId, jobName, groupName);
    }

    public void unschedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = this._groupLocalService.getGroup(stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        this._layoutService.unschedulePublishToLive(liveGroupId, jobName, groupName);
    }

    public void unschedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", stagingGroupId);
        this._layoutService.unschedulePublishToRemote(stagingGroupId, jobName, groupName);
    }

    public void updateLastImportSettings(Element layoutElement, Layout layout, PortletDataContext portletDataContext) {
        Map parameterMap = portletDataContext.getParameterMap();
        String cmd = MapUtil.getString((Map)parameterMap, (String)"cmd");
        if (!(cmd.equals("publish_to_live") || cmd.equals("publish_to_remote") || cmd.equals("schedule_publish_to_live") || cmd.equals("schedule_publish_to_remote"))) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("last-import-date", String.valueOf(System.currentTimeMillis()));
        String layoutRevisionId = GetterUtil.getString((String)layoutElement.attributeValue("layout-revision-id"));
        typeSettingsUnicodeProperties.setProperty("last-import-layout-revision-id", layoutRevisionId);
        String layoutSetBranchId = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchId");
        typeSettingsUnicodeProperties.setProperty("last-import-layout-set-branch-id", layoutSetBranchId);
        String layoutSetBranchName = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchName");
        typeSettingsUnicodeProperties.setProperty("last-import-layout-set-branch-name", layoutSetBranchName);
        String lastImportUserName = MapUtil.getString((Map)parameterMap, (String)"lastImportUserName");
        typeSettingsUnicodeProperties.setProperty("last-import-user-name", lastImportUserName);
        String lastImportUserUuid = MapUtil.getString((Map)parameterMap, (String)"lastImportUserUuid");
        typeSettingsUnicodeProperties.setProperty("last-import-user-uuid", lastImportUserUuid);
        String layoutBranchId = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-id"));
        typeSettingsUnicodeProperties.setProperty("last-import-layout-branch-id", layoutBranchId);
        String layoutBranchName = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-name"));
        typeSettingsUnicodeProperties.setProperty("last-import-layout-branch-name", layoutBranchName);
        layout.setTypeSettingsProperties(typeSettingsUnicodeProperties);
    }

    public void validateRemoteGroupIsSame(long groupId, long remoteGroupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) throws PortalException {
        if (remoteGroupId <= 0L) {
            RemoteOptionsException remoteOptionsException = new RemoteOptionsException(3);
            remoteOptionsException.setRemoteGroupId(remoteGroupId);
            throw remoteOptionsException;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        String remoteURL = this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            StagingGroupServiceTunnelUtil.checkRemoteStagingGroup(httpPrincipal, remoteGroupId);
            Group group = this._groupLocalService.getGroup(groupId);
            Group remoteGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
            if (group.getGroupId() == remoteGroup.getGroupId() && Objects.equals(group.getUuid(), remoteGroup.getUuid())) {
                String validationTimestamp = String.valueOf(System.currentTimeMillis());
                this._setGroupTypeSetting(groupId, "validationTimestamp", validationTimestamp);
                remoteGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
                UnicodeProperties remoteTypeSettingsUnicodeProperties = remoteGroup.getTypeSettingsProperties();
                String remoteValidationTimestamp = GetterUtil.getString((String)remoteTypeSettingsUnicodeProperties.getProperty("validationTimestamp"));
                if (validationTimestamp.equals(remoteValidationTimestamp)) {
                    RemoteExportException remoteExportException = new RemoteExportException(4);
                    remoteExportException.setGroupId(remoteGroupId);
                    throw remoteExportException;
                }
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchGroupException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(3);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(5);
            remoteExportException.setGroupId(remoteGroupId);
            throw remoteExportException;
        }
        catch (RemoteAuthException remoteAuthException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)remoteAuthException);
            }
            remoteAuthException.setURL(remoteURL);
            throw remoteAuthException;
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)systemException);
            }
            RemoteExportException remoteExportException = new RemoteExportException(1, systemException.getMessage());
            remoteExportException.setURL(remoteURL);
            throw remoteExportException;
        }
        finally {
            this._setGroupTypeSetting(groupId, "validationTimestamp", null);
        }
    }

    protected boolean getBoolean(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)param, (boolean)GetterUtil.getBoolean((String)group.getTypeSettingsProperty(param)));
    }

    protected int getInteger(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getInteger((PortletRequest)portletRequest, (String)param, (int)GetterUtil.getInteger((String)group.getTypeSettingsProperty(param)));
    }

    protected long getLong(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getLong((PortletRequest)portletRequest, (String)param, (long)GetterUtil.getLong((String)group.getTypeSettingsProperty(param)));
    }

    protected long getRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid) throws PortalException {
        block11: {
            long layoutBranchId;
            block10: {
                LayoutRevision layoutRevision;
                if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
                    List layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, true);
                    if (ListUtil.isNotEmpty((List)layoutRevisions)) {
                        LayoutRevision layoutRevision2 = (LayoutRevision)layoutRevisions.get(0);
                        return layoutRevision2.getLayoutRevisionId();
                    }
                    return 0L;
                }
                layoutBranchId = this._getRecentLayoutBranchId(userId, layoutSetBranchId, plid);
                RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
                if (recentLayoutRevision != null && (layoutRevision = this._layoutRevisionLocalService.fetchLayoutRevision(recentLayoutRevision.getLayoutRevisionId())) != null && layoutRevision.getLayoutBranchId() == layoutBranchId) {
                    return layoutRevision.getLayoutRevisionId();
                }
                LayoutBranch layoutBranch = this._layoutBranchLocalService.fetchLayoutBranch(layoutBranchId);
                if (layoutBranch == null) {
                    try {
                        layoutBranch = this._layoutBranchLocalService.getMasterLayoutBranch(layoutSetBranchId, plid);
                        layoutBranchId = layoutBranch.getLayoutBranchId();
                    }
                    catch (NoSuchLayoutBranchException noSuchLayoutBranchException) {
                        if (!_log.isDebugEnabled()) break block10;
                        _log.debug((Throwable)noSuchLayoutBranchException);
                    }
                }
            }
            if (layoutBranchId > 0L) {
                try {
                    LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutSetBranchId, layoutBranchId, plid);
                    if (layoutRevision != null) {
                        return layoutRevision.getLayoutRevisionId();
                    }
                }
                catch (NoSuchLayoutRevisionException noSuchLayoutRevisionException) {
                    if (!_log.isDebugEnabled()) break block11;
                    _log.debug((Throwable)noSuchLayoutRevisionException);
                }
            }
        }
        return 0L;
    }

    protected String getString(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)param, (String)GetterUtil.getString((String)group.getTypeSettingsProperty(param)));
    }

    protected long publishPortlet(long userId, long scopeGroupId, long plid, String portletId, Map<String, String[]> parameterMap, boolean copyFromLive) throws PortalException {
        Layout sourceLayout = this._layoutLocalService.getLayout(plid);
        Group scopeGroup = sourceLayout.getScopeGroup();
        Group liveGroup = null;
        Group stagingGroup = null;
        long targetGroupId = 0L;
        long targetLayoutPlid = 0L;
        if (sourceLayout.isTypeControlPanel()) {
            stagingGroup = this._groupLocalService.fetchGroup(scopeGroupId);
            if (stagingGroup.isStagedRemotely()) {
                targetGroupId = stagingGroup.getRemoteLiveGroupId();
                User user = this._userLocalService.getUser(userId);
                HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
                targetLayoutPlid = LayoutServiceHttp.getControlPanelLayoutPlid((HttpPrincipal)httpPrincipal);
            } else {
                liveGroup = stagingGroup.getLiveGroup();
                targetGroupId = liveGroup.getGroupId();
                targetLayoutPlid = sourceLayout.getPlid();
            }
        } else if (sourceLayout.hasScopeGroup() && scopeGroup.getGroupId() == scopeGroupId) {
            stagingGroup = scopeGroup;
            liveGroup = stagingGroup.getLiveGroup();
            targetGroupId = liveGroup.getGroupId();
            Layout layout = this._layoutLocalService.getLayout(liveGroup.getClassPK());
            targetLayoutPlid = layout.getPlid();
        } else {
            stagingGroup = sourceLayout.getGroup();
            if (stagingGroup.isStagedRemotely()) {
                targetGroupId = stagingGroup.getRemoteLiveGroupId();
                targetLayoutPlid = this.getRemoteLayoutPlid(userId, stagingGroup.getGroupId(), sourceLayout.getPlid());
            } else {
                liveGroup = stagingGroup.getLiveGroup();
                targetGroupId = liveGroup.getGroupId();
                Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(sourceLayout.getUuid(), liveGroup.getGroupId(), sourceLayout.isPrivateLayout());
                targetLayoutPlid = layout.getPlid();
            }
        }
        if (copyFromLive) {
            return this.publishPortlet(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), targetLayoutPlid, sourceLayout.getPlid(), portletId, parameterMap);
        }
        return this.publishPortlet(userId, stagingGroup.getGroupId(), targetGroupId, sourceLayout.getPlid(), targetLayoutPlid, portletId, parameterMap);
    }

    protected void setRecentLayoutBranchId(long userId, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        LayoutBranch layoutBranch = this._layoutBranchLocalService.fetchLayoutBranch(layoutBranchId);
        if (layoutBranch == null) {
            return;
        }
        RecentLayoutBranch recentLayoutBranch = this._recentLayoutBranchLocalService.fetchRecentLayoutBranch(userId, layoutSetBranchId, plid);
        if (layoutBranch.isMaster()) {
            if (recentLayoutBranch != null) {
                this._recentLayoutBranchLocalService.deleteRecentLayoutBranch(recentLayoutBranch);
            }
        } else {
            if (recentLayoutBranch == null) {
                recentLayoutBranch = this._recentLayoutBranchLocalService.addRecentLayoutBranch(userId, layoutBranchId, layoutSetBranchId, plid);
            }
            recentLayoutBranch.setLayoutBranchId(layoutBranchId);
            this._recentLayoutBranchLocalService.updateRecentLayoutBranch(recentLayoutBranch);
        }
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
    }

    protected void setRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        long layoutBranchId;
        block6: {
            if (layoutRevisionId <= 0L || ExportImportThreadLocal.isLayoutStagingInProcess()) {
                return;
            }
            layoutBranchId = 0L;
            try {
                LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutRevisionId);
                layoutBranchId = layoutRevision.getLayoutBranchId();
                LayoutRevision lastLayoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutSetBranchId, layoutBranchId, plid);
                if (lastLayoutRevision.getLayoutRevisionId() == layoutRevisionId) {
                    this.deleteRecentLayoutRevisionId(userId, layoutSetBranchId, plid);
                } else {
                    RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
                    if (recentLayoutRevision == null) {
                        recentLayoutRevision = this._recentLayoutRevisionLocalService.addRecentLayoutRevision(userId, layoutRevisionId, layoutSetBranchId, plid);
                    }
                    recentLayoutRevision.setLayoutRevisionId(layoutRevisionId);
                    this._recentLayoutRevisionLocalService.updateRecentLayoutRevision(recentLayoutRevision);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to set recent layout revision ID with layout ", "set branch ", layoutSetBranchId, " and PLID ", plid, " and layout branch ", layoutBranchId}), (Throwable)portalException);
            }
        }
        this.setRecentLayoutBranchId(userId, layoutSetBranchId, plid, layoutBranchId);
    }

    protected void setRecentLayoutSetBranchId(long userId, long layoutSetId, long layoutSetBranchId) throws PortalException {
        LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
        if (layoutSetBranch == null) {
            return;
        }
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(userId, layoutSetId);
        if (layoutSetBranch.isMaster()) {
            if (recentLayoutSetBranch != null) {
                this._recentLayoutSetBranchLocalService.deleteRecentLayoutSetBranch(recentLayoutSetBranch);
            }
        } else {
            if (recentLayoutSetBranch == null) {
                recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.addRecentLayoutSetBranch(userId, layoutSetBranchId, layoutSetId);
            }
            recentLayoutSetBranch.setLayoutSetBranchId(layoutSetBranchId);
            this._recentLayoutSetBranchLocalService.updateRecentLayoutSetBranch(recentLayoutSetBranch);
        }
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
    }

    private void _checkPermission(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)exportImportConfiguration.getGroupId(), (String)"PUBLISH_STAGING");
    }

    private long _copyRemoteLayouts(ExportImportConfiguration exportImportConfiguration, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, boolean remotePrivateLayout) throws PortalException {
        this._checkPermission(exportImportConfiguration);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String backgroundTaskName = MapUtil.getString((Map)parameterMap, (String)"name", (String)exportImportConfiguration.getName());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(user.getUserId(), exportImportConfiguration.getGroupId(), backgroundTaskName, "com.liferay.exportimport.internal.background.task.LayoutRemoteStagingBackgroundTaskExecutor", (Map)HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).put((Object)"httpPrincipal", (Object)new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection), user.getLogin(), user.getPassword(), user.isPasswordEncrypted())).put((Object)"privateLayout", (Object)remotePrivateLayout).build(), new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    private long _getRecentLayoutBranchId(long userId, long layoutSetBranchId, long plid) throws PortalException {
        RecentLayoutBranch recentLayoutBranch = this._recentLayoutBranchLocalService.fetchRecentLayoutBranch(userId, layoutSetBranchId, plid);
        if (recentLayoutBranch != null) {
            return recentLayoutBranch.getLayoutBranchId();
        }
        try {
            LayoutBranch masterLayoutBranch = this._layoutBranchLocalService.getMasterLayoutBranch(layoutSetBranchId, plid);
            return masterLayoutBranch.getLayoutBranchId();
        }
        catch (NoSuchLayoutBranchException noSuchLayoutBranchException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchLayoutBranchException);
            }
            return 0L;
        }
    }

    private ScheduleInformation _getScheduleInformation(PortletRequest portletRequest, long targetGroupId, boolean remote) throws SchedulerException {
        Calendar currentCalendar;
        Calendar startCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
        if (startCalendar.before(currentCalendar = Calendar.getInstance(startCalendar.getTimeZone()))) {
            SchedulerException schedulerException = new SchedulerException();
            schedulerException.setType(1);
            throw schedulerException;
        }
        ScheduleInformation scheduleInformation = new ScheduleInformation();
        int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
        scheduleInformation.setCronText(CronTextUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCalendar, (boolean)false, (int)recurrenceType));
        String destinationName = "liferay/layouts_local_publisher";
        if (remote) {
            destinationName = "liferay/layouts_remote_publisher";
        }
        scheduleInformation.setGroupName(this.getSchedulerGroupName(destinationName, targetGroupId));
        Date schedulerEndDate = null;
        int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
        if (endDateType == 1) {
            Calendar endCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
            schedulerEndDate = endCalendar.getTime();
        }
        scheduleInformation.setSchedulerEndDate(schedulerEndDate);
        scheduleInformation.setStartCalendar(startCalendar);
        return scheduleInformation;
    }

    private boolean _isLayoutRevisionIncomplete(long plid, LayoutRevision layoutRevision, long layoutSetBranchId) {
        List layoutRevisions;
        if (layoutRevision == null && !(layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, true)).isEmpty()) {
            return false;
        }
        layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, false);
        if (!layoutRevisions.isEmpty()) {
            layoutRevision = (LayoutRevision)layoutRevisions.get(0);
        }
        return layoutRevision == null || layoutRevision.getStatus() == 6;
    }

    private boolean _isPrivateLayout(PortletRequest portletRequest) {
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        if (Validator.isNotNull((String)tabs1)) {
            return !tabs1.equals("public-pages");
        }
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"privateLayout", (boolean)true);
    }

    private boolean _isStagingUseVirtualHostForRemoteSite() {
        try {
            StagingConfiguration stagingConfiguration = (StagingConfiguration)this._configurationProvider.getCompanyConfiguration(StagingConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return stagingConfiguration.stagingUseVirtualHostForRemoteSite();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    private void _setGroupTypeSetting(long groupId, String key, String value) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        if (Validator.isNotNull((String)value)) {
            typeSettingsUnicodeProperties.setProperty(key, value);
        } else {
            typeSettingsUnicodeProperties.remove((Object)key);
        }
        group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        group.setTypeSettings(typeSettingsUnicodeProperties.toString());
        this._groupLocalService.updateGroup(group);
    }

    private class ScheduleInformation {
        private String _cronText;
        private String _groupName;
        private Date _schedulerEndDate;
        private Calendar _startCalendar;

        private ScheduleInformation() {
        }

        public String getCronText() {
            return this._cronText;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public Date getSchedulerEndDate() {
            return this._schedulerEndDate;
        }

        public Calendar getStartCalendar() {
            return this._startCalendar;
        }

        public Date getStartDate() {
            return this._startCalendar.getTime();
        }

        public void setCronText(String cronText) {
            this._cronText = cronText;
        }

        public void setGroupName(String groupName) {
            this._groupName = groupName;
        }

        public void setSchedulerEndDate(Date schedulerEndDate) {
            this._schedulerEndDate = schedulerEndDate;
        }

        public void setStartCalendar(Calendar startCalendar) {
            this._startCalendar = startCalendar;
        }
    }
}

