/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.configuration.persistence.listener;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.configuration.ExportImportServiceConfigurationWhitelistedURLPatternsHelper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.exportimport.configuration.ExportImportServiceConfiguration"}, service={ConfigurationModelListener.class})
public class ExportImportServiceConfigurationModelListener
implements ConfigurationModelListener {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportServiceConfigurationModelListener.class);
    private final Snapshot<ExportImportServiceConfigurationWhitelistedURLPatternsHelper> _exportImportServiceConfigurationWhitelistedURLPatternsHelperSnapshot = new Snapshot(ExportImportServiceConfigurationModelListener.class, ExportImportServiceConfigurationWhitelistedURLPatternsHelper.class);

    public void onAfterDelete(String pid) {
        ExportImportServiceConfigurationWhitelistedURLPatternsHelper exportImportServiceConfigurationWhitelistedURLPatternsHelper = (ExportImportServiceConfigurationWhitelistedURLPatternsHelper)this._exportImportServiceConfigurationWhitelistedURLPatternsHelperSnapshot.get();
        exportImportServiceConfigurationWhitelistedURLPatternsHelper.removeURLPatternMappers();
    }

    public void onAfterSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            ExportImportServiceConfigurationWhitelistedURLPatternsHelper exportImportServiceConfigurationWhitelistedURLPatternsHelper = (ExportImportServiceConfigurationWhitelistedURLPatternsHelper)this._exportImportServiceConfigurationWhitelistedURLPatternsHelperSnapshot.get();
            exportImportServiceConfigurationWhitelistedURLPatternsHelper.removeURLPatternMapper(GetterUtil.getLong((Object)properties.get("companyId")));
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception, ExportImportServiceConfiguration.class, this.getClass(), properties);
        }
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        ExportImportServiceConfiguration exportImportServiceConfiguration = (ExportImportServiceConfiguration)ConfigurableUtil.createConfigurable(ExportImportServiceConfiguration.class, properties);
        String[] whitelistedURLPatterns = exportImportServiceConfiguration.validateLayoutReferencesWhitelistedURLPatterns();
        if (whitelistedURLPatterns == null) {
            return;
        }
        for (String whitelistedURLPattern : whitelistedURLPatterns) {
            if (Validator.isBlank((String)whitelistedURLPattern) || whitelistedURLPattern.equals("*")) continue;
            if (!whitelistedURLPattern.startsWith("/")) {
                throw new ConfigurationModelListenerException(this._getMessage("please-enter-a-relative-url-that-begins-with-a-slash", new Object[0]), ExportImportServiceConfiguration.class, this.getClass(), properties);
            }
            if (whitelistedURLPattern.endsWith("/")) {
                throw new ConfigurationModelListenerException(this._getMessage("please-enter-a-relative-url-that-does-not-end-with-a-slash", new Object[0]), ExportImportServiceConfiguration.class, this.getClass(), properties);
            }
            if (whitelistedURLPattern.contains("//")) {
                throw new ConfigurationModelListenerException(this._getMessage("please-enter-a-relative-url-that-does-not-have-adjacent-slashes", new Object[0]), ExportImportServiceConfiguration.class, this.getClass(), properties);
            }
            for (char c : whitelistedURLPattern.toCharArray()) {
                if (Validator.isChar((char)c) || Validator.isDigit((char)c) || c == '-' || c == '%' || c == '.' || c == '+' || c == '/' || c == '*' || c == '_') continue;
                throw new ConfigurationModelListenerException(this._getMessage("please-enter-a-relative-url-with-valid-characters", new Object[0]), ExportImportServiceConfiguration.class, this.getClass(), properties);
            }
        }
    }

    private String _getMessage(String key, Object ... arguments) {
        try {
            return ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)key, (Object[])arguments);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }
}

