/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DeletionSystemEventImporter {
    private static final Log _log = LogFactoryUtil.getLog(DeletionSystemEventImporter.class);
    private static final DeletionSystemEventImporter _deletionSystemEventImporter = new DeletionSystemEventImporter();

    public static DeletionSystemEventImporter getInstance() {
        return _deletionSystemEventImporter;
    }

    public void importDeletionSystemEvents(final PortletDataContext portletDataContext) throws Exception {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/deletion-system-events.xml");
        if (xml == null) {
            return;
        }
        XMLReader xmlReader = SecureXMLFactoryProviderUtil.newXMLReader();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                DeletionSystemEventImporter.this._importDeletionSystemEvents(portletDataContext, element);
            }
        }, new String[]{"deletion-system-event"});
        xmlReader.setContentHandler((ContentHandler)elementHandler);
        xmlReader.parse(new InputSource(new StringReader(xml)));
    }

    private DeletionSystemEventImporter() {
    }

    private void _importDeletionSystemEvents(PortletDataContext portletDataContext, Element element) {
        block3: {
            StagedModelType stagedModelType = new StagedModelType(element.attributeValue("class-name"), element.attributeValue("referrer-class-name"));
            if (!this._shouldImportDeletionSystemEvent(portletDataContext, stagedModelType)) {
                return;
            }
            try {
                StagedModelDataHandlerUtil.deleteStagedModel((PortletDataContext)portletDataContext, (Element)element);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to process deletion for ", stagedModelType, " with UUID ", element.attributeValue("uuid")}), (Throwable)exception);
            }
        }
    }

    private boolean _shouldImportDeletionSystemEvent(PortletDataContext portletDataContext, StagedModelType stagedModelType) {
        Set stagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
        if (stagedModelTypes.contains(stagedModelType)) {
            return true;
        }
        for (StagedModelType curStagedModelType : stagedModelTypes) {
            if (curStagedModelType.getClassNameId() != stagedModelType.getClassNameId() || !"referrer-class-name-all".equals(curStagedModelType.getReferrerClassName()) && (!Validator.isNotNull((String)stagedModelType.getReferrerClassName()) || !"referrer-class-name-any".equals(curStagedModelType.getReferrerClassName()))) continue;
            return true;
        }
        return false;
    }
}

