/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class DeletionSystemEventExporter {
    private static final Log _log = LogFactoryUtil.getLog(DeletionSystemEventExporter.class);
    private static final DeletionSystemEventExporter _deletionSystemEventExporter = new DeletionSystemEventExporter();

    public static DeletionSystemEventExporter getInstance() {
        return _deletionSystemEventExporter;
    }

    public void exportDeletionSystemEvents(PortletDataContext portletDataContext) throws Exception {
        List<Long> exportedSystemEventIds = null;
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("deletion-system-events");
        Set deletionSystemEventStagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
        if (!deletionSystemEventStagedModelTypes.isEmpty() && MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETE_LAYOUTS")) {
                deletionSystemEventStagedModelTypes.remove(new StagedModelType(Layout.class));
            }
            exportedSystemEventIds = this._exportDeletionSystemEvents(portletDataContext, rootElement, deletionSystemEventStagedModelTypes);
        }
        if (exportedSystemEventIds != null) {
            for (Long systemEventId : exportedSystemEventIds) {
                SystemEvent systemEvent = SystemEventLocalServiceUtil.fetchSystemEvent((long)systemEventId);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
                Object assetTitle = jsonObject.get("assetTitle");
                if (assetTitle == null || !FeatureFlagManagerUtil.isEnabled((String)"LPS-165481")) continue;
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                manifestSummary.addAssetTitle(systemEvent.getClassName(), String.valueOf(assetTitle));
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/deletion-system-events.xml", document.formattedString());
        if (ListUtil.isNotEmpty(exportedSystemEventIds) && ExportImportThreadLocal.isStagingInProcess()) {
            ExportImportProcessCallbackRegistryUtil.registerCallback((String)portletDataContext.getExportImportProcessId(), (Callable)new DeleteSystemEventsCallable(exportedSystemEventIds));
        }
    }

    protected void addCreateDateProperty(PortletDataContext portletDataContext, DynamicQuery dynamicQuery) {
        if (!portletDataContext.hasDateRange()) {
            return;
        }
        Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
        dynamicQuery.add(createDateProperty.ge((Object)portletDataContext.getStartDate()));
        dynamicQuery.add(createDateProperty.le((Object)portletDataContext.getEndDate()));
    }

    protected void doAddCriteria(PortletDataContext portletDataContext, Set<StagedModelType> deletionSystemEventStagedModelTypes, DynamicQuery dynamicQuery) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        disjunction.add(groupIdProperty.eq((Object)0L));
        disjunction.add(groupIdProperty.eq((Object)portletDataContext.getScopeGroupId()));
        dynamicQuery.add((Criterion)disjunction);
        if (!deletionSystemEventStagedModelTypes.isEmpty()) {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            Property referrerClassNameIdProperty = PropertyFactoryUtil.forName((String)"referrerClassNameId");
            Disjunction referrerClassNameIdDisjunction = RestrictionsFactoryUtil.disjunction();
            for (StagedModelType stagedModelType : deletionSystemEventStagedModelTypes) {
                String className;
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(classNameIdProperty.eq((Object)stagedModelType.getClassNameId()));
                if (stagedModelType.getReferrerClassNameId() >= 0L) {
                    conjunction.add(referrerClassNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                }
                if ((className = stagedModelType.getClassName()).equals(Layout.class.getName())) {
                    Property extraDataProperty = PropertyFactoryUtil.forName((String)"extraData");
                    conjunction.add(extraDataProperty.like((Object)("%\"privateLayout\":\"" + portletDataContext.isPrivateLayout() + "\"%")));
                }
                referrerClassNameIdDisjunction.add((Criterion)conjunction);
            }
            dynamicQuery.add((Criterion)referrerClassNameIdDisjunction);
        }
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.eq((Object)1));
        if (ExportImportDateUtil.isRangeDateRange((PortletDataContext)portletDataContext)) {
            this.addCreateDateProperty(portletDataContext, dynamicQuery);
        }
    }

    private DeletionSystemEventExporter() {
    }

    private void _exportDeletionSystemEvent(PortletDataContext portletDataContext, SystemEvent systemEvent, Element deletionSystemEventsElement) {
        Element deletionSystemEventElement = deletionSystemEventsElement.addElement("deletion-system-event");
        String className = PortalUtil.getClassName((long)systemEvent.getClassNameId());
        deletionSystemEventElement.addAttribute("class-name", className);
        if (className.equals(FragmentEntry.class.getName())) {
            try {
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
                Long[] layoutIds = ArrayUtil.toArray((long[])portletDataContext.getLayoutIds());
                if (layoutIds.length > 0) {
                    String[] layoutUUIDs = new String[layoutIds.length];
                    for (int i = 0; i < layoutIds.length; ++i) {
                        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout(), (long)layoutIds[i]);
                        layoutUUIDs[i] = layout.getUuid();
                    }
                    extraDataJSONObject.put("layoutUUIDs", (Object)layoutUUIDs).put("privateLayout", portletDataContext.isPrivateLayout());
                }
                deletionSystemEventElement.addAttribute("extra-data", extraDataJSONObject.toString());
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                deletionSystemEventElement.addAttribute("extra-data", systemEvent.getExtraData());
            }
        } else {
            deletionSystemEventElement.addAttribute("extra-data", systemEvent.getExtraData());
        }
        deletionSystemEventElement.addAttribute("group-id", String.valueOf(systemEvent.getGroupId()));
        if (systemEvent.getReferrerClassNameId() > 0L) {
            deletionSystemEventElement.addAttribute("referrer-class-name", PortalUtil.getClassName((long)systemEvent.getReferrerClassNameId()));
        }
        deletionSystemEventElement.addAttribute("uuid", systemEvent.getClassUuid());
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        manifestSummary.incrementModelDeletionCount(new StagedModelType(systemEvent.getClassNameId(), systemEvent.getReferrerClassNameId()));
    }

    private List<Long> _exportDeletionSystemEvents(PortletDataContext portletDataContext, Element rootElement, Set<StagedModelType> deletionSystemEventStagedModelTypes) throws Exception {
        ArrayList<Long> systemEventIds = new ArrayList<Long>();
        ActionableDynamicQuery actionableDynamicQuery = SystemEventLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> this.doAddCriteria(portletDataContext, deletionSystemEventStagedModelTypes, dynamicQuery));
        actionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        actionableDynamicQuery.setPerformActionMethod(systemEvent -> {
            this._exportDeletionSystemEvent(portletDataContext, (SystemEvent)systemEvent, rootElement);
            systemEventIds.add(systemEvent.getSystemEventId());
        });
        actionableDynamicQuery.performActions();
        return systemEventIds;
    }

    private class DeleteSystemEventsCallable
    implements Callable<Void> {
        private final List<Long> _systemEventIds;

        public DeleteSystemEventsCallable(List<Long> systemEventIds) {
            this._systemEventIds = systemEventIds;
        }

        @Override
        public Void call() throws PortalException {
            for (Long systemEventId : this._systemEventIds) {
                this._deleteSystemEvent(systemEventId);
            }
            return null;
        }

        private void _deleteSystemEvent(long systemEventId) throws PortalException {
            block2: {
                try {
                    SystemEventLocalServiceUtil.deleteSystemEvent((long)systemEventId);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)"Unable to delete system event. The system events will be cleaned up by a scheduled process.", (Throwable)portalException);
                }
            }
        }
    }
}

