/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.portlet.data.handler.provider.PortletDataHandlerProvider;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.StagedModel;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortletDataHandlerStatusMessageSender.class})
public class PortletDataHandlerStatusMessageSenderImpl
implements PortletDataHandlerStatusMessageSender {
    @Reference
    private BackgroundTaskStatusMessageSender _backgroundTaskStatusMessageSender;
    @Reference
    private PortletDataHandlerProvider _portletDataHandlerProvider;

    public void sendStatusMessage(String messageType, String portletId, ManifestSummary manifestSummary) {
        Message message = new Message();
        this.init(message, messageType, manifestSummary);
        message.put("portletId", (Object)portletId);
        PortletDataHandler portletDataHandler = this._portletDataHandlerProvider.provide(portletId);
        if (portletDataHandler == null) {
            this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
            return;
        }
        long portletModelAdditionCountersTotal = portletDataHandler.getExportModelCount(manifestSummary);
        if (portletModelAdditionCountersTotal < 0L) {
            portletModelAdditionCountersTotal = 0L;
        }
        message.put("portletModelAdditionCountersTotal", (Object)portletModelAdditionCountersTotal);
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }

    public void sendStatusMessage(String messageType, String[] portletIds, ManifestSummary manifestSummary) {
        Message message = new Message();
        this.init(message, messageType, manifestSummary);
        message.put("portletIds", (Object)portletIds);
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }

    public <T extends StagedModel> void sendStatusMessage(String messageType, T stagedModel, ManifestSummary manifestSummary) {
        Message message = new Message();
        this.init(message, messageType, manifestSummary);
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)ExportImportClassedModelUtil.getClassName(stagedModel));
        message.put("stagedModelName", (Object)stagedModelDataHandler.getDisplayName(stagedModel));
        message.put("stagedModelType", (Object)String.valueOf(stagedModel.getStagedModelType()));
        message.put("uuid", (Object)stagedModel.getUuid());
        this._backgroundTaskStatusMessageSender.sendBackgroundTaskStatusMessage(message);
    }

    protected void init(Message message, String messageType, ManifestSummary manifestSummary) {
        message.put("backgroundTaskId", (Object)BackgroundTaskThreadLocal.getBackgroundTaskId());
        message.put("messageType", (Object)messageType);
        message.put("modelAdditionCounters", new HashMap(manifestSummary.getModelAdditionCounters()));
        message.put("modelDeletionCounters", new HashMap(manifestSummary.getModelDeletionCounters()));
    }
}

