/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.processor.type=DLReferences"}, service={ExportImportContentProcessor.class})
public class DLReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String[] _DL_REFERENCE_LEGACY_STOP_STRINGS = new String[]{"'", "&apos;", "]", "}", ")", ">", "<", "|", "\"", "&quot;", " "};
    private static final String[] _DL_REFERENCE_STOP_STRINGS = new String[]{"'", "&apos;", "]", "}", ")", ">", "<", "|", "?", "\"", "&quot;", " "};
    private static final int _OFFSET_HREF_ATTRIBUTE = 6;
    private static final int _OFFSET_SRC_ATTRIBUTE = 5;
    private static final Log _log = LogFactoryUtil.getLog(DLReferencesExportImportContentProcessor.class);
    private static final Pattern _uuidPattern = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    @Reference
    private CompanyLocalService _companyLocalService;
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this.replaceExportDLReferences(portletDataContext, stagedModel, content, exportReferencedContent);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this.replaceImportDLReferences(portletDataContext, stagedModel, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        if (this.isValidateDLReferences()) {
            this.validateDLReferences(groupId, content);
        }
    }

    protected void deleteTimestampParameters(StringBuilder sb, int beginPos) {
        if ((beginPos = sb.indexOf("]", beginPos)) == -1 || beginPos == sb.length() - 1 || sb.charAt(beginPos + 1) != '?') {
            return;
        }
        int endPos = StringUtil.indexOfAny((String)sb.toString(), (String[])_DL_REFERENCE_LEGACY_STOP_STRINGS, (int)(beginPos + 2));
        if (endPos == -1) {
            return;
        }
        String urlParams = sb.substring(beginPos + 1, endPos);
        urlParams = this._http.removeParameter(urlParams, "t");
        sb.replace(beginPos + 1, endPos, urlParams);
    }

    protected ObjectValuePair<String, Integer> getDLReferenceEndPosObjectValuePair(String content, int beginPos, int endPos) {
        String[] stopStrings = _DL_REFERENCE_LEGACY_STOP_STRINGS;
        if (!this.isLegacyURL(content, beginPos)) {
            stopStrings = _DL_REFERENCE_STOP_STRINGS;
        }
        if ((endPos = StringUtil.indexOfAny((String)content, (String[])stopStrings, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        return new ObjectValuePair((Object)content.substring(beginPos, endPos), (Object)endPos);
    }

    protected Map<String, String[]> getDLReferenceParameters(long groupId, String content, int beginPos, int endPos) {
        boolean legacyURL = this.isLegacyURL(content, beginPos);
        Map<String, Object> map = new HashMap<String, String[]>();
        ObjectValuePair<String, Integer> dlReferenceEndPosObjectValuePair = this.getDLReferenceEndPosObjectValuePair(content, beginPos, endPos);
        String dlReference = (String)dlReferenceEndPosObjectValuePair.getKey();
        endPos = (Integer)dlReferenceEndPosObjectValuePair.getValue();
        while (dlReference.contains("&amp;")) {
            dlReference = dlReference.replace("&amp;", "&");
        }
        if (!legacyURL) {
            String[] pathArray = dlReference.split("/");
            if (pathArray.length < 3) {
                return map;
            }
            if ("portlet_file_entry".equals(pathArray[2])) {
                map.put("groupId", new String[]{pathArray[3]});
                map.put("title", new String[]{StringUtils.substringBefore((String)this._http.decodeURL(pathArray[4]), (String)"#")});
            } else {
                map.put("groupId", new String[]{pathArray[2]});
                if (pathArray.length == 5) {
                    map.put("folderId", new String[]{pathArray[3]});
                    map.put("title", new String[]{StringUtils.substringBefore((String)this._http.decodeURL(pathArray[4]), (String)"#")});
                }
            }
            String uuid = this._getUuid(dlReference);
            if (Validator.isNotNull((String)uuid)) {
                map.put("uuid", new String[]{uuid});
            }
        } else {
            dlReference = dlReference.substring(dlReference.indexOf(63) + 1);
            map = this._http.parameterMapFromString(dlReference);
            Object[] imageIds = null;
            if (map.containsKey("img_id")) {
                imageIds = (String[])map.get("img_id");
            } else if (map.containsKey("i_id")) {
                imageIds = (String[])map.get("i_id");
            }
            imageIds = (String[])ArrayUtil.filter((Object[])imageIds, Validator::isNotNull);
            if (ArrayUtil.isNotEmpty((Object[])imageIds)) {
                map.put("image_id", imageIds);
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (String)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(groupId);
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    protected FileEntry getFileEntry(Map<String, String[]> map) {
        FileEntry fileEntry;
        block12: {
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (String)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (String)"name");
                    String title = MapUtil.getString(map, (String)"title");
                    if (Validator.isNotNull((String)title)) {
                        fileEntry = this._dlAppLocalService.getFileEntry(groupId, folderId, title);
                    } else {
                        DLFileEntry dlFileEntry2 = this._dlFileEntryLocalService.fetchFileEntryByName(groupId, folderId, name);
                        if (dlFileEntry2 != null) {
                            fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = this._dlFileEntryLocalService.fetchFileEntryByAnyImageId(MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)e.getMessage());
            }
        }
        return fileEntry;
    }

    protected boolean isLegacyURL(String content, int beginPos) {
        return !content.startsWith("/documents/", beginPos);
    }

    protected boolean isValidateDLReferences() {
        try {
            ExportImportServiceConfiguration configuration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return configuration.validateFileEntryReferences();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return true;
        }
    }

    protected String replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet") && ExportImportThreadLocal.isStagingInProcess()) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = this._portal.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block12: {
                Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(portletDataContext.getScopeGroupId(), content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
                if (fileEntry == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(dlReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent && !fileEntry.isInTrash()) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    } else {
                        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                        String referenceType = "dependency";
                        if (fileEntry.isInTrash()) {
                            referenceType = "disposable_dependency";
                        }
                        portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)fileEntry, referenceType, true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
                    StringBundler exportedReferenceSB = new StringBundler(6);
                    exportedReferenceSB.append("[$dl-reference=");
                    exportedReferenceSB.append(path);
                    exportedReferenceSB.append("$]");
                    if (fileEntry.isInTrash()) {
                        String originalReference = sb.substring(beginPos, endPos);
                        exportedReferenceSB.append("[#dl-reference=");
                        exportedReferenceSB.append(originalReference);
                        exportedReferenceSB.append("#]");
                    }
                    sb.replace(beginPos, endPos, exportedReferenceSB.toString());
                    int deleteTimestampParametersOffset = beginPos;
                    if (fileEntry.isInTrash()) {
                        deleteTimestampParametersOffset = sb.indexOf("[#dl-reference=", beginPos);
                    }
                    this.deleteTimestampParameters(sb, deleteTimestampParametersOffset);
                }
                catch (Exception e) {
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process file entry ");
                    exceptionSB.append(fileEntry.getFileEntryId());
                    exceptionSB.append(" for staged model ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    ExportImportContentProcessorException eicpe = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)e);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exceptionSB.toString(), (Throwable)eicpe);
                    }
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    protected String replaceImportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            Long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, DLFileEntry.class, classPK.longValue());
            String path = null;
            if (referenceDataElement != null) {
                path = referenceDataElement.attributeValue("path");
            }
            if (Validator.isNull(path)) {
                long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                String className = referenceElement.attributeValue("class-name");
                path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (Serializable)classPK);
            }
            while (content.contains("[$dl-reference=" + path + "$]")) {
                block14: {
                    try {
                        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, DLFileEntry.class, (Serializable)classPK);
                    }
                    catch (Exception e) {
                        StringBundler exceptionSB = new StringBundler(6);
                        exceptionSB.append("Unable to process file entry ");
                        exceptionSB.append((Object)classPK);
                        exceptionSB.append(" for ");
                        exceptionSB.append(stagedModel.getModelClassName());
                        exceptionSB.append(" with primary key ");
                        exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                        ExportImportContentProcessorException eicpe = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)e);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)exceptionSB.toString(), (Throwable)eicpe);
                        }
                        if (!_log.isWarnEnabled()) break block14;
                        _log.warn((Object)exceptionSB.toString());
                    }
                }
                Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
                long fileEntryId = MapUtil.getLong((Map)dlFileEntryIds, (long)classPK, (long)classPK);
                int beginPos = content.indexOf("[$dl-reference=" + path);
                int endPos = content.indexOf("$]", beginPos) + 2;
                FileEntry importedFileEntry = null;
                try {
                    importedFileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
                }
                catch (PortalException pe) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)pe, (Throwable)pe);
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)pe.getMessage());
                    }
                    if (!content.startsWith("[#dl-reference=", endPos)) continue;
                    int prefixPos = endPos + "[#dl-reference=".length();
                    int postfixPos = content.indexOf("#]", prefixPos);
                    String originalReference = content.substring(prefixPos, postfixPos);
                    String exportedReference = content.substring(beginPos, postfixPos + 2);
                    content = StringUtil.replace((String)content, (String)exportedReference, (String)originalReference);
                    continue;
                }
                String url = DLUtil.getPreviewURL((FileEntry)importedFileEntry, (FileVersion)importedFileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
                if (url.contains("?")) {
                    content = StringUtil.replace((String)content, (String)"$]?", (String)"$]&");
                }
                String exportedReference = "[$dl-reference=" + path + "$]";
                if (content.startsWith("[#dl-reference=", endPos)) {
                    endPos = content.indexOf("#]", beginPos) + 2;
                    exportedReference = content.substring(beginPos, endPos);
                }
                content = StringUtil.replace((String)content, (String)exportedReference, (String)url);
            }
        }
        return content;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    protected void validateDLReferences(long groupId, String content) throws PortalException {
        String pathContext = this._portal.getPathContext();
        String[] patterns = new String[]{pathContext.concat("/c/document_library/get_file?"), pathContext.concat("/documents/"), pathContext.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(groupId, content, beginPos + pathContext.length(), endPos);
            FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
            if (fileEntry == null) {
                boolean absolutePortalURL = false;
                boolean relativePortalURL = false;
                if (content.regionMatches(true, beginPos - 6, "href=", 0, 5) || content.regionMatches(true, beginPos - 5, "src=", 0, 4)) {
                    relativePortalURL = true;
                }
                if (!relativePortalURL) {
                    ServiceContext serviceContext;
                    String portalURL = pathContext;
                    if (Validator.isNull((String)portalURL) && (serviceContext = ServiceContextThreadLocal.getServiceContext()) != null && serviceContext.getThemeDisplay() != null) {
                        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
                        portalURL = this._portal.getPortalURL(themeDisplay);
                    }
                    HashSet<String> hostNames = new HashSet<String>();
                    hostNames.add(portalURL);
                    List companies = this._companyLocalService.getCompanies();
                    for (Company company : companies) {
                        String virtualHostname = company.getVirtualHostname();
                        hostNames.add("http://" + virtualHostname);
                        hostNames.add("https://" + virtualHostname);
                        hostNames.add(virtualHostname);
                    }
                    for (String hostName : hostNames) {
                        int curBeginPos = beginPos - hostName.length();
                        String substring = content.substring(curBeginPos, endPos);
                        if (!substring.startsWith(hostName) || !content.regionMatches(true, curBeginPos - 6, "href=", 0, 5) && !content.regionMatches(true, curBeginPos - 5, "src=", 0, 4)) continue;
                        absolutePortalURL = true;
                    }
                }
                if (absolutePortalURL || relativePortalURL) {
                    ExportImportContentValidationException eicve = new ExportImportContentValidationException(DLReferencesExportImportContentProcessor.class.getName(), (Throwable)new NoSuchFileEntryException());
                    eicve.setDlReferenceParameters(dlReferenceParameters);
                    ObjectValuePair<String, Integer> dlReferenceEndPosObjectValuePair = this.getDLReferenceEndPosObjectValuePair(content, beginPos, endPos);
                    eicve.setDlReference((String)dlReferenceEndPosObjectValuePair.getKey());
                    eicve.setType(5);
                    throw eicve;
                }
            }
            endPos = beginPos - 1;
        }
    }

    private String _getUuid(String s) {
        Matcher matcher = _uuidPattern.matcher(s);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }
}

