/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.rest.internal.resource.v1_0;

import com.liferay.exportimport.rest.dto.v1_0.ImportProcess;
import com.liferay.exportimport.rest.dto.v1_0.Status;
import com.liferay.exportimport.rest.internal.resource.v1_0.BaseImportProcessResourceImpl;
import com.liferay.exportimport.rest.internal.util.PermissionUtil;
import com.liferay.exportimport.rest.resource.v1_0.ImportProcessResource;
import com.liferay.headless.delivery.dto.v1_0.util.CreatorUtil;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.constants.BackgroundTaskConstants;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchBackgroundTaskException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.staging.StagingGroupHelper;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/import-process.properties"}, scope=ServiceScope.PROTOTYPE, service={ImportProcessResource.class})
public class ImportProcessResourceImpl
extends BaseImportProcessResourceImpl {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Page<ImportProcess> getAssetLibraryImportProcessesPage(Long assetLibraryId, Long creatorId, String search, Integer status, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        return Page.of(this.transform(this._getBackgroundTasks(creatorId, assetLibraryId, pagination, search, sorts, status), this::_toImportProcess), (Pagination)pagination, (long)this._backgroundTaskLocalService.dynamicQueryCount(this._getDynamicQuery(creatorId, assetLibraryId, search, status)));
    }

    @Override
    public ImportProcess getImportProcess(Long importProcessId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(importProcessId.longValue());
        PermissionUtil.checkPermission(this.contextCompany.getCompanyId(), backgroundTask.getGroupId());
        if (!StringUtil.equals((String)backgroundTask.getTaskExecutorClassName(), (String)"com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor")) {
            throw new NoSuchBackgroundTaskException();
        }
        return this._toImportProcess(backgroundTask);
    }

    @Override
    public Page<ImportProcess> getImportProcessesPage(Long creatorId, String search, Integer status, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        long groupId = this._getCompanyGroupId();
        return Page.of(this.transform(this._getBackgroundTasks(creatorId, groupId, pagination, search, sorts, status), this::_toImportProcess), (Pagination)pagination, (long)this._backgroundTaskLocalService.dynamicQueryCount(this._getDynamicQuery(creatorId, groupId, search, status)));
    }

    @Override
    public Page<ImportProcess> getSiteImportProcessesPage(Long siteId, Long creatorId, String search, Integer status, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-35914")) {
            throw new NotFoundException();
        }
        return Page.of(this.transform(this._getBackgroundTasks(creatorId, siteId, pagination, search, sorts, status), this::_toImportProcess), (Pagination)pagination, (long)this._backgroundTaskLocalService.dynamicQueryCount(this._getDynamicQuery(creatorId, siteId, search, status)));
    }

    private List<BackgroundTask> _getBackgroundTasks(Long creatorId, long groupId, Pagination pagination, String search, Sort[] sorts, Integer status) throws Exception {
        PermissionUtil.checkPermission(this.contextCompany.getCompanyId(), groupId);
        DynamicQuery dynamicQuery = this._getDynamicQuery(creatorId, groupId, search, status);
        this._setSorts(dynamicQuery, sorts);
        return this._backgroundTaskLocalService.dynamicQuery(dynamicQuery, pagination.getStartPosition(), pagination.getEndPosition());
    }

    private long _getCompanyGroupId() {
        Group group = this._stagingGroupHelper.fetchCompanyGroup(this.contextCompany.getCompanyId());
        if (group == null) {
            return 0L;
        }
        return group.getGroupId();
    }

    private DynamicQuery _getDynamicQuery(Long creatorId, long groupId, String search, Integer status) {
        DynamicQuery dynamicQuery = this._backgroundTaskLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)this.contextCompany.getCompanyId()));
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId));
        if (!Validator.isBlank((String)search)) {
            dynamicQuery.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)search));
        }
        if (status != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"status", (Object)status));
        }
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"taskExecutorClassName", (Object)"com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor"));
        if (creatorId != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"userId", (Object)creatorId));
        }
        return dynamicQuery;
    }

    private void _setSorts(DynamicQuery dynamicQuery, Sort[] sorts) {
        if (sorts == null) {
            dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"modifiedDate"));
            return;
        }
        for (Sort sort : sorts) {
            String fieldName = sort.getFieldName();
            if ((fieldName = StringUtil.removeSubstring((String)fieldName, (String)"_sortable")).equals("creator")) {
                fieldName = "userName";
            } else if (fieldName.equals("dateCreated")) {
                fieldName = "createDate";
            } else if (fieldName.equals("id")) {
                fieldName = "backgroundTaskId";
            } else if (fieldName.equals("dateModified")) {
                fieldName = "modifiedDate";
            } else if (fieldName.equals("title")) {
                fieldName = "name";
            }
            if (sort.isReverse()) {
                dynamicQuery.addOrder(OrderFactoryUtil.desc((String)fieldName));
                continue;
            }
            dynamicQuery.addOrder(OrderFactoryUtil.asc((String)fieldName));
        }
    }

    private ImportProcess _toImportProcess(final BackgroundTask backgroundTask) throws PortalException {
        return new ImportProcess(){
            {
                this.setCreator(() -> CreatorUtil.toCreator(null, (Portal)ImportProcessResourceImpl.this._portal, (User)ImportProcessResourceImpl.this._userLocalService.fetchUser(backgroundTask.getUserId())));
                this.setDateCreated(() -> ((BackgroundTask)backgroundTask).getCreateDate());
                this.setDateModified(() -> ((BackgroundTask)backgroundTask).getModifiedDate());
                this.setId(() -> ((BackgroundTask)backgroundTask).getBackgroundTaskId());
                this.setStatus(() -> ImportProcessResourceImpl.this._toStatus(backgroundTask.getStatus()));
                this.setTitle(() -> ((BackgroundTask)backgroundTask).getName());
            }
        };
    }

    private Status _toStatus(final int status) {
        return new Status(){
            {
                this.setCode(() -> status);
                this.setLabel(() -> ImportProcessResourceImpl.this._language.get(ImportProcessResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), BackgroundTaskConstants.getStatusLabel((int)status)));
            }
        };
    }
}

