/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal.util;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class DDMFormRuleValidatorUtil {
    public static void validateDDMFormRules(DDMExpressionFactory ddmExpressionFactory, List<DDMFormRule> ddmFormRules) throws DDMFormValidationException {
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            DDMFormRuleValidatorUtil._validateDDMFormRule(ddmExpressionFactory, ddmFormRule);
        }
    }

    private static void _validateDDMExpression(DDMExpressionFactory ddmExpressionFactory, String ddmExpressionString, String expressionType) throws DDMFormValidationException {
        if (Validator.isNull((String)ddmExpressionString)) {
            throw new DDMFormValidationException.MustSetValidFormRuleExpression(expressionType, ddmExpressionString, (Throwable)new DDMExpressionException());
        }
        try {
            ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)ddmExpressionString).build());
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new DDMFormValidationException.MustSetValidFormRuleExpression(expressionType, ddmExpressionString, (Throwable)ddmExpressionException);
        }
    }

    private static void _validateDDMFormRule(DDMExpressionFactory ddmExpressionFactory, DDMFormRule ddmFormRule) throws DDMFormValidationException {
        if (ListUtil.isEmpty((List)ddmFormRule.getActions())) {
            throw new DDMFormValidationException.MustSetValidFormRuleExpression("action", "", (Throwable)new DDMExpressionException());
        }
        for (String action : ddmFormRule.getActions()) {
            DDMFormRuleValidatorUtil._validateDDMExpression(ddmExpressionFactory, action, "action");
        }
        DDMFormRuleValidatorUtil._validateDDMExpression(ddmExpressionFactory, ddmFormRule.getCondition(), "condition");
    }
}

