/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToMapConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormValuesToMapConverter.class})
public class DDMFormValuesToMapConverterImpl
implements DDMFormValuesToMapConverter {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesToMapConverterImpl.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public Map<String, Object> convert(DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws PortalException {
        if (ddmFormValues == null) {
            return Collections.emptyMap();
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        List ddmFormFieldValues = DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true));
        Map ddmFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(ddmFormFieldsMap.size());
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldValue.getName())) continue;
            this._addValues(ddmFormFieldsMap, ddmFormFieldValue, values);
        }
        return values;
    }

    private void _addValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        if (ddmFormField == null) {
            return;
        }
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return;
        }
        if (ddmFormField.isLocalizable()) {
            values.put("value", this._toLocalizedMap(ddmFormField.getType(), this._getLocalizedValue(value)));
        } else {
            values.put("value", value.getString(value.getDefaultLocale()));
        }
    }

    private void _addValues(Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> values) {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        if (ddmFormField == null) {
            return;
        }
        Map fieldInstanceValue = (Map)values.computeIfAbsent(this._getDDMFormFieldValueInstanceKey(ddmFormFieldValue), k -> new LinkedHashMap());
        if (!Objects.equals(ddmFormField.getType(), "fieldset")) {
            this._addValue(ddmFormField, ddmFormFieldValue, fieldInstanceValue);
        }
        if (ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) {
            Map nestedFieldInstanceValues = (Map)fieldInstanceValue.computeIfAbsent("nestedValues", k -> new LinkedHashMap());
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                this._addValues(ddmFormFieldsMap, nestedDDMFormFieldValue, nestedFieldInstanceValues);
            }
        }
    }

    private String _getDDMFormFieldValueInstanceKey(DDMFormFieldValue ddmFormFieldValue) {
        return StringBundler.concat((String[])new String[]{ddmFormFieldValue.getName(), "_INSTANCE_", ddmFormFieldValue.getInstanceId()});
    }

    private LocalizedValue _getLocalizedValue(Value value) {
        if (value == null) {
            return null;
        }
        if (value.isLocalized()) {
            return (LocalizedValue)value;
        }
        LocalizedValue localizedValue = new LocalizedValue(value.getDefaultLocale());
        Map values = localizedValue.getValues();
        values.putAll(value.getValues());
        return localizedValue;
    }

    private Map<String, Object> _toLocalizedMap(String fieldType, LocalizedValue localizedValue) {
        HashMap<String, Object> localizedMap = new HashMap<String, Object>();
        Function<Locale, Object> function = locale -> GetterUtil.getString((String)localizedValue.getString(locale));
        if (fieldType.equals("checkbox_multiple") || fieldType.equals("select")) {
            function = locale -> this._toStringList((Locale)locale, localizedValue);
        }
        for (Locale locale2 : localizedValue.getAvailableLocales()) {
            localizedMap.put(this._language.getLanguageId(locale2), function.apply(locale2));
        }
        return localizedMap;
    }

    private List<String> _toStringList(Locale locale, LocalizedValue localizedValue) {
        try {
            return JSONUtil.toStringList((JSONArray)this._jsonFactory.createJSONArray(localizedValue.getString(locale)));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return Collections.emptyList();
        }
    }
}

