/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessor;
import com.liferay.dynamic.data.mapping.report.DDMFormFieldTypeReportProcessorRegistry;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceReportLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFormInstancePersistence;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport"}, service={AopService.class})
public class DDMFormInstanceReportLocalServiceImpl
extends DDMFormInstanceReportLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceReportLocalServiceImpl.class);
    @Reference
    private DDMFormFieldTypeReportProcessorRegistry _ddmFormFieldTypeReportProcessorRegistry;
    @Reference
    private DDMFormInstancePersistence _ddmFormInstancePersistence;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public DDMFormInstanceReport addFormInstanceReport(long formInstanceId) throws PortalException {
        DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.create(this.counterLocalService.increment());
        DDMFormInstance ddmFormInstance = this._ddmFormInstancePersistence.findByPrimaryKey(formInstanceId);
        ddmFormInstanceReport.setGroupId(ddmFormInstance.getGroupId());
        ddmFormInstanceReport.setCompanyId(ddmFormInstance.getCompanyId());
        ddmFormInstanceReport.setCreateDate(new Date());
        ddmFormInstanceReport.setFormInstanceId(ddmFormInstance.getFormInstanceId());
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)ddmFormInstanceReport);
    }

    public DDMFormInstanceReport getFormInstanceReportByFormInstanceId(long formInstanceId) throws PortalException {
        return this.ddmFormInstanceReportPersistence.findByFormInstanceId(formInstanceId);
    }

    public void processFormInstanceReportEvent(long formInstanceReportId, long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) {
        block2: {
            try {
                this.ddmFormInstanceReportLocalService.updateFormInstanceReport(formInstanceReportId, formInstanceRecordVersionId, ddmFormInstanceReportEvent);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update dynamic data mapping form instance ", "report ", formInstanceReportId}), (Throwable)exception);
            }
        }
    }

    public DDMFormInstanceReport updateFormInstanceReport(long formInstanceReportId, long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) throws PortalException {
        DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.findByPrimaryKey(formInstanceReportId);
        ddmFormInstanceReport.setModifiedDate(new Date());
        ddmFormInstanceReport.setData(this._getData(formInstanceRecordVersionId, ddmFormInstanceReportEvent));
        return (DDMFormInstanceReport)this.ddmFormInstanceReportPersistence.update((BaseModel)ddmFormInstanceReport);
    }

    private String _getData(long formInstanceRecordVersionId, String ddmFormInstanceReportEvent) throws PortalException {
        try {
            DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getDDMFormInstanceRecordVersion(formInstanceRecordVersionId);
            DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportPersistence.findByFormInstanceId(ddmFormInstanceRecordVersion.getFormInstanceId());
            JSONObject ddmFormInstanceReportDataJSONObject = this._jsonFactory.createJSONObject(ddmFormInstanceReport.getData());
            DDMFormValues ddmFormValues = ddmFormInstanceRecordVersion.getDDMFormValues();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
                this._processDDMFormFieldValue(ddmFormFieldValue, ddmFormInstanceRecordVersion, ddmFormInstanceReportDataJSONObject, ddmFormInstanceReportEvent);
                for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                    this._processDDMFormFieldValue(nestedDDMFormFieldValue, ddmFormInstanceRecordVersion, ddmFormInstanceReportDataJSONObject, ddmFormInstanceReportEvent);
                }
            }
            int totalItems = ddmFormInstanceReportDataJSONObject.getInt("totalItems");
            if (ddmFormInstanceReportEvent.equals("add")) {
                ++totalItems;
            } else if (ddmFormInstanceReportEvent.equals("delete")) {
                --totalItems;
            }
            ddmFormInstanceReportDataJSONObject.put("totalItems", totalItems);
            return ddmFormInstanceReportDataJSONObject.toString();
        }
        catch (Exception exception) {
            throw new PortalException("Unable to process data for form instance record version " + formInstanceRecordVersionId, (Throwable)exception);
        }
    }

    private void _processDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, JSONObject ddmFormInstanceReportDataJSONObject, String ddmFormInstanceReportEvent) throws Exception, JSONException {
        DDMFormFieldTypeReportProcessor ddmFormFieldTypeReportProcessor = this._ddmFormFieldTypeReportProcessorRegistry.getDDMFormFieldTypeReportProcessor(ddmFormFieldValue.getType());
        if (ddmFormFieldTypeReportProcessor != null) {
            String fieldName = ddmFormFieldValue.getName();
            JSONObject fieldJSONObject = ddmFormInstanceReportDataJSONObject.getJSONObject(fieldName);
            if (fieldJSONObject == null) {
                fieldJSONObject = JSONUtil.put((String)"type", (Object)ddmFormFieldValue.getType()).put("values", this._jsonFactory.createJSONObject());
            }
            JSONObject processedFieldJSONObject = ddmFormFieldTypeReportProcessor.process(ddmFormFieldValue, this._jsonFactory.createJSONObject(fieldJSONObject.toString()), ddmFormInstanceRecordVersion.getFormInstanceRecordId(), ddmFormInstanceReportEvent);
            ddmFormInstanceReportDataJSONObject.put(fieldName, processedFieldJSONObject);
        }
    }
}

