/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;

public class LinkToPageFieldRenderer
extends BaseFieldRenderer {
    private static final Log _log = LogFactoryUtil.getLog(LinkToPageFieldRenderer.class);
    private final JSONFactory _jsonFactory;
    private final Language _language;
    private final LayoutService _layoutService;

    protected LinkToPageFieldRenderer(JSONFactory jsonFactory, Language language, LayoutService layoutService) {
        this._jsonFactory = jsonFactory;
        this._language = language;
        this._layoutService = layoutService;
    }

    protected String doRender(Field field, Locale locale) throws Exception {
        return StringUtil.merge((Collection)TransformUtil.transform((Collection)field.getValues(locale), value -> {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) {
                return null;
            }
            return this.handleJSON(valueString, locale);
        }), (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this.handleJSON(String.valueOf(value), locale);
    }

    protected String handleJSON(String value, Locale locale) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(value);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
            }
            return "";
        }
        long groupId = jsonObject.getLong("groupId");
        boolean privateLayout = jsonObject.getBoolean("privateLayout");
        long layoutId = jsonObject.getLong("layoutId");
        try {
            return this._layoutService.getLayoutName(groupId, privateLayout, layoutId, this._language.getLanguageId(locale));
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchLayoutException || exception instanceof PrincipalException) {
                return this._language.format(locale, "is-temporarily-unavailable", (Object)"content");
            }
            return "";
        }
    }
}

