/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;

public class DateFieldRenderer
extends BaseFieldRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DateFieldRenderer.class);
    private final Language _language;

    protected DateFieldRenderer(Language language) {
        this._language = language;
    }

    protected String doRender(Field field, Locale locale) throws Exception {
        return StringUtil.merge((Collection)TransformUtil.transform((Collection)field.getValues(locale), value -> {
            if (Validator.isNull((Object)value)) {
                return null;
            }
            return this._format((Serializable)value, locale);
        }), (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this._format(value, locale);
    }

    private String _format(Serializable value, Locale locale) {
        try {
            return DateUtil.formatDate((String)"yyyy-MM-dd", (String)value.toString(), (Locale)locale);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return this._language.format(locale, "is-temporarily-unavailable", (Object)"content");
        }
    }
}

