/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.util.DateDDMFormFieldUtil;
import com.liferay.dynamic.data.mapping.util.NumericDDMFormFieldUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellUtil;
import org.osgi.service.component.annotations.Component;

@Component(property={"ddm.form.instance.record.writer.type=xls"}, service={DDMFormInstanceRecordWriter.class})
public class DDMFormInstanceRecordXLSWriter
implements DDMFormInstanceRecordWriter {
    private static final int _CELL_MAX_LENGTH = Short.MAX_VALUE;
    private static final int _COLUMNS_MAX_COUNT = 256;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordXLSWriter.class);

    public DDMFormInstanceRecordWriterResponse write(DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest) throws Exception {
        Map ddmFormFieldsLabel = ddmFormInstanceRecordWriterRequest.getDDMFormFieldsLabel();
        if (ddmFormFieldsLabel.size() > 256 && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Form has ", ddmFormFieldsLabel.size(), " fields. Due to XLS file format limitations, the first", 256, " will be included in the exported file."}));
        }
        int rowIndex = 0;
        try (ByteArrayOutputStream byteArrayOutputStream = this.createByteArrayOutputStream();){
            DDMFormInstanceRecordWriterResponse dDMFormInstanceRecordWriterResponse;
            block14: {
                Workbook workbook = this.createWorkbook();
                try {
                    CreationHelper creationHelper = workbook.getCreationHelper();
                    DataFormat dataFormat = creationHelper.createDataFormat();
                    Sheet sheet = workbook.createSheet();
                    this.createRow(this.createCellStyle(workbook, true, "Courier New", (short)14), dataFormat, null, sheet.createRow(rowIndex++), ddmFormFieldsLabel);
                    CellStyle rowCellStyle = this.createCellStyle(workbook, false, "Courier New", (short)12);
                    rowCellStyle.setQuotePrefixed(true);
                    for (Map ddmFormFieldsValue : ddmFormInstanceRecordWriterRequest.getDDMFormFieldValues()) {
                        this.createRow(rowCellStyle, dataFormat, ddmFormInstanceRecordWriterRequest.getDDMFormFields(), sheet.createRow(rowIndex++), ddmFormFieldsValue);
                    }
                    workbook.write((OutputStream)byteArrayOutputStream);
                    dDMFormInstanceRecordWriterResponse = DDMFormInstanceRecordWriterResponse.Builder.newBuilder((byte[])byteArrayOutputStream.toByteArray()).build();
                    if (workbook == null) break block14;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return dDMFormInstanceRecordWriterResponse;
        }
    }

    protected ByteArrayOutputStream createByteArrayOutputStream() {
        return new ByteArrayOutputStream();
    }

    protected CellStyle createCellStyle(Workbook workbook, boolean bold, String fontName, short heightInPoints) {
        Font font = workbook.createFont();
        font.setBold(bold);
        font.setFontHeightInPoints(heightInPoints);
        font.setFontName(fontName);
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        return style;
    }

    protected void createRow(CellStyle cellStyle, DataFormat dataFormat, Map<String, DDMFormField> ddmFormFields, Row row, Map<String, String> values) {
        int cellIndex = 0;
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            if (cellIndex == 256) break;
            String value = entry.getValue();
            if (value.length() > Short.MAX_VALUE) {
                value = value.substring(0, 32766);
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Cell ", row.getRowNum(), ",", cellIndex, " value trimmed to ", Short.MAX_VALUE, " characters"}));
                }
            }
            Cell cell = row.createCell(cellIndex++);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(value);
            if (ddmFormFields == null) continue;
            DDMFormField ddmFormField = ddmFormFields.get(entry.getKey());
            if (ddmFormField == null) {
                if (!Objects.equals(entry.getKey(), "modifiedDate")) continue;
                SimpleDateFormat simpleDateFormat = DateDDMFormFieldUtil.getSimpleDateFormat((boolean)true, (Locale)locale);
                this._setCellValue(cell, dataFormat, true, simpleDateFormat.toPattern(), value);
                continue;
            }
            if (ddmFormField.isRepeatable() && value.contains(", ")) continue;
            if (Objects.equals(ddmFormField.getType(), "date")) {
                this._setCellValue(cell, dataFormat, false, DateDDMFormFieldUtil.getPattern((boolean)false, (Locale)locale), value);
                continue;
            }
            if (Objects.equals(ddmFormField.getType(), "date_time")) {
                this._setCellValue(cell, dataFormat, true, DateDDMFormFieldUtil.getPattern((boolean)true, (Locale)locale), value);
                continue;
            }
            if (!Objects.equals(ddmFormField.getType(), "numeric")) continue;
            DecimalFormat decimalFormat = NumericDDMFormFieldUtil.getDecimalFormat((Locale)locale);
            try {
                cell.setCellValue(GetterUtil.getDouble((Object)decimalFormat.parse(NumericDDMFormFieldUtil.getFormattedValue((Locale)locale, (String)value))));
            }
            catch (ParseException parseException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)parseException);
            }
        }
    }

    protected Workbook createWorkbook() {
        return new HSSFWorkbook();
    }

    private void _setCellValue(Cell cell, DataFormat dataFormat, boolean dateTime, String pattern, String value) {
        block4: {
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
                if (dateTime) {
                    cell.setCellValue(LocalDateTime.parse(value, dateTimeFormatter));
                } else {
                    cell.setCellValue(LocalDate.parse(value, dateTimeFormatter));
                }
                CellUtil.setCellStyleProperty((Cell)cell, (String)"dataFormat", (Object)dataFormat.getFormat(pattern));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }
}

