/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortalPreferenceValue;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class PortalPreferenceValueModelListener
extends BaseModelListener<PortalPreferenceValue> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;

    public void onAfterCreate(PortalPreferenceValue portalPreferenceValue) {
        this._updateLayoutSet(portalPreferenceValue.getCompanyId(), portalPreferenceValue.getKey(), portalPreferenceValue.getValue());
    }

    public void onAfterUpdate(PortalPreferenceValue originalPortalPreferenceValue, PortalPreferenceValue portalPreferenceValue) throws ModelListenerException {
        this._updateLayoutSet(portalPreferenceValue.getCompanyId(), portalPreferenceValue.getKey(), portalPreferenceValue.getValue());
    }

    private void _updateLayoutSet(long companyId, String key, String value) {
        if (!StringUtil.equals((String)key, (String)"default.regular.theme.id")) {
            return;
        }
        Group group = this._groupLocalService.fetchGroup(companyId, "Forms");
        if (group == null) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, "/shared");
        if (layout == null) {
            return;
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        layoutSet.setThemeId(value);
        this._layoutSetLocalService.updateLayoutSet(layoutSet);
    }
}

