/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.exception.StructureFieldException;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.impl.DDMStructureBaseImpl;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class DDMStructureImpl
extends DDMStructureBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureImpl.class);
    private static final Snapshot<DDMFormDeserializer> _ddmFormDeserializerSnapshot = new Snapshot(DDMStructureImpl.class, DDMFormDeserializer.class, "(ddm.form.deserializer.type=json)");
    private String _className;
    private DDMForm _ddmForm;
    private Map<String, DDMFormField> _ddmFormFieldsMap;

    public DDMForm createFullHierarchyDDMForm() throws PortalException {
        return this.createFullHierarchyDDMForm(true);
    }

    public DDMForm createFullHierarchyDDMForm(boolean copy) throws PortalException {
        DDMForm fullHierarchyDDMForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        DDMStructure parentDDMStructure = this.getParentDDMStructure();
        if (parentDDMStructure == null && !copy) {
            return fullHierarchyDDMForm;
        }
        fullHierarchyDDMForm = new DDMForm(fullHierarchyDDMForm);
        if (parentDDMStructure != null) {
            DDMForm ancestorsDDMForm = parentDDMStructure.createFullHierarchyDDMForm();
            List ancestorsDDMFormFields = ancestorsDDMForm.getDDMFormFields();
            for (DDMFormField ancestorsDDMFormField : ancestorsDDMFormFields) {
                ancestorsDDMFormField.setDDMForm(fullHierarchyDDMForm);
            }
            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
            ddmFormFields.addAll(0, ancestorsDDMFormFields);
        }
        return fullHierarchyDDMForm;
    }

    public DDMStructureLayout fetchDDMStructureLayout() {
        try {
            DDMStructureVersion ddmStructureVersion = this.getLatestStructureVersion();
            return DDMStructureLayoutLocalServiceUtil.getStructureLayoutByStructureVersionId((long)ddmStructureVersion.getStructureVersionId());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    @Override
    public String[] getAvailableLanguageIds() {
        DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        Set availableLocales = ddmForm.getAvailableLocales();
        return LocaleUtil.toLanguageIds((Locale[])availableLocales.toArray(new Locale[0]));
    }

    public List<String> getChildrenFieldNames(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return this.getDDMFormFieldNames(ddmFormField.getNestedDDMFormFields());
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this._className = PortalUtil.getClassName((long)this.getClassNameId());
            classNameUpdateEntityCacheBiConsumer.accept(this, this._className);
        }
        return this._className;
    }

    @Override
    public DDMForm getDDMForm() {
        return this.getDDMForm(true);
    }

    public DDMForm getDDMForm(boolean copy) {
        DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        if (copy) {
            ddmForm = new DDMForm(ddmForm);
        }
        return ddmForm;
    }

    public DDMFormField getDDMFormField(String fieldName) throws PortalException {
        return this.getDDMFormField(fieldName, true);
    }

    public DDMFormField getDDMFormField(String fieldName, boolean copy) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        if (copy) {
            ddmFormField = new DDMFormField(ddmFormField);
        }
        return ddmFormField;
    }

    public DDMFormField getDDMFormFieldByFieldReference(String fieldReference) throws PortalException {
        return new DDMFormField(this._getDDMFormFieldByFieldReference(fieldReference));
    }

    public List<DDMFormField> getDDMFormFields(boolean includeTransientFields) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>(ddmFormFieldsMap.values());
        if (includeTransientFields) {
            return ddmFormFields;
        }
        return this.filterTransientDDMFormFields(ddmFormFields);
    }

    @Override
    public Map<String, DDMFormField> getDDMFormFieldsMap() {
        if (this._ddmFormFieldsMap == null) {
            DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
            this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
            ddmFormFieldsMapUpdateEntityCacheBiConsumer.accept(this, this._ddmFormFieldsMap);
        }
        return this._ddmFormFieldsMap;
    }

    public DDMFormLayout getDDMFormLayout() throws PortalException {
        DDMStructureVersion structureVersion = this.getStructureVersion();
        DDMStructureLayout ddmStructureLayout = DDMStructureLayoutLocalServiceUtil.getStructureLayoutByStructureVersionId((long)structureVersion.getStructureVersionId());
        return ddmStructureLayout.getDDMFormLayout();
    }

    public long getDefaultDDMStructureLayoutId() {
        DDMStructureLayout ddmStructureLayout = this.fetchDDMStructureLayout();
        if (ddmStructureLayout != null) {
            return ddmStructureLayout.getStructureLayoutId();
        }
        return 0L;
    }

    @Override
    public String getDefaultLanguageId() {
        DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        return LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale());
    }

    public String getFieldDataType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.getDataType();
    }

    public String getFieldLabel(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    public String getFieldLabel(String fieldName, String locale) throws PortalException {
        return this.getFieldLabel(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public Set<String> getFieldNames() {
        return SetUtil.fromList(this.getDDMFormFieldNames(this.getDDMFormFields(false)));
    }

    public String getFieldProperty(String fieldName, String property) throws PortalException {
        return BeanPropertiesUtil.getString((Object)this._getDDMFormField(fieldName), (String)property);
    }

    public String getFieldPropertyByFieldReference(String fieldReference, String property) throws PortalException {
        return BeanPropertiesUtil.getString((Object)this._getDDMFormFieldByFieldReference(fieldReference), (String)property);
    }

    public boolean getFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean getFieldRequired(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRequired();
    }

    public String getFieldTip(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        LocalizedValue tip = ddmFormField.getTip();
        return tip.getString(locale);
    }

    public String getFieldTip(String fieldName, String locale) throws PortalException {
        return this.getFieldTip(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public String getFieldType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.getType();
    }

    public DDMForm getFullHierarchyDDMForm() {
        return this.getFullHierarchyDDMForm(true);
    }

    public DDMForm getFullHierarchyDDMForm(boolean copy) {
        try {
            return this.createFullHierarchyDDMForm(copy);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return new DDMForm();
        }
    }

    public Map<String, DDMFormField> getFullHierarchyDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return ddmForm.getDDMFormFieldsMap(includeNestedDDMFormFields);
    }

    public DDMStructureVersion getLatestStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getLatestStructureVersion((long)this.getStructureId());
    }

    @Override
    public String getName(Locale locale, boolean useDefault) {
        String name = super.getName(locale, useDefault);
        if (Validator.isNull((String)name)) {
            return super.getName(this.getDefaultLanguageId(), useDefault);
        }
        return name;
    }

    public List<String> getRootFieldNames() {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        List ddmFormFields = ddmForm.getDDMFormFields();
        ddmFormFields.removeIf(ddmFormField -> GetterUtil.getBoolean((Object)ddmFormField.getProperty("upgradedStructure")));
        return this.getDDMFormFieldNames(ddmFormFields);
    }

    public DDMStructureVersion getStructureVersion() throws PortalException {
        return DDMStructureVersionLocalServiceUtil.getStructureVersion((long)this.getStructureId(), (String)this.getVersion());
    }

    public List<DDMTemplate> getTemplates() {
        return DDMTemplateLocalServiceUtil.getTemplates((long)this.getStructureId());
    }

    public String getUnambiguousName(List<DDMStructure> structures, long groupId, Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getName(locale);
        }
        boolean hasAmbiguousName = ListUtil.exists(structures, structure -> {
            if (structure.getStructureId() == this.getStructureId()) {
                return false;
            }
            String name = structure.getName(locale);
            return name.equals(this.getName(locale));
        });
        if (hasAmbiguousName) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getName(locale), locale);
        }
        return this.getName(locale);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, String webDAVToken) {
        StringBundler sb = new StringBundler(8);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        sb.append(PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure));
        sb.append(themeDisplay.getPathContext());
        sb.append("/webdav");
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getFriendlyURL());
        sb.append("/");
        sb.append(webDAVToken);
        sb.append("/Structures/");
        sb.append(this.getStructureId());
        return sb.toString();
    }

    public boolean hasField(String fieldName) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getDDMFormFieldsMap();
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField != null) {
            return true;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.hasField(fieldName);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return false;
    }

    public boolean hasFieldByFieldReference(String fieldReference) {
        DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        DDMFormField ddmFormField = this._fetchDDMFormFieldByFieldReference(ddmForm.getDDMFormFields(), fieldReference);
        if (ddmFormField != null) {
            return true;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.hasFieldByFieldReference(fieldReference);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return false;
    }

    public boolean isFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean isFieldTransient(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this._getDDMFormField(fieldName);
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        super.prepareLocalizedFieldsForImport(defaultImportLocale);
        try {
            this.setDefinition(DDMStructureLocalServiceUtil.prepareLocalizedDefinitionForImport((DDMStructure)this, (Locale)defaultImportLocale));
        }
        catch (Exception exception) {
            throw new LocaleException(2, (Throwable)exception);
        }
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setDDMForm(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    @Override
    public void setDDMFormFieldsMap(Map<String, DDMFormField> ddmFormFieldsMap) {
        this._ddmFormFieldsMap = ddmFormFieldsMap;
    }

    @Override
    public void setDefinition(String definition) {
        super.setDefinition(definition);
        this._ddmForm = null;
    }

    protected List<DDMFormField> filterTransientDDMFormFields(List<DDMFormField> ddmFormFields) {
        return ListUtil.filter(ddmFormFields, ddmFormField -> Validator.isNotNull((String)ddmFormField.getDataType()));
    }

    protected List<String> getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        return TransformUtil.transform(ddmFormFields, ddmFormField -> ddmFormField.getName());
    }

    protected DDMStructure getParentDDMStructure() throws PortalException {
        if (this.getParentStructureId() == 0L) {
            return null;
        }
        return DDMStructureLocalServiceUtil.getStructure((long)this.getParentStructureId());
    }

    private DDMFormField _fetchDDMFormField(List<DDMFormField> ddmFormFields, String fieldName) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            DDMFormField targetDDMFormField = null;
            targetDDMFormField = fieldName.equals(ddmFormField.getName()) ? ddmFormField : this._fetchDDMFormField(ddmFormField.getNestedDDMFormFields(), fieldName);
            if (targetDDMFormField == null) continue;
            return targetDDMFormField;
        }
        return null;
    }

    private DDMFormField _fetchDDMFormFieldByFieldReference(List<DDMFormField> ddmFormFields, String fieldReference) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            DDMFormField targetDDMFormField = null;
            targetDDMFormField = fieldReference.equals(ddmFormField.getFieldReference()) ? ddmFormField : this._fetchDDMFormFieldByFieldReference(ddmFormField.getNestedDDMFormFields(), fieldReference);
            if (targetDDMFormField == null) continue;
            return targetDDMFormField;
        }
        return null;
    }

    private DDMForm _getDDMForm(BiConsumer<DDMStructure, DDMForm> ddmFormUpdateEntityCacheBiConsumer) {
        if (this._ddmForm == null) {
            DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)this.getDefinition());
            DDMFormDeserializer ddmFormDeserializer = (DDMFormDeserializer)_ddmFormDeserializerSnapshot.get();
            DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
            this._ddmForm = ddmFormDeserializerDeserializeResponse.getDDMForm();
            for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
                if (!this._isFieldSet(ddmFormField) || !ListUtil.isEmpty((List)ddmFormField.getNestedDDMFormFields())) continue;
                this._setNestedDDMFormFields(ddmFormField);
            }
            ddmFormUpdateEntityCacheBiConsumer.accept(this, this._ddmForm);
        }
        return this._ddmForm;
    }

    private DDMFormField _getDDMFormField(String fieldName) throws PortalException {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getDDMFormFieldsMap();
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField != null) {
            return ddmFormField;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.getDDMFormField(fieldName);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        throw new StructureFieldException("Unable to find field " + fieldName);
    }

    private DDMFormField _getDDMFormFieldByFieldReference(String fieldReference) throws PortalException {
        DDMForm ddmForm = this._getDDMForm(ddmFormUpdateEntityCacheBiConsumer);
        DDMFormField ddmFormField = this._fetchDDMFormFieldByFieldReference(ddmForm.getDDMFormFields(), fieldReference);
        if (ddmFormField != null) {
            return ddmFormField;
        }
        try {
            DDMStructure parentDDMStructure = this.getParentDDMStructure();
            if (parentDDMStructure != null) {
                return parentDDMStructure.getDDMFormFieldByFieldReference(fieldReference);
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        throw new StructureFieldException("Unable to find field " + fieldReference);
    }

    private boolean _isFieldSet(DDMFormField ddmFormField) {
        return Objects.equals(ddmFormField.getType(), "fieldset");
    }

    private void _setNestedDDMFormFields(DDMFormField ddmFormField) {
        block3: {
            if (Validator.isNotNull((Object)ddmFormField.getProperty("ddmStructureId"))) {
                try {
                    DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureId")));
                    DDMForm ddmForm = ddmStructure.getDDMForm();
                    ddmFormField.setNestedDDMFormFields(ddmForm.getDDMFormFields());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)portalException);
                }
            }
        }
    }
}

