/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.util.NumericDDMFormFieldUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={FieldsToDDMFormValuesConverter.class})
public class FieldsToDDMFormValuesConverterImpl
implements FieldsToDDMFormValuesConverter {
    public DDMFormValues convert(DDMStructure ddmStructure, Fields fields) throws PortalException {
        DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFormValues ddmFormValues = this.createDDMFormValues(ddmForm, fields.getAvailableLocales(), fields.getDefaultLocale());
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : this._getDDMFormFieldNames(ddmForm.getDDMFormFields())) {
            int repetitions = this._countDDMFieldRepetitions(ddmFormFieldsMap, fields, fieldName, null, -1);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(fieldName, fields, ddmFieldsCounter);
                DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(fieldName);
                if (ddmFormField != null) {
                    ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
                }
                this._setDDMFormFieldValueProperties(ddmFormFieldValue, ddmFormFieldsMap, fields, ddmFieldsCounter);
                ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }
        }
        return ddmFormValues;
    }

    protected DDMFormFieldValue createDDMFormFieldValue(String name, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(this._getDDMFieldInstanceId(ddmFields, name, ddmFieldsCounter.get((Object)name)));
        ddmFormFieldValue.setName(name);
        return ddmFormFieldValue;
    }

    protected DDMFormValues createDDMFormValues(DDMForm ddmForm, Set<Locale> availableLocales, Locale defaultLocale) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.setAvailableLocales(availableLocales);
        ddmFormValues.setDefaultLocale(defaultLocale);
        return ddmFormValues;
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    private int _countDDMFieldRepetitions(Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws PortalException {
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            if (ddmFields.contains(fieldName)) {
                return 1;
            }
            return 0;
        }
        String[] ddmFieldsDisplayValues = this._getDDMFieldsDisplayValues(ddmFormFieldsMap, ddmFieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (String fieldDisplayName : ddmFieldsDisplayValues) {
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    private String _getDDMFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] ddmFieldsDisplayValues;
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            return StringUtil.randomString();
        }
        String prefix = fieldName.concat("_INSTANCE_");
        for (String ddmFieldsDisplayValue : ddmFieldsDisplayValues = StringUtil.split((String)((String)((Object)ddmFieldsDisplayField.getValue())))) {
            if (!ddmFieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)ddmFieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    private String[] _getDDMFieldsDisplayValues(Map<String, DDMFormField> ddmFormFieldsMap, Field ddmFieldsDisplayField) throws PortalException {
        try {
            String[] values;
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this.splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmFormFieldsMap.containsKey(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private String _getDDMFieldValueString(Field ddmField, Locale locale, int index) {
        Serializable fieldValue = ddmField.getValue(locale, index);
        if (fieldValue == null) {
            return "";
        }
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            fieldValue = Long.valueOf(valueDate.getTime());
        } else if (fieldValue instanceof Number && !(fieldValue instanceof Integer)) {
            DecimalFormat decimalFormat = NumericDDMFormFieldUtil.getDecimalFormat((Locale)locale);
            Number number = (Number)fieldValue;
            if (number instanceof Double || number instanceof Float) {
                decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
                decimalFormat.setMinimumFractionDigits(1);
            }
            return decimalFormat.format(number.doubleValue());
        }
        return String.valueOf(fieldValue);
    }

    private List<String> _getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        return TransformUtil.transform(ddmFormFields, ddmFormField -> ddmFormField.getName());
    }

    private void _setDDMFormFieldValueLocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        LocalizedValue value = new LocalizedValue(ddmField.getDefaultLocale());
        for (Locale availableLocale : ddmField.getAvailableLocales()) {
            String valueString = this._getDDMFieldValueString(ddmField, availableLocale, index);
            value.addString(availableLocale, valueString);
        }
        ddmFormFieldValue.setValue((Value)value);
    }

    private void _setDDMFormFieldValueProperties(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        this._setNestedDDMFormFieldValues(ddmFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
        this._setDDMFormFieldValueValues(ddmFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
    }

    private void _setDDMFormFieldValueUnlocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        String valueString = this._getDDMFieldValueString(ddmField, ddmField.getDefaultLocale(), index);
        UnlocalizedValue value = new UnlocalizedValue(valueString);
        ddmFormFieldValue.setValue((Value)value);
    }

    private void _setDDMFormFieldValueValues(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        DDMFormField ddmFormField = ddmFormFieldMap.get(fieldName);
        Field field = ddmFields.get(fieldName);
        if (!ddmFormField.isTransient() && field != null) {
            if (ddmFormField.isLocalizable()) {
                this._setDDMFormFieldValueLocalizedValue(ddmFormFieldValue, field, ddmFieldsCounter.get((Object)fieldName));
            } else {
                this._setDDMFormFieldValueUnlocalizedValue(ddmFormFieldValue, field, ddmFieldsCounter.get((Object)fieldName));
            }
        }
        ddmFieldsCounter.incrementKey((Object)fieldName);
    }

    private void _setNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        int parentOffset = ddmFieldsCounter.get((Object)fieldName);
        DDMFormField parentDDMFormField = ddmFormFieldsMap.get(fieldName);
        List<String> nestedFieldNames = this._getDDMFormFieldNames(parentDDMFormField.getNestedDDMFormFields());
        for (String nestedFieldName : nestedFieldNames) {
            int repetitions = this._countDDMFieldRepetitions(ddmFormFieldsMap, ddmFields, nestedFieldName, fieldName, parentOffset);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue nestedDDMFormFieldValue = this.createDDMFormFieldValue(nestedFieldName, ddmFields, ddmFieldsCounter);
                DDMFormField nestedDDMFormField = ddmFormFieldsMap.get(nestedFieldName);
                if (nestedDDMFormField != null) {
                    nestedDDMFormFieldValue.setFieldReference(nestedDDMFormField.getFieldReference());
                }
                this._setDDMFormFieldValueProperties(nestedDDMFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
                ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
            }
        }
    }
}

