/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.dynamic.data.mapping.data.provider.settings.DDMDataProviderSettingsProvider;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataProviderInstanceUpgradeProcess
extends UpgradeProcess {
    private static final String _DEFAULT_OUTPUT_PARAMETER_LABEL = "Default Output";
    private static final String _DEFAULT_OUTPUT_PARAMETER_NAME = "Default-Output";
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final ServiceTrackerMap<String, DDMDataProviderSettingsProvider> _serviceTrackerMap;

    public DataProviderInstanceUpgradeProcess(ServiceTrackerMap<String, DDMDataProviderSettingsProvider> ddmDataProviderSettingsProviderServiceTracker, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer) {
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._serviceTrackerMap = ddmDataProviderSettingsProviderServiceTracker;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select dataProviderInstanceId, definition, type_ from DDMDataProviderInstance");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where dataProviderInstanceId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String dataProviderInstanceDefinition = resultSet.getString(2);
                String type = resultSet.getString(3);
                String newDefinition = this._upgradeDataProviderInstanceDefinition(dataProviderInstanceDefinition, type);
                preparedStatement2.setString(1, newDefinition);
                long dataProviderInstanceId = resultSet.getLong(1);
                preparedStatement2.setLong(2, dataProviderInstanceId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _addDefaultInputParameters(DDMFormValues ddmFormValues) {
        DDMFormFieldValue ddmFormFieldValue = this._createDDMFormFieldValue(ddmFormValues, "inputParameters", null);
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "inputParameterLabel", ""));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "inputParameterName", ""));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "inputParameterRequired", "false"));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "inputParameterType", "[]"));
        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
    }

    private void _addDefaultOutputParameters(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (!ddmFormFieldValuesMap.containsKey("key") || !ddmFormFieldValuesMap.containsKey("value")) {
            return;
        }
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("key");
        DDMFormFieldValue keyDDMFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("value");
        DDMFormFieldValue valueDDMFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        String outputParameterPath = this._createOutputPathValue(ddmFormValues.getDefaultLocale(), keyDDMFormFieldValue.getValue(), valueDDMFormFieldValue.getValue());
        ddmFormValues.addDDMFormFieldValue(this._createDefaultOutputParameters(ddmFormValues, outputParameterPath));
    }

    private void _addPaginationParameter(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (ddmFormFieldValuesMap.containsKey("pagination")) {
            return;
        }
        ddmFormValues.addDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "pagination", "false"));
    }

    private void _addStartEndParameters(DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        if (ddmFormFieldValuesMap.containsKey("paginationStartParameterName") || ddmFormFieldValuesMap.containsKey("paginationEndParameterName")) {
            return;
        }
        ddmFormValues.addDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "paginationStartParameterName", "start"));
        ddmFormValues.addDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "paginationEndParameterName", "end"));
    }

    private DDMFormFieldValue _createDDMFormFieldValue(DDMFormValues ddmFormValues, String name, String value) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setDDMFormValues(ddmFormValues);
        ddmFormFieldValue.setName(name);
        if (Validator.isNotNull((String)value)) {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
        }
        return ddmFormFieldValue;
    }

    private DDMFormFieldValue _createDefaultOutputParameters(DDMFormValues ddmFormValues, String outputParameterPath) {
        DDMFormFieldValue ddmFormFieldValue = this._createDDMFormFieldValue(ddmFormValues, "outputParameters", null);
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "outputParameterLabel", _DEFAULT_OUTPUT_PARAMETER_LABEL));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "outputParameterName", _DEFAULT_OUTPUT_PARAMETER_NAME));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "outputParameterPath", outputParameterPath));
        ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormValues, "outputParameterType", "[\"list\"]"));
        return ddmFormFieldValue;
    }

    private String _createOutputPathValue(Locale locale, Value key, Value value) {
        return StringBundler.concat((Object[])new Object[]{key.getString(locale), Character.valueOf(';'), value.getString(locale)});
    }

    private String _upgradeDataProviderInstanceDefinition(String dataProviderInstanceDefinition, String type) throws Exception {
        DDMDataProviderSettingsProvider ddmDataProviderSettingsProvider = (DDMDataProviderSettingsProvider)this._serviceTrackerMap.getService((Object)type);
        DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)dataProviderInstanceDefinition, (DDMForm)DDMFormFactory.create((Class)ddmDataProviderSettingsProvider.getSettings()), (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
        this._addDefaultInputParameters(ddmFormValues);
        this._addDefaultOutputParameters(ddmFormValues);
        this._addPaginationParameter(ddmFormValues);
        this._addStartEndParameters(ddmFormValues);
        return DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer);
    }
}

