/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={DDMFormValuesToFieldsConverter.class})
public class DDMFormValuesToFieldsConverterImpl
implements DDMFormValuesToFieldsConverter {
    public Fields convert(DDMStructure ddmStructure, DDMFormValues ddmFormValues) throws PortalException {
        DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm(false);
        ddmFormValues.setDDMFormFieldValues(DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true)));
        Map<String, Set<Locale>> ddmFormFieldAvailableLocales = this._getDDMFormFieldAvailableLocales(ddmFormValues.getDDMFormFieldValuesMap(true));
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Fields fields = new Fields();
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        StringBundler fieldDisplayNamesSB = new StringBundler(ddmFormFieldValues.size() * 4);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this._addFields(ddmFormFieldAvailableLocales, ddmFormFieldsMap, ddmFormFieldValue, ddmStructure.getStructureId(), ddmFormValues.getDefaultLocale(), fields, fieldDisplayNamesSB);
        }
        if (!ddmFormFieldValues.isEmpty()) {
            fieldDisplayNamesSB.setIndex(fieldDisplayNamesSB.index() - 1);
        }
        fields.put(new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)fieldDisplayNamesSB.toString())));
        return fields;
    }

    private void _addField(DDMFormField ddmFormField, Map<String, Set<Locale>> ddmFormFieldAvailableLocales, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale, Fields fields) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        Field field = this._createField(ddmFormField, ddmFormFieldAvailableLocales, ddmFormFieldValue, ddmStructureId, defaultLocale);
        Field existingField = fields.get(field.getName());
        if (existingField == null) {
            fields.put(field);
            return;
        }
        for (Locale availableLocale : field.getAvailableLocales()) {
            existingField.addValues(availableLocale, field.getValues(availableLocale));
        }
    }

    private void _addFields(Map<String, Set<Locale>> ddmFormFieldAvailableLocales, Map<String, DDMFormField> ddmFormFieldsMap, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale, Fields fields, StringBundler fieldDisplayNamesSB) throws PortalException {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        this._addField(ddmFormField, ddmFormFieldAvailableLocales, ddmFormFieldValue, ddmStructureId, defaultLocale, fields);
        fieldDisplayNamesSB.append(ddmFormFieldValue.getName());
        fieldDisplayNamesSB.append("_INSTANCE_");
        fieldDisplayNamesSB.append(ddmFormFieldValue.getInstanceId());
        fieldDisplayNamesSB.append(",");
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addFields(ddmFormFieldAvailableLocales, ddmFormFieldsMap, nestedDDMFormFieldValue, ddmStructureId, defaultLocale, fields, fieldDisplayNamesSB);
        }
    }

    private Field _createField(DDMFormField ddmFormField, Map<String, Set<Locale>> ddmFormFieldAvailableLocales, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale) throws PortalException {
        Field field = new Field();
        field.setDDMStructureId(ddmStructureId);
        field.setDefaultLocale(defaultLocale);
        field.setName(ddmFormFieldValue.getName());
        Value value = ddmFormFieldValue.getValue();
        if (MapUtil.isEmpty((Map)value.getValues())) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            Map predefinedValuesMap = predefinedValue.getValues();
            if (predefinedValuesMap.isEmpty()) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
                localizedValue.addString(defaultLocale, "");
                ddmFormField.setPredefinedValue(localizedValue);
            }
            value = ddmFormField.getPredefinedValue();
            Set availableLocales = ddmFormFieldAvailableLocales.computeIfAbsent(ddmFormField.getName(), key -> new HashSet());
            availableLocales.addAll(value.getAvailableLocales());
        }
        if (!value.isLocalized()) {
            field.addValue(defaultLocale, FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)ddmFormField.getDataType(), (String)value.getString(LocaleUtil.ROOT)));
            return field;
        }
        for (Locale availableLocale : ddmFormFieldAvailableLocales.get(field.getName())) {
            field.addValue(availableLocale, FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)ddmFormField.getDataType(), (String)value.getString(availableLocale)));
        }
        return field;
    }

    private Map<String, Set<Locale>> _getDDMFormFieldAvailableLocales(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) {
        HashMap<String, Set<Locale>> ddmFormFieldAvailableLocales = new HashMap<String, Set<Locale>>();
        for (Map.Entry<String, List<DDMFormFieldValue>> entry : ddmFormFieldValuesMap.entrySet()) {
            if (ListUtil.isEmpty(entry.getValue())) continue;
            HashSet availableLocales = new HashSet();
            for (DDMFormFieldValue ddmFormFieldValue : entry.getValue()) {
                Value value = ddmFormFieldValue.getValue();
                if (value == null) continue;
                availableLocales.addAll(value.getAvailableLocales());
            }
            ddmFormFieldAvailableLocales.put(entry.getKey(), availableLocales);
        }
        return ddmFormFieldAvailableLocales;
    }
}

