/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_3_2;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMFormInstanceSettingsUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceSettingsUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("where settings_ like '%storageType\\\",\\\"");
        sb.append("value\\\":\\\"[\\\\\\\\\"object\\\\\\\\\"]\\\"%'");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, formInstanceId, settings_ from DDMFormInstance " + sb.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstance set settings_ = ? where ctCollectionId = ? and formInstanceId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("select ctCollectionId, formInstanceVersionId, settings_ from DDMFormInstanceVersion " + sb.toString());
             PreparedStatement preparedStatement4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstanceVersion set settings_ = ? where ctCollectionId = ? and formInstanceVersionId = ?");){
            this._executePreparedStatements("formInstanceId", preparedStatement1, preparedStatement2);
            this._executePreparedStatements("formInstanceVersionId", preparedStatement3, preparedStatement4);
        }
    }

    private void _executePreparedStatements(String columnName, PreparedStatement preparedStatement1, PreparedStatement preparedStatement2) throws Exception {
        try (ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                JSONObject settingsJSONObject = this._jsonFactory.createJSONObject(resultSet.getString("settings_"));
                if (!this._upgradeSettings(settingsJSONObject)) continue;
                preparedStatement2.setString(1, settingsJSONObject.toString());
                preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                preparedStatement2.setLong(3, resultSet.getLong(columnName));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private boolean _upgradeSettings(JSONObject settingsJSONObject) {
        JSONArray fieldValuesJSONArray = settingsJSONObject.getJSONArray("fieldValues");
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldValueJSONObject.getString("name"), (String)"autosaveEnabled")) continue;
            if (fieldValueJSONObject.getBoolean("value")) {
                fieldValueJSONObject.put("value", Boolean.FALSE.toString());
                return true;
            }
            return false;
        }
        return false;
    }
}

