/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v5_4_1;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormSerializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DDMStructureUpgradeProcess
extends UpgradeProcess {
    private static final String _CLASS_NAME_DDM_FORM_INSTANCE = "com.liferay.dynamic.data.mapping.model.DDMFormInstance";
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private final Language _language;

    public DDMStructureUpgradeProcess(DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer, Language language) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._language = language;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeDDMStructure();
        this._upgradeDDMStructureVersion();
    }

    private void _setProperty(final Set<Locale> availableLocales, DDMFormField ddmFormField, String propertyName, final String propertyValue) {
        LocalizedValue localizedValue = (LocalizedValue)ddmFormField.getProperty(propertyName);
        if (localizedValue != null) {
            Map values = localizedValue.getValues();
            for (String value : values.values()) {
                if (!Validator.isNotNull((String)value)) continue;
                return;
            }
        }
        ddmFormField.setProperty(propertyName, (Object)new LocalizedValue(){
            {
                for (Locale locale : availableLocales) {
                    this.addString(locale, DDMStructureUpgradeProcess.this._language.get(locale, propertyValue));
                }
            }
        });
    }

    private void _upgradeDDMStructure() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ?");
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            this._upgradeDDMStructureDefinition("structureId", selectPreparedStatement, updatePreparedStatement);
        }
    }

    private void _upgradeDDMStructureDefinition(String idColumnName, PreparedStatement selectPreparedStatement, PreparedStatement updatePreparedStatement) throws Exception {
        selectPreparedStatement.setLong(1, PortalUtil.getClassNameId((String)_CLASS_NAME_DDM_FORM_INSTANCE));
        try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)resultSet.getString("definition"));
                ListUtil.isNotEmptyForEach((List)ddmForm.getDDMFormFields(), ddmFormField -> this._upgradeRequireConfirmationProperties(ddmForm.getAvailableLocales(), (DDMFormField)ddmFormField));
                updatePreparedStatement.setString(1, DDMFormSerializeUtil.serialize((DDMForm)ddmForm, (DDMFormSerializer)this._ddmFormSerializer));
                updatePreparedStatement.setLong(2, resultSet.getLong(idColumnName));
                updatePreparedStatement.addBatch();
            }
            updatePreparedStatement.executeBatch();
        }
    }

    private void _upgradeDDMStructureVersion() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureVersion.structureVersionId, ", "DDMStructureVersion.definition from ", "DDMStructureVersion inner join DDMStructure on ", "DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            this._upgradeDDMStructureDefinition("structureVersionId", selectPreparedStatement, updatePreparedStatement);
        }
    }

    private void _upgradeRequireConfirmationProperties(Set<Locale> availableLocales, DDMFormField ddmFormField) {
        ListUtil.isNotEmptyForEach((List)ddmFormField.getNestedDDMFormFields(), nestedDDMFormField -> this._upgradeRequireConfirmationProperties(availableLocales, (DDMFormField)nestedDDMFormField));
        if (!Objects.equals(ddmFormField.getType(), "text") && !Objects.equals(ddmFormField.getType(), "numeric")) {
            return;
        }
        this._setProperty(availableLocales, ddmFormField, "confirmationErrorMessage", "the-information-does-not-match");
        this._setProperty(availableLocales, ddmFormField, "confirmationLabel", "confirm");
    }
}

