/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2;

import com.liferay.dynamic.data.mapping.internal.upgrade.v3_10_2.util.DDMFormFieldUpgradeProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMFormInstanceReportUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DDMFormInstanceReportUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMFormInstanceReport.data_, ", "DDMFormInstanceReport.formInstanceReportId from ", "DDMFormInstanceReport"}));
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMFormInstanceReport set data_ = ? where formInstanceReportId = ?");
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                String newData;
                String data = resultSet.getString(1);
                if (StringUtil.equals((String)data, (String)(newData = this.upgradeDDMFormInstanceReportData(data)))) continue;
                updatePreparedStatement.setString(1, newData);
                updatePreparedStatement.setLong(2, resultSet.getLong(2));
                updatePreparedStatement.addBatch();
            }
            updatePreparedStatement.executeBatch();
        }
    }

    protected String upgradeDDMFormInstanceReportData(String data) throws JSONException {
        JSONObject normalizedDataJSONObject = this._jsonFactory.createJSONObject();
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        for (String key : dataJSONObject.keySet()) {
            if (StringUtil.equals((String)key, (String)"totalItems")) {
                normalizedDataJSONObject.put(key, dataJSONObject.getInt(key));
                continue;
            }
            normalizedDataJSONObject.put(DDMFormFieldUpgradeProcessUtil.getNormalizedName(key), this._getNormalizedFieldJSONObject(dataJSONObject.getJSONObject(key)));
        }
        return normalizedDataJSONObject.toString();
    }

    private JSONObject _getNormalizedFieldJSONObject(JSONObject fieldJSONObject) {
        String type = fieldJSONObject.getString("type");
        if (!DDMFormFieldUpgradeProcessUtil.isDDMFormFieldWithOptions(type)) {
            return fieldJSONObject;
        }
        JSONObject normalizedFieldJSONObject = this._jsonFactory.createJSONObject();
        return normalizedFieldJSONObject.put("totalEntries", () -> {
            if (fieldJSONObject.has("totalEntries")) {
                return fieldJSONObject.getInt("totalEntries");
            }
            return null;
        }).put("type", type).put("values", this._getNormalizedValuesJSONObject(fieldJSONObject.getJSONObject("values")));
    }

    private JSONObject _getNormalizedValuesJSONObject(JSONObject valuesJSONObject) {
        JSONObject normalizedValuesJSONObject = this._jsonFactory.createJSONObject();
        if (valuesJSONObject != null && valuesJSONObject.length() > 0) {
            for (String key : valuesJSONObject.keySet()) {
                normalizedValuesJSONObject.put(DDMFormFieldUpgradeProcessUtil.getNormalizedName(key), valuesJSONObject.getInt(key));
            }
        }
        return normalizedValuesJSONObject;
    }
}

