/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class DDMFormInstanceStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMFormInstance> {
    public static final String[] CLASS_NAMES = new String[]{DDMFormInstance.class.getName()};
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance)")
    private StagedModelRepository<DDMFormInstance> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMFormInstance ddmFormInstance) {
        return ddmFormInstance.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws Exception {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance, (StagedModel)ddmStructure, (String)"strong");
        for (DDMTemplate ddmTemplate : ddmStructure.getTemplates()) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)ddmFormInstance, (StagedModel)ddmTemplate, (String)"strong");
        }
        Element element = portletDataContext.getExportDataElement((ClassedModel)ddmFormInstance);
        String settingsDDMFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)ddmFormInstance, (String)"settings-ddm-form-values.json");
        element.addAttribute("settings-ddm-form-values-path", settingsDDMFormValuesPath);
        if (StringUtil.equals((String)ddmStructure.getStorageType(), (String)"object")) {
            portletDataContext.addZipEntry(settingsDDMFormValuesPath, this._addObjectDefinitionExternalReferenceCode(this._jsonFactory.createJSONObject(ddmFormInstance.getSettings())));
        } else {
            portletDataContext.addZipEntry(settingsDDMFormValuesPath, ddmFormInstance.getSettings());
        }
        portletDataContext.addClassedModel(element, ExportImportPathUtil.getModelPath((StagedModel)ddmFormInstance), (ClassedModel)ddmFormInstance);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long ddmFormInstanceId) throws Exception {
        DDMFormInstance existingDDMFormInstance = (DDMFormInstance)this.fetchMissingReference(uuid, groupId);
        if (existingDDMFormInstance == null) {
            return;
        }
        Map ddmFormInstanceIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class);
        ddmFormInstanceIds.put(ddmFormInstanceId, existingDDMFormInstance.getFormInstanceId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMFormInstance ddmFormInstance) throws Exception {
        DDMFormInstance importedDDMFormInstance = (DDMFormInstance)ddmFormInstance.clone();
        importedDDMFormInstance.setGroupId(portletDataContext.getScopeGroupId());
        importedDDMFormInstance.setStructureId(MapUtil.getLong((Map)portletDataContext.getNewPrimaryKeysMap(DDMStructure.class), (long)ddmFormInstance.getStructureId(), (long)ddmFormInstance.getStructureId()));
        DDMFormInstance existingDDMFormInstance = (DDMFormInstance)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(ddmFormInstance.getUuid(), portletDataContext.getScopeGroupId());
        if (existingDDMFormInstance == null || !portletDataContext.isDataStrategyMirror()) {
            importedDDMFormInstance = (DDMFormInstance)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedDDMFormInstance);
        } else {
            importedDDMFormInstance.setMvccVersion(existingDDMFormInstance.getMvccVersion());
            importedDDMFormInstance.setFormInstanceId(existingDDMFormInstance.getFormInstanceId());
            importedDDMFormInstance = (DDMFormInstance)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedDDMFormInstance);
        }
        Element element = portletDataContext.getImportDataElement((StagedModel)ddmFormInstance);
        String serializedSettingsDDMFormValues = portletDataContext.getZipEntryAsString(element.attributeValue("settings-ddm-form-values-path"));
        if (StringUtil.equals((String)importedDDMFormInstance.getStorageType(), (String)"object")) {
            serializedSettingsDDMFormValues = this._addObjectDefinitionId(this._jsonFactory.createJSONObject(serializedSettingsDDMFormValues));
        }
        this._ddmFormInstanceLocalService.updateFormInstance(importedDDMFormInstance.getFormInstanceId(), importedDDMFormInstance.getStructureId(), importedDDMFormInstance.getNameMap(), importedDDMFormInstance.getDescriptionMap(), DDMFormValuesDeserializeUtil.deserialize((String)serializedSettingsDDMFormValues, (DDMForm)DDMFormFactory.create(DDMFormInstanceSettings.class), (DDMFormValuesDeserializer)this._jsonDDMFormValuesDeserializer), portletDataContext.createServiceContext((StagedModel)importedDDMFormInstance));
        portletDataContext.importClassedModel((ClassedModel)ddmFormInstance, (ClassedModel)importedDDMFormInstance);
    }

    protected StagedModelRepository<DDMFormInstance> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    private String _addObjectDefinitionExternalReferenceCode(JSONObject jsonObject) throws Exception {
        JSONObject fieldValueJSONObject = this._getFieldValueJSONObject(jsonObject.getJSONArray("fieldValues"), "objectDefinitionId");
        if (fieldValueJSONObject == null) {
            return jsonObject.toString();
        }
        JSONArray valueJSONArray = this._jsonFactory.createJSONArray(fieldValueJSONObject.getString("value"));
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(valueJSONArray.getLong(0));
        if (objectDefinition == null) {
            return jsonObject.toString();
        }
        return jsonObject.put("objectDefinitionExternalReferenceCode", objectDefinition.getExternalReferenceCode()).toString();
    }

    private String _addObjectDefinitionId(JSONObject jsonObject) {
        String objectDefinitionExternalReferenceCode = jsonObject.getString("objectDefinitionExternalReferenceCode");
        jsonObject.remove("objectDefinitionExternalReferenceCode");
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode(objectDefinitionExternalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        if (objectDefinition == null) {
            return jsonObject.toString();
        }
        JSONObject fieldValueJSONObject = this._getFieldValueJSONObject(jsonObject.getJSONArray("fieldValues"), "objectDefinitionId");
        if (fieldValueJSONObject == null) {
            return jsonObject.toString();
        }
        fieldValueJSONObject.put("value", JSONUtil.put((Object)String.valueOf(objectDefinition.getObjectDefinitionId())));
        return jsonObject.toString();
    }

    private JSONObject _getFieldValueJSONObject(JSONArray fieldValuesJSONArray, String name) {
        for (int i = 0; i < fieldValuesJSONArray.length(); ++i) {
            JSONObject fieldValueJSONObject = fieldValuesJSONArray.getJSONObject(i);
            if (!StringUtil.equals((String)fieldValueJSONObject.getString("name"), (String)name)) continue;
            return fieldValueJSONObject;
        }
        return null;
    }
}

