/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.model.impl;

import com.liferay.dynamic.data.mapping.model.DDMField;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalServiceUtil;

/**
 * The extended model base implementation for the DDMField service. Represents a row in the &quot;DDMField&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DDMFieldImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFieldImpl
 * @see DDMField
 * @generated
 */
public abstract class DDMFieldBaseImpl
	extends DDMFieldModelImpl implements DDMField {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ddm field model instance should use the <code>DDMField</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DDMFieldLocalServiceUtil.addDDMField(this);
		}
		else {
			DDMFieldLocalServiceUtil.updateDDMField(this);
		}
	}

}