/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_3_3;

import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class DDMStructureLayoutUpgradeProcess
extends UpgradeProcess {
    private final DDMFormLayoutDeserializer _ddmFormLayoutDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final JSONFactory _jsonFactory;

    public DDMStructureLayoutUpgradeProcess(DDMFormLayoutDeserializer ddmFormLayoutDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, JSONFactory jsonFactory) {
        this._ddmFormLayoutDeserializer = ddmFormLayoutDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMStructureLayout.structureLayoutId, ", "DDMStructureLayout.definition from DDMStructureLayout ", "inner join DDMStructureVersion on ", "DDMStructureLayout.structureVersionId = ", "DDMStructureVersion.structureVersionId inner join ", "DDMStructure on DDMStructure.structureId = ", "DDMStructureVersion.structureId where ", "DDMStructure.classNameId = ?"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureLayout set definition = ? where structureLayoutId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)DDMFormInstance.class.getName()));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    DDMFormLayout ddmFormLayout = DDMFormLayoutDeserializeUtil.deserialize((DDMFormLayoutDeserializer)this._ddmFormLayoutDeserializer, (String)resultSet.getString("definition"));
                    if (!Objects.equals(ddmFormLayout.getPaginationMode(), "wizard")) continue;
                    ddmFormLayout.setPaginationMode("multi-pages");
                    DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout).build());
                    preparedStatement2.setString(1, ddmFormLayoutSerializerSerializeResponse.getContent());
                    long structureLayoutId = resultSet.getLong("structureLayoutId");
                    preparedStatement2.setLong(2, structureLayoutId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

