/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLinkException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLinkLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureLink"}, service={AopService.class})
public class DDMStructureLinkLocalServiceImpl
extends DDMStructureLinkLocalServiceBaseImpl {
    public DDMStructureLink addStructureLink(long classNameId, long classPK, long structureId) {
        long structureLinkId = this.counterLocalService.increment();
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.create(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        return (DDMStructureLink)this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
    }

    public void deleteStructureLink(DDMStructureLink structureLink) {
        this.ddmStructureLinkPersistence.remove((BaseModel)structureLink);
    }

    public void deleteStructureLink(long structureLinkId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureLink(long classNameId, long classPK, long structureId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByC_C_S(classNameId, classPK, structureId);
        this.deleteDDMStructureLink(structureLink);
    }

    public void deleteStructureLinks(long classNameId, long classPK) {
        List structureLinks = this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
        for (DDMStructureLink ddmStructureLink : structureLinks) {
            this.deleteStructureLink(ddmStructureLink);
        }
    }

    public void deleteStructureStructureLinks(long structureId) {
        List structureLinks = this.ddmStructureLinkPersistence.findByStructureId(structureId);
        for (DDMStructureLink structureLink : structureLinks) {
            this.deleteStructureLink(structureLink);
        }
    }

    @Deprecated
    public List<DDMStructureLink> getClassNameStructureLinks(long classNameId) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        return this.dynamicQuery(dynamicQuery);
    }

    public DDMStructureLink getStructureLink(long structureLinkId) throws PortalException {
        return this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId) {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId, int start, int end) {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId, start, end);
    }

    public List<DDMStructureLink> getStructureLinks(long classNameId, long classPK) {
        return this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
    }

    public List<DDMStructureLink> getStructureLinks(long classNameId, long classPK, int start, int end) {
        return this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK, start, end);
    }

    public int getStructureLinksCount(long classNameId, long classPK) {
        return this.ddmStructureLinkPersistence.countByC_C(classNameId, classPK);
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK) throws PortalException {
        ArrayList<DDMStructure> structures = new ArrayList<DDMStructure>();
        List<DDMStructureLink> structureLinks = this.getStructureLinks(classNameId, classPK);
        for (DDMStructureLink structureLink : structureLinks) {
            structures.add(structureLink.getStructure());
        }
        return structures;
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK, int start, int end) throws PortalException {
        ArrayList<DDMStructure> structures = new ArrayList<DDMStructure>();
        List<DDMStructureLink> structureLinks = this.getStructureLinks(classNameId, classPK, start, end);
        for (DDMStructureLink structureLink : structureLinks) {
            structures.add(structureLink.getStructure());
        }
        return structures;
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK, String keywords) throws PortalException {
        return this.getStructureLinkStructures(classNameId, classPK, keywords, -1, -1);
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK, String keywords, int start, int end) throws PortalException {
        return this.getStructureLinkStructures(classNameId, classPK, keywords, start, end, null);
    }

    public List<DDMStructure> getStructureLinkStructures(long classNameId, long classPK, String keywords, int start, int end, OrderByComparator<DDMStructureLink> orderByComparator) throws PortalException {
        ArrayList<DDMStructure> structures = new ArrayList<DDMStructure>();
        List structureLinks = this.ddmStructureLinkFinder.findByKeywords(classNameId, classPK, keywords, start, end, orderByComparator);
        for (DDMStructureLink structureLink : structureLinks) {
            structures.add(structureLink.getStructure());
        }
        return structures;
    }

    public int getStructureLinkStructuresCount(long classNameId, long classPK, String keywords) {
        return this.ddmStructureLinkFinder.countByKeywords(classNameId, classPK, keywords);
    }

    public DDMStructureLink getUniqueStructureLink(long classNameId, long classPK) throws PortalException {
        List structureLinks = this.ddmStructureLinkPersistence.findByC_C(classNameId, classPK);
        if (structureLinks.isEmpty()) {
            StringBundler sb = new StringBundler(5);
            sb.append("No DDMStructureLink found for {classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            throw new NoSuchStructureLinkException(sb.toString());
        }
        return (DDMStructureLink)structureLinks.get(0);
    }

    public DDMStructureLink updateStructureLink(long structureLinkId, long classNameId, long classPK, long structureId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        return (DDMStructureLink)this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
    }
}

