/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_9_0;

import com.liferay.dynamic.data.mapping.data.provider.settings.DDMDataProviderSettingsProvider;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpgradeDDMDataProviderInstance
extends UpgradeProcess {
    private final ServiceTrackerMap<String, DDMDataProviderSettingsProvider> _ddmDataProviderSettingsProviderServiceTracker;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;

    public UpgradeDDMDataProviderInstance(ServiceTrackerMap<String, DDMDataProviderSettingsProvider> ddmDataProviderSettingsProviderServiceTracker, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer) {
        this._ddmDataProviderSettingsProviderServiceTracker = ddmDataProviderSettingsProviderServiceTracker;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select dataProviderInstanceId, definition, type_ from DDMDataProviderInstance");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where dataProviderInstanceId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String dataProviderInstanceDefinition = rs.getString(2);
                String type = rs.getString(3);
                ps2.setString(1, this._upgradeDataProviderInstanceDefinition(dataProviderInstanceDefinition, type));
                long dataProviderInstanceId = rs.getLong(1);
                ps2.setLong(2, dataProviderInstanceId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    private void _updateNestedDDMFormFieldValue(DDMFormFieldValue nestedDDMFormFieldValue) {
        Value value = nestedDDMFormFieldValue.getValue();
        Map valuesMap = value.getValues();
        for (Map.Entry valueEntry : valuesMap.entrySet()) {
            String valueString = (String)valueEntry.getValue();
            String[] valueStringParts = valueString.split(";");
            if (valueStringParts.length <= 1) continue;
            String outputPathType = valueStringParts[1];
            String outputPathValue = valueStringParts[0];
            if (outputPathType.equals("List")) {
                StringBundler sb = new StringBundler(3);
                sb.append("$");
                sb.append("..");
                sb.append(outputPathValue);
                outputPathValue = sb.toString();
            }
            valuesMap.put(valueEntry.getKey(), outputPathValue);
        }
    }

    private String _upgradeDataProviderInstanceDefinition(String dataProviderInstanceDefinition, String type) throws Exception {
        DDMDataProviderSettingsProvider ddmDataProviderSettingsProvider = (DDMDataProviderSettingsProvider)this._ddmDataProviderSettingsProviderServiceTracker.getService((Object)type);
        DDMForm ddmForm = DDMFormFactory.create((Class)ddmDataProviderSettingsProvider.getSettings());
        DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)dataProviderInstanceDefinition, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(false);
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("outputParameters");
        if (ddmFormFieldValues != null) {
            Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get("outputParameters");
            Map nestedDDMFormFieldsMap = ddmFormField.getNestedDDMFormFieldsMap();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                ArrayList<DDMFormFieldValue> newNestedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>();
                for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                    String nestedDDMFormFieldValueName = nestedDDMFormFieldValue.getName();
                    DDMFormField nestedDDMFormField = (DDMFormField)nestedDDMFormFieldsMap.get(nestedDDMFormFieldValueName);
                    if (nestedDDMFormField == null) continue;
                    if (nestedDDMFormFieldValueName.equals("outputParameterPath")) {
                        this._updateNestedDDMFormFieldValue(nestedDDMFormFieldValue);
                    }
                    newNestedDDMFormFieldValues.add(nestedDDMFormFieldValue);
                }
                ddmFormFieldValue.setNestedDDMFormFields(newNestedDDMFormFieldValues);
            }
        }
        return DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer);
    }
}

