/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDMFormInstanceStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMFormInstance> {
    public static final String[] CLASS_NAMES = new String[]{DDMFormInstance.class.getName()};
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    private StagedModelRepository<DDMFormInstance> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMFormInstance formInstance) {
        return formInstance.getNameCurrentValue();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMFormInstance formInstance) throws Exception {
        DDMStructure ddmStructure = formInstance.getStructure();
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)formInstance, (StagedModel)ddmStructure, (String)"strong");
        List ddmTemplates = ddmStructure.getTemplates();
        Element formInstanceElement = portletDataContext.getExportDataElement((ClassedModel)formInstance);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)formInstance, (StagedModel)ddmTemplate, (String)"strong");
        }
        this.exportFormInstanceSettings(portletDataContext, formInstance, formInstanceElement);
        portletDataContext.addClassedModel(formInstanceElement, ExportImportPathUtil.getModelPath((StagedModel)formInstance), (ClassedModel)formInstance);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long formInstanceId) throws Exception {
        DDMFormInstance existingFormInstance = (DDMFormInstance)this.fetchMissingReference(uuid, groupId);
        if (existingFormInstance == null) {
            return;
        }
        Map formInstanceIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class);
        formInstanceIds.put(formInstanceId, existingFormInstance.getFormInstanceId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMFormInstance formInstance) throws Exception {
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)formInstance.getStructureId(), (long)formInstance.getStructureId());
        DDMFormInstance importedFormInstance = (DDMFormInstance)formInstance.clone();
        importedFormInstance.setGroupId(portletDataContext.getScopeGroupId());
        importedFormInstance.setStructureId(ddmStructureId);
        DDMFormInstance existingFormInstance = (DDMFormInstance)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(formInstance.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFormInstance == null || !portletDataContext.isDataStrategyMirror()) {
            importedFormInstance = (DDMFormInstance)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedFormInstance);
        } else {
            importedFormInstance.setMvccVersion(existingFormInstance.getMvccVersion());
            importedFormInstance.setFormInstanceId(existingFormInstance.getFormInstanceId());
            importedFormInstance = (DDMFormInstance)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedFormInstance);
        }
        Element formInstanceElement = portletDataContext.getImportDataElement((StagedModel)formInstance);
        DDMFormValues settingsDDMFormValues = this.getImportFormInstanceSettings(portletDataContext, formInstanceElement);
        this._ddmFormInstanceLocalService.updateFormInstance(importedFormInstance.getFormInstanceId(), importedFormInstance.getStructureId(), importedFormInstance.getNameMap(), importedFormInstance.getDescriptionMap(), settingsDDMFormValues, portletDataContext.createServiceContext((StagedModel)importedFormInstance));
        portletDataContext.importClassedModel((ClassedModel)formInstance, (ClassedModel)importedFormInstance);
    }

    protected void exportFormInstanceSettings(PortletDataContext portletDataContext, DDMFormInstance formInstance, Element formInstanceElement) {
        String settingsDDMFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)formInstance, (String)"settings-ddm-form-values.json");
        formInstanceElement.addAttribute("settings-ddm-form-values-path", settingsDDMFormValuesPath);
        portletDataContext.addZipEntry(settingsDDMFormValuesPath, formInstance.getSettings());
    }

    protected DDMFormValues getImportFormInstanceSettings(PortletDataContext portletDataContext, Element formInstanceElement) throws Exception {
        DDMForm ddmForm = DDMFormFactory.create(DDMFormInstanceSettings.class);
        String settingsDDMFormValuesPath = formInstanceElement.attributeValue("settings-ddm-form-values-path");
        String serializedSettingsDDMFormValues = portletDataContext.getZipEntryAsString(settingsDDMFormValuesPath);
        return this.deserialize(serializedSettingsDDMFormValues, ddmForm);
    }

    protected StagedModelRepository<DDMFormInstance> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceLocalService(DDMFormInstanceLocalService ddmFormInstanceLocalService) {
        this._ddmFormInstanceLocalService = ddmFormInstanceLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstance)", unbind="-")
    protected void setStagedModelRepository(StagedModelRepository<DDMFormInstance> stagedModelRepository) {
        this._stagedModelRepository = stagedModelRepository;
    }
}

