/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.result.contributor;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={ModelSummaryContributor.class})
public class DDMFormInstanceRecordModelSummaryContributor
implements ModelSummaryContributor {
    @Reference
    protected DDMFormInstanceLocalService ddmFormInstanceLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordModelSummaryContributor.class);

    public Summary getSummary(Document document, Locale locale, String snippet) {
        long ddmFormInstanceId = GetterUtil.getLong((String)document.get("formInstanceId"));
        String prefix = "snippet_";
        String description = document.get(locale, prefix + "description", "description");
        Summary summary = new Summary(this.getTitle(ddmFormInstanceId, locale), description);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected ResourceBundle getResourceBundle(Locale defaultLocale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return portalResourceBundleLoader.loadResourceBundle(defaultLocale);
    }

    protected String getTitle(long ddmFormInstanceId, Locale locale) {
        try {
            DDMFormInstance ddmFormInstance = this.ddmFormInstanceLocalService.getFormInstance(ddmFormInstanceId);
            String ddmFormInstanceName = ddmFormInstance.getName(locale);
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"form-record-for-form-x", (Object)ddmFormInstanceName, (boolean)false);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            return "";
        }
    }
}

