/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormRenderer.class})
public class DDMFormRendererImpl
implements DDMFormRenderer {
    private static final String _MODULE_NAME = "dynamic-data-mapping-form-renderer/js/custom/form/FormView.es";
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private ReactRenderer _reactRenderer;

    public Map<String, Object> getDDMFormTemplateContext(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws Exception {
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        ddmFormTemplateContext.put("editable", false);
        ddmFormTemplateContext.remove("fieldTypes");
        HttpServletRequest httpServletRequest = ddmFormRenderingContext.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String pathThemeImages = themeDisplay.getPathThemeImages();
        String spriteMap = pathThemeImages.concat("/clay/icons.svg");
        ddmFormTemplateContext.put("spritemap", spriteMap);
        return ddmFormTemplateContext;
    }

    public String render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    public String render(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this.doRender(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    protected String doRender(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws Exception {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        writer.append("<div id=\"");
        writer.append(ddmFormRenderingContext.getContainerId());
        writer.append("\">");
        this._reactRenderer.renderReact(new ComponentDescriptor(this._npmResolver.resolveModuleName(_MODULE_NAME)), this.getDDMFormTemplateContext(ddmForm, ddmFormLayout, ddmFormRenderingContext), ddmFormRenderingContext.getHttpServletRequest(), (Writer)writer);
        writer.append("</div>");
        return writer.toString();
    }
}

