/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import extractDataRecordValueKey from '../util/extractDataRecordValueKey.es';

export default (
	{
		locale,
		localizable,
		localizedValue = {
			[locale]: '',
		},
		localizedValueEdited,
		name,
		transient,
		value = '',
		visible,
	},
	dataRecordValues,
	languageId,
	preserveValue
) => {
	const dataRecordValueKey = extractDataRecordValueKey(name);

	if (transient) {
		dataRecordValues[dataRecordValueKey] = '';

		return;
	}

	let _value = value;

	if (typeof value !== 'string') {
		_value = JSON.stringify(value);
	}

	if (!visible) {
		_value = '';
	}

	if (localizable) {
		const edited =
			!!localizedValue?.[languageId] ||
			(localizedValueEdited && localizedValueEdited[languageId]);

		let availableLanguageIds;

		Object.keys(localizedValue)
			.filter(
				(languageId) =>
					!localizedValueEdited?.[languageId] &&
					(localizedValue[languageId] === '' ||
						localizedValue[languageId] === '[]' ||
						localizedValue[languageId] === '{}')
			)
			.forEach((languageId) => {
				delete localizedValue[languageId];
			});

		if (localizedValue) {
			availableLanguageIds = Object.keys(localizedValue);
		}
		else {
			availableLanguageIds = [];
		}

		if (!availableLanguageIds.includes(languageId)) {
			availableLanguageIds.push(languageId);
		}

		dataRecordValues[dataRecordValueKey] = {...localizedValue};

		if (edited) {
			dataRecordValues[dataRecordValueKey] = {
				...localizedValue,
				[languageId]: _value,
			};
		}
		else if (preserveValue) {
			dataRecordValues[dataRecordValueKey] = {
				...localizedValue,
				[languageId]: value,
			};
		}
	}
	else {
		dataRecordValues[dataRecordValueKey] = _value;
	}
};
