/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

/**
 * The validator only removes properties with the value undefined to allow
 * the initialProps to be added.
 */
const validator = (props) => {
	const newProps = {};

	for (const key in props) {
		const value = props[key];

		if (value !== undefined) {
			newProps[key] = value;
		}
	}

	return newProps;
};

export const parseProps = ({
	allowInvalidAvailableLocalesForProperty,
	allowNestedFields,
	autocompleteUserURL,
	cancelLabel,
	config = {},
	containerId,
	contentType,
	context: {dataEngineSidebar, sidebarPanels, ...otherContext} = {},
	dataDefinitionId,
	dataLayoutBuilderElementId,
	dataLayoutBuilderId,
	dataLayoutId,
	dataProviderInstanceParameterSettingsURL,
	dataProviderInstancesURL,
	defaultSiteLanguageId,
	fieldSetDefinitionURL,
	fieldTypes,
	formInstanceId,
	functionsMetadata,
	functionsURL,
	groupId,
	portletNamespace,
	publishFormInstanceURL,
	published,
	redirectURL,
	restrictedFormURL,
	rolesURL,
	rules,
	shareFormInstanceURL,
	sharedFormURL,
	showCancelButton,
	showPublishAlert,
	showSubmitButton,
	spritemap,
	submitLabel,
	view,
	...otherProps
}) => ({
	config: validator({
		allowInvalidAvailableLocalesForProperty,
		allowNestedFields,
		autocompleteUserURL,
		cancelLabel,
		...config,
		containerId,
		contentType,
		dataDefinitionId,
		dataEngineSidebar,
		dataLayoutBuilderElementId,
		dataLayoutBuilderId,
		dataLayoutId,
		dataProviderInstanceParameterSettingsURL,
		dataProviderInstancesURL,
		defaultSiteLanguageId,
		fieldSetDefinitionURL,
		fieldTypes,
		formInstanceId,
		functionsMetadata,
		functionsURL,
		groupId,
		portletNamespace,
		publishFormInstanceURL,
		published,
		redirectURL,
		restrictedFormURL,
		rolesURL,
		shareFormInstanceURL,
		sharedFormURL,
		showCancelButton,
		showPublishAlert,
		showSubmitButton,
		sidebarPanels,
		spritemap,
		submitLabel,
		view,
	}),
	state: validator({
		...otherProps,
		...otherContext,
		rules,
	}),
});
